/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JComboBoxAvocent;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.snmp.VarBind;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class JPanelSettingsVersionsRips
extends JPanelAmpPanel
implements InterfaceAVWorksEventBroadcasterListener {
    public static final String CNAME = "JPanelSettingsVersionsRips";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private static Object[] RIP = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
    private static final Integer STATUS_OFFLINE_VAL = new Integer(2);
    private static final Integer UPGR_READY_VAL = new Integer(1);
    private static final Integer UPGR_INPROGRESS_VAL = new Integer(2);
    private static final Integer UPGR_SUCCEEDED_VAL = new Integer(3);
    private static final Integer UPGR_FAILED_VAL = new Integer(4);
    private static final Integer REQUEST_UPGRADE = new Integer(2);
    private static final Integer AUTO_UPGRADE_OFF = new Integer(1);
    private static final Integer AUTO_UPGRADE_ON = new Integer(2);
    private static final int POLL_INTERVAL_SECONDS = 5;
    private static final Object[] m_aoUpgradeFieldIds = new Object[]{"avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableIndex", "avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionAvailable"};
    private Rip[] m_aRipTable;
    private Hashtable m_htRipUpgradeTable;
    private ThreadPollData m_threadPollData;
    private int m_nSelIndex = -1;
    private boolean m_bLoadingFirmware = false;
    private boolean m_bIgnoreRipSelection = false;
    private boolean m_bReloadRips = false;
    private boolean m_bVendorSupport = false;
    private boolean m_bResetRipSupport = false;
    private boolean m_bRipIsPS2 = false;
    private RipIdItemListener m_ripIdItemListener = null;
    private EnableItemL m_LEnableItem = null;
    private boolean m_bReportsUpgradeableRips = false;
    private int m_nMibMajorVersion = 1;
    private int m_nMibMinorVersion = 0;
    private AmpControllerAvr m_acController;
    private SnmpValueObject m_svoAutoUpgradeRIPS;
    GridBagLayout m_gridBagLayout1 = new GridBagLayout();
    JPanel m_jpRipSelect = new JPanel();
    TitledBorder m_titledBorderInformation;
    TitledBorder m_titledBorderLoadFirmware;
    JPanel m_jpStatusMsgs = new JPanel();
    GridBagLayout m_gridBagLayout2 = new GridBagLayout();
    GridBagLayout m_gridBagLayout3 = new GridBagLayout();
    JPanel m_jpInformation = new JPanel();
    GridBagLayout m_gridBagLayout4 = new GridBagLayout();
    JPanel m_jpLoadFirmware = new JPanel();
    GridBagLayout m_gridBagLayout5 = new GridBagLayout();
    JLabel m_jlRipId = new JLabel();
    JComboBoxAvocent m_jcbRipIds = new JComboBoxAvocent();
    JLabel m_jlApplication = new JLabel();
    JLabel m_jlApplicationValue = new JLabel();
    JLabel m_jlBoot = new JLabel();
    JLabel m_jlBootValue = new JLabel();
    JLabel m_jlHardware = new JLabel();
    JLabel m_jlHardwareValue = new JLabel();
    JLabel m_jlType = new JLabel();
    JLabel m_jlTypeValue = new JLabel();
    JLabel m_jlVendor = new JLabel();
    JLabel m_jlVendorValue = new JLabel();
    JLabel m_jlLoadFirmware = new JLabel();
    JLabel m_jlLoadFirmwareValue = new JLabel();
    JLabel m_jlFPGA = new JLabel();
    JLabel m_jlFPGAValue = new JLabel();
    JButton m_jbLoadFirmware = new JButton();
    JLabel m_jlStatus = new JLabel();
    JLabel m_jlFailureReason = new JLabel();
    JLabel m_jlFillerRight = new JLabel();
    JButton m_jbResetRip = new JButton();
    JCheckBox m_cbAutoUpgradeRIPS = new JCheckBox();

    public JPanelSettingsVersionsRips(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed, ExceptionInvalidArgument {
        super((AmpController)ampControllerAvr, AVWorksBranding.getDsrIqName((boolean)false), res.getString("JPanelSettingsVersionsRips_Versions") + " - " + AVWorksBranding.getDsrIqName((boolean)false), JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_View_RIP_version", (Object[])RIP), "IDH_SETTINGS_TAB_RIP_VERSION");
        this.m_acController = ampControllerAvr;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
        int[] nArray = new int[]{5, 10, 2, 8, 13};
        AVWorksEventBroadcaster.addListener((InterfaceAVWorksEventBroadcasterListener)this, (int[])nArray);
    }

    void jbInit() throws Exception {
        this.setLayout(this.m_gridBagLayout1);
        this.m_cbAutoUpgradeRIPS.setBorder(null);
        this.m_cbAutoUpgradeRIPS.setText(res.getString("JPanelSettingsVersionsRips_AutoUpgradeRIPS"));
        this.m_jpRipSelect.setLayout(this.m_gridBagLayout2);
        this.m_jpInformation.setLayout(this.m_gridBagLayout4);
        this.m_titledBorderInformation = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), res.getString("JPanelSettingsVersionsRips_Information"));
        this.m_jpInformation.setBorder(this.m_titledBorderInformation);
        this.m_jpLoadFirmware.setLayout(this.m_gridBagLayout5);
        this.m_titledBorderLoadFirmware = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), res.getString("JPanelSettingsVersionsRips_Firmware_Available"));
        this.m_jpLoadFirmware.setBorder(this.m_titledBorderLoadFirmware);
        this.m_jpStatusMsgs.setLayout(this.m_gridBagLayout3);
        this.m_jlRipId.setText(res.getString("JPanelSettingsVersionsRips_ID_"));
        this.m_jlApplication.setText(res.getString("JPanelSettingsVersionsRips_Application_"));
        this.m_jlBoot.setText(res.getString("JPanelSettingsVersionsRips_Boot_"));
        this.m_jlHardware.setText(res.getString("JPanelSettingsVersionsRips_Hardware_"));
        this.m_jlType.setText(res.getString("JPanelSettingsVersionsRips_Type_"));
        this.m_jlVendor.setText(res.getString("JPanelSettingsVersionsRips_Vendor"));
        this.m_jlLoadFirmware.setText(res.getString("JPanelSettingsVersionsRips_Application_"));
        this.m_jbLoadFirmware.setText(res.getString("JPanelSettingsVersionsRips_Load_Firmware"));
        this.m_jbLoadFirmware.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsVersionsRips.this.m_jbLoadFirmware_actionPerformed(actionEvent);
            }
        });
        this.m_jbLoadFirmware.setEnabled(false);
        this.m_jbResetRip.setText(JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Reset", (Object[])RIP));
        this.enableResetRipButton(false);
        this.m_jbResetRip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsVersionsRips.this.resetRip();
            }
        });
        this.m_jlStatus.setFont(new Font("Dialog", 1, 12));
        this.m_jlFailureReason.setFont(new Font("Dialog", 1, 12));
        this.getContentPane().add((Component)this.m_jpRipSelect, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(11, 5, 11, 0), 1, 1));
        this.m_jpRipSelect.add((Component)this.m_jlRipId, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_jpInformation, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(11, 5, 11, 0), 0, 0));
        this.getContentPane().add((Component)this.m_jpLoadFirmware, new GridBagConstraints(-1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(11, 5, 11, 0), 0, 0));
        this.m_jpRipSelect.add((Component)this.m_jcbRipIds, new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlApplication, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlApplicationValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlBoot, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlBootValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlHardware, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlHardwareValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlType, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlVendor, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlTypeValue, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlVendorValue, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlFPGA, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpInformation.add((Component)this.m_jlFPGAValue, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpLoadFirmware.add((Component)this.m_jlLoadFirmware, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpLoadFirmware.add((Component)this.m_jlLoadFirmwareValue, new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 20), 0, 0));
        this.m_jpInformation.add((Component)this.m_jbResetRip, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 11, 5), 0, 0));
        this.m_jpLoadFirmware.add((Component)this.m_jbLoadFirmware, new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.m_jpStatusMsgs.add((Component)this.m_jlStatus, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpStatusMsgs.add((Component)this.m_jlFailureReason, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_cbAutoUpgradeRIPS, new GridBagConstraints(-1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(11, 5, 11, 0), 0, 0));
        this.getContentPane().add((Component)this.m_jpStatusMsgs, new GridBagConstraints(-1, 5, 0, 1, 1.0, 0.2, 10, 1, new Insets(11, 5, 11, 0), 0, 0));
    }

    protected boolean initialize() {
        Object[] objectArray;
        Object[] objectArray2;
        this.showStatusMsgs("", "");
        this.m_nMibMajorVersion = this.m_acController.getAppliance().getMibMajorVersion();
        this.m_nMibMinorVersion = this.m_acController.getAppliance().getMibMinorVersion();
        Trace.logInfo((String)CNAME, (String)("Initialize: MIB version is " + this.m_nMibMajorVersion + "." + this.m_nMibMinorVersion));
        this.m_bVendorSupport = this.m_acController.isFeatureSupported("RipInteroperabilityFeature");
        this.m_bReportsUpgradeableRips = this.m_nMibMajorVersion > 1 || this.m_nMibMajorVersion == 1 && this.m_nMibMinorVersion >= 9;
        this.m_cbAutoUpgradeRIPS.setVisible(this.m_nMibMajorVersion >= 2);
        try {
            objectArray2 = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileCreationStatus.0"};
            objectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray2);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_cbAutoUpgradeRIPS.setEnabled(false);
            this.m_jbLoadFirmware.setVisible(false);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logInfo((String)CNAME, (String)("initialize:ExceptionInvalidArgument - " + exceptionInvalidArgument.getMessage()));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)CNAME, (String)("initialize:ExceptionRequestFailed - " + exceptionRequestFailed.getMessage()));
        }
        catch (Exception exception) {
            Trace.logInfo((String)CNAME, (String)("initialize:Exception - " + exception.getMessage()));
        }
        this.m_bResetRipSupport = !AVWorksBranding.getBoolean((String)"Ps2ResetButtonAvailableViewer", (boolean)true) && (this.m_nMibMajorVersion > 1 || this.m_nMibMajorVersion == 1 && this.m_nMibMinorVersion >= 10);
        this.m_jbResetRip.setVisible(this.m_bResetRipSupport);
        this.m_jlVendor.setVisible(this.m_bVendorSupport);
        this.m_jlVendorValue.setVisible(this.m_bVendorSupport);
        try {
            if (this.m_ripIdItemListener != null) {
                this.m_jcbRipIds.removeItemListener((ItemListener)this.m_ripIdItemListener);
                this.m_ripIdItemListener = null;
            }
            if (this.m_nMibMajorVersion >= 2) {
                if (this.m_LEnableItem != null) {
                    this.m_cbAutoUpgradeRIPS.removeItemListener(this.m_LEnableItem);
                    this.m_LEnableItem = null;
                }
                this.m_LEnableItem = new EnableItemL();
                this.m_cbAutoUpgradeRIPS.addItemListener(this.m_LEnableItem);
                objectArray2 = new InterfaceValueObject[1];
                try {
                    objectArray = new Object[]{"avocent.ds.dsManagement.dsPort.dsRipAutomaticUpgrade.0"};
                    InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
                    this.m_svoAutoUpgradeRIPS = (SnmpValueObject)interfaceValueObjectArray[0];
                    this.m_cbAutoUpgradeRIPS.setSelected(this.m_svoAutoUpgradeRIPS.getInteger().compareTo(AUTO_UPGRADE_ON) == 0);
                }
                catch (Exception exception) {
                    this.m_acController.showException(null, this.getTraceContext(), null, exception);
                    return false;
                }
            }
            this.logInfo("initialize: Retrieving the RIP version information.");
            this.m_aRipTable = this.loadRipPortTable();
            this.loadRipIdsIntoComboBox();
            this.m_htRipUpgradeTable = this.loadRipUpgradeTable();
            this.m_ripIdItemListener = new RipIdItemListener();
            this.m_jcbRipIds.addItemListener((ItemListener)this.m_ripIdItemListener);
            if (this.m_aRipTable.length > 0) {
                this.m_jcbRipIds.setSelectedIndex(-1);
                this.m_jcbRipIds.setSelectedIndex(0);
            }
            int n = (int)this.m_jpInformation.getSize().getWidth();
            int n2 = (int)this.m_jcbRipIds.getPreferredSize().getHeight();
            this.m_jcbRipIds.setMaximumSize(new Dimension(n, n2));
            this.logInfo("initialize: Creating and starting data polling thread");
            this.m_threadPollData = new ThreadPollData();
            this.m_threadPollData.start();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError("initialize: " + exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError("initialize: " + exception.getMessage(), exception);
            return false;
        }
    }

    public boolean onSetActive() {
        this.m_acController.showCloseButton();
        if (this.m_nState == 103) {
            this.m_acController.setBusy(true);
            this.showStatusMsgs("", "");
            this.m_bReloadRips = true;
            this.m_threadPollData.resumeThread();
            this.m_threadPollData.interrupt();
        }
        return super.onSetActive();
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        this.m_acController.showCancelButton();
        if (this.m_nState == 103) {
            this.m_threadPollData.suspendThread();
            this.m_acController.setBusy(false);
        }
        return false;
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        if (this.m_nState == 103) {
            this.m_threadPollData.stopThread();
        }
        this.m_nState = 104;
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
    }

    public void doHandleEvent(Object object, int n) {
        Trace.logInfo((String)"RipVersionsEventListenerInterface:doHandleEvent", (String)("Received event ID=" + n));
        if (this.isVisible()) {
            if (n == 8 || n == 2 || n == 13) {
                this.m_bReloadRips = true;
            } else if (n == 10 && ((ApplianceInfo)object).getID() == this.m_acController.getApplianceInfo().getID()) {
                this.m_bReloadRips = true;
            }
        } else if (n == 10 && ((ApplianceInfo)object).getID() == this.m_acController.getApplianceInfo().getID()) {
            this.m_nState = 101;
        }
    }

    protected boolean applyValues() {
        if (this.m_acController.getAppliance().getMibMajorVersion() >= 2) {
            InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[1];
            try {
                VarBind varBind = new VarBind("avocent.ds.dsManagement.dsPort.dsRipAutomaticUpgrade.0");
                this.m_svoAutoUpgradeRIPS.setValue((Object)(this.m_cbAutoUpgradeRIPS.isSelected() ? AUTO_UPGRADE_ON : AUTO_UPGRADE_OFF));
                interfaceValueObjectArray[0] = this.m_svoAutoUpgradeRIPS;
                AvrSnmpHelper.setValues(this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
            }
            catch (Exception exception) {
                this.m_acController.showException(null, this.getTraceContext(), null, exception);
                return false;
            }
        }
        return true;
    }

    private void resetRip() {
        String string = AVWorksBranding.getDsrIqName((boolean)true);
        Object[] objectArray = new Object[]{AVWorksBranding.getCascadeSwitchName((boolean)false), string, AVWorksBranding.getServerName((boolean)true)};
        String string2 = MessageFormat.format(res.getString("JPanelSettingsVersionsRips_Reset_Confirm"), objectArray);
        int n = JOptionPaneFixedSize.showConfirmDialog((Component)this.m_acController.getMainFrame(), (Object)string2, (String)JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Reset_Confirm_Title", (Object[])RIP), (int)0);
        if (n == 1 || n == -1) {
            return;
        }
        Rip rip = this.getSelectedRipFromPortRipTable();
        Object[] objectArray2 = new Object[]{"avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipResetControl"};
        Object[] objectArray3 = new Object[]{new Integer(2)};
        try {
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray2, objectArray3, rip.getIndex().toString());
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            String string3 = res.getString("JPanelSettingsVersionsRips_Unable_to_Reset_Rip");
            Object[] objectArray4 = new Object[]{string};
            string3 = MessageFormat.format(string3, objectArray4);
            Message.show((Component)((Object)this), (String)(string3 + " " + exceptionAsmpRequestFailed.getMessage()));
        }
        catch (Exception exception) {
            String string4 = res.getString("JPanelSettingsVersionsRips_Exception_while_Reset_Rip");
            Object[] objectArray5 = new Object[]{string};
            string4 = MessageFormat.format(string4, objectArray5);
            this.m_acController.showException(null, this.getTraceContext(), string4, exception);
        }
    }

    private void enableResetRipButton(NameValue nameValue) {
        boolean bl = false;
        if ((Integer)nameValue.getValue() == 1) {
            bl = true;
        }
        this.enableResetRipButton(bl);
    }

    private void enableResetRipButton(boolean bl) {
        this.m_jbResetRip.setEnabled(bl);
        this.m_bRipIsPS2 = bl;
    }

    private Rip[] loadRipPortTable() throws Exception {
        int n = this.m_acController.getAppliance().getMibMajorVersion();
        Vector<String> vector = new Vector<String>();
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableIndex");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipId");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipType");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipBootImageVersion");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipAppImageVersion");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipHardwareVersion");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeControl");
        vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeStatus");
        if (n < 2) {
            vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailReason");
        } else {
            vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailCode");
        }
        int n2 = 0;
        int n3 = -1;
        if (this.m_bVendorSupport) {
            vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipVendor");
            n3 = 10 + n2++;
        }
        Trace.logInfo((String)CNAME, (String)("loadRipPortTable:ReportsUpgradableRips is " + this.m_bReportsUpgradeableRips));
        int n4 = -1;
        if (this.m_bReportsUpgradeableRips) {
            vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradable");
            n4 = 10 + n2++;
        }
        int n5 = -1;
        if (n >= 2) {
            vector.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableAppVersionAvailable");
            n5 = 10 + n2++;
        }
        Object[] objectArray = vector.toArray();
        InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
        Vector<Rip> vector2 = new Vector<Rip>(interfaceValueObjectArray.length);
        for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
            String string = interfaceValueObjectArray[i][1].toString();
            string = string + " : " + this.getConnectedTo(string);
            NameValue nameValue = (NameValue)interfaceValueObjectArray[i][3].getValue();
            Integer n6 = (Integer)nameValue.getValue();
            if (n6.equals(STATUS_OFFLINE_VAL)) {
                this.logInfo("loadRipPortTable: The RIP " + string + " is OFFLINE " + "and will not be included in the combo box.");
                continue;
            }
            SnmpValueObject snmpValueObject = (SnmpValueObject)interfaceValueObjectArray[i][0];
            Rip rip = new Rip(snmpValueObject.getInteger(), string, (NameValue)interfaceValueObjectArray[i][2].getValue(), nameValue, interfaceValueObjectArray[i][4].toString(), interfaceValueObjectArray[i][5].toString(), interfaceValueObjectArray[i][6].toString(), interfaceValueObjectArray[i][7], (NameValue)interfaceValueObjectArray[i][8].getValue(), interfaceValueObjectArray[i][9].toString(), null);
            vector2.addElement(rip);
            if (this.m_bVendorSupport && n3 > 0) {
                rip.setVendor((NameValue)interfaceValueObjectArray[i][n3].getValue());
            }
            if (this.m_bReportsUpgradeableRips && n4 > 0) {
                NameValue nameValue2 = (NameValue)interfaceValueObjectArray[i][n4].getValue();
                Integer n7 = (Integer)nameValue2.getValue();
                rip.setUpgradable(n7 == 2);
            }
            if (this.m_nMibMajorVersion < 2 || n5 <= 0) continue;
            rip.setAvailableVers(interfaceValueObjectArray[i][n5].toString());
        }
        Object[] objectArray2 = new Rip[vector2.size()];
        vector2.copyInto(objectArray2);
        return objectArray2;
    }

    private void loadRipIdsIntoComboBox() {
        Vector<OrderedContent> vector = new Vector<OrderedContent>(this.m_aRipTable.length);
        for (int i = 0; i < this.m_aRipTable.length; ++i) {
            String string = this.m_aRipTable[i].getId();
            String string2 = this.getOnlineRipPortNum(string);
            String string3 = "P" + string2 + " : " + string;
            Integer n = null;
            try {
                n = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = new Integer("99");
                Trace.logError((String)"loadRipIdsIntoComboBox(): ", (String)numberFormatException.toString());
            }
            try {
                OrderedContent orderedContent = new OrderedContent(string3, n);
                vector.add(orderedContent);
                continue;
            }
            catch (RuntimeException runtimeException) {
                Trace.logError((String)"JPanelSettingsVersionsRips: ", (String)runtimeException.toString());
            }
        }
        try {
            Collections.sort(vector);
        }
        catch (RuntimeException runtimeException) {
            Trace.logError((String)"JPanelSettingsVersionsRips: ", (String)runtimeException.toString());
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.m_jcbRipIds.setModel(defaultComboBoxModel);
    }

    private String getOnlineRipPortNum(String string) {
        String string2 = "";
        int n = 1;
        int n2 = this.m_acController.getAppliance().getMibMajorVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipId");
        arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableInputPort");
        arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus");
        try {
            InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
            for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                String string3 = interfaceValueObjectArray[i][0].getString();
                String string4 = interfaceValueObjectArray[i][2].getValue().toString();
                String string5 = res.getString("JPanelSettingsVersionsRips_Online");
                if (!string.startsWith(string3) || !string4.equalsIgnoreCase(string5)) continue;
                string2 = interfaceValueObjectArray[i][1].getValue().toString();
                int n3 = Integer.parseInt(string2) + n;
                string2 = Integer.toString(n3);
                break;
            }
        }
        catch (Exception exception) {
            string2 = "";
            Trace.logError((String)"JPanelSettingsVersionsRips: ", (String)exception.toString());
        }
        return string2;
    }

    private Hashtable loadRipUpgradeTable() throws Exception {
        if (this.m_nMibMajorVersion >= 2) {
            return null;
        }
        InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), m_aoUpgradeFieldIds);
        Hashtable<Integer, RipType> hashtable = new Hashtable<Integer, RipType>(interfaceValueObjectArray.length);
        for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
            NameValue nameValue = (NameValue)interfaceValueObjectArray[i][0].getValue();
            Integer n = (Integer)nameValue.getValue();
            RipType ripType = new RipType(nameValue, interfaceValueObjectArray[i][1].toString());
            hashtable.put(n, ripType);
        }
        return hashtable;
    }

    private void showSelectedItemInfo(boolean bl, boolean bl2) {
        if (this.m_nSelIndex != -1) {
            Object object;
            Rip rip = this.getSelectedRipFromPortRipTable();
            this.logInfo("RIP selected: " + rip);
            this.m_jlApplicationValue.setText(rip.getAppVers());
            this.m_jlBootValue.setText(rip.getBootVers());
            this.m_jlHardwareValue.setText(rip.getHwVersion());
            NameValue nameValue = rip.getType();
            this.m_jlTypeValue.setText(nameValue.toString());
            this.enableResetRipButton(nameValue);
            if (this.m_bVendorSupport) {
                object = rip.getVendor();
                this.m_jlVendorValue.setText(object.toString());
                this.logInfo(JPanelSettingsVersionsRips.nvToString((NameValue)object));
            }
            if (this.m_jlTypeValue.getText().equals(res.getString("JPanelSettingsVersionsRips_ENUM_CMC"))) {
                this.m_jbLoadFirmware.setEnabled(false);
                this.logInfo("RipType == CMC: Not Upgradeable");
            } else {
                this.m_jbLoadFirmware.setEnabled(true);
            }
            object = (Integer)rip.m_nvType.getValue();
            if ((Integer)object == 9 || (Integer)object == 7) {
                int n = rip.getIndex();
                this.m_jlFPGA.setText(res.getString("JPanelSettingsVersionsRips_FPGA"));
                this.m_jlFPGAValue.setText(this.getFPGAVersion(n));
            } else {
                this.m_jlFPGA.setText("");
                this.m_jlFPGAValue.setText("");
            }
            NameValue nameValue2 = rip.getStatus();
            Integer n = (Integer)nameValue2.getValue();
            boolean bl3 = n.equals(STATUS_OFFLINE_VAL);
            NameValue nameValue3 = rip.getUpgradeStatus();
            Integer n2 = (Integer)nameValue3.getValue();
            boolean bl4 = n2.equals(UPGR_INPROGRESS_VAL);
            this.logInfo("showSelectedItemInfo: bRipNowInProgress=" + bl4 + "; " + "bPreviouslyInProgress=" + bl + "; " + "bRipNowOffline=" + bl3 + "; " + "bPreviouslyOffline=" + bl2 + ".");
            if (bl4 || bl || bl3 || bl2) {
                this.setUpgradeStatusMsg(nameValue2, nameValue3, rip.getUpgradeFailureReason());
                rip.setUpgradeWasInProgress(bl4);
                rip.setWasOffline(bl3);
            }
            if (rip.getAvailableVers() != null) {
                this.m_jlLoadFirmwareValue.setText(rip.getAvailableVers());
            } else {
                try {
                    RipType ripType = (RipType)this.m_htRipUpgradeTable.get(object);
                    if (ripType != null) {
                        this.logInfo("RipType(" + object + ") found: " + ripType);
                        this.m_jlLoadFirmwareValue.setText(ripType.getAvailableVers());
                    } else {
                        this.logInfo("Unknown RIP type returned (" + object + "), blanking out fields and disable load button");
                        this.m_jlLoadFirmwareValue.setText("");
                        this.showStatusMsgs("", "");
                        this.m_jbLoadFirmware.setEnabled(false);
                        this.enableResetRipButton(false);
                    }
                }
                catch (Exception exception) {
                    this.logError("showSelectedItemInfo: " + exception.getMessage(), exception);
                }
            }
            if (!rip.isUpgradable()) {
                this.logInfo("Rip is not upgradable: disabling button and setting message ");
                this.showStatusMsgs(JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Remote_RIP_Not_Upgradable", (Object[])RIP), "");
                this.m_jbLoadFirmware.setEnabled(false);
            }
        } else {
            this.m_jlApplicationValue.setText("");
            this.m_jlBootValue.setText("");
            this.m_jlHardwareValue.setText("");
            this.m_jlTypeValue.setText("");
            this.m_jlVendorValue.setText("");
            this.m_jlLoadFirmwareValue.setText("");
            this.m_jbLoadFirmware.setEnabled(false);
            this.enableResetRipButton(false);
            this.showStatusMsgs("", "");
        }
    }

    private void updateDynamicInfo(boolean bl) {
        if (this.m_nState == 103 && this.isShowing() && !this.m_bLoadingFirmware) {
            block7: {
                try {
                    if (bl) {
                        this.reloadRips();
                        this.m_bReloadRips = false;
                    } else {
                        this.updateSelectedRip();
                    }
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    this.logError("updateDynamicInfo: Exception updating dynamic info. " + exceptionAsmpRequestFailed.getMessage() + ", m_nState =" + this.m_nState, (Exception)((Object)exceptionAsmpRequestFailed));
                    if (this.m_nState == 103 && this.isShowing() && !this.m_bLoadingFirmware) {
                        String string = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Unable_to_Read_Rip", (Object[])RIP);
                        Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                    }
                }
                catch (Exception exception) {
                    this.logError("updateDynamicInfo: Exception updating dynamic info. " + exception.getMessage() + ", m_nState =" + this.m_nState, exception);
                    if (this.m_nState != 103 || !this.isShowing() || this.m_bLoadingFirmware) break block7;
                    Message.show((Component)this.m_acController.getMainFrame(), (String)exception.getMessage());
                }
            }
            this.m_acController.setBusy(false);
        }
    }

    private String getFPGAVersion(int n) {
        String string = "";
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipFPGAVersion"};
        try {
            InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
            string = interfaceValueObjectArray[n - 1][0].getValue().toString();
        }
        catch (Exception exception) {
            Trace.logInfo((String)"JPanelSettingsVersionsRips:getFPGAVersion", (String)"Unable to retrieve FGPA version from appliance");
        }
        return string;
    }

    private void updateSelectedRip() throws Exception {
        final Hashtable hashtable = this.loadRipUpgradeTable();
        if (this.m_nSelIndex > -1) {
            if (this.m_nSelIndex < this.m_aRipTable.length) {
                final Rip rip = this.getSelectedRipFromPortRipTable();
                Integer n = rip.getIndex();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipAppImageVersion");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeStatus");
                if (this.m_nMibMajorVersion >= 2) {
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailCode");
                } else {
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailReason");
                }
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipBootImageVersion");
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray(), n.toString());
                rip.setAppVers(interfaceValueObjectArray[0].toString());
                rip.setStatus((NameValue)interfaceValueObjectArray[1].getValue());
                rip.setUpgradeStatus((NameValue)interfaceValueObjectArray[2].getValue());
                rip.setUpgradeFailureReason(interfaceValueObjectArray[3].toString());
                rip.setBootVers(interfaceValueObjectArray[4].toString());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing() && !JPanelSettingsVersionsRips.this.m_bLoadingFirmware) {
                            boolean bl = rip.wasUpgradeInProgress();
                            boolean bl2 = rip.wasOffline();
                            JPanelSettingsVersionsRips.this.m_htRipUpgradeTable = hashtable;
                            JPanelSettingsVersionsRips.this.showSelectedItemInfo(bl, bl2);
                        }
                    }
                });
            } else {
                this.logError("runUpdate: Selected index=" + this.m_nSelIndex + ", returned from the RIP ID combobox is out of the " + "bounds of the m_aRipTable.length=" + this.m_aRipTable.length);
            }
        }
    }

    private void reloadRips() throws Exception {
        final Rip[] ripArray = this.loadRipPortTable();
        final Hashtable hashtable = this.loadRipUpgradeTable();
        if (this.m_nSelIndex > -1) {
            if (this.m_nSelIndex < this.m_aRipTable.length) {
                int n;
                Rip rip = this.getSelectedRipFromPortRipTable();
                Integer n2 = rip.getIndex();
                int n3 = -1;
                boolean bl = true;
                for (n = 0; n < ripArray.length; ++n) {
                    if (!ripArray[n].getIndex().equals(n2)) continue;
                    n3 = this.m_nSelIndex;
                    break;
                }
                if (n3 == -1) {
                    if (this.m_nState == 103 && this.isShowing() && !this.m_bLoadingFirmware) {
                        Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)true), AVWorksBranding.getApplianceName((boolean)true)};
                        String string = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_selected_rip_removed", (Object[])objectArray);
                        Message.show((Component)this.m_acController.getMainFrame(), (String)string);
                    }
                    n3 = ripArray.length > 0 ? 0 : -1;
                    bl = false;
                }
                n = n3;
                final boolean bl2 = bl;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing() && !JPanelSettingsVersionsRips.this.m_jcbRipIds.isPopupVisible() && !JPanelSettingsVersionsRips.this.m_bLoadingFirmware) {
                            boolean bl;
                            boolean bl22;
                            if (bl2) {
                                Rip rip = JPanelSettingsVersionsRips.this.getSelectedRipFromPortRipTable();
                                bl22 = rip.wasUpgradeInProgress();
                                bl = rip.wasOffline();
                            } else {
                                bl22 = false;
                                bl = false;
                            }
                            JPanelSettingsVersionsRips.access$802(JPanelSettingsVersionsRips.this, ripArray);
                            JPanelSettingsVersionsRips.this.m_htRipUpgradeTable = hashtable;
                            JPanelSettingsVersionsRips.this.loadRipIdsIntoComboBox();
                            JPanelSettingsVersionsRips.this.m_bIgnoreRipSelection = true;
                            JPanelSettingsVersionsRips.this.m_jcbRipIds.setSelectedIndex(n);
                            JPanelSettingsVersionsRips.this.m_nSelIndex = n;
                            JPanelSettingsVersionsRips.this.showSelectedItemInfo(bl22, bl);
                        }
                    }
                });
            } else {
                this.logError("reloadRips: Selected index=" + this.m_nSelIndex + ", returned from the RIP ID combobox is out of the " + "bounds of the m_aRipTable.length=" + this.m_aRipTable.length);
            }
        } else {
            this.logInfo("reloadRips: Retrieving the RIP version information.");
            this.m_aRipTable = ripArray;
            this.loadRipIdsIntoComboBox();
            this.m_htRipUpgradeTable = hashtable;
            if (this.m_aRipTable.length > 0) {
                this.m_bIgnoreRipSelection = false;
                this.m_jcbRipIds.setSelectedIndex(-1);
                this.m_jcbRipIds.setSelectedIndex(0);
            }
        }
    }

    private Rip getSelectedRipFromPortRipTable() {
        ComboBoxModel comboBoxModel = this.m_jcbRipIds.getModel();
        OrderedContent orderedContent = (OrderedContent)comboBoxModel.getSelectedItem();
        if (orderedContent == null) {
            return null;
        }
        String string = orderedContent.toString();
        String string2 = string.substring(string.indexOf(":") + 1, string.lastIndexOf(":")).trim();
        Rip rip = this.m_aRipTable[0];
        for (int i = 0; i < this.m_aRipTable.length; ++i) {
            String string3 = this.m_aRipTable[i].getId();
            String string4 = string3.substring(0, string3.lastIndexOf(":")).trim();
            if (!string4.equalsIgnoreCase(string2)) continue;
            rip = this.m_aRipTable[i];
            break;
        }
        return rip;
    }

    private void setUpgradeStatusMsg(NameValue nameValue, NameValue nameValue2, String string) {
        if (nameValue != null && nameValue2 != null && string != null) {
            Integer n = (Integer)nameValue.getValue();
            Integer n2 = (Integer)nameValue2.getValue();
            if (n2.equals(UPGR_INPROGRESS_VAL)) {
                String string2 = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade_In", (Object[])RIP);
                this.showStatusMsgs(string2, "");
                this.m_jbLoadFirmware.setEnabled(false);
                this.enableResetRipButton(false);
            } else if (n2.equals(UPGR_FAILED_VAL)) {
                String string3 = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade1", (Object[])RIP);
                this.showStatusMsgs(string3, string);
                this.m_jbLoadFirmware.setEnabled(true);
                this.enableResetRipButton(this.m_bRipIsPS2);
            } else if (n.equals(STATUS_OFFLINE_VAL)) {
                String string4 = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Rip_is_offline", (Object[])RIP);
                this.showStatusMsgs(string4, "");
                this.m_jbLoadFirmware.setEnabled(false);
                this.enableResetRipButton(false);
            } else if (n2.equals(UPGR_READY_VAL)) {
                this.showStatusMsgs("", "");
                this.m_jbLoadFirmware.setEnabled(true);
                this.enableResetRipButton(this.m_bRipIsPS2);
            } else if (n2.equals(UPGR_SUCCEEDED_VAL)) {
                String string5 = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade", (Object[])RIP);
                this.showStatusMsgs(string5, "");
                this.m_jbLoadFirmware.setEnabled(true);
                this.enableResetRipButton(this.m_bRipIsPS2);
            }
        } else {
            this.logError("setUpgradeStatusMsg: Invalid argument.  nvStatus=" + nameValue + ", nvUpgradeStatus=" + nameValue2 + " and szFailureReason=" + string);
        }
    }

    private void m_jbLoadFirmware_actionPerformed(ActionEvent actionEvent) {
        this.logInfo("JPanelSettingsVersionsRips: Load Firmware button pressed.");
        if (this.m_nSelIndex > -1) {
            Thread thread = new Thread(){

                public void run() {
                    block10: {
                        if (JPanelSettingsVersionsRips.this.m_nSelIndex < JPanelSettingsVersionsRips.this.m_aRipTable.length) {
                            try {
                                JPanelSettingsVersionsRips.this.m_threadPollData.suspendThread();
                                if (JPanelSettingsVersionsRips.this.loadFirmwareConfirmedByUser()) {
                                    Rip rip = JPanelSettingsVersionsRips.this.getSelectedRipFromPortRipTable();
                                    JPanelSettingsVersionsRips.this.m_bLoadingFirmware = true;
                                    JPanelSettingsVersionsRips.this.m_acController.setBusy(true);
                                    InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[]{rip.getUpgradeControl()};
                                    interfaceValueObjectArray[0].setValue((Object)REQUEST_UPGRADE);
                                    AvrSnmpHelper.setValues(JPanelSettingsVersionsRips.this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
                                    SwingUtilities.invokeLater(new Runnable(this, rip){
                                        private final /* synthetic */ Rip val$rip;
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$rip = rip;
                                        }

                                        public void run() {
                                            String string = JPanelAmpPanel.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade_In", (Object[])JPanelSettingsVersionsRips.access$1600());
                                            JPanelSettingsVersionsRips.access$1800(5.access$1700(this.this$1), string, "");
                                            5.access$1700(this.this$1).m_jbLoadFirmware.setEnabled(false);
                                            JPanelSettingsVersionsRips.access$1900(5.access$1700(this.this$1), false);
                                            this.val$rip.setUpgradeWasInProgress(true);
                                        }
                                    });
                                    JPanelSettingsVersionsRips.this.m_bLoadingFirmware = false;
                                    JPanelSettingsVersionsRips.this.m_acController.setBusy(false);
                                }
                                if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing()) {
                                    5.sleep(5000L);
                                    JPanelSettingsVersionsRips.this.m_threadPollData.resumeThread();
                                }
                                break block10;
                            }
                            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                                JPanelSettingsVersionsRips.this.logError("m_jbLoadFirmware_actionPerformed: Exception updating dynamic info. " + exceptionAsmpRequestFailed.getMessage() + ", m_nState =" + JPanelSettingsVersionsRips.this.m_nState, (Exception)((Object)exceptionAsmpRequestFailed));
                                if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing()) {
                                    JPanelSettingsVersionsRips.this.m_threadPollData.suspendThread();
                                    String string = JPanelAmpPanel.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Load_RIP_Firmware_Failed", (Object[])RIP);
                                    Message.show((Component)JPanelSettingsVersionsRips.this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                                    if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing()) {
                                        JPanelSettingsVersionsRips.this.m_threadPollData.resumeThread();
                                    }
                                    JPanelSettingsVersionsRips.this.m_bLoadingFirmware = false;
                                    JPanelSettingsVersionsRips.this.m_acController.setBusy(false);
                                }
                                break block10;
                            }
                            catch (Exception exception) {
                                JPanelSettingsVersionsRips.this.logError("m_jbLoadFirmware_actionPerformed: Exception attempting to load firmware. " + exception.getMessage() + ", m_nState =" + JPanelSettingsVersionsRips.this.m_nState, exception);
                                if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing()) {
                                    JPanelSettingsVersionsRips.this.m_threadPollData.suspendThread();
                                    JPanelSettingsVersionsRips.this.m_acController.showException(null, "AVR AMP panel", "", exception);
                                    if (JPanelSettingsVersionsRips.this.m_nState == 103 && JPanelSettingsVersionsRips.this.isShowing()) {
                                        JPanelSettingsVersionsRips.this.m_threadPollData.resumeThread();
                                    }
                                    JPanelSettingsVersionsRips.this.m_bLoadingFirmware = false;
                                    JPanelSettingsVersionsRips.this.m_acController.setBusy(false);
                                }
                                break block10;
                            }
                        }
                        JPanelSettingsVersionsRips.this.logError("m_jbLoadFirmware_actionPerformed: The selected index=" + JPanelSettingsVersionsRips.this.m_nSelIndex + ", returned from the " + "RIP ID combobox is out of the bounds of the " + "m_aRipTable.length=" + JPanelSettingsVersionsRips.this.m_aRipTable.length);
                    }
                }

                static /* synthetic */ JPanelSettingsVersionsRips access$1700(5 var0) {
                    return var0.JPanelSettingsVersionsRips.this;
                }
            };
            thread.start();
        }
    }

    private boolean loadFirmwareConfirmedByUser() {
        boolean bl = false;
        String string = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Load_Firmware_Warning", (Object[])RIP);
        int n = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)this), (Object)string, (String)res.getString("JPanelSettingsVersionsRips_Confirm_Load_Firmware"), (int)0);
        if (n == 0) {
            this.logInfo("loadFirmwareConfirmedByUser: User confirmed load firmware for selected RIP...");
            bl = true;
        } else {
            this.logInfo("loadFirmwareConfirmedByUser: User declined load firmware for selected RIP...");
        }
        return bl;
    }

    private void showStatusMsgs(String string, String string2) {
        Color color = this.m_jlRipId.getForeground();
        Color color2 = this.m_jlStatus.getBackground();
        Color color3 = color;
        if (string.trim().length() == 0) {
            color3 = color2;
            string = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade_In", (Object[])RIP);
        }
        this.m_jlStatus.setForeground(color3);
        if (string2.trim().length() == 0) {
            color3 = color2;
            string2 = JPanelSettingsVersionsRips.getResourceString((ResourceManager)res, (String)"JPanelSettingsVersionsRips_Firmware_Upgrade_In", (Object[])RIP);
        }
        this.m_jlFailureReason.setForeground(color3);
        this.m_jlStatus.setText(string);
        this.m_jlFailureReason.setText(string2);
    }

    private String getConnectedTo(String string) {
        int n = this.m_acController.getApplianceInfo().getID();
        this.logInfo("getConnectedTo: Getting connection information for RIP ID: " + string + " on appliance: " + this.m_acController.getApplianceInfo().getName() + " with appliance ID=" + n);
        String string2 = null;
        try {
            InterfaceInfo interfaceInfo = AvrDatabaseHelper.getInterfaceObjectFromDB(n, string);
            this.logInfo("getConnectedTo: InterfaceInfo for RIP ID=" + string + ": Name=" + interfaceInfo.getName() + ", ConnType=" + interfaceInfo.getConnType() + ", ConnId=" + interfaceInfo.getConnID());
            if (interfaceInfo.getConnType() == 1) {
                this.logInfo("getConnectedTo: RIP ID: " + string + " is connected " + "to a SERVER.");
                int n2 = interfaceInfo.getConnID();
                ServerInfo serverInfo = ServersDb.getServerInfo((int)n2);
                string2 = serverInfo.getName();
            } else if (interfaceInfo != null && interfaceInfo.getConnType() == 2) {
                this.logInfo("getConnectedTo: RIP ID: " + string + " is connected " + "to an SWITCH.");
                n = interfaceInfo.getConnID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n);
                string2 = applianceInfo.getName();
            }
        }
        catch (Exception exception) {
            this.logInfo("getConnectedTo: Error getting connection information for RIP ID: " + string + ".");
        }
        string2 = string2 == null || string2.trim().length() == 0 ? res.getString("JPanelSettingsVersionsRips_None") : ConnectionPath.parseSwitchName((String)string2);
        this.logInfo("getConnectedTo: Returning RIP ID: " + string + " is connected to: " + string2);
        return string2;
    }

    private static String nvToString(NameValue nameValue) {
        if (nameValue == null) {
            return "null";
        }
        return nameValue.getName() + "=" + nameValue.getValue();
    }

    static /* synthetic */ Rip[] access$802(JPanelSettingsVersionsRips jPanelSettingsVersionsRips, Rip[] ripArray) {
        jPanelSettingsVersionsRips.m_aRipTable = ripArray;
        return ripArray;
    }

    static /* synthetic */ void access$1900(JPanelSettingsVersionsRips jPanelSettingsVersionsRips, boolean bl) {
        jPanelSettingsVersionsRips.enableResetRipButton(bl);
    }

    class OrderedContent
    implements Comparable {
        Object obj;
        Integer portNum;

        OrderedContent(Object object, Integer n) {
            this.obj = object;
            this.portNum = n;
        }

        public int compareTo(Object object) {
            return this.portNum.compareTo(((OrderedContent)object).portNum);
        }

        public String toString() {
            return this.obj.toString();
        }
    }

    class RipType {
        NameValue m_nvIndex;
        String m_szAvailableVers;

        RipType(NameValue nameValue, String string) {
            this.m_nvIndex = nameValue;
            this.m_szAvailableVers = string;
        }

        public NameValue getIndex() {
            return this.m_nvIndex;
        }

        public void setAvailableVers(String string) {
            this.m_szAvailableVers = string;
        }

        public String getAvailableVers() {
            return this.m_szAvailableVers;
        }

        public String toString() {
            return "RipType:" + JPanelSettingsVersionsRips.nvToString(this.m_nvIndex) + ";Vers=" + this.m_szAvailableVers;
        }
    }

    class Rip {
        Integer m_iIndex;
        String m_szId;
        NameValue m_nvType;
        NameValue m_nvVendor;
        NameValue m_nvStatus;
        String m_szBootVers;
        String m_szAppVers;
        String m_szHwVers;
        String m_szAvailableVers;
        InterfaceValueObject m_ivoUpgradeControl;
        NameValue m_nvUpgradeStatus;
        String m_szUpgradeFailureReason;
        boolean m_bUpgradeWasInProgress;
        boolean m_bWasOffline;
        boolean m_bUpgradable;

        Rip(Integer n, String string, NameValue nameValue, NameValue nameValue2, String string2, String string3, String string4, InterfaceValueObject interfaceValueObject, NameValue nameValue3, String string5, String string6) {
            this.m_iIndex = n;
            this.m_szId = string;
            this.m_nvType = nameValue;
            this.m_nvStatus = nameValue2;
            this.m_szBootVers = string2;
            this.m_szAppVers = string3;
            this.m_szHwVers = string4;
            this.m_ivoUpgradeControl = interfaceValueObject;
            this.m_nvUpgradeStatus = nameValue3;
            this.m_szUpgradeFailureReason = string5;
            this.m_bUpgradeWasInProgress = false;
            this.m_bWasOffline = false;
            this.m_bUpgradable = true;
            this.m_szAvailableVers = string6;
        }

        public void setVendor(NameValue nameValue) {
            this.m_nvVendor = nameValue;
        }

        public Integer getIndex() {
            return this.m_iIndex;
        }

        public String getId() {
            return this.m_szId;
        }

        public NameValue getType() {
            return this.m_nvType;
        }

        public NameValue getVendor() {
            return this.m_nvVendor;
        }

        public void setStatus(NameValue nameValue) {
            this.m_nvStatus = nameValue;
        }

        public NameValue getStatus() {
            return this.m_nvStatus;
        }

        public void setBootVers(String string) {
            this.m_szBootVers = string;
        }

        public String getBootVers() {
            return this.m_szBootVers;
        }

        public void setAppVers(String string) {
            this.m_szAppVers = string;
        }

        public String getAppVers() {
            return this.m_szAppVers;
        }

        public String getHwVersion() {
            return this.m_szHwVers;
        }

        public InterfaceValueObject getUpgradeControl() {
            return this.m_ivoUpgradeControl;
        }

        public void setUpgradeStatus(NameValue nameValue) {
            this.m_nvUpgradeStatus = nameValue;
        }

        public NameValue getUpgradeStatus() {
            return this.m_nvUpgradeStatus;
        }

        public void setUpgradeFailureReason(String string) {
            this.m_szUpgradeFailureReason = string;
        }

        public String getUpgradeFailureReason() {
            return this.m_szUpgradeFailureReason;
        }

        public void setAvailableVers(String string) {
            this.m_szAvailableVers = string;
        }

        public String getAvailableVers() {
            return this.m_szAvailableVers;
        }

        public void setUpgradeWasInProgress(boolean bl) {
            this.m_bUpgradeWasInProgress = bl;
        }

        public boolean wasUpgradeInProgress() {
            return this.m_bUpgradeWasInProgress;
        }

        public void setWasOffline(boolean bl) {
            this.m_bWasOffline = bl;
        }

        public boolean wasOffline() {
            return this.m_bWasOffline;
        }

        public void setUpgradable(boolean bl) {
            this.m_bUpgradable = bl;
        }

        public boolean isUpgradable() {
            return this.m_bUpgradable;
        }

        public String toString() {
            return "Rip[" + this.m_iIndex + "] " + this.m_szId + ";" + JPanelSettingsVersionsRips.nvToString(this.m_nvType) + ";" + JPanelSettingsVersionsRips.nvToString(this.m_nvVendor) + ";" + JPanelSettingsVersionsRips.nvToString(this.m_nvStatus) + ";boot=" + this.m_szBootVers + ";app=" + this.m_szAppVers + ";hware=" + this.m_szHwVers + ";ctrl=" + this.m_ivoUpgradeControl + ";" + JPanelSettingsVersionsRips.nvToString(this.m_nvUpgradeStatus) + ";failure=\"" + this.m_szUpgradeFailureReason + "\"" + ";" + (this.m_bUpgradeWasInProgress ? "" : "No ") + "UpgradeInProgress" + ";Previously " + (this.m_bWasOffline ? "Offline" : "Online") + ";" + (this.m_bUpgradable ? "" : "Not ") + "Upgradeable";
        }
    }

    class ThreadPollData
    extends ThreadContinuous {
        private boolean m_bThreadSuspended;

        ThreadPollData() {
            super(5000L);
            this.m_bThreadSuspended = false;
        }

        protected void performTask() {
            if (!this.m_bThreadSuspended) {
                JPanelSettingsVersionsRips.this.updateDynamicInfo(JPanelSettingsVersionsRips.this.m_bReloadRips);
            }
        }

        public void suspendThread() {
            JPanelSettingsVersionsRips.this.logInfo("ThreadPollData: thread suspended.");
            this.m_bThreadSuspended = true;
        }

        public void resumeThread() {
            JPanelSettingsVersionsRips.this.logInfo("ThreadPollData: thread resumed.");
            this.m_bThreadSuspended = false;
        }
    }

    class EnableItemL
    implements ItemListener {
        EnableItemL() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelSettingsVersionsRips.this.setIsModified(true);
        }
    }

    class RipIdItemListener
    implements ItemListener {
        RipIdItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (JPanelSettingsVersionsRips.this.m_bIgnoreRipSelection) {
                JPanelSettingsVersionsRips.this.m_bIgnoreRipSelection = false;
            } else {
                JPanelSettingsVersionsRips.this.m_nSelIndex = JPanelSettingsVersionsRips.this.m_jcbRipIds.getSelectedIndex();
                JPanelSettingsVersionsRips.this.showStatusMsgs("", "");
                JPanelSettingsVersionsRips.this.m_jbLoadFirmware.setEnabled(true);
                JPanelSettingsVersionsRips.this.showSelectedItemInfo(false, false);
                Rip rip = JPanelSettingsVersionsRips.this.getSelectedRipFromPortRipTable();
                if (rip == null) {
                    JPanelSettingsVersionsRips.this.m_jbResetRip.setVisible(false);
                } else if (JPanelSettingsVersionsRips.this.m_bResetRipSupport) {
                    JPanelSettingsVersionsRips.this.m_jbResetRip.setVisible(true);
                    NameValue nameValue = rip.getType();
                    JPanelSettingsVersionsRips.this.enableResetRipButton(nameValue);
                }
            }
        }
    }
}

