/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JPanelStatusAvr
extends JPanelAmpPanel {
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    public static final String CNAME = "JPanelStatusAvr";
    public static final Integer STATUS_DEFAULT = new Integer(0);
    public static final Integer STATUS_LOCKED = new Integer(1);
    public static final Integer STATUS_RESERVED = new Integer(2);
    public static final Integer STATUS_RESERVED_LOCKED = new Integer(3);
    protected static int AVCT_TABLE_FEATURE_LEVEL = 1;
    protected static int INITIAL_SORT_COLUMN_NUM = 0;
    private static final Integer UPGR_READY_VAL = new Integer(1);
    private static final Integer TERMINATE_SESSION_VAL = new Integer(2);
    private ListSelectionListener m_listSelectionListener = null;
    JTableAvocent m_jTable = new JTableAvocent(AVCT_TABLE_FEATURE_LEVEL);
    private Session[] m_sessionTable;
    private TableModelColumnSorted m_tableModel;
    private ThreadPollData m_threadPollData;
    private boolean m_bDisconnecting = false;
    private ArrayList m_alSessionFields = new ArrayList();
    private ArrayList m_alColumnNames = new ArrayList();
    GridBagLayout m_gridBagLayout1 = new GridBagLayout();
    JLabel m_jlActiveVideoSessions = new JLabel();
    JScrollPane m_jScrollPane = new JScrollPane();
    JButton m_jbDisconnect = new JButton();
    private SessionStatusIcon m_iiDefault;
    private SessionStatusIcon m_iiReserved;
    private SessionStatusIcon m_iiLocked;
    private SessionStatusIcon m_iiReservedLocked;

    public JPanelStatusAvr(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, "", "AVR Status", "", "IDH_STATUS_TAB_ACTIVE_VIDEO_SESSIONS");
        URL uRL = ((Object)((Object)this)).getClass().getResource("sessDefault.gif");
        URL uRL2 = ((Object)((Object)this)).getClass().getResource("sessReserved.gif");
        URL uRL3 = ((Object)((Object)this)).getClass().getResource("sessLocked.gif");
        URL uRL4 = ((Object)((Object)this)).getClass().getResource("sessReservedLocked.gif");
        this.m_iiDefault = new SessionStatusIcon(STATUS_DEFAULT, uRL);
        this.m_iiReserved = new SessionStatusIcon(STATUS_RESERVED, uRL2);
        this.m_iiLocked = new SessionStatusIcon(STATUS_LOCKED, uRL3);
        this.m_iiReservedLocked = new SessionStatusIcon(STATUS_RESERVED_LOCKED, uRL4);
        try {
            this.initializeTable();
            this.jbInit();
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.m_gridBagLayout1);
        this.m_jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_jScrollPane.setPreferredSize(new Dimension(300, 300));
        this.m_jbDisconnect.setText(res.getString("JPanelStatusAvr_Disconnect_Session"));
        this.m_jbDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelStatusAvr.this.m_jbDisconnect_actionPerformed(actionEvent);
            }
        });
        this.m_jlActiveVideoSessions.setText(res.getString("JPanelStatusAvr_Currently_active"));
        this.getContentPane().add((Component)this.m_jlActiveVideoSessions, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_jScrollPane, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 12), 0, 0));
        this.m_jScrollPane.getViewport().add((Component)this.m_jTable, null);
        this.getContentPane().add((Component)this.m_jbDisconnect, new GridBagConstraints(-1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 12, 12), 0, 0));
        this.m_sessionTable = new Session[0];
    }

    protected boolean initialize() {
        this.m_jbDisconnect.setEnabled(false);
        this.logInfo("initialize: Creating and starting data polling thread.");
        this.m_threadPollData = new ThreadPollData();
        this.m_threadPollData.start();
        return true;
    }

    public boolean onSetActive() {
        if (this.m_nState == 103) {
            this.m_acController.setBusy(true);
            this.m_threadPollData.resumeThread();
            this.m_threadPollData.interrupt();
        }
        return super.onSetActive();
    }

    public boolean onKillActive() {
        this.logInfo("JPanelStatus.onKillActive() was called.");
        if (this.m_nState == 103) {
            this.m_threadPollData.suspendThread();
            this.m_acController.setBusy(false);
        }
        return false;
    }

    public void onDestroy() {
        this.logInfo("JPanelStatus.onDestroy() was called.");
        if (this.m_nState == 103) {
            this.m_threadPollData.stopThread();
        }
        this.m_nState = 104;
    }

    private void initializeTable() {
        this.m_alSessionFields.clear();
        this.m_alColumnNames.clear();
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableIndex");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableRipId");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableSwitchChannel");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableServerName");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableUserName");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableDuration");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableRemoteIPAddress");
        this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableControl");
        this.m_alColumnNames.add(res.getString("JPanelStatusAvr_User"));
        this.m_alColumnNames.add(res.getString("JPanelStatusAvr_Duration"));
        this.m_alColumnNames.add(res.getString("JPanelStatusAvr_Connected_To"));
        this.m_alColumnNames.add(res.getString("JPanelStatusAvr_Client_Address"));
        if (((AmpControllerAvr)this.m_acController).getAppliance().getMibMajorVersion() >= 2) {
            this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableStatus");
            this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableSessionType");
            this.m_alSessionFields.add("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTablePrimarySessionIndex");
            if (this.m_acController.isFeatureSupported("VirtualMediaSupport")) {
                this.m_alColumnNames.add(0, res.getString("JPanelStatusAvr_Status"));
                this.m_alColumnNames.add(3, res.getString("JPanelStatusAvr_Type"));
            } else {
                this.m_alColumnNames.add(2, res.getString("JPanelStatusAvr_Type"));
            }
        }
        if (this.m_listSelectionListener != null) {
            this.m_jTable.getSelectionModel().removeListSelectionListener(this.m_listSelectionListener);
        }
        this.m_tableModel = this.createTableModel();
        this.m_jTable.setModel((TableModel)this.m_tableModel);
        this.m_jTable.setColumnSelectionAllowed(false);
        this.m_jTable.setShowGrid(false);
        this.m_jTable.setIntercellSpacing(new Dimension(0, 0));
        this.m_jTable.setSelectionMode(2);
        this.m_jTable.sortTableData(INITIAL_SORT_COLUMN_NUM);
        this.m_listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                int[] nArray = JPanelStatusAvr.this.m_jTable.getSelectedRows();
                boolean bl2 = bl = nArray.length > 0;
                if (bl) {
                    JPanelStatusAvr.this.m_threadPollData.suspendThread();
                    JPanelStatusAvr.this.m_jbDisconnect.setEnabled(bl);
                    JPanelStatusAvr.this.m_acController.setBusy(false);
                    int n = 10000;
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (2.access$300(this.this$1).m_jbDisconnect.isSelected()) {
                                2.access$300(this.this$1).m_jbDisconnect.setEnabled(false);
                            }
                            JPanelStatusAvr.access$100(2.access$300(this.this$1)).resumeThread();
                        }
                    }, new Date(System.currentTimeMillis() + (long)n));
                } else {
                    JPanelStatusAvr.this.m_jbDisconnect.setEnabled(bl);
                    JPanelStatusAvr.this.m_threadPollData.resumeThread();
                }
            }

            static /* synthetic */ JPanelStatusAvr access$300(2 var0) {
                return var0.JPanelStatusAvr.this;
            }
        };
        this.m_jTable.getSelectionModel().addListSelectionListener(this.m_listSelectionListener);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    if (object instanceof ImageIcon) {
                        this.setIcon((ImageIcon)object);
                        this.setText("");
                    } else {
                        this.setIcon(null);
                        this.setText(object.toString());
                    }
                }
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
                this.setHorizontalAlignment(2);
                return this;
            }
        };
        this.m_jTable.setDefaultRenderer(ImageIcon.class, (TableCellRenderer)defaultTableCellRenderer);
        this.m_jTable.setDefaultRenderer(String.class, (TableCellRenderer)defaultTableCellRenderer);
    }

    private TableModelColumnSorted createTableModel() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return JPanelStatusAvr.this.m_alColumnNames.size();
            }

            public int getRowCount() {
                return JPanelStatusAvr.this.m_sessionTable == null ? 0 : JPanelStatusAvr.this.m_sessionTable.length;
            }

            public String getColumnName(int n) {
                return (String)JPanelStatusAvr.this.m_alColumnNames.get(n);
            }

            public Class getColumnClass(int n) {
                Class clazz = n == 0 ? (class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = JPanelStatusAvr.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon) : (class$java$lang$String == null ? (class$java$lang$String = JPanelStatusAvr.class$("java.lang.String")) : class$java$lang$String);
                return clazz;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object getValueAt(int n, int n2) {
                String string = null;
                if (n > -1 && n < JPanelStatusAvr.this.m_sessionTable.length) {
                    Session session = JPanelStatusAvr.this.m_sessionTable[n];
                    if (((AmpControllerAvr)JPanelStatusAvr.this.m_acController).getAppliance().getMibMajorVersion() >= 2) {
                        if (JPanelStatusAvr.this.m_acController.isFeatureSupported("VirtualMediaSupport")) {
                            if (n2 == 0) {
                                return session.getStatusIcon();
                            }
                            if (n2 == 1) {
                                return session.getUser();
                            }
                            if (n2 == 2) {
                                return session.getDurationString();
                            }
                            if (n2 == 3) {
                                return session.getDisplayType();
                            }
                            if (n2 == 4) {
                                return session.getServerName();
                            }
                            if (n2 == 5) {
                                return session.getClientIpAddress();
                            }
                            String string2 = String.valueOf(JPanelStatusAvr.this.m_alColumnNames.size() - 1);
                            throw new RuntimeException("Invalid column index (" + n2 + ">" + string2 + ")");
                        }
                        if (n2 == 0) {
                            return session.getUser();
                        }
                        if (n2 == 1) {
                            return session.getDurationString();
                        }
                        if (n2 == 2) {
                            return session.getDisplayType();
                        }
                        if (n2 == 3) {
                            return session.getServerName();
                        }
                        if (n2 == 4) {
                            return session.getClientIpAddress();
                        }
                        String string3 = String.valueOf(JPanelStatusAvr.this.m_alColumnNames.size() - 1);
                        throw new RuntimeException("Invalid column index (" + n2 + ">" + string3 + ")");
                    }
                    if (n2 == 0) {
                        return session.getUser();
                    }
                    if (n2 == 1) {
                        return session.getDurationString();
                    }
                    if (n2 == 2) {
                        return session.getServerName();
                    }
                    if (n2 == 3) {
                        return session.getClientIpAddress();
                    }
                    String string4 = String.valueOf(JPanelStatusAvr.this.m_alColumnNames.size() - 1);
                    throw new RuntimeException("Invalid column index (" + n2 + ">" + string4 + ")");
                }
                String string5 = String.valueOf(JPanelStatusAvr.this.m_sessionTable.length - 1);
                throw new RuntimeException("Invalid row index (" + n + ">" + string5 + ")");
            }
        };
        return new TableModelColumnSorted((TableModel)abstractTableModel, (JTable)this.m_jTable);
    }

    private void updateDynamicInfo() {
        if (this.m_nState == 103 && this.isShowing() && !this.m_bDisconnecting) {
            block7: {
                try {
                    InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), this.m_alSessionFields.toArray());
                    final Session[] sessionArray = new Session[interfaceValueObjectArray.length];
                    for (int i = 0; i < sessionArray.length; ++i) {
                        SnmpValueObject snmpValueObject = (SnmpValueObject)interfaceValueObjectArray[i][0];
                        SnmpValueObject snmpValueObject2 = (SnmpValueObject)interfaceValueObjectArray[i][2];
                        SnmpValueObject snmpValueObject3 = (SnmpValueObject)interfaceValueObjectArray[i][5];
                        Session session = new Session(snmpValueObject.getInteger(), interfaceValueObjectArray[i][1].toString(), snmpValueObject2.getInteger(), interfaceValueObjectArray[i][3].toString(), interfaceValueObjectArray[i][4].toString(), snmpValueObject3.getInteger(), interfaceValueObjectArray[i][6].toString(), interfaceValueObjectArray[i][7]);
                        if (((AmpControllerAvr)this.m_acController).getAppliance().getMibMajorVersion() >= 2) {
                            session.setStatus(interfaceValueObjectArray[i][8].getInteger());
                            session.setType(interfaceValueObjectArray[i][9].getInteger());
                            session.setDisplayType(interfaceValueObjectArray[i][9].toString());
                            session.setPrimaryIndex(interfaceValueObjectArray[i][10].getInteger());
                        }
                        session.setServerName(this.getConnectedTo(session));
                        sessionArray[i] = session;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int n;
                            int n2;
                            int[] nArray = JPanelStatusAvr.this.m_jTable.getSelectedRows();
                            int[] nArray2 = new int[nArray.length];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                n = JPanelStatusAvr.this.m_jTable.mapIndex(nArray[n2]);
                                if (n > -1 && n < JPanelStatusAvr.this.m_sessionTable.length) {
                                    nArray2[n2] = JPanelStatusAvr.this.m_sessionTable[nArray[n2]].getIndex();
                                    continue;
                                }
                                JPanelStatusAvr.this.logError("updateDynamicInfo: The selected row (" + n + ") is out of bounds of " + "m_sessionTable (length=" + JPanelStatusAvr.this.m_sessionTable.length + ").");
                            }
                            JPanelStatusAvr.access$502(JPanelStatusAvr.this, sessionArray);
                            JPanelStatusAvr.this.m_tableModel.fireTableDataChanged();
                            for (n2 = 0; n2 < JPanelStatusAvr.this.m_sessionTable.length; ++n2) {
                                for (n = 0; n < nArray2.length; ++n) {
                                    if (nArray2[n] != JPanelStatusAvr.this.m_sessionTable[n2].getIndex()) continue;
                                    JPanelStatusAvr.this.m_jTable.addRowSelectionInterval(n2, n2);
                                }
                            }
                        }
                    });
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    this.logError("updateDynamicInfo: Exception updating dynamic info. " + exceptionAsmpRequestFailed.getMessage() + ", m_nState =" + this.m_nState, (Exception)((Object)exceptionAsmpRequestFailed));
                    if (this.m_nState == 103 && this.isShowing() && !this.m_bDisconnecting) {
                        this.m_acController.getMainFrame().getHelpButton().setEnabled(false);
                        String string = res.getString("JPanelStatusAvr_Unable_to_Read_Status");
                        Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                    }
                }
                catch (Exception exception) {
                    this.logError("updateDynamicInfo: Exception updating dynamic info. " + exception.getMessage() + ", m_nState =" + this.m_nState, exception);
                    if (this.m_nState != 103 || !this.isShowing() || this.m_bDisconnecting) break block7;
                    Message.show((Component)this.m_acController.getMainFrame(), (String)exception.getMessage());
                }
            }
            this.m_acController.setBusy(false);
        }
    }

    private void m_jbDisconnect_actionPerformed(ActionEvent actionEvent) {
        this.logInfo("JPanelStatus: Disconnect button pressed.");
        final int[] nArray = this.m_jTable.getSelectedRows();
        if (nArray.length > 0) {
            this.m_threadPollData.suspendThread();
            this.m_bDisconnecting = true;
            this.logInfo("m_jbDisconnect_actionPerformed: Asking user to confirmed disconnect for (" + nArray.length + ") rows...");
            String string = res.getString("JPanelStatusAvr_Are_you_sure_you_want");
            int n = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)this), (Object)string, (String)res.getString("JPanelStatusAvr_Confirm_Disconnect"), (int)0);
            if (n == 0) {
                this.logInfo("m_jbDisconnect_actionPerformed: User confirmed disconnect (" + nArray.length + ") are selected.  Terminating each one...");
                this.m_acController.setBusy(true);
                this.m_jbDisconnect.setEnabled(false);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            for (int i = 0; i < nArray.length; ++i) {
                                int n = JPanelStatusAvr.this.m_jTable.mapIndex(nArray[i]);
                                if (n > -1 && n < JPanelStatusAvr.this.m_sessionTable.length) {
                                    JPanelStatusAvr.this.logInfo("m_jbDisconnect_actionPerformed: Sending terminate request for row=" + n + ", server=" + JPanelStatusAvr.this.m_sessionTable[n].getServerName() + "...");
                                    InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[]{JPanelStatusAvr.this.getSessionControlValue(n)};
                                    interfaceValueObjectArray[0].setValue((Object)TERMINATE_SESSION_VAL);
                                    AvrSnmpHelper.setValues(JPanelStatusAvr.this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
                                    continue;
                                }
                                JPanelStatusAvr.this.logError("m_jbDisconnect_actionPerformed: The row (" + n + ") selected for " + "session termination is out of bounds " + "of the m_sessionTable (length=" + JPanelStatusAvr.this.m_sessionTable.length + ").");
                            }
                            JPanelStatusAvr.this.m_acController.setBusy(false);
                            if (JPanelStatusAvr.this.m_nState == 103 && JPanelStatusAvr.this.isShowing()) {
                                JPanelStatusAvr.this.m_threadPollData.resumeThread();
                            }
                            JPanelStatusAvr.this.m_bDisconnecting = false;
                        }
                        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                            JPanelStatusAvr.this.logError("m_jbDisconnect_actionPerformed: Exception attempting to disconnect sessions. " + exceptionAsmpRequestFailed.getMessage() + ", m_nState =" + JPanelStatusAvr.this.m_nState, (Exception)((Object)exceptionAsmpRequestFailed));
                            if (JPanelStatusAvr.this.m_nState == 103 && JPanelStatusAvr.this.isShowing()) {
                                String string = res.getString("JPanelStatusAvr_Unable_to_Disconnect_Sessions");
                                JPanelStatusAvr.this.m_threadPollData.suspendThread();
                                Message.show((Component)JPanelStatusAvr.this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                                if (JPanelStatusAvr.this.m_nState == 103 && JPanelStatusAvr.this.isShowing()) {
                                    JPanelStatusAvr.this.m_threadPollData.resumeThread();
                                }
                                JPanelStatusAvr.this.m_bDisconnecting = false;
                            }
                            JPanelStatusAvr.this.m_acController.setBusy(false);
                        }
                        catch (Exception exception) {
                            JPanelStatusAvr.this.logError("m_jbDisconnect_actionPerformed: Exception attempting to disconnect sessions. " + exception.getMessage() + ", m_nState =" + JPanelStatusAvr.this.m_nState, exception);
                            if (JPanelStatusAvr.this.m_nState == 103 && JPanelStatusAvr.this.isShowing()) {
                                JPanelStatusAvr.this.m_threadPollData.suspendThread();
                                JPanelStatusAvr.this.m_acController.showException(null, "AVR AMP panel", "", (Throwable)exception);
                                if (JPanelStatusAvr.this.m_nState == 103 && JPanelStatusAvr.this.isShowing()) {
                                    JPanelStatusAvr.this.m_threadPollData.resumeThread();
                                }
                                JPanelStatusAvr.this.m_bDisconnecting = false;
                            }
                            JPanelStatusAvr.this.m_acController.setBusy(false);
                        }
                    }
                };
                thread.start();
            } else if (this.m_nState == 103 && this.isShowing()) {
                this.m_threadPollData.resumeThread();
                this.m_bDisconnecting = false;
            }
        }
    }

    private InterfaceValueObject getSessionControlValue(int n) {
        int n2 = -1;
        Object object = this.m_jTable.getValueAt(n, 2);
        for (int i = 0; i < this.m_sessionTable.length; ++i) {
            if (!this.m_sessionTable[i].getServerName().equals(object)) continue;
            return this.m_sessionTable[i].getSessionControl();
        }
        return this.m_sessionTable[n].getSessionControl();
    }

    private String getConnectedTo(Session session) {
        int n = this.m_acController.getApplianceInfo().getID();
        String string = null;
        try {
            string = AvrDatabaseHelper.getServerName(n, session.getRipId(), session.getChannel());
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            this.logError("getConnectedTo: Call to AvrDatabaseHelper.getServerName( " + n + ", " + session.getRipId() + ", " + session.getChannel() + " ) failed.  " + exceptionRequestFailed.getMessage());
        }
        if ((string == null || string.trim().length() == 0) && (string = session.getServerName()).trim().length() == 0) {
            string = session.getRipId().trim().length() == 0 ? res.getString("JPanelStatusAvr_Undefined") : session.getRipId() + "\u27a1" + String.valueOf(session.getChannel());
        }
        return string;
    }

    static /* synthetic */ Session[] access$502(JPanelStatusAvr jPanelStatusAvr, Session[] sessionArray) {
        jPanelStatusAvr.m_sessionTable = sessionArray;
        return sessionArray;
    }

    class SessionStatusIcon
    extends ImageIcon
    implements Comparable,
    Cloneable {
        static final int LOCKED = 1;
        static final int RESERVED = 2;
        static final int RESERVED_LOCKED = 3;
        URL url;
        protected int m_nState;

        public SessionStatusIcon(int n) {
            this.m_nState = n;
        }

        public SessionStatusIcon(int n, URL uRL) {
            super(uRL);
            this.m_nState = n;
            this.url = uRL;
        }

        public Object clone() throws NullPointerException {
            if (this.url == null) {
                throw new NullPointerException("URL object has null value");
            }
            return new SessionStatusIcon(this.m_nState, this.url);
        }

        public int compareTo(Object object) {
            if (object instanceof SessionStatusIcon) {
                SessionStatusIcon sessionStatusIcon = (SessionStatusIcon)object;
                if (sessionStatusIcon.m_nState > this.m_nState) {
                    return -1;
                }
                if (sessionStatusIcon.m_nState < this.m_nState) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    class Session {
        private final Integer UNDEFINED;
        int m_nIndex;
        String m_szRipId;
        Integer m_iChannel;
        String m_szServerName;
        String m_szUser;
        Integer m_iDuration;
        String m_szIpAddress;
        Integer m_NStatus;
        Integer m_NType;
        String m_szDisplayType;
        int SESS_TYPE_SHAREDACTIVE;
        int m_nPrimIndex;
        private final String SESS_TYPE_CONTROLLING;
        private final String SESS_TYPE_UNKNOWN;
        InterfaceValueObject m_ivoSessionControl;

        public Session() {
            this.m_NStatus = this.UNDEFINED = new Integer(-1);
            this.m_NType = this.UNDEFINED;
            this.m_szDisplayType = res.getString("JPanelStatusAvr_Sess_Type_Unknown");
            this.SESS_TYPE_SHAREDACTIVE = 3;
            this.m_nPrimIndex = this.UNDEFINED;
            this.SESS_TYPE_CONTROLLING = res.getString("JPanelStatusAvr_Sess_Type_Controlling");
            this.SESS_TYPE_UNKNOWN = res.getString("JPanelStatusAvr_Sess_Type_Unknown");
        }

        Session(int n, String string, Integer n2, String string2, String string3, Integer n3, String string4, InterfaceValueObject interfaceValueObject) {
            this.m_NStatus = this.UNDEFINED = new Integer(-1);
            this.m_NType = this.UNDEFINED;
            this.m_szDisplayType = res.getString("JPanelStatusAvr_Sess_Type_Unknown");
            this.SESS_TYPE_SHAREDACTIVE = 3;
            this.m_nPrimIndex = this.UNDEFINED;
            this.SESS_TYPE_CONTROLLING = res.getString("JPanelStatusAvr_Sess_Type_Controlling");
            this.SESS_TYPE_UNKNOWN = res.getString("JPanelStatusAvr_Sess_Type_Unknown");
            this.m_nIndex = n;
            this.m_szRipId = string;
            this.m_iChannel = n2;
            this.m_szServerName = string2;
            this.m_szUser = string3;
            this.m_iDuration = n3;
            this.m_szIpAddress = string4;
            this.m_ivoSessionControl = interfaceValueObject;
        }

        public int getIndex() {
            return this.m_nIndex;
        }

        public void setIndex(int n) {
            this.m_nIndex = n;
        }

        public void setIndex(Integer n) {
            this.m_nIndex = n;
        }

        public void setRipId(String string) {
            this.m_szRipId = string;
        }

        public String getRipId() {
            return this.m_szRipId;
        }

        public void setChannel(Integer n) {
            this.m_iChannel = n;
        }

        public int getChannel() {
            return this.m_iChannel;
        }

        public void setServerName(String string) {
            this.m_szServerName = string;
        }

        public String getServerName() {
            return this.m_szServerName;
        }

        public void setUser(String string) {
            this.m_szUser = string;
        }

        public String getUser() {
            return this.m_szUser;
        }

        public void setDuration(Integer n) {
            this.m_iDuration = n;
        }

        public Integer getDuration() {
            return this.m_iDuration;
        }

        public void setClientIpAddress(String string) {
            this.m_szIpAddress = string;
        }

        public String getClientIpAddress() {
            return this.m_szIpAddress;
        }

        public InterfaceValueObject getSessionControl() {
            return this.m_ivoSessionControl;
        }

        public void setSessionControl(InterfaceValueObject interfaceValueObject) {
            this.m_ivoSessionControl = interfaceValueObject;
        }

        public SessionStatusIcon getStatusIcon() {
            if (this.getStatus().compareTo(STATUS_DEFAULT) == 0) {
                return JPanelStatusAvr.this.m_iiDefault;
            }
            if (this.getStatus().compareTo(STATUS_RESERVED) == 0) {
                return JPanelStatusAvr.this.m_iiReserved;
            }
            if (this.getStatus().compareTo(STATUS_LOCKED) == 0) {
                return JPanelStatusAvr.this.m_iiLocked;
            }
            if (this.getStatus().compareTo(STATUS_RESERVED_LOCKED) == 0) {
                return JPanelStatusAvr.this.m_iiReservedLocked;
            }
            return JPanelStatusAvr.this.m_iiDefault;
        }

        public Integer getStatus() {
            return this.m_NStatus;
        }

        public void setStatus(Integer n) {
            this.m_NStatus = n;
        }

        public Integer getType() {
            return this.m_NType;
        }

        public void setType(Integer n) {
            this.m_NType = n;
        }

        public String getDisplayType() {
            if (this.m_NType == this.SESS_TYPE_SHAREDACTIVE && this.m_nPrimIndex == 0) {
                return this.SESS_TYPE_CONTROLLING;
            }
            return this.m_szDisplayType;
        }

        public void setDisplayType(String string) {
            this.m_szDisplayType = string;
        }

        public String getDurationString() {
            StringBuffer stringBuffer = new StringBuffer();
            long l = this.m_iDuration.intValue();
            int n = (int)(l / 86400L);
            int n2 = (int)((l %= 86400L) / 3600L);
            int n3 = (int)((l %= 3600L) / 60L);
            int n4 = (int)(l % 60L);
            if (n > 0) {
                stringBuffer.append(n + "d ");
            }
            stringBuffer.append(n2 + ":");
            stringBuffer.append(this.fmt(n3) + ":");
            stringBuffer.append(this.fmt(n4));
            return stringBuffer.toString();
        }

        String fmt(int n) {
            String string = String.valueOf(n);
            if (string.length() < 2) {
                string = "0" + string;
            }
            return string;
        }

        public void setPrimaryIndex(int n) {
            this.m_nPrimIndex = n;
        }
    }

    class ThreadPollData
    extends ThreadContinuous {
        private static final int POLL_INTERVAL = 5;
        private boolean m_bThreadSuspended;

        ThreadPollData() {
            super(5000L);
            this.m_bThreadSuspended = false;
        }

        protected void performTask() {
            if (!this.m_bThreadSuspended) {
                JPanelStatusAvr.this.updateDynamicInfo();
            }
        }

        public void suspendThread() {
            JPanelStatusAvr.this.logInfo("ThreadPollData: thread suspended.");
            this.m_bThreadSuspended = true;
        }

        public void resumeThread() {
            JPanelStatusAvr.this.logInfo("ThreadPollData: thread resumed.");
            this.m_bThreadSuspended = false;
        }
    }
}

