/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.CheckableItem;
import com.avocent.lib.gui.renderers.ListCellRendererCheckBox;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JPanelTrapsSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelTrapsSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private static final Integer TRAP_DISABLED_VAL = new Integer(1);
    private static final Integer TRAP_ENABLED_VAL = new Integer(2);
    private static final Integer WARM_START_TRAP_VAL = new Integer(2);
    InterfaceValueObject[][] m_trapConfigTable;
    private CheckableItem[] m_ciTraps;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel m_jlEnabledTraps = new JLabel();
    JScrollPane m_jScrollPane = new JScrollPane();
    JList m_jListTraps = new JList();
    JPanel m_jPanelButtons = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton m_jbEnableAll = new JButton();
    JButton m_jbDisableAll = new JButton();

    public JPanelTrapsSettings(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, res.getString("JPanelTrapsSettings_Traps"), res.getString("JPanelTrapsSettings_SNMP") + " - " + res.getString("JPanelTrapsSettings_Traps"), res.getString("JPanelTrapsSettings_Enable_Disable_SNMP"), "IDH_SETTINGS_TAB_SNMP_TRAPS");
        this.getContentPane().setVisible(false);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.m_jlEnabledTraps.setText(res.getString("JPanelTrapsSettings_Enabled_Traps_"));
        this.setLayout(this.gridBagLayout1);
        this.m_jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_jScrollPane.setPreferredSize(new Dimension(300, 300));
        this.m_jListTraps.setSelectionMode(0);
        this.m_jListTraps.setVisibleRowCount(20);
        this.m_jPanelButtons.setLayout(this.gridBagLayout2);
        this.m_jbEnableAll.setText(res.getString("JPanelTrapsSettings_Enable_All"));
        this.m_jbDisableAll.setText(res.getString("JPanelTrapsSettings_Disable_All"));
        this.add(this.m_jlEnabledTraps, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_jScrollPane, new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 10, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_jPanelButtons, new GridBagConstraints(-1, 1, 1, -1, 0.0, 0.0, 10, 3, new Insets(0, 10, 0, 10), 0, 0));
        this.m_jPanelButtons.add((Component)this.m_jbEnableAll, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.m_jScrollPane.getViewport().add((Component)this.m_jListTraps, null);
        this.m_jPanelButtons.add((Component)this.m_jbDisableAll, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.m_jListTraps.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == ' ') {
                    CheckableItem checkableItem = null;
                    int n = JPanelTrapsSettings.this.m_jListTraps.getSelectedIndex();
                    if (n >= 0) {
                        checkableItem.setSelected(!(checkableItem = (CheckableItem)JPanelTrapsSettings.this.m_jListTraps.getModel().getElementAt(n)).isSelected());
                        Rectangle rectangle = JPanelTrapsSettings.this.m_jListTraps.getCellBounds(n, n);
                        JPanelTrapsSettings.this.m_jListTraps.repaint(rectangle);
                        JPanelTrapsSettings.this.setIsModified(true);
                    }
                }
            }
        });
        this.m_jListTraps.addFocusListener(new FocusListener(){
            final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
            final Border FOCUS_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);

            public void focusGained(FocusEvent focusEvent) {
                JPanelTrapsSettings.this.m_jListTraps.setBorder(this.FOCUS_BORDER);
                int n = JPanelTrapsSettings.this.m_jListTraps.getSelectedIndex();
                if (JPanelTrapsSettings.this.m_jListTraps.getModel().getSize() > 0) {
                    if (n == -1) {
                        n = 0;
                    }
                    JPanelTrapsSettings.this.m_jListTraps.setSelectedIndex(n);
                    JPanelTrapsSettings.this.m_jListTraps.ensureIndexIsVisible(n);
                }
                JPanelTrapsSettings.this.m_jListTraps.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                JPanelTrapsSettings.this.m_jListTraps.setBorder(this.NO_FOCUS_BORDER);
                JPanelTrapsSettings.this.m_jListTraps.repaint();
            }
        });
    }

    protected boolean initialize() {
        this.getContentPane().setVisible(this.m_acController.getAppliance().isUserApplianceAdmin());
        try {
            this.removeEventListeners();
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsSnmp.dsTrapCfgTable.dsTrapCfgTableEntry.dsTrapCfgTableIndex", "avocent.ds.dsManagement.dsSnmp.dsTrapCfgTable.dsTrapCfgTableEntry.dsTrapCfgTableControl"};
            this.m_trapConfigTable = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
            this.m_trapConfigTable = this.removeUnsupportedTraps(this.m_trapConfigTable);
            this.m_ciTraps = this.createListData(this.m_trapConfigTable);
            if (this.m_ciTraps == null) {
                this.m_ciTraps = new CheckableItem[0];
            }
            this.m_jListTraps.setListData(this.m_ciTraps);
            this.m_jListTraps.setCellRenderer(new ListCellRendererCheckBox());
            this.m_jListTraps.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    CheckableItem checkableItem;
                    int n = JPanelTrapsSettings.this.m_jListTraps.locationToIndex(mouseEvent.getPoint());
                    checkableItem.setSelected(!(checkableItem = (CheckableItem)JPanelTrapsSettings.this.m_jListTraps.getModel().getElementAt(n)).isSelected());
                    Rectangle rectangle = JPanelTrapsSettings.this.m_jListTraps.getCellBounds(n, n);
                    JPanelTrapsSettings.this.m_jListTraps.repaint(rectangle);
                    JPanelTrapsSettings.this.setIsModified(true);
                }
            });
            this.m_jbEnableAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelTrapsSettings.this.setCheckBoxSelections(true);
                }
            });
            this.m_jbDisableAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelTrapsSettings.this.setCheckBoxSelections(false);
                }
            });
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    private InterfaceValueObject[][] removeUnsupportedTraps(InterfaceValueObject[][] interfaceValueObjectArray) {
        int n = interfaceValueObjectArray.length;
        if (n > 0) {
            int n2;
            Vector<InterfaceValueObject[]> vector = new Vector<InterfaceValueObject[]>(n);
            for (n2 = 0; n2 < n; ++n2) {
                InterfaceValueObject[] interfaceValueObjectArray2 = interfaceValueObjectArray[n2];
                NameValue nameValue = (NameValue)interfaceValueObjectArray2[0].getValue();
                Integer n3 = (Integer)nameValue.getValue();
                if (n3.equals(WARM_START_TRAP_VAL)) {
                    this.logInfo("removeUnsupportedTraps: found unsupported trap entry (" + nameValue.toString() + ").  It will not be included " + "in the panel list.");
                    continue;
                }
                vector.addElement(interfaceValueObjectArray2);
            }
            n = vector.size();
            if (n > 0) {
                n2 = interfaceValueObjectArray[0].length;
                interfaceValueObjectArray = new SnmpValueObject[n][n2];
                vector.copyInto((Object[])interfaceValueObjectArray);
            } else {
                interfaceValueObjectArray = new SnmpValueObject[][]{};
            }
        }
        return interfaceValueObjectArray;
    }

    protected boolean applyValues() {
        Integer n = null;
        String string = null;
        try {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsSnmp.dsTrapCfgTable.dsTrapCfgTableEntry.dsTrapCfgTableControl"};
            InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[1];
            ListModel listModel = this.m_jListTraps.getModel();
            int n2 = listModel.getSize();
            for (int i = 0; i < n2; ++i) {
                CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                n = checkableItem.isSelected() ? TRAP_ENABLED_VAL : TRAP_DISABLED_VAL;
                NameValue nameValue = (NameValue)this.m_trapConfigTable[i][1].getValue();
                string = this.m_trapConfigTable[i][0].getString();
                Integer n3 = (Integer)nameValue.getValue();
                if (n3.equals(n)) continue;
                nameValue.setValue((Object)n);
                this.m_trapConfigTable[i][1].setValue((Object)nameValue);
                interfaceValueObjectArray[0] = this.m_trapConfigTable[i][1];
                AvrSnmpHelper.setValues(this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
            }
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            Object[] objectArray = new Object[]{string};
            String string2 = n.equals(TRAP_ENABLED_VAL) ? "JPanelTrapsSettings_SNMP_Enable_Traps_Failed" : "JPanelTrapsSettings_SNMP_Disable_Traps_Failed";
            String string3 = JPanelTrapsSettings.getResourceString((ResourceManager)res, (String)string2, (Object[])objectArray) + " " + exceptionAsmpRequestFailed.getMessage();
            this.logError(string3, (Exception)((Object)exceptionAsmpRequestFailed));
            this.m_jListTraps.requestFocus();
            Message.show((Component)((Object)this), (String)string3);
            return false;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            String string4 = n.equals(TRAP_ENABLED_VAL) ? "JPanelTrapsSettings_Enable_Trap_Failed" : "JPanelTrapsSettings_Disable_Trap_Failed";
            String string5 = JPanelTrapsSettings.getResourceString((ResourceManager)res, (String)string4, (Object[])objectArray);
            this.logError(string5 + exception.getMessage(), exception);
            this.m_jListTraps.requestFocus();
            Message.show((Component)((Object)this), (String)string5);
            return false;
        }
    }

    private void setCheckBoxSelections(boolean bl) {
        ListModel listModel = this.m_jListTraps.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(bl);
            this.m_jListTraps.repaint();
        }
        this.setIsModified(true);
    }

    private CheckableItem[] createListData(InterfaceValueObject[][] interfaceValueObjectArray) {
        int n = interfaceValueObjectArray.length;
        CheckableItem[] checkableItemArray = new CheckableItem[n];
        for (int i = 0; i < n; ++i) {
            String string = interfaceValueObjectArray[i][0].toString();
            NameValue nameValue = (NameValue)interfaceValueObjectArray[i][1].getValue();
            Integer n2 = (Integer)nameValue.getValue();
            boolean bl = n2.equals(TRAP_ENABLED_VAL);
            checkableItemArray[i] = new CheckableItem(string, bl);
        }
        return checkableItemArray;
    }

    private void removeEventListeners() {
        int n;
        this.logInfo("removeEventListeners() was called.");
        MouseListener[] mouseListenerArray = this.m_jListTraps.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            this.m_jListTraps.removeMouseListener(mouseListenerArray[i]);
        }
        ActionListener[] actionListenerArray = this.m_jbEnableAll.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.m_jbEnableAll.removeActionListener(actionListenerArray[n]);
        }
        actionListenerArray = this.m_jbDisableAll.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.m_jbDisableAll.removeActionListener(actionListenerArray[n]);
        }
    }
}

