/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.JDialogAddUser;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.InterfaceStringComparable;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JPanelUsersSettings
extends JPanelAmpPanel
implements InterfaceAVWorksEventBroadcasterListener {
    public static final String CNAME = "JPanelUsersSettings";
    public static final int FULLY_ENABLED_MODE = 1;
    public static final int PASSWORD_DISABLED_MODE = 2;
    public static int DISABLED_MODE = 3;
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static int INITIAL_SORT_COLUMN_NUM = 1;
    protected static int AVCT_STD_TABLE_FEATURE_LEVEL = 1;
    boolean initialSortFlag;
    static final int INVALID_TEMP_USER_ID = 99;
    private int COLUMN_LOCK_STATUS = -1;
    private int COLUMN_USER_NAME = -1;
    private int COLUMN_ACCESS_LEVEL = -1;
    private int NUM_COLUMNS = -1;
    private static final int MAX_CHARS_DURATION = 2;
    private static final int MIN_DURATION = 1;
    private static final int MAX_DURATION = 99;
    private static final int MIB_USER_UNLOCKED = 1;
    private static final int MIB_USER_LOCKED = 2;
    private static final String DEFAULT_DURATION_BLANK = "";
    private static final String BLANK_ICON = "blank11.gif";
    private static final String LOCK_NOT_SELECTED_ICON = "lock11.gif";
    private static final String LOCK_SELECTED_ICON = "locksel11.gif";
    private boolean m_bTableColumnsSized = false;
    private boolean m_bIsSecLockoutSupported = false;
    private String[] m_aszColumnName = new String[3];
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane m_jspUserTable = new JScrollPane();
    JPanel m_jpButtonPanel = new JPanel();
    UserTableModel m_tablemodel = new UserTableModel();
    JTableAvocent m_jtUserTable = new JTableAvocent();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel m_jpSecLockoutPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    TitledBorder titledBorder1;
    JCheckBox m_jCheckBoxSecLockoutEnabled = new JCheckBox();
    JLabel m_jLabelDuration = new JLabel();
    JTextField m_jTextFieldDuration = new JTextFieldAvocent();
    JLabel m_jLabelHours = new JLabel();
    JButton m_jbUnlockButton = new JButton();
    JButton m_jbDeleteButton = new JButton();
    JButton m_jbModifyButton = new JButton();
    JButton m_jbAddButton = new JButton();
    protected int m_nApplianceAdministratorCount = 0;
    protected ImageIcon m_iiUserSelLockedIcon = null;
    protected ImageIcon m_iiUserNotSelLockedIcon = null;
    protected ImageIcon m_iiUserUnlockedIcon = null;
    protected Hashtable m_hToDeleteUser = new Hashtable();
    protected Hashtable m_hToAddUser = new Hashtable();
    protected Hashtable m_hToModifyUser = new Hashtable();
    protected Hashtable m_hToModifyAccess = new Hashtable();
    protected Hashtable m_hToUnlockUser = new Hashtable();
    protected final Vector m_vUserList = new Vector();
    protected Vector m_vServerList = new Vector();
    protected JDialogAddUser m_jdauAddUserDialog;
    protected NameValue[] m_anvAccessLevels;
    protected Hashtable m_hUserIdMap = new Hashtable();
    protected Hashtable m_hUserNameMap = new Hashtable();
    protected boolean m_bServerDataLoaded = false;
    protected Object[] APPLIANCE_ADMINISTRATOR = new Object[1];
    protected Hashtable m_hRipToChannelCount = new Hashtable();
    protected int m_mode;

    public JPanelUsersSettings() throws ExceptionConstructorFailed {
        super(null, res.getString("JPanelUsersSettings_Users"), res.getString("JPanelUsersSettings_Users"), res.getString("JPanelUsersSettings_Configure_user"), "IDH_SETTINGS_TAB_USERS");
        this.m_mode = 1;
        try {
            this.createPanelComponents();
        }
        catch (Exception exception) {
            String string = res.getString("JPanelUsersSettings_Failed_to_construct_JPUS");
            this.logError("Constructor failed.", exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public JPanelUsersSettings(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, res.getString("JPanelUsersSettings_Users"), res.getString("JPanelUsersSettings_Users"), res.getString("JPanelUsersSettings_Configure_user"), "IDH_SETTINGS_TAB_USERS");
        try {
            this.createPanelComponents();
            AmpController ampController2 = ampController;
            ampController.getAppliance().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (JPanelUsersSettings.this.m_nState != 101 && (propertyChangeEvent.getPropertyName().equalsIgnoreCase("LDAP_FOR_AUTH_ONLY") || propertyChangeEvent.getPropertyName().equalsIgnoreCase("LDAP_AUTH_LICENSED") || propertyChangeEvent.getPropertyName().equalsIgnoreCase("LOCAL_METHOD_IS_ENABLED"))) {
                        try {
                            JPanelUsersSettings.this.setupPanelMode();
                        }
                        catch (Exception exception) {
                            JPanelUsersSettings.this.m_acController.showException(null, "AVR AMP panel", null, (Throwable)exception);
                        }
                    }
                }
            });
            int[] nArray = new int[]{5, 10, 2, 8, 13};
            AVWorksEventBroadcaster.addListener((InterfaceAVWorksEventBroadcasterListener)this, (int[])nArray);
        }
        catch (Exception exception) {
            String string = res.getString("JPanelUsersSettings_Failed_to_construct_JPUS");
            this.logError("Constructor failed.", exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public void createPanelComponents() throws Exception {
        this.m_bIsSecLockoutSupported = this.isSecLockoutSupported();
        this.jbInit();
        this.initialSortFlag = true;
        URL uRL = ((Object)((Object)this)).getClass().getResource(LOCK_SELECTED_ICON);
        if (uRL != null) {
            this.m_iiUserSelLockedIcon = new ImageIcon(uRL);
        }
        if ((uRL = ((Object)((Object)this)).getClass().getResource(LOCK_NOT_SELECTED_ICON)) != null) {
            this.m_iiUserNotSelLockedIcon = new ImageIcon(uRL);
        }
        if ((uRL = ((Object)((Object)this)).getClass().getResource(BLANK_ICON)) != null) {
            this.m_iiUserUnlockedIcon = new ImageIcon(uRL);
        }
        if (this.m_bIsSecLockoutSupported) {
            this.m_aszColumnName[0] = res.getString("JPanelUsersSettings_Status");
            this.m_aszColumnName[1] = res.getString("JPanelUsersSettings_Name");
            this.m_aszColumnName[2] = res.getString("JPanelUsersSettings_Access_Level");
            this.COLUMN_LOCK_STATUS = 0;
            this.COLUMN_USER_NAME = 1;
            this.COLUMN_ACCESS_LEVEL = 2;
            this.NUM_COLUMNS = 3;
        } else {
            this.m_aszColumnName[0] = res.getString("JPanelUsersSettings_Name");
            this.m_aszColumnName[1] = res.getString("JPanelUsersSettings_Access_Level");
            this.COLUMN_USER_NAME = 0;
            this.COLUMN_ACCESS_LEVEL = 1;
            this.NUM_COLUMNS = 2;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    if (object instanceof LockStatus) {
                        ImageIcon imageIcon = JPanelUsersSettings.this.m_iiUserUnlockedIcon;
                        this.setHorizontalAlignment(2);
                        int n3 = ((LockStatus)object).getState();
                        if (n3 == 1) {
                            imageIcon = bl ? JPanelUsersSettings.this.m_iiUserSelLockedIcon : JPanelUsersSettings.this.m_iiUserNotSelLockedIcon;
                        }
                        this.setIcon(imageIcon);
                        this.setText(JPanelUsersSettings.DEFAULT_DURATION_BLANK);
                    } else {
                        this.setHorizontalAlignment(2);
                        this.setIcon(null);
                        this.setText(object.toString());
                    }
                }
                this.setBorder(bl2 && jTable.getRowSelectionAllowed() ? UIManager.getBorder("Table.focusCellHighlightBorder") : DefaultTableCellRenderer.noFocusBorder);
                return this;
            }
        };
        this.m_jtUserTable.setColumnSelectionAllowed(false);
        this.m_jtUserTable.setShowGrid(false);
        this.m_jtUserTable.setIntercellSpacing(new Dimension(0, 0));
        this.m_jtUserTable.setModel((TableModel)this.m_tablemodel);
        this.m_jtUserTable.setAvctStdTableFeatures(AVCT_STD_TABLE_FEATURE_LEVEL);
        this.m_jtUserTable.enableAvctStdTableFeatures();
        this.m_jtUserTable.setDefaultRenderer(ImageIcon.class, (TableCellRenderer)defaultTableCellRenderer);
        this.m_jtUserTable.setDefaultRenderer(String.class, (TableCellRenderer)defaultTableCellRenderer);
        this.m_jtUserTable.sortTableData(INITIAL_SORT_COLUMN_NUM);
        this.m_jbUnlockButton.setEnabled(false);
        this.m_jbDeleteButton.setEnabled(false);
        this.m_jbModifyButton.setEnabled(false);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                JPanelUsersSettings.this.setIsModified(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JPanelUsersSettings.this.setIsModified(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.m_jTextFieldDuration.getDocument().addDocumentListener(documentListener);
        this.m_jtUserTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (JPanelUsersSettings.this.m_jtUserTable.getSelectedRowCount() > 0) {
                    JPanelUsersSettings.this.m_jbDeleteButton.setEnabled(true);
                    JPanelUsersSettings.this.m_jbUnlockButton.setEnabled(JPanelUsersSettings.this.selectedUsersAreLocked());
                } else {
                    JPanelUsersSettings.this.m_jbDeleteButton.setEnabled(false);
                    JPanelUsersSettings.this.m_jbUnlockButton.setEnabled(false);
                }
                int n = JPanelUsersSettings.this.m_jtUserTable.getSelectedRowCount();
                JPanelUsersSettings.this.m_jbModifyButton.setEnabled(n == 1);
            }
        });
        this.m_jCheckBoxSecLockoutEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    JPanelUsersSettings.this.setIsModified(true);
                    JPanelUsersSettings.this.enableSecLockoutDuration();
                    return;
                }
                if (n == 2) {
                    JPanelUsersSettings.this.setIsModified(true);
                    JPanelUsersSettings.this.disableSecLockoutDuration();
                    return;
                }
            }
        });
        INITIAL_SORT_COLUMN_NUM = this.COLUMN_USER_NAME;
    }

    public void doHandleEvent(Object object, int n) {
        Trace.logInfo((String)"UsersEventListenerInterface:doHandleEvent", (String)("Received event ID=" + n));
        if (n == 8) {
            this.processDeletedServerList((UnitInfo[])object);
        } else if (n == 2) {
            this.processModifiedServerList((UnitInfo[])object);
        } else if (n == 13) {
            this.processMergedServerList((Map)object);
        } else if (!(n != 10 && ((ApplianceInfo)object).getID() != this.m_acController.getApplianceInfo().getID() || this.isVisible())) {
            this.m_nState = 101;
        }
    }

    public void processDeletedServerList(UnitInfo[] unitInfoArray) {
        block0: for (int i = 0; i < unitInfoArray.length; ++i) {
            if (this.m_vServerList == null || this.m_vServerList.isEmpty()) continue;
            Iterator iterator = this.m_vServerList.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                if (server.getID() != unitInfoArray[i].getID()) continue;
                server.setNameToRip();
                continue block0;
            }
        }
    }

    public void processModifiedServerList(UnitInfo[] unitInfoArray) {
        block0: for (int i = 0; i < unitInfoArray.length; ++i) {
            if (this.m_vServerList == null || this.m_vServerList.isEmpty()) continue;
            Iterator iterator = this.m_vServerList.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                if (server.getID() != unitInfoArray[i].getID()) continue;
                server.rename(unitInfoArray[i].getName());
                continue block0;
            }
        }
    }

    public void processMergedServerList(Map map) {
        if (this.m_vServerList == null || this.m_vServerList.isEmpty()) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        block0: while (iterator.hasNext()) {
            ServerInfo serverInfo = (ServerInfo)iterator.next();
            ServerInfo serverInfo2 = (ServerInfo)map.get(serverInfo);
            Trace.logInfo((String)CNAME, (String)("Merging " + serverInfo + " with " + serverInfo2));
            Iterator iterator2 = this.m_vServerList.iterator();
            while (iterator2.hasNext()) {
                Server server = (Server)iterator2.next();
                if (server.getID() != serverInfo.getID()) continue;
                server.rewrap(serverInfo2);
                continue block0;
            }
        }
    }

    private boolean selectedUsersAreLocked() {
        int[] nArray = this.m_jtUserTable.getSelectedRows();
        if (nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            User user = (User)this.m_jtUserTable.getValueAt(nArray[i], this.COLUMN_USER_NAME);
            if (user.isLocked()) continue;
            return false;
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.m_jpButtonPanel.setLayout(this.gridBagLayout2);
        if (this.m_bIsSecLockoutSupported) {
            this.titledBorder1 = new TitledBorder(DEFAULT_DURATION_BLANK);
            this.m_jpSecLockoutPanel.setLayout(this.gridBagLayout3);
            this.m_jpSecLockoutPanel.setBorder(this.titledBorder1);
            this.m_jbUnlockButton.setText(res.getString("JPanelUsersSettings_Unlock"));
            this.m_jbUnlockButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelUsersSettings.this.m_jbUnlockButton_actionPerformed(actionEvent);
                }
            });
            this.titledBorder1.setTitle(res.getString("JPanelUsersSettings_Security_Lockout"));
            this.m_jCheckBoxSecLockoutEnabled.setText(res.getString("JPanelUsersSettings_SecLockOut_Enabled"));
            this.m_jTextFieldDuration.setFont(new Font("SansSerif", 0, 12));
            this.m_jTextFieldDuration.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_jTextFieldDuration.setPreferredSize(new Dimension(0, 18));
            this.m_jTextFieldDuration.setEditable(true);
            this.m_jTextFieldDuration.setEnabled(false);
            this.m_jLabelDuration.setText(res.getString("JPanelUsersSettings_Duration"));
            this.m_jLabelHours.setText(res.getString("JPanelUsersSettings_Hours"));
        }
        this.m_jbDeleteButton.setText(res.getString("JPanelUsersSettings_Delete"));
        this.m_jbDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelUsersSettings.this.m_jbDeleteButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbModifyButton.setText(res.getString("JPanelUsersSettings_Modify_"));
        this.m_jbModifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelUsersSettings.this.m_jbModifyButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbAddButton.setText(res.getString("JPanelUsersSettings_Add_"));
        this.m_jbAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelUsersSettings.this.m_jbAddButton_actionPerformed(actionEvent);
            }
        });
        this.m_jtUserTable.setBackground(UIManager.getColor("Table.background"));
        this.m_jspUserTable.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_jspUserTable.setPreferredSize(new Dimension(300, 300));
        this.add(this.m_jspUserTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.m_jspUserTable.getViewport().add((Component)this.m_jtUserTable, null);
        this.add(this.m_jpButtonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 15), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbAddButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbModifyButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbDeleteButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
        if (this.m_bIsSecLockoutSupported) {
            this.m_jpButtonPanel.add((Component)this.m_jbUnlockButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.add(this.m_jpSecLockoutPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(11, 5, 11, 5), 0, 0));
            this.m_jpSecLockoutPanel.add((Component)this.m_jLabelDuration, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_jpSecLockoutPanel.add((Component)this.m_jTextFieldDuration, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(6, 0, 6, 0), 0, 0));
            this.m_jpSecLockoutPanel.add((Component)this.m_jCheckBoxSecLockoutEnabled, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.m_jpSecLockoutPanel.add((Component)this.m_jLabelHours, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
    }

    public boolean initialize() {
        try {
            this.m_nState = 101;
            this.setupPanelMode();
            this.m_hToAddUser = new Hashtable();
            this.m_hToDeleteUser = new Hashtable();
            this.m_hToModifyAccess = new Hashtable();
            this.m_hToModifyUser = new Hashtable();
            this.m_hToUnlockUser = new Hashtable();
            this.loadUserTable();
            this.loadServerTable();
            if (this.m_bIsSecLockoutSupported) {
                this.loadSecLockoutDuration();
                this.m_bIsModified = false;
            }
            this.m_anvAccessLevels = AvrSnmpHelper.getInstance().getMibEnumPairs("avocent.ds.dsManagement.dsUser.dsUserAccessLevel.0");
            for (int i = 0; i < this.m_anvAccessLevels.length; ++i) {
                if ((Integer)this.m_anvAccessLevels[i].getValue() != 3) continue;
                this.APPLIANCE_ADMINISTRATOR[0] = this.m_anvAccessLevels[i].getName();
                break;
            }
            if (this.initialSortFlag) {
                try {
                    this.m_jtUserTable.setInitialSortColumn(INITIAL_SORT_COLUMN_NUM);
                    this.m_jtUserTable.doInitialColumnSorting();
                    this.initialSortFlag = false;
                }
                catch (RuntimeException runtimeException) {
                    Trace.logError((String)"JPanelUserSettings: ", (String)runtimeException.toString());
                }
            } else {
                this.displayAddedDataSorted();
            }
            this.setPanelState(103);
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            String string = "Unable to initialize user settings panel.";
            this.logError(string, exception);
            return false;
        }
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
    }

    public boolean onKillActive() {
        if (this.m_nState == 103 && !this.isValidSecLockoutDuration()) {
            String string = res.getString("JPanelUsersSettings_Invalid_Duration");
            Message.show((Component)((Object)this), (String)string);
            this.m_jTextFieldDuration.grabFocus();
            return true;
        }
        return false;
    }

    public User getUserForId(Integer n) throws ExceptionNoValue {
        User user = (User)this.m_hUserIdMap.get(n);
        if (user == null) {
            throw new ExceptionNoValue(res.getString("JPanelUsersSettings_Unable_to_find_user"));
        }
        return user;
    }

    public User getUserForName(String string) throws ExceptionNoValue {
        User user = (User)this.m_hUserNameMap.get(string);
        if (user == null) {
            throw new ExceptionNoValue(res.getString("JPanelUsersSettings_Unable_to_find_user"));
        }
        return user;
    }

    public boolean userExists(String string) {
        User user = (User)this.m_hUserNameMap.get(string);
        return user != null;
    }

    protected void loadUserTable() throws Exception {
        this.m_vUserList.removeAllElements();
        this.m_nApplianceAdministratorCount = 0;
        this.m_hUserIdMap.clear();
        this.m_hUserNameMap.clear();
        this.m_bServerDataLoaded = false;
        this.m_vServerList.removeAllElements();
        Object[] objectArray = this.getLoadFieldNames();
        InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
        for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
            User user = this.createNewUser(interfaceValueObjectArray[i]);
            this.m_vUserList.addElement(user);
            this.m_hUserIdMap.put(user.m_iUserId, user);
            this.m_hUserNameMap.put(user.m_szName, user);
            if (!user.isApplianceAdministrator()) continue;
            ++this.m_nApplianceAdministratorCount;
        }
        try {
            this.resizeTableColumnWidths();
        }
        catch (Exception exception) {
            Trace.logError((String)exception.toString(), (String)DEFAULT_DURATION_BLANK);
        }
        this.m_tablemodel.fireTableDataChanged();
    }

    protected void loadServerTable() throws Exception {
        if (this.m_bServerDataLoaded) {
            return;
        }
        this.loadSwitchInformation();
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableAccessControlList"};
        InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
        int n = this.m_acController.getApplianceInfo().getID();
        this.m_vServerList.removeAllElements();
        for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
            int n2;
            Object v;
            String string = interfaceValueObjectArray[i][0].toString();
            String string2 = interfaceValueObjectArray[i][1].toString();
            int n3 = interfaceValueObjectArray[i][2].getInteger();
            if (n3 > 0 && ((v = this.m_hRipToChannelCount.get(string2)) == null || n3 > (n2 = ((Integer)v).intValue()))) continue;
            int n4 = AvrDatabaseHelper.getServerId(n, string2, n3);
            String string3 = null;
            if (n4 > -1) {
                string3 = ServersDb.getServerName((int)n4);
            }
            if (string3 != null && string3.length() != 0) {
                string = string3;
            } else if (string == null || string.length() == 0) {
                string = string2 + "-" + n3;
            }
            Server server = new Server(string, string2, n3, n4);
            this.m_vServerList.addElement(server);
            byte[] byArray = interfaceValueObjectArray[i][3].getByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                User user = this.getUserForId(new Integer(byArray[j]));
                user.addServer(server);
            }
        }
        this.m_bServerDataLoaded = true;
    }

    public int getApplianceAdministratorCount() {
        return this.m_nApplianceAdministratorCount;
    }

    public int getServerCount() throws Exception {
        if (!this.m_bServerDataLoaded) {
            this.loadServerTable();
        }
        return this.m_vServerList.size();
    }

    public Server getServerAt(int n) throws Exception {
        if (!this.m_bServerDataLoaded) {
            this.loadServerTable();
        }
        return (Server)this.m_vServerList.elementAt(n);
    }

    public void addToAddUserList(User user) {
        if (this.m_hUserNameMap.get(user.m_szName) != null) {
            Message.show((Component)((Object)this), (String)res.getString("JPanelUsersSettings_duplicate_user_name"));
            return;
        }
        this.m_hToAddUser.put(user.m_szName, user);
        this.m_vUserList.addElement(user);
        if (user.isApplianceAdministrator()) {
            ++this.m_nApplianceAdministratorCount;
        }
        int n = this.m_vUserList.size() - 1;
        this.m_tablemodel.fireTableRowsInserted(n, n);
        this.m_hUserNameMap.put(user.m_szName, user);
        this.setIsModified(true);
    }

    private void displayAddedDataSorted() {
        try {
            int n = this.m_jtUserTable.getLastClickedColumnNum();
            boolean bl = !this.m_jtUserTable.getNextSortDirection();
            this.m_jtUserTable.setNextSortDirection(bl);
            this.m_jtUserTable.setInitialSortColumn(n);
            this.m_jtUserTable.doInitialColumnSorting();
        }
        catch (RuntimeException runtimeException) {
            Trace.logError((String)"JPanelUserSettings: ", (String)runtimeException.toString());
        }
    }

    public void addToModifyUserList(User user, boolean bl) {
        if (this.m_hToAddUser.get(user.getUserName()) == null) {
            this.m_hToModifyUser.put(user.getUserName(), user);
        }
        if (bl) {
            --this.m_nApplianceAdministratorCount;
        } else if (user.isApplianceAdministrator()) {
            ++this.m_nApplianceAdministratorCount;
        }
        this.setIsModified(true);
        Runnable runnable = new Runnable(){

            public void run() {
                JPanelUsersSettings.this.displayAddedDataSorted();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addToModifyAccessList(User user) {
        this.m_hToModifyAccess.put(user.getUserName(), user);
        this.setIsModified(true);
    }

    void m_jbModifyButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_jdauAddUserDialog = new JDialogAddUser(this, this.m_anvAccessLevels);
            int[] nArray = this.m_jtUserTable.getSelectedRows();
            if (nArray.length == 0) {
                Message.show((Component)((Object)this), (String)res.getString("JPanelUsersSettings_Please_select_a_user"));
                return;
            }
            User user = (User)this.m_jtUserTable.getValueAt(nArray[0], this.COLUMN_USER_NAME);
            this.m_jdauAddUserDialog.showModifyUser(user);
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            this.logError("Exception while attempting to showt the modify user dialog.", (Exception)((Object)exceptionConstructorFailed));
            String string = res.getString("JPanelUsersSettings_Error_while");
            Message.show((Component)((Object)this), (String)string);
        }
    }

    void m_jbDeleteButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.m_jtUserTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        Vector<User> vector = new Vector<User>();
        for (n = 0; n < nArray.length; ++n) {
            vector.addElement((User)this.m_jtUserTable.getValueAt(nArray[n], this.COLUMN_USER_NAME));
        }
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((User)vector.elementAt(i)).isApplianceAdministrator()) continue;
            ++n;
        }
        if (!this.getController().isFeatureSupported("OverrideAdminUser") && this.getApplianceAdministratorCount() - n < 1) {
            String string = res.getString("JPanelUsersSettings_Cannot_remove_last_app_admin");
            string = MessageFormat.format(string, this.APPLIANCE_ADMINISTRATOR);
            Message.show((Component)this.m_acController.getMainFrame(), (String)string);
            return;
        }
        String string = res.getString("JPanelUsersSettings_Delete_0_selected");
        Object[] objectArray = new Object[]{DEFAULT_DURATION_BLANK + nArray.length};
        int n2 = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)this), (Object)(string = MessageFormat.format(string, objectArray)), (String)res.getString("JPanelUsersSettings_Confirm_Deletion"), (int)0);
        if (n2 == 0) {
            this.m_jtUserTable.clearSelection();
            Arrays.sort(nArray);
            for (int i = 0; i < vector.size(); ++i) {
                User user = (User)vector.elementAt(i);
                if (user.m_iUserId != null && this.m_hUserIdMap.get(user.m_iUserId) != null) {
                    this.m_hToDeleteUser.put(user.m_szName, user);
                }
                if (user.m_iUserId == 99) {
                    this.m_hToDeleteUser.put(user.m_szName, user);
                }
                this.m_vUserList.remove(user);
                if (user.isApplianceAdministrator()) {
                    --this.m_nApplianceAdministratorCount;
                }
                this.m_hToModifyUser.remove(user.getUserName());
                this.m_hToModifyAccess.remove(user.getUserName());
                this.m_hToAddUser.remove(user.m_szName);
                if (user.m_iUserId != null) {
                    this.m_hUserIdMap.remove(user.m_iUserId);
                }
                this.m_hUserNameMap.remove(user.m_szName);
            }
            this.redisplayTableData();
            this.setIsModified(true);
        }
    }

    private void redisplayTableData() throws ClassCastException {
        this.m_tablemodel.fireTableDataChanged();
    }

    void m_jbAddButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.m_vUserList.size();
            if (n >= 64) {
                Message.show((Component)((Object)this), (String)res.getString("JPanelUsersSettings_Maximum_number_of"));
                return;
            }
            this.m_jdauAddUserDialog = new JDialogAddUser(this, this.m_anvAccessLevels);
            this.m_jdauAddUserDialog.showAddUser();
        }
        catch (Exception exception) {
            this.logError("Exception while showing add user dialog.", exception);
            Message.show((Component)((Object)this), (String)res.getString("JPanelUsersSettings_Exception_while"));
        }
    }

    void m_jbUnlockButton_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        int[] nArray = this.m_jtUserTable.getSelectedRows();
        final AbstractTableModel abstractTableModel = (AbstractTableModel)this.m_jtUserTable.getModel();
        for (int i = 0; i < nArray.length; ++i) {
            User user = (User)this.m_jtUserTable.getValueAt(nArray[i], this.COLUMN_USER_NAME);
            user.setLockStatus(false);
            this.m_hToUnlockUser.put(user.m_szName, user);
            ++n;
        }
        if (n > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    abstractTableModel.fireTableRowsUpdated(0, JPanelUsersSettings.this.m_jtUserTable.getRowCount() - 1);
                    JPanelUsersSettings.this.m_jbUnlockButton.setEnabled(false);
                    JPanelUsersSettings.this.m_jtUserTable.grabFocus();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
            this.setIsModified(true);
        }
    }

    public boolean applyValues() {
        try {
            Object[] objectArray;
            Object[] objectArray2;
            Integer[] integerArray;
            if (this.m_bIsSecLockoutSupported && !this.applySecurityLockoutChanges()) {
                return false;
            }
            Object[] objectArray3 = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
            Integer n = new Integer(4);
            Enumeration enumeration = this.m_hToDeleteUser.elements();
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            for (int i = 0; i < vector.size(); ++i) {
                integerArray = (Integer[])vector.elementAt(i);
                if (integerArray.getUserId() == 99) continue;
                objectArray2 = new Object[]{integerArray.m_szName, n};
                try {
                    AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray3, objectArray2);
                    this.m_hToDeleteUser.remove(integerArray.m_szName);
                    continue;
                }
                catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                    Trace.logError((String)"AVR AMP panel", (String)("Error while attempting to delete user: " + exceptionSnmpRequestFailed.getMessage()), (Throwable)exceptionSnmpRequestFailed);
                    if (integerArray != null) {
                        this.m_hToDeleteUser.remove(integerArray.m_szName);
                        this.m_vUserList.add(integerArray);
                        this.m_tablemodel.fireTableDataChanged();
                    }
                    String string = res.getString("JPanelUsersSettings_Users_Delete_Failed");
                    Object[] objectArray4 = new Object[]{integerArray.m_szName};
                    string = MessageFormat.format(string, objectArray4);
                    String string2 = res.getString("JPanelUsersSettings_overwrite_file");
                    Message.showReasonMessage((Component)this.m_acController.getMainFrame(), (String)string2, (String)string);
                    return false;
                }
            }
            Hashtable[] hashtableArray = new Hashtable[]{this.m_hToAddUser, this.m_hToModifyUser};
            integerArray = new Integer[]{new Integer(2), new Integer(3)};
            objectArray2 = null;
            Object[] objectArray5 = null;
            for (int i = 0; i < hashtableArray.length; ++i) {
                enumeration = hashtableArray[i].elements();
                while (enumeration.hasMoreElements()) {
                    objectArray = (Object[])enumeration.nextElement();
                    if (objectArray.wasPasswordModified()) {
                        objectArray2 = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUserPassword.0", "avocent.ds.dsManagement.dsUser.dsUserAccessLevel.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
                        objectArray5 = new Object[]{objectArray.m_szName, objectArray.m_szPassword, objectArray.m_oAccessLevel, integerArray[i]};
                        objectArray.clearPasswordModified();
                    } else {
                        objectArray2 = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUserAccessLevel.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
                        objectArray5 = new Object[]{objectArray.m_szName, objectArray.m_oAccessLevel, integerArray[i]};
                    }
                    try {
                        AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray2, objectArray5);
                    }
                    catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                        Trace.logError((String)"AVR AMP panel", (String)("Error while applying user data changes: " + exceptionSnmpRequestFailed.getMessage()), (Throwable)exceptionSnmpRequestFailed);
                        if (exceptionSnmpRequestFailed.getErrorIndex() == 2) {
                            String string = res.getString("JPanelUsersSettings_Password_Invalid");
                            Object[] objectArray6 = new Object[]{objectArray5[0]};
                            string = MessageFormat.format(string, objectArray6);
                            Message.show((Component)((Object)this), (String)string);
                        } else {
                            String string = res.getString("JPanelUsersSettings_Users_Apply_Failed_User");
                            Object[] objectArray7 = new Object[]{objectArray5[0]};
                            string = MessageFormat.format(string, objectArray7);
                            Message.show((Component)((Object)this), (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
                        }
                        return false;
                    }
                    catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                        this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
                        this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
                        String string = res.getString("JPanelUsersSettings_Users_Apply_Failed");
                        Message.show((Component)((Object)this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                        return false;
                    }
                }
            }
            Object[] objectArray8 = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
            objectArray = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUserRipId.0", "avocent.ds.dsManagement.dsUser.dsUserChannel.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
            Object[] objectArray9 = new Object[]{DEFAULT_DURATION_BLANK, new Integer(5)};
            Object[] objectArray10 = new Object[]{DEFAULT_DURATION_BLANK, DEFAULT_DURATION_BLANK, DEFAULT_DURATION_BLANK, new Integer(6)};
            enumeration = this.m_hToModifyAccess.elements();
            while (enumeration.hasMoreElements()) {
                User user = (User)enumeration.nextElement();
                if (!user.isUser()) continue;
                objectArray9[0] = user.m_szName;
                AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray8, objectArray9);
                for (int i = 0; i < user.getServerCount(); ++i) {
                    Server server = user.getServerAt(i);
                    objectArray10[0] = user.m_szName;
                    objectArray10[1] = server.m_szRipId;
                    objectArray10[2] = new Integer(server.m_nChannel);
                    AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray10);
                }
            }
            if (this.isShowing()) {
                this.initialize();
            }
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("JPanelUsersSettings_Users_Apply_Failed");
            Message.show((Component)((Object)this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)this.getTraceContext(), (String)"Exception while applying user settings: ", (Throwable)exception);
            String string = res.getString("JPanelUsersSettings_Error_while_modifying");
            Message.show((Component)((Object)this), (String)string);
            return false;
        }
    }

    private boolean applySecurityLockoutChanges() throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        if (!this.isValidSecLockoutDuration()) {
            String string = res.getString("JPanelUsersSettings_Invalid_Duration");
            Message.show((Component)((Object)this), (String)string);
            this.m_jTextFieldDuration.grabFocus();
            return false;
        }
        Object[] objectArray3 = new Object[]{"avocent.ds.dsManagement.dsServer.dsUserLockDuration.0"};
        Integer n = new Integer(0);
        try {
            objectArray2 = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray3);
            n = (Integer)objectArray2[0].getValue();
        }
        catch (Exception exception) {
            return false;
        }
        objectArray2 = new Object[]{"avocent.ds.dsManagement.dsServer.dsUserLockDuration.0"};
        Integer n2 = null;
        String string = this.m_jTextFieldDuration.getText().trim();
        n2 = string.equals(DEFAULT_DURATION_BLANK) ? new Integer(0) : Integer.valueOf(string);
        if (!n.equals(n2)) {
            objectArray = new Integer[]{n2};
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray2, objectArray);
        }
        objectArray = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserName.0", "avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0"};
        Integer n3 = new Integer(7);
        Enumeration enumeration = this.m_hToUnlockUser.elements();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            User user = (User)enumeration2.nextElement();
            Object[] objectArray4 = new Object[]{user.m_szName, n3};
            boolean bl = false;
            Enumeration enumeration3 = this.m_hToDeleteUser.elements();
            while (enumeration3.hasMoreElements()) {
                User user2 = (User)enumeration3.nextElement();
                if (!user.m_szName.equals(user2.m_szName)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            try {
                AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray4);
                this.m_hToUnlockUser.remove(user.m_szName);
            }
            catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                Trace.logError((String)"AVR AMP panel", (String)("Error while attempting to unlock user \"" + user.m_szName + "\" : " + exceptionSnmpRequestFailed.getMessage()), (Throwable)exceptionSnmpRequestFailed);
                this.m_hToUnlockUser.remove(user.m_szName);
                user.setLockStatus(true);
                String string2 = res.getString("JPanelUsersSettings_Users_Unlock_Failed");
                Object[] objectArray5 = new Object[]{user.m_szName};
                string2 = MessageFormat.format(string2, objectArray5);
                String string3 = res.getString("JPanelUsersSettings_overwrite_file");
                Message.showReasonMessage((Component)this.m_acController.getMainFrame(), (String)string3, (String)string2);
                Runnable runnable = new Runnable(){

                    public void run() {
                        AbstractTableModel abstractTableModel = (AbstractTableModel)JPanelUsersSettings.this.m_jtUserTable.getModel();
                        abstractTableModel.fireTableRowsUpdated(0, JPanelUsersSettings.this.m_jtUserTable.getRowCount() - 1);
                        JPanelUsersSettings.this.setIsModified(JPanelUsersSettings.this.m_hToUnlockUser.size() > 0);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
                return false;
            }
        }
        return true;
    }

    private boolean isValidSecLockoutDuration() {
        try {
            String string = this.m_jTextFieldDuration.getText().trim();
            if (string.equals(DEFAULT_DURATION_BLANK)) {
                return !this.m_jCheckBoxSecLockoutEnabled.isSelected();
            }
            int n = Integer.parseInt(string);
            if (this.m_jCheckBoxSecLockoutEnabled.isSelected() && (n < 1 || n > 99)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private Object[] getLoadFieldNames() {
        if (this.m_bIsSecLockoutSupported) {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableIndex", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableName", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTablePassword", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableAccessLevel", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableLockStatus"};
            return objectArray;
        }
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableIndex", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableName", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTablePassword", "avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableAccessLevel"};
        return objectArray;
    }

    private User createNewUser(InterfaceValueObject[] interfaceValueObjectArray) throws Exception {
        User user = null;
        if (this.m_bIsSecLockoutSupported) {
            boolean bl = false;
            Integer n = interfaceValueObjectArray[4].getInteger();
            switch (n) {
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            user = new User(interfaceValueObjectArray[0].getInteger(), interfaceValueObjectArray[1].toString(), interfaceValueObjectArray[2].toString(), (NameValue)interfaceValueObjectArray[3].getValue(), bl);
        } else {
            user = new User(interfaceValueObjectArray[0].getInteger(), interfaceValueObjectArray[1].toString(), interfaceValueObjectArray[2].toString(), (NameValue)interfaceValueObjectArray[3].getValue());
        }
        return user;
    }

    private void enableSecLockoutDuration() {
        if (this.m_mode == 1) {
            this.m_jTextFieldDuration.setEnabled(true);
            this.m_jTextFieldDuration.setEditable(true);
        }
    }

    private void disableSecLockoutDuration() {
        this.m_jTextFieldDuration.setEnabled(false);
        this.m_jTextFieldDuration.setEditable(false);
        this.m_jTextFieldDuration.setText(DEFAULT_DURATION_BLANK);
    }

    private void loadSecLockoutDuration() {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsUserLockDuration.0"};
        Integer n = new Integer(0);
        try {
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
            n = (Integer)interfaceValueObjectArray[0].getValue();
        }
        catch (Exception exception) {
            this.disableSecLockoutDuration();
            return;
        }
        if (n == 0) {
            this.m_jCheckBoxSecLockoutEnabled.setSelected(false);
            this.disableSecLockoutDuration();
        } else {
            this.m_jCheckBoxSecLockoutEnabled.setSelected(true);
            this.enableSecLockoutDuration();
            this.m_jTextFieldDuration.setText(n.toString());
        }
    }

    private void resizeTableColumnWidths() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!JPanelUsersSettings.this.m_bTableColumnsSized) {
                    JTableAvocent jTableAvocent = JPanelUsersSettings.this.m_jtUserTable;
                    TableColumnPacker tableColumnPacker = new TableColumnPacker((JTable)jTableAvocent);
                    int n = 2;
                    tableColumnPacker.packAllColumns(n);
                    JPanelUsersSettings.this.m_bTableColumnsSized = true;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private boolean isSecLockoutSupported() {
        int n = this.m_acController.getAppliance().getMibMajorVersion();
        int n2 = this.m_acController.getAppliance().getMibMinorVersion();
        return n > 1 || n >= 1 && n2 >= 1;
    }

    public String getTraceContext() {
        return "AVR AMP User Settings";
    }

    void loadSwitchInformation() throws ExceptionRequestFailed {
        this.m_hRipToChannelCount.clear();
        String string = " WHERE APPLIANCE_ID=" + this.m_acController.getApplianceInfo().getID() + " AND CONN_TYPE=" + 2;
        InterfaceInfo[] interfaceInfoArray = new InterfaceInfo[]{};
        try {
            interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            // empty catch block
        }
        for (int i = 0; i < interfaceInfoArray.length; ++i) {
            int n;
            Object object;
            try {
                object = AppliancesDb.getApplianceInfo((int)interfaceInfoArray[i].getConnID());
                n = AvrDatabaseHelper.getSwitchPortCount(object.getProductID());
            }
            catch (Exception exception) {
                continue;
            }
            object = new Integer(interfaceInfoArray[i].getConnID());
            this.m_hRipToChannelCount.put(interfaceInfoArray[i].getName(), new Integer(n));
        }
    }

    void setupPanelMode() throws Exception {
        Appliance appliance = this.m_acController.getAppliance();
        LdapSupport ldapSupport = appliance.getLdapSupport();
        AuthSupport authSupport = appliance.getLocalAuthSupport();
        boolean bl = true;
        if (AVWorksBranding.getBoolean((String)"localAuthAlwaysOn", (boolean)true)) {
            bl = true;
        } else if (appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            bl = authSupport.getIsEnabled(false);
        }
        int n = DISABLED_MODE;
        if (bl) {
            n = 1;
        } else if (ldapSupport.getIsLicensed(false) && ldapSupport.getIsEnabled(false)) {
            n = ldapSupport.isLdapForAuthOnly(false) ? 2 : DISABLED_MODE;
        }
        this.setMode(n);
    }

    public void setMode(int n) {
        this.m_mode = n;
        Color color = UIManager.getColor("control");
        Color color2 = UIManager.getColor("TextField.background");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = this.m_jCheckBoxSecLockoutEnabled.isSelected();
        if (n == DISABLED_MODE) {
            bl = false;
            bl2 = false;
        } else if (n == 1) {
            bl = true;
            bl2 = true;
        } else if (n == 2) {
            bl = true;
            bl2 = false;
        }
        int n2 = this.m_jtUserTable.getSelectedRowCount();
        this.m_jbAddButton.setEnabled(bl);
        this.m_jbModifyButton.setEnabled(bl && n2 == 1);
        this.m_jbDeleteButton.setEnabled(bl && n2 >= 1);
        this.m_jbUnlockButton.setEnabled(bl && this.selectedUsersAreLocked());
        this.m_jtUserTable.setEnabled(bl);
        this.m_jtUserTable.setBackground(bl ? color2 : color);
        this.m_jspUserTable.getViewport().setBackground(bl ? color2 : color);
        this.m_jCheckBoxSecLockoutEnabled.setEnabled(bl2);
        this.m_jTextFieldDuration.setEnabled(bl2 && bl3);
        this.m_jTextFieldDuration.setBackground(bl2 && bl3 ? color2 : color);
        if (!bl) {
            this.m_jtUserTable.clearSelection();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    private class UserTableModel
    extends AbstractTableModel {
        private UserTableModel() {
        }

        public int getColumnCount() {
            return JPanelUsersSettings.this.NUM_COLUMNS;
        }

        public int getRowCount() {
            return JPanelUsersSettings.this.m_vUserList.size();
        }

        public String getColumnName(int n) {
            return JPanelUsersSettings.this.m_aszColumnName[n];
        }

        public Class getColumnClass(int n) {
            if (JPanelUsersSettings.this.m_bIsSecLockoutSupported) {
                Class clazz = n == JPanelUsersSettings.this.COLUMN_LOCK_STATUS ? (class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = JPanelUsersSettings.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon) : (class$java$lang$String == null ? (class$java$lang$String = JPanelUsersSettings.class$("java.lang.String")) : class$java$lang$String);
                return clazz;
            }
            return class$java$lang$String == null ? (class$java$lang$String = JPanelUsersSettings.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                return null;
            }
            User user = (User)JPanelUsersSettings.this.m_vUserList.elementAt(n);
            if (JPanelUsersSettings.this.m_bIsSecLockoutSupported && n2 == JPanelUsersSettings.this.COLUMN_LOCK_STATUS) {
                return new LockStatus(user.isLocked());
            }
            if (n2 == JPanelUsersSettings.this.COLUMN_USER_NAME) {
                return user;
            }
            if (n2 == JPanelUsersSettings.this.COLUMN_ACCESS_LEVEL) {
                return user.m_oAccessLevel;
            }
            throw new RuntimeException(res.getString("JPanelUsersSettings_Invalid_column_index_"));
        }

        public void fireTableChanged(TableModelEvent tableModelEvent) {
            if (!SwingUtilities.isEventDispatchThread()) {
                TableModelEvent tableModelEvent2 = tableModelEvent;
                Runnable runnable = new Runnable(this, tableModelEvent2){
                    private final /* synthetic */ TableModelEvent val$tme;
                    private final /* synthetic */ UserTableModel this$1;
                    {
                        this.this$1 = userTableModel;
                        this.val$tme = tableModelEvent;
                    }

                    public void run() {
                        UserTableModel.access$1401(this.this$1, this.val$tme);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                super.fireTableChanged(tableModelEvent);
            }
        }

        static /* synthetic */ void access$1401(UserTableModel userTableModel, TableModelEvent tableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        }
    }

    class LockStatus
    implements Comparable {
        static final int LOCKED = 1;
        static final int UNLOCKED = 2;
        protected int m_nState;
        protected boolean m_bLockStatus;

        public LockStatus(boolean bl) {
            this.m_bLockStatus = bl;
            this.m_nState = this.m_bLockStatus ? 1 : 2;
        }

        public int getState() {
            return this.m_nState;
        }

        public void setState(int n) {
            this.m_nState = n;
        }

        public int compareTo(Object object) {
            if (object instanceof LockStatus) {
                LockStatus lockStatus = (LockStatus)object;
                if (lockStatus.m_nState > this.m_nState) {
                    return -1;
                }
                if (lockStatus.m_nState < this.m_nState) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    public class User
    implements InterfaceStringComparable,
    Cloneable {
        Integer m_iUserId;
        String m_szName;
        String m_szPassword;
        NameValue m_oAccessLevel;
        boolean m_bIsLocked;
        boolean m_bPasswordModified;
        Vector m_vServerList = new Vector();

        User() {
            this(null, JPanelUsersSettings.DEFAULT_DURATION_BLANK, JPanelUsersSettings.DEFAULT_DURATION_BLANK, jPanelUsersSettings.m_anvAccessLevels[0], false);
        }

        User(Integer n, String string, String string2, NameValue nameValue) {
            this(n, string, string2, nameValue, false);
        }

        User(Integer n, String string, String string2, NameValue nameValue, boolean bl) {
            this.m_iUserId = n;
            this.m_szName = string;
            this.m_szPassword = string2;
            this.m_oAccessLevel = nameValue;
            this.m_bIsLocked = bl;
            this.m_bPasswordModified = false;
        }

        public Integer getUserId() {
            return this.m_iUserId;
        }

        public void setUserId(Integer n) {
            this.m_iUserId = n;
        }

        public String getUserName() {
            return this.m_szName;
        }

        public void setUserName(String string) {
            this.m_szName = string;
        }

        public String getPassword() {
            return this.m_szPassword;
        }

        public void setPassword(String string) {
            this.m_szPassword = string;
            this.m_bPasswordModified = true;
        }

        public NameValue getAccessLevel() {
            return this.m_oAccessLevel;
        }

        public void setAccessLevel(NameValue nameValue) {
            this.m_oAccessLevel = nameValue;
        }

        public Object clone() {
            User user = new User(this.m_iUserId, this.m_szName, this.m_szPassword, this.m_oAccessLevel, this.m_bIsLocked);
            user.setAccessList((Vector)this.m_vServerList.clone());
            if (this.m_bPasswordModified) {
                user.setPassword(user.getPassword());
            }
            return user;
        }

        public void setAccessList(Vector vector) {
            this.m_vServerList = vector;
        }

        public Vector getAccessList() {
            return this.m_vServerList;
        }

        public String toString() {
            return this.m_szName;
        }

        public void addServer(Server server) {
            this.m_vServerList.addElement(server);
        }

        public int getServerCount() throws Exception {
            if (!JPanelUsersSettings.this.m_bServerDataLoaded) {
                JPanelUsersSettings.this.loadServerTable();
            }
            return this.m_vServerList.size();
        }

        public Server getServerAt(int n) {
            return (Server)this.m_vServerList.elementAt(n);
        }

        public void setServerAt(Server server, int n) throws IndexOutOfBoundsException {
            this.m_vServerList.insertElementAt(server, n);
        }

        public void clearServerList() {
            this.m_vServerList.removeAllElements();
        }

        public int compareTo(Object object) {
            if (object instanceof User) {
                return this.toString().compareTo(object.toString());
            }
            return 0;
        }

        public boolean isStringComparable() {
            return true;
        }

        public boolean isApplianceAdministrator() {
            return (Integer)this.m_oAccessLevel.getValue() == 3;
        }

        public boolean isAdministrator() {
            return (Integer)this.m_oAccessLevel.getValue() == 2;
        }

        public boolean isUser() {
            return (Integer)this.m_oAccessLevel.getValue() == 1;
        }

        public boolean isLocked() {
            return this.m_bIsLocked;
        }

        public void setLockStatus(boolean bl) {
            this.m_bIsLocked = bl;
        }

        public boolean getLockStatus() {
            return this.m_bIsLocked;
        }

        public boolean wasPasswordModified() {
            return this.m_bPasswordModified;
        }

        public void clearPasswordModified() {
            this.m_bPasswordModified = false;
        }
    }

    class Server {
        String m_szName;
        String m_szRipId;
        int m_nChannel;
        int m_nID;

        Server(String string, String string2, int n) {
            this(string, string2, n, -1);
        }

        Server(String string, String string2, int n, int n2) {
            this.m_szName = string;
            this.m_szRipId = string2;
            this.m_nChannel = n;
            this.m_nID = n2;
        }

        public String toString() {
            return this.m_szName;
        }

        public void rename(String string) {
            this.m_szName = string;
        }

        public void rewrap(ServerInfo serverInfo) {
            this.m_szName = serverInfo.getName();
            this.m_nID = serverInfo.getID();
        }

        public void setNameToRip() {
            this.m_szName = this.m_szRipId;
            this.m_nID = -1;
        }

        public int getID() {
            return this.m_nID;
        }
    }

    public static final class TableColumnPacker {
        private RestrictedTableModelColumnSorted packer;

        TableColumnPacker(JTable jTable) throws IllegalArgumentException {
            if (jTable == null) {
                throw new IllegalArgumentException("Null param in constructor");
            }
            this.packer = new RestrictedTableModelColumnSorted(jTable);
        }

        public void packAllColumns(int n) {
            this.packer.packAllColumns(n);
        }

        public void packColumn(int n, int n2) {
            this.packer.packColumn(n, n2);
        }

        private class RestrictedTableModelColumnSorted
        extends TableModelColumnSorted {
            public RestrictedTableModelColumnSorted(JTable jTable) {
                this.m_jtTable = jTable;
                this.m_tmPeer = jTable.getModel();
            }
        }
    }
}

