/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr.model;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.BooleanToYesNo;
import com.avocent.avworks.nmm.common.model.DefaultFeatureSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.nmm.common.model.ValueConverter;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;

public class AvrLdapSupport
extends DefaultFeatureSupport
implements LdapSupport {
    public static final String TRACE_CONTEXT = "AVR LDAP support";
    private static int DEFAULT_LDAP_PORT_VALUE = 389;
    private static int DEFAULT_LDAPS_PORT_VALUE = 636;
    private static int DEFAULT_MAX_LDAP_FIELD_LENGTH = 256;

    public AvrLdapSupport(Appliance appliance) {
        super(appliance);
        AvrSnmpHelper avrSnmpHelper = AvrSnmpHelper.getInstance();
        String string = "JPanelAuthSettings_";
        if (this.isSimpleOptionsEnabled()) {
            this.add("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.2", "LDAP_METHOD_PRIORITY", string + "auth_priority_field", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSchemaExtensions.0", "SCHEMA_EXTENSIONS", string + "SchemaExtensions", (ValueConverter)new BooleanToYesNo(2, 1, false));
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapApplianceDomain.0", "LDAP_APP_DN", string + "AppDomainName", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSearchRootDomain.0", "LDAP_ROOT_DN", string + "RootDomainName", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainer.0", "LDAP_GROUP_CONTAINER", string + "Group_Container", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainerDomain.0", "LDAP_GROUP_CONTAINER_DN", string + "GroupContainerDomain", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapAccessControl.0", "LDAP_ACCESS_CONTROL", string + "AccessCtrlAttr", null);
        } else {
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSearchDN.0", "LDAP_SEARCH_DN", string + "Search_DN", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSearchPasswd.0", "LDAP_SEARCH_PASSWORD", string + "Search_Password", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSearchBase.0", "LDAP_SEARCH_BASE", string + "Search_Base", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapSearchUid.0", "LDAP_SEARCH_UID", string + "UID_Mask", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableName.1", "LDAP_PRI_SERVER_IP", string + "IP_Address", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTablePort.1", "LDAP_PRI_SERVER_PORT", string + "Port_ID", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableName.2", "LDAP_SEC_SERVER_IP", string + "IP_Address", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTablePort.2", "LDAP_SEC_SERVER_PORT", string + "Port_ID", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableAccess.1", "LDAP_PRI_SERVER_ACCESS", string + "Access_Type", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableAccess.2", "LDAP_SEC_SERVER_ACCESS", string + "Access_Type", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapQueryModeAppliance.0", "LDAP_QUERY_MODE_APPLIANCE", string + "Query_Mode_App", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapQueryModeServer.0", "LDAP_QUERY_MODE_SERVER", string + "Query_Mode_Server", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainer.0", "LDAP_GROUP_CONTAINER", string + "Group_Container", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainerMask.0", "LDAP_GROUP_MASK", string + "Group_Container_Mask", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapTargetMask.0", "LDAP_TARGET_MASK", string + "Target_Mask", null);
            this.add("avocent.ds.dsManagement.dsLdap.dsLdapAccessControl.0", "LDAP_ACCESS_CONTROL", string + "Access_Control_Attribute", null);
            this.add("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.2", "LDAP_METHOD_PRIORITY", string + "auth_priority_field", null);
            if (this.isLdapForAuthOnlyBrandingEnabled()) {
                this.add("avocent.ds.dsManagement.dsLdap.dsLdapAuthenticateOnly.0", "LDAP_FOR_AUTH_ONLY", string + "LDAPAuthOnly", (ValueConverter)new BooleanToYesNo(2, 1, false));
            }
            if (this.isSchemaExtensionBrandingEnabled()) {
                this.add("avocent.ds.dsManagement.dsLdap.dsLdapSchemaExtensions.0", "SCHEMA_EXTENSIONS", string + "SchemaExtensions", (ValueConverter)new BooleanToYesNo(2, 1, false));
            }
            this.m_constantsMap.put("DEFAULT_LDAP_PORT", new Integer(DEFAULT_LDAP_PORT_VALUE));
            this.m_constantsMap.put("DEFAULT_LDAPS_PORT", new Integer(DEFAULT_LDAPS_PORT_VALUE));
            this.m_constantsMap.put("ACCESS_MODE_LDAP", new Integer(1));
            this.m_constantsMap.put("ACCESS_MODE_LDAPS", new Integer(2));
            this.m_constantsMap.put("QUERY_MODE_BASIC", new Integer(1));
            this.m_constantsMap.put("QUERY_MODE_ATTRIBUTE", new Integer(2));
            this.m_constantsMap.put("QUERY_MODE_GROUP", new Integer(3));
        }
    }

    public void loadValues() throws ExceptionAsmpRequestFailed, Exception {
        if (this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            super.loadValues();
            this.getIsLicensed(true);
            this.m_appliance.setValue((Object)"LDAP_METHOD_IS_ENABLED", (Object)new Boolean(this.getPriority() > 0));
        } else {
            Trace.logError((String)TRACE_CONTEXT, (String)"loadValues called while LDAP support is not available.");
        }
    }

    public boolean getIsLicensed() {
        Object object = this.m_appliance.getValue((Object)"LDAP_AUTH_LICENSED");
        if (object == null) {
            throw new RuntimeException("Call to getCachedIsLicensed() before cached values loaded.");
        }
        return (Boolean)object;
    }

    public int getPriority() {
        Object object = this.m_appliance.getValue((Object)"LDAP_METHOD_PRIORITY");
        if (object == null) {
            if (!this.getIsLicensed()) {
                return 0;
            }
            throw new RuntimeException("Call to getCachedPriority() before cached values loaded.");
        }
        return (Integer)object;
    }

    public boolean getIsLicensed(boolean bl) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionRequestFailed, Exception {
        Object object;
        if (!bl && (object = this.m_appliance.getValue((Object)"LDAP_AUTH_LICENSED")) != null) {
            return (Boolean)object;
        }
        boolean bl2 = false;
        if (this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableIndex", "avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableStatus"};
            InterfaceValueObject[][] interfaceValueObjectArray = this.m_appliance.getSnmpTableValues(objectArray);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Retrieved Licensed Options, number of options = " + interfaceValueObjectArray.length));
            for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                Integer n = (Integer)interfaceValueObjectArray[i][0].getValue();
                int n2 = n;
                if (n2 != 1) continue;
                Integer n3 = (Integer)interfaceValueObjectArray[i][1].getValue();
                int n4 = n3;
                bl2 = n4 == 2;
            }
        } else {
            Trace.logError((String)TRACE_CONTEXT, (String)"isLicensed called while LDAP or licensing support is not available.");
        }
        this.m_appliance.setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(bl2));
        return bl2;
    }

    public int getPriority(boolean bl) throws ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, Exception {
        Object[] objectArray;
        if (!this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            Trace.logError((String)TRACE_CONTEXT, (String)"getPriority called while LDAP support is not available.");
            return 0;
        }
        if (!bl && (objectArray = this.m_appliance.getValue((Object)"LDAP_METHOD_PRIORITY")) != null) {
            return (Integer)objectArray;
        }
        objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.2"};
        InterfaceValueObject[] interfaceValueObjectArray = this.m_appliance.getSnmpValues(objectArray);
        this.m_appliance.setValue((Object)"LDAP_METHOD_PRIORITY", interfaceValueObjectArray[0].getValue());
        return interfaceValueObjectArray[0].getInteger();
    }

    public void setPriority(int n) {
        this.m_appliance.setValue((Object)"LDAP_METHOD_PRIORITY", (Object)new Integer(n));
    }

    public void setIsEnabled(boolean bl) {
        this.m_appliance.setValue((Object)"LDAP_METHOD_IS_ENABLED", (Object)new Boolean(bl));
    }

    public boolean isLdapForAuthOnly(boolean bl) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionRequestFailed, Exception {
        Object object;
        if (!this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport") || !this.isLdapForAuthOnlyBrandingEnabled()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"isLdapForAuthOnly called while LDAP support is not available.");
            return false;
        }
        if (!bl && (object = this.m_appliance.getValue((Object)"LDAP_FOR_AUTH_ONLY")) != null) {
            return (Boolean)object;
        }
        object = this.loadValue("LDAP_FOR_AUTH_ONLY");
        return (Boolean)object;
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        if (this.getPriority() == 0 && this.getIsEnabled()) {
            this.m_appliance.setAmpValue((Object)"LDAP_METHOD_PRIORITY", (Object)new Integer(1));
        } else if (!this.getIsEnabled()) {
            this.m_appliance.setAmpValue((Object)"LDAP_METHOD_PRIORITY", (Object)new Integer(0));
        }
        Object object = this.m_appliance.getAmpValue((Object)"LDAP_SEC_SERVER_PORT");
        if (object != null && object.toString().length() == 0) {
            this.m_appliance.setAmpValue((Object)"LDAP_SEC_SERVER_PORT", (Object)"0");
        }
        return super.applyValues(applianceRequest);
    }

    public int getDefaultLdapPort() {
        return DEFAULT_LDAP_PORT_VALUE;
    }

    public int getMaxFieldLength() {
        return DEFAULT_MAX_LDAP_FIELD_LENGTH;
    }

    public int getDefaultLdapsPort() {
        return DEFAULT_LDAPS_PORT_VALUE;
    }

    public boolean getIsEnabled(boolean bl) throws ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, Exception {
        Object object;
        if (!bl && (object = this.m_appliance.getValue((Object)"LDAP_METHOD_IS_ENABLED")) != null) {
            return (Boolean)object;
        }
        int n = this.getPriority(bl);
        Boolean bl2 = new Boolean(n > 0);
        this.m_appliance.setValue((Object)"LDAP_METHOD_IS_ENABLED", (Object)bl2);
        return bl2;
    }

    public boolean getIsEnabled() {
        Object object = this.m_appliance.getValue((Object)"LDAP_METHOD_IS_ENABLED");
        if (object == null) {
            throw new RuntimeException("Call to getIsEnabled() before cached values loaded.");
        }
        return (Boolean)object;
    }

    public boolean isLdapForAuthOnlyBrandingEnabled() {
        return this.m_appliance.isFeatureSupported("LDAPAuthenticationOnly");
    }

    public boolean isSchemaExtensionBrandingEnabled() {
        return this.m_appliance.isFeatureSupported("LDAPSchemaExtensions");
    }

    public boolean isSimpleOptionsEnabled() {
        return this.m_appliance.isFeatureSupported("LDAPSimpleOptions");
    }
}

