/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr.model;

import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.DefaultFeatureSupport;
import com.avocent.avworks.nmm.common.model.LocalAuthSupport;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.io.IOException;

public class AvrLocalAuthSupport
extends DefaultFeatureSupport
implements LocalAuthSupport {
    public static final String TRACE_CONTEXT = "AVR local auth support";

    public AvrLocalAuthSupport(Appliance appliance) {
        super(appliance);
        this.add("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.1", "LOCAL_METHOD_PRIORITY", "_local_auth_field", null);
    }

    public void loadValues() throws ExceptionAsmpRequestFailed, Exception {
        if (this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            super.loadValues();
            this.m_appliance.setValue((Object)"LOCAL_METHOD_IS_ENABLED", (Object)new Boolean(this.getPriority() > 0));
        } else {
            this.m_appliance.setValue((Object)"LOCAL_METHOD_IS_ENABLED", (Object)Boolean.TRUE);
        }
    }

    public boolean getIsLicensed(boolean bl) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionRequestFailed, Exception {
        return true;
    }

    public boolean isActive(boolean bl) throws Exception {
        Object object;
        if (!bl && (object = this.m_appliance.getValue((Object)"LOCAL_METHOD_IS_ENABLED")) != null) {
            return (Boolean)object;
        }
        boolean bl2 = true;
        if (this.m_appliance.getMibMajorVersion() >= 1 || this.m_appliance.getMibMajorVersion() > 1 && this.m_appliance.getMibMinorVersion() >= 5) {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableIndex", "avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder"};
            InterfaceValueObject[][] interfaceValueObjectArray = this.m_appliance.getSnmpTableValues(objectArray);
            InterfaceValueObject interfaceValueObject = interfaceValueObjectArray[0][1];
            bl2 = interfaceValueObject.getInteger() > 0;
        }
        this.m_appliance.setValue((Object)"LOCAL_METHOD_IS_ENABLED", (Object)new Boolean(bl2));
        return bl2;
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        if (this.getPriority() == 0 && this.getIsEnabled()) {
            this.m_appliance.setAmpValue((Object)"LOCAL_METHOD_PRIORITY", (Object)new Integer(1));
        } else if (!this.getIsEnabled()) {
            this.m_appliance.setAmpValue((Object)"LOCAL_METHOD_PRIORITY", (Object)new Integer(0));
        }
        return super.applyValues(applianceRequest);
    }

    public int getPriority(boolean bl) throws IOException, Exception {
        Object[] objectArray;
        if (!this.m_appliance.isFeatureSupported("LDAPAuthenticationSupport")) {
            Trace.logError((String)TRACE_CONTEXT, (String)"getPriority called while LDAP support is not available.");
            return 1;
        }
        if (!bl && (objectArray = this.m_appliance.getValue((Object)"LOCAL_METHOD_PRIORITY")) != null) {
            return (Integer)objectArray;
        }
        objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.1"};
        InterfaceValueObject[] interfaceValueObjectArray = this.m_appliance.getSnmpValues(objectArray);
        this.m_appliance.setValue((Object)"LOCAL_METHOD_PRIORITY", interfaceValueObjectArray[0].getValue());
        return interfaceValueObjectArray[0].getInteger();
    }

    public boolean getIsLicensed() {
        return true;
    }

    public int getPriority() {
        Object object = this.m_appliance.getValue((Object)"LOCAL_METHOD_PRIORITY");
        if (object == null) {
            throw new RuntimeException("Call to getCachedPriority() before cached values loaded.");
        }
        return (Integer)object;
    }

    public boolean getIsEnabled() {
        Object object = this.m_appliance.getValue((Object)"LOCAL_METHOD_IS_ENABLED");
        if (object == null) {
            throw new RuntimeException("Call to getIsEnabled() before cached values loaded.");
        }
        return true;
    }

    public boolean getIsEnabled(boolean bl) throws IOException, Exception {
        Object object;
        if (!bl && (object = this.m_appliance.getValue((Object)"LOCAL_METHOD_IS_ENABLED")) != null) {
            return (Boolean)object;
        }
        int n = this.getPriority(bl);
        Boolean bl2 = new Boolean(n > 0);
        this.m_appliance.setValue((Object)"LOCAL_METHOD_IS_ENABLED", (Object)bl2);
        return bl2;
    }

    public void setPriority(int n) {
        this.m_appliance.setValue((Object)"LOCAL_METHOD_PRIORITY", (Object)new Integer(n));
    }

    public void setIsEnabled(boolean bl) {
        this.m_appliance.setValue((Object)"LOCAL_METHOD_IS_ENABLED", (Object)new Boolean(bl));
    }
}

