/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr.virtualmedia;

import com.avocent.avworks.nmm.avr.AvrAppliance;
import com.avocent.avworks.nmm.avr.virtualmedia.VirtualMediaPanel;
import com.avocent.avworks.nmm.avr.virtualmedia.VirtualMediaSupport;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class VirtualMediaPanelController
extends InterfaceAmpPanelController
implements ActionListener {
    public static final String TRACE_CTXT = "Virtual Media Panel";
    public static final String CNAME = "VirtualMedia";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected VirtualMediaPanel m_virtualMediaPanel;

    public VirtualMediaPanelController(AmpController ampController) {
        super(ampController, res.getString("VirtualMedia_Name"), res.getString("VirtualMedia_Title"), res.getString("VirtualMedia_Description"), "IDH_SETTINGS_VIRTUAL_MEDIA");
        this.m_view = this.createView();
        this.getContentPane().add(this.m_view);
    }

    public boolean validateInputFields() {
        return true;
    }

    protected boolean initializeImpl() throws ExceptionAsmpRequestFailed, Exception {
        AvrAppliance avrAppliance = (AvrAppliance)this.m_acAmpController.getAppliance();
        VirtualMediaSupport virtualMediaSupport = avrAppliance.getVirtualMediaSupport();
        virtualMediaSupport.loadValues();
        this.updateViews();
        return true;
    }

    public Component createView() {
        try {
            this.m_virtualMediaPanel = new VirtualMediaPanel();
            this.m_view = this.m_virtualMediaPanel;
            this.initializeView();
            return this.m_view;
        }
        catch (Exception exception) {
            Trace.logError((String)"AMP Panel", (String)"Unable to create view component.", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        if (object == this.m_virtualMediaPanel.getLockToKvmCheckBox()) {
            Boolean bl2 = new Boolean(this.m_virtualMediaPanel.getLockToKvmCheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_LOCKED", (Object)bl2);
        } else if (object == this.m_virtualMediaPanel.getReservedSessionsCheckBox()) {
            Boolean bl3 = new Boolean(this.m_virtualMediaPanel.getReservedSessionsCheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_RESERVED", (Object)bl3);
        } else if (object == this.m_virtualMediaPanel.getReadOnlyCheckBox()) {
            Boolean bl4 = new Boolean(this.m_virtualMediaPanel.getReadOnlyCheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_READONLY", (Object)bl4);
        } else if (object == this.m_virtualMediaPanel.get128CheckBox()) {
            Boolean bl5 = new Boolean(this.m_virtualMediaPanel.get128CheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_128_ENABLED", (Object)bl5);
        } else if (object == this.m_virtualMediaPanel.getDESCheckBox()) {
            Boolean bl6 = new Boolean(this.m_virtualMediaPanel.getDESCheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_DES_ENABLED", (Object)bl6);
        } else if (object == this.m_virtualMediaPanel.get3DESCheckBox()) {
            Boolean bl7 = new Boolean(this.m_virtualMediaPanel.get3DESCheckBox().isSelected());
            bl = this.m_acAmpController.getAppliance().setAmpValue((Object)"VM_3DES_ENABLED", (Object)bl7);
        }
        this.setIsModified(this.isModified() || bl);
    }

    public void initializeView() {
        this.m_virtualMediaPanel.getLockToKvmCheckBox().addActionListener(this);
        this.m_virtualMediaPanel.getReservedSessionsCheckBox().addActionListener(this);
        this.m_virtualMediaPanel.getReadOnlyCheckBox().addActionListener(this);
        this.m_virtualMediaPanel.get128CheckBox().addActionListener(this);
        this.m_virtualMediaPanel.getDESCheckBox().addActionListener(this);
        this.m_virtualMediaPanel.get3DESCheckBox().addActionListener(this);
    }

    protected void updateViewsImpl() throws Exception {
        this.m_inUpdate = true;
        Appliance appliance = this.getAmpController().getAppliance();
        JCheckBox[] jCheckBoxArray = new JCheckBox[]{this.m_virtualMediaPanel.getLockToKvmCheckBox(), this.m_virtualMediaPanel.getReservedSessionsCheckBox(), this.m_virtualMediaPanel.getReadOnlyCheckBox(), this.m_virtualMediaPanel.get128CheckBox(), this.m_virtualMediaPanel.getDESCheckBox(), this.m_virtualMediaPanel.get3DESCheckBox()};
        Object[] objectArray = new Object[]{"VM_LOCKED", "VM_RESERVED", "VM_READONLY", "VM_128_ENABLED", "VM_DES_ENABLED", "VM_3DES_ENABLED"};
        for (int i = 0; i < jCheckBoxArray.length; ++i) {
            Boolean bl = appliance.getBooleanValue(objectArray[i]);
            jCheckBoxArray[i].setSelected(bl != null ? bl : false);
        }
    }

    protected boolean applyValuesImpl() throws Exception {
        AvrAppliance avrAppliance = (AvrAppliance)this.m_acAmpController.getAppliance();
        ApplianceRequest applianceRequest = new ApplianceRequest();
        avrAppliance.getVirtualMediaSupport().applyValues(applianceRequest);
        applianceRequest.sendSetRequest((Appliance)avrAppliance);
        return true;
    }

    protected String setErrorFieldFocus(Object object) {
        AvrAppliance avrAppliance = (AvrAppliance)this.m_acAmpController.getAppliance();
        VirtualMediaSupport virtualMediaSupport = avrAppliance.getVirtualMediaSupport();
        String string = virtualMediaSupport.getFieldResourceKey(object);
        if (object.equals("VM_LOCKED")) {
            this.m_virtualMediaPanel.getLockToKvmCheckBox().requestFocusInWindow();
        } else if (object.equals("VM_RESERVED")) {
            this.m_virtualMediaPanel.getLockToKvmCheckBox().requestFocusInWindow();
        } else if (object.equals("VM_READONLY")) {
            this.m_virtualMediaPanel.getReadOnlyCheckBox().requestFocusInWindow();
        } else if (object.equals("VM_128_ENABLED")) {
            this.m_virtualMediaPanel.get128CheckBox().requestFocusInWindow();
        } else if (object.equals("VM_DES_ENABLED")) {
            this.m_virtualMediaPanel.getDESCheckBox().requestFocusInWindow();
        } else if (object.equals("VM_3DES_ENABLED")) {
            this.m_virtualMediaPanel.get3DESCheckBox().requestFocusInWindow();
        }
        return string;
    }

    public void setErrorFieldFocus(int n) {
        switch (n) {
            case 0: {
                this.m_virtualMediaPanel.getLockToKvmCheckBox().requestFocusInWindow();
                break;
            }
            case 1: {
                this.m_virtualMediaPanel.getLockToKvmCheckBox().requestFocusInWindow();
                break;
            }
            case 2: {
                this.m_virtualMediaPanel.getReadOnlyCheckBox().requestFocusInWindow();
                break;
            }
            case 3: {
                this.m_virtualMediaPanel.get128CheckBox().requestFocusInWindow();
                break;
            }
            case 4: {
                this.m_virtualMediaPanel.getDESCheckBox().requestFocusInWindow();
                break;
            }
            case 5: {
                this.m_virtualMediaPanel.get3DESCheckBox().requestFocusInWindow();
            }
        }
    }
}

