/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr.virtualmedia;

import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.BadFieldValueException;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.model.ApplianceRequest;
import com.avocent.avworks.nmm.common.model.BooleanToYesNo;
import com.avocent.avworks.nmm.common.model.DefaultFeatureSupport;
import com.avocent.avworks.nmm.common.model.ValueConverter;
import com.avocent.lib.debug.Trace;

public class VirtualMediaSupport
extends DefaultFeatureSupport {
    public static final String TRACE_CONTEXT = "Virtual Media Support";
    public static final String VM_LOCKED = "VM_LOCKED";
    public static final String VM_RESERVED = "VM_RESERVED";
    public static final String VM_READONLY = "VM_READONLY";
    public static final String VM_ENCRYT_INDEX = "VM_ENCRYPT_INDEX";
    public static final String VM_ENCRYT_ENABLED = "VM_ENCRYPT_CONTROL";
    public static final String VM_128_ENABLED = "VM_128_ENABLED";
    public static final String VM_DES_ENABLED = "VM_DES_ENABLED";
    public static final String VM_3DES_ENABLED = "VM_3DES_ENABLED";
    public static final int LOCKED_TRUE = 1;
    public static final int LOCKED_FALSE = 2;
    public static final int RESERVED_NO = 1;
    public static final int RESERVED_YES = 2;
    public static final int READONLY = 1;
    public static final int READWRITE = 2;
    public static final int ENABLED = 2;
    public static final int DISABLED = 1;

    public VirtualMediaSupport(Appliance appliance) {
        super(appliance);
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaLockedToKvmAction.0", VM_LOCKED, "VirtualMedia_lock_to_kvm_session", (ValueConverter)new BooleanToYesNo(1, 2, false));
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaReserved.0", VM_RESERVED, "VirtualMedia_allow_reserved_sessions", (ValueConverter)new BooleanToYesNo(2, 1, false));
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaAccessMode.0", VM_READONLY, "VirtualMedia_read_only_access", (ValueConverter)new BooleanToYesNo(1, 2, false));
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.3", VM_128_ENABLED, "VirtualMedia_encryption_128", (ValueConverter)new BooleanToYesNo(2, 1, false));
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.1", VM_DES_ENABLED, "VirtualMedia_encryption_des", (ValueConverter)new BooleanToYesNo(2, 1, false));
        this.add("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.2", VM_3DES_ENABLED, "VirtualMedia_encryption_3des", (ValueConverter)new BooleanToYesNo(2, 1, false));
    }

    public void loadValues() throws ExceptionAsmpRequestFailed, Exception {
        if (this.m_appliance.isFeatureSupported("VirtualMediaSupport")) {
            super.loadValues();
        } else {
            Trace.logError((String)TRACE_CONTEXT, (String)"loadValues called while Virtual Media support is not available.");
            this.m_isLoaded = false;
        }
    }

    public boolean applyValues(ApplianceRequest applianceRequest) throws BadFieldValueException, Exception {
        if (!this.m_appliance.isFeatureSupported("VirtualMediaSupport")) {
            Trace.logError((String)TRACE_CONTEXT, (String)"applyValues called while VM support is not available.");
            return false;
        }
        super.applyValues(applianceRequest);
        return true;
    }
}

