/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2AuthorizeReply;
import com.avocent.protocols.adsap2.Adsap2AuthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2ClearCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeReply;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2SetCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2StatusReply;
import com.avocent.protocols.adsap2.InterfaceAdsap2RequestHandler;
import java.security.cert.X509Certificate;

public abstract class AbstractAdsap2RequestHandler
implements InterfaceAdsap2RequestHandler {
    private static final String TRACE_CONTEXT = "AbstractAdsap2RequestHandler";

    public X509Certificate[] getCertificates(String string) {
        return null;
    }

    public void serverStopped() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Server Stopped.");
    }

    public Adsap2Message handleRequest(String string, Adsap2Message adsap2Message) throws ExceptionRequestFailed, ExceptionNotSupported {
        Adsap2StatusReply adsap2StatusReply;
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid parameters for handleRequest()");
            throw new ExceptionRequestFailed();
        }
        if (!adsap2Message.isValid()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid request passed to handleRequest()");
            throw new ExceptionRequestFailed();
        }
        switch (adsap2Message.getCommandId()) {
            case 1: {
                adsap2StatusReply = this.handleSetCertificatesRequest(string, (Adsap2SetCertificatesRequest)adsap2Message);
                break;
            }
            case 2: {
                adsap2StatusReply = this.handleClearCertificatesRequest(string, (Adsap2ClearCertificatesRequest)adsap2Message);
                break;
            }
            case 3: {
                adsap2StatusReply = this.handlePreAuthorizeRequest(string, (Adsap2PreauthorizeRequest)adsap2Message);
                break;
            }
            case 4: {
                adsap2StatusReply = this.handleAuthorizeRequest(string, (Adsap2AuthorizeRequest)adsap2Message);
                break;
            }
            default: {
                Trace.logError((String)TRACE_CONTEXT, (String)("Unexpected Request[" + adsap2Message.getCommandId() + "]"));
                throw new ExceptionNotSupported();
            }
        }
        return adsap2StatusReply;
    }

    protected Adsap2StatusReply handleSetCertificatesRequest(String string, Adsap2SetCertificatesRequest adsap2SetCertificatesRequest) throws ExceptionRequestFailed {
        return Adsap2StatusReply.createSetCertificatesReply(256);
    }

    protected Adsap2StatusReply handleClearCertificatesRequest(String string, Adsap2ClearCertificatesRequest adsap2ClearCertificatesRequest) throws ExceptionRequestFailed {
        return Adsap2StatusReply.createClearCertificatesReply(256);
    }

    protected Adsap2PreauthorizeReply handlePreAuthorizeRequest(String string, Adsap2PreauthorizeRequest adsap2PreauthorizeRequest) throws ExceptionRequestFailed {
        return Adsap2PreauthorizeReply.createPreauthorizeReply(256);
    }

    protected Adsap2AuthorizeReply handleAuthorizeRequest(String string, Adsap2AuthorizeRequest adsap2AuthorizeRequest) throws ExceptionRequestFailed {
        return Adsap2AuthorizeReply.createAuthorizeReply(256);
    }
}

