/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2StatusReply;
import com.avocent.protocols.adsap2.MessageField;
import java.util.Vector;

public class Adsap2AuthorizeReply
extends Adsap2StatusReply {
    private static final String TRACE_CONTEXT = "Adsap2AuthorizeReply";

    protected Adsap2AuthorizeReply(Vector vector) {
        super(132, vector);
    }

    public int getPreemptionLevel() throws ExceptionRequestFailed {
        return this.getFieldDataByte(2);
    }

    public String getApplianceRole() throws ExceptionRequestFailed {
        return this.getFieldDataUTF(3);
    }

    public boolean isValid() {
        boolean bl = true;
        int n = 0;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isValid()");
        try {
            n = this.getStatus();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to get value for Status Field");
            return false;
        }
        if (!(n != 0 || this.isFieldAvailable(2) && this.isFieldAvailable(3))) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing Preemption Level or Appliance Role Fields");
            return false;
        }
        return true;
    }

    public static boolean isValidApplianceRole(String string) {
        if (string == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"No appliance role passed to verify. Invalid.");
            return false;
        }
        if (string.equals("APPLIANCE ADMIN") || string.equals("USER ADMIN") || string.equals("USER")) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Valid appliance role [" + string + "]"));
            return true;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Invalid appliance role [" + string + "]"));
        return false;
    }

    public static Adsap2AuthorizeReply createAuthorizeReply(int n) throws ExceptionRequestFailed {
        if (n != 256 && n != 259) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Incorrect usage of status for AuthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        return new Adsap2AuthorizeReply(vector);
    }

    public static Adsap2AuthorizeReply createAuthorizeReply(int n, int n2, String string) throws ExceptionRequestFailed {
        if (n != 0 && n != 256 && n != 259) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported status for AuthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        if (n == 0 && !Adsap2AuthorizeReply.isValidApplianceRole(string)) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported appliance role for AuthorizeReply[" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        if (n == 0) {
            vector.add(MessageField.createMessageFieldByte(2, n2));
            vector.add(MessageField.createMessageFieldUTF(3, string));
        }
        return new Adsap2AuthorizeReply(vector);
    }
}

