/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.security.PKIHelper;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.MessageField;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class Adsap2AuthorizeRequest
extends Adsap2Message {
    private static final String TRACE_CONTEXT = "Adsap2AuthorizeRequest";

    protected Adsap2AuthorizeRequest(Vector vector) {
        super(4, vector);
    }

    public X509Certificate getSessionCertificate() throws ExceptionRequestFailed {
        return this.getFieldDataX509Cert(1);
    }

    public X509Certificate getSessionCertificate(X509Certificate x509Certificate) {
        X509Certificate x509Certificate2 = null;
        try {
            x509Certificate2 = this.getSessionCertificate();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get session certificate, return default");
            x509Certificate2 = x509Certificate;
        }
        return x509Certificate2;
    }

    public String getUsername() throws ExceptionRequestFailed {
        if (this.isFieldAvailable(1)) {
            X509Certificate x509Certificate = this.getSessionCertificate();
            String string = PKIHelper.getCertificateSubjectCommonName((X509Certificate)x509Certificate);
            if (string == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to find username is subject of session cert");
                throw new ExceptionRequestFailed();
            }
            return string;
        }
        return this.getFieldDataUTF(2);
    }

    public String getUsername(String string) {
        String string2 = null;
        try {
            string2 = this.getUsername();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get username, return default");
            string2 = string;
        }
        return string2;
    }

    public String getPassword() throws ExceptionRequestFailed {
        if (this.isFieldAvailable(1)) {
            X509Certificate x509Certificate = this.getSessionCertificate();
            try {
                String string = PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.1");
                if (string == null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to find password in session cert");
                    throw new ExceptionRequestFailed();
                }
                return string;
            }
            catch (IOException iOException) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Problem getting extension value");
                throw new ExceptionRequestFailed();
            }
        }
        return this.getFieldDataUTF(3);
    }

    public String getPassword(String string) {
        String string2 = null;
        try {
            string2 = this.getPassword();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get password, return default");
            string2 = string;
        }
        return string2;
    }

    public String getSessionMode() throws ExceptionRequestFailed {
        if (this.isFieldAvailable(1)) {
            X509Certificate x509Certificate = this.getSessionCertificate();
            try {
                String string = PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.3");
                if (string == null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to find mode in session cert");
                    throw new ExceptionRequestFailed();
                }
                return string;
            }
            catch (IOException iOException) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Problem getting extension value");
                throw new ExceptionRequestFailed();
            }
        }
        return this.getFieldDataUTF(5);
    }

    public String getSessionMode(String string) {
        String string2 = null;
        try {
            string2 = this.getSessionMode();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get session mode, return default");
            string2 = string;
        }
        return string2;
    }

    public PublicKey getPublicKey() throws ExceptionRequestFailed {
        return this.getFieldDataPublicKey(4);
    }

    public PublicKey getPublicKey(PublicKey publicKey) {
        PublicKey publicKey2 = null;
        try {
            publicKey2 = this.getPublicKey();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get public key, return default");
            publicKey2 = publicKey;
        }
        return publicKey2;
    }

    public String getAddressLevel(int n) throws ExceptionRequestFailed {
        if (n < 0 || n >= 128) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported address level requested[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        if (this.isFieldAvailable(1)) {
            X509Certificate x509Certificate = this.getSessionCertificate();
            try {
                int n2 = 128 + n;
                String string = PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)("1.3.6.1.4.1.10418.6.1." + n2));
                if (string == null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Unable to find address level [" + n + " in session cert"));
                    throw new ExceptionRequestFailed();
                }
                return string;
            }
            catch (IOException iOException) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Problem getting extension value");
                throw new ExceptionRequestFailed();
            }
        }
        return this.getFieldDataUTF(128 + n);
    }

    public String getAddressLevel(int n, String string) {
        String string2 = null;
        try {
            string2 = this.getAddressLevel(n);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unable to get address level, return default");
            string2 = string;
        }
        return string2;
    }

    public String[] getAddressLevels() {
        String string;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 128 && (string = this.getAddressLevel(i, null)) != null; ++i) {
            vector.add(string);
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Found [" + vector.size() + "] Address Levels"));
        if (vector.size() <= 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean isValid() {
        boolean bl = true;
        if (this.isFieldAvailable(1)) {
            if (this.getNumberOfFields() > 1) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Too many fields defined");
                return false;
            }
        } else {
            if (!this.isFieldAvailable(2)) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Missing Username");
                return false;
            }
            if (!this.isFieldAvailable(3) && !this.isFieldAvailable(4)) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Missing Password or Public Key");
                return false;
            }
            if (this.isFieldAvailable(3) && this.isFieldAvailable(4)) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Password and Public Key both found, only one should be");
                return false;
            }
        }
        return true;
    }

    public boolean isReplyValid(Adsap2Message adsap2Message) {
        boolean bl = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isReplyValid()");
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid parameter for isReplyValid()");
            return false;
        }
        if (adsap2Message.getCommandId() != 132) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Reply[" + adsap2Message.getCommandId() + "]"));
            return false;
        }
        return adsap2Message.isValid();
    }

    public static Adsap2AuthorizeRequest createAuthorizeRequest(X509Certificate x509Certificate) throws ExceptionRequestFailed {
        if (x509Certificate == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Required field passed as null.");
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldX509Cert(1, x509Certificate));
        return new Adsap2AuthorizeRequest(vector);
    }

    public static Adsap2AuthorizeRequest createAuthorizeRequest(String string, String string2, String string3, String[] stringArray) throws ExceptionRequestFailed {
        if (string == null || string2 == null || string3 == null || stringArray == null || stringArray.length <= 0 || stringArray.length > 128) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Required field passed as null or invalid size.");
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldUTF(2, string));
        vector.add(MessageField.createMessageFieldUTF(3, string2));
        vector.add(MessageField.createMessageFieldUTF(5, string3));
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(MessageField.createMessageFieldUTF(128 + i, stringArray[i]));
        }
        return new Adsap2AuthorizeRequest(vector);
    }

    public static Adsap2AuthorizeRequest createAuthorizeRequest(String string, PublicKey publicKey, String string2, String[] stringArray) throws ExceptionRequestFailed {
        if (string == null || publicKey == null || string2 == null || stringArray == null || stringArray.length <= 0 || stringArray.length > 128) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Required field passed as null or invalid size.");
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldUTF(2, string));
        vector.add(MessageField.createMessageFieldPublicKey(4, publicKey));
        vector.add(MessageField.createMessageFieldUTF(5, string2));
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(MessageField.createMessageFieldUTF(128 + i, stringArray[i]));
        }
        return new Adsap2AuthorizeRequest(vector);
    }
}

