/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2AuthorizeReply;
import com.avocent.protocols.adsap2.Adsap2AuthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2ClearCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeReply;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2Session;
import com.avocent.protocols.adsap2.Adsap2SetCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2StatusReply;
import com.avocent.protocols.adsap2.InterfaceAdsap2;
import com.avocent.protocols.socket.SSLHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Adsap2Client
implements InterfaceAdsap2 {
    private static final String TRACE_CONTEXT = "Adsap2Client";
    private static final int MAX_SESSION_RETRIES = Integer.getInteger("Adsap2Client.MAX_SESSION_RETRIES", 1);
    private InetAddress m_iaServer = null;
    private int m_nPort = 3871;
    private String[] m_aszCiphers = InterfaceAdsap2.ADSAP2_CIPHERS;
    private PrivateKey m_PrivateKey = null;
    private X509Certificate[] m_x509certChain = null;
    private X509Certificate[] m_x509cTrusted = null;
    private int m_nTimeout = Integer.parseInt(System.getProperty("Adsap2Client.Timeout", "30000"));
    private boolean m_bSessionActive = false;
    private SSLSocket m_sslsAppliance = null;
    private Adsap2Session m_adsap2Session = null;

    public Adsap2Client(InetAddress inetAddress, PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        this.m_PrivateKey = privateKey;
        this.m_x509certChain = x509CertificateArray;
        try {
            this.setServerAddress(inetAddress);
            this.setTrustedCertificates(x509CertificateArray2);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create Adsap2Client", (Throwable)exceptionRequestFailed);
        }
    }

    public synchronized boolean isSessionActive() {
        return this.m_bSessionActive;
    }

    private synchronized boolean setSessionState(boolean bl) {
        if (bl) {
            if (this.isSessionActive()) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set session state. Session already in progress");
                return false;
            }
            this.m_bSessionActive = true;
        } else {
            this.m_bSessionActive = false;
        }
        return true;
    }

    public synchronized void setServerAddress(InetAddress inetAddress) throws ExceptionRequestFailed {
        if (this.isSessionActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set server address. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_iaServer = inetAddress;
    }

    public synchronized void setTrustedCertificates(X509Certificate[] x509CertificateArray) throws ExceptionRequestFailed {
        if (this.isSessionActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set trusted certificates. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_x509cTrusted = x509CertificateArray;
    }

    public synchronized void setServerPort(int n) throws ExceptionRequestFailed {
        if (this.isSessionActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set server port. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_nPort = n;
    }

    public synchronized void setTimeout(int n) throws ExceptionRequestFailed {
        if (this.isSessionActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set timeout. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_nTimeout = n;
    }

    public synchronized void setCiphers(String[] stringArray) throws ExceptionRequestFailed {
        if (this.isSessionActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set ciphers. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_aszCiphers = stringArray;
    }

    public void establishSession() throws ExceptionRequestFailed, IOException {
        if (!this.setSessionState(true)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to establish new session. Session already in progress");
            throw new ExceptionRequestFailed();
        }
        if (this.m_iaServer == null || this.m_PrivateKey == null || this.m_x509certChain == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to establish new session. Invalid settings.");
            this.setSessionState(false);
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Opening SSL socket connection to appliance");
            SSLSocketFactory sSLSocketFactory = SSLHelper.getSSLSocketFactory(this.m_PrivateKey, this.m_x509certChain, this.m_x509cTrusted);
            this.m_sslsAppliance = SSLHelper.createSSLSocket(null, this.m_iaServer.getHostAddress(), this.m_nPort, this.m_nTimeout, this.m_aszCiphers, sSLSocketFactory);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"SSL socket connection failed", (Throwable)iOException);
            this.setSessionState(false);
            throw iOException;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"SSL socket connection failed", (Throwable)exceptionRequestFailed);
            this.setSessionState(false);
            throw exceptionRequestFailed;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"SSL Connection established with the appliance");
        this.m_sslsAppliance.setSoTimeout(this.m_nTimeout);
        this.m_adsap2Session = new Adsap2Session(this.m_sslsAppliance);
        this.m_adsap2Session.startSession();
    }

    public synchronized void stopSession() throws ExceptionRequestFailed, IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Stopping session.");
        this.setSessionState(false);
        if (this.m_sslsAppliance != null) {
            this.m_sslsAppliance.close();
        }
        this.m_sslsAppliance = null;
        this.m_adsap2Session = null;
    }

    public Adsap2StatusReply setCertificates(X509Certificate x509Certificate, X509Certificate x509Certificate2, PrivateKey privateKey) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing setCertificates() Request");
        Adsap2SetCertificatesRequest adsap2SetCertificatesRequest = Adsap2SetCertificatesRequest.createSetCertificatesRequest(x509Certificate, x509Certificate2, privateKey);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"setCertificates() Request Created. Now sending.");
        return (Adsap2StatusReply)this.performRequest(adsap2SetCertificatesRequest);
    }

    public Adsap2StatusReply clearCertificates() throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing clearCertificates() Request");
        Adsap2ClearCertificatesRequest adsap2ClearCertificatesRequest = Adsap2ClearCertificatesRequest.createClearCertificatesRequest();
        Trace.logInfo((String)TRACE_CONTEXT, (String)"clearCertificates() Request Created. Now sending.");
        return (Adsap2StatusReply)this.performRequest(adsap2ClearCertificatesRequest);
    }

    public Adsap2PreauthorizeReply preAuthorize(X509Certificate x509Certificate) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing preAuthorize() Request");
        Adsap2PreauthorizeRequest adsap2PreauthorizeRequest = Adsap2PreauthorizeRequest.createPreauthorizeRequest(x509Certificate);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"preAuthorize() Request Created. Now sending.");
        return (Adsap2PreauthorizeReply)this.performRequest(adsap2PreauthorizeRequest);
    }

    public Adsap2AuthorizeReply authorize(X509Certificate x509Certificate) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing authorize() Request");
        Adsap2AuthorizeRequest adsap2AuthorizeRequest = Adsap2AuthorizeRequest.createAuthorizeRequest(x509Certificate);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"authorize() Request Created. Now sending.");
        return (Adsap2AuthorizeReply)this.performRequest(adsap2AuthorizeRequest);
    }

    public Adsap2AuthorizeReply authorize(String string, PublicKey publicKey, String string2, String[] stringArray) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing authorize() Request");
        Adsap2AuthorizeRequest adsap2AuthorizeRequest = Adsap2AuthorizeRequest.createAuthorizeRequest(string, publicKey, string2, stringArray);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"authorize() Request Created. Now sending.");
        return (Adsap2AuthorizeReply)this.performRequest(adsap2AuthorizeRequest);
    }

    public Adsap2AuthorizeReply authorize(String string, String string2, String string3, String[] stringArray) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing authorize() Request");
        Adsap2AuthorizeRequest adsap2AuthorizeRequest = Adsap2AuthorizeRequest.createAuthorizeRequest(string, string2, string3, stringArray);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"authorize() Request Created. Now sending.");
        return (Adsap2AuthorizeReply)this.performRequest(adsap2AuthorizeRequest);
    }

    private Adsap2Message performRequest(Adsap2Message adsap2Message) throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Performing performRequest()");
        if (this.m_adsap2Session == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Client not ready to handle requests, session not ready.");
            throw new ExceptionRequestFailed();
        }
        int n = 0;
        while (true) {
            try {
                return this.m_adsap2Session.performRequest(adsap2Message);
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to perform request.", (Throwable)iOException);
                try {
                    this.stopSession();
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Problems stopping session", (Throwable)exception);
                }
                if (n < MAX_SESSION_RETRIES) {
                    try {
                        this.establishSession();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"Problems reestablishing session", (Throwable)exception);
                        throw new ExceptionRequestFailed();
                    }
                } else {
                    throw new ExceptionRequestFailed();
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

