/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2Client;
import com.avocent.protocols.adsap2.Adsap2Key;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class Adsap2ConnectionPool
extends GenericKeyedObjectPool {
    private static final String TRACE_CONTEXT = "Adsap2ConnectionPool";
    private static final int MAX_ACTIVE = Integer.parseInt(System.getProperty("Adsap2ConnectionPool.MAX_ACTIVE", Integer.toString(4)));
    private static final int MAX_IDLE = Integer.parseInt(System.getProperty("Adsap2ConnectionPool.MAX_IDLE", Integer.toString(1)));
    private static final int MAX_TOTAL = Integer.parseInt(System.getProperty("Adsap2ConnectionPool.MAX_TOTAL", Integer.toString(-1)));
    private static final long MAX_WAIT = Long.parseLong(System.getProperty("Adsap2ConnectionPool.MAX_WAIT", Long.toString(100L)));
    private static final long EVICTION_CHECK_TIME = Long.parseLong(System.getProperty("Adsap2ConnectionPool.EVICTION_CHECK_TIME", Long.toString(10000L)));
    private static final long EVICTABLE_IDLE_TIME = Long.parseLong(System.getProperty("Adsap2ConnectionPool.EVICTABLE_IDLE_TIME", Long.toString(600000L)));
    private static final int TCP_CONNECTION_RETRY_COUNT = Integer.parseInt(System.getProperty("Adsap2ConnectionPool.TCP_CONNECTION_RETRY_COUNT", Integer.toString(0)));
    private static final int TCP_CONNECTION_RETRY_DELAY = Integer.parseInt(System.getProperty("Adsap2ConnectionPool.TCP_CONNECTION_RETRY_DELAY", Integer.toString(500)));
    private static Adsap2ConnectionFactory m_adsap2ConnectionFactory = null;
    private static HashMap m_hmConnections = new HashMap();
    private static HashMap m_hmPendingConnectionsToDelete = new HashMap();
    private static Adsap2ConnectionPool m_acpInstance = new Adsap2ConnectionPool();

    private Adsap2ConnectionPool() {
        m_adsap2ConnectionFactory = new Adsap2ConnectionFactory();
        this.setFactory(m_adsap2ConnectionFactory);
        this.setMaxActive(MAX_ACTIVE);
        this.setMaxIdle(MAX_IDLE);
        this.setMaxTotal(MAX_TOTAL);
        this.setMaxWait(MAX_WAIT);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(true);
        this.setTestWhileIdle(true);
        this.setTimeBetweenEvictionRunsMillis(EVICTION_CHECK_TIME);
        this.setMinEvictableIdleTimeMillis(EVICTABLE_IDLE_TIME);
        this.setWhenExhaustedAction((byte)1);
    }

    public static Adsap2ConnectionPool getInstance() {
        return m_acpInstance;
    }

    public Object borrowObject(Object object) throws UnknownHostException, IOException, ExceptionRequestFailed, Exception {
        return super.borrowObject(object);
    }

    public static void addObserver(Observer observer) {
        m_adsap2ConnectionFactory.addObserver(observer);
    }

    public static void deleteObserver(Observer observer) {
        m_adsap2ConnectionFactory.deleteObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearByAddress(String string) {
        HashMap hashMap = m_hmConnections;
        synchronized (hashMap) {
            Iterator iterator = m_hmConnections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Adsap2Client adsap2Client = (Adsap2Client)entry.getKey();
                Adsap2Key adsap2Key = (Adsap2Key)entry.getValue();
                if (!adsap2Key.getAddress().equals(string)) continue;
                m_hmPendingConnectionsToDelete.put(adsap2Client, adsap2Key);
            }
        }
    }

    private static class Adsap2ConnectionFactory
    extends Observable
    implements KeyedPoolableObjectFactory {
        private Adsap2ConnectionFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject(Object object) throws UnknownHostException, IOException, ExceptionRequestFailed {
            Adsap2Client adsap2Client = null;
            Adsap2Key adsap2Key = (Adsap2Key)object;
            if (adsap2Key == null) {
                throw new IOException("No Key Passed");
            }
            Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)("Creating ADSAP2 Connection for [" + adsap2Key.getAddress() + "]"));
            InetAddress inetAddress = InetAddress.getByName(adsap2Key.getAddress());
            adsap2Client = new Adsap2Client(inetAddress, adsap2Key.getPrivateKey(), adsap2Key.getClientCertificateChain(), adsap2Key.getTrustedCertificateChain());
            adsap2Client.establishSession();
            Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)"ASMP Connection Established Successfully");
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                m_hmConnections.put(adsap2Client, adsap2Key);
            }
            return adsap2Client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object object, Object object2) {
            Adsap2Client adsap2Client = (Adsap2Client)object2;
            Adsap2Key adsap2Key = (Adsap2Key)object;
            Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)("Destroying ADSAP2 Connection [" + adsap2Key.getAddress() + "]"));
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                m_hmConnections.remove(adsap2Client);
                m_hmPendingConnectionsToDelete.remove(adsap2Client);
            }
            if (adsap2Client != null) {
                try {
                    adsap2Client.stopSession();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)"Problem closing ADSAP2 Connection", (Throwable)exceptionRequestFailed);
                }
                catch (IOException iOException) {
                    Trace.logError((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)"Problem closing ADSAP2 Connection", (Throwable)iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(Object object, Object object2) {
            Adsap2Client adsap2Client = (Adsap2Client)object2;
            Adsap2Key adsap2Key = (Adsap2Key)object;
            if (adsap2Client == null || adsap2Key == null) {
                Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)"Null data passed to validate, drop from pool");
                return false;
            }
            if (!adsap2Client.isSessionActive()) {
                Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)("ADSAP2 Connection Invalid [" + adsap2Key.getAddress() + "]"));
                return false;
            }
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                if (m_hmPendingConnectionsToDelete.get(adsap2Client) != null) {
                    Trace.logInfo((String)Adsap2ConnectionPool.TRACE_CONTEXT, (String)("ADSAP2 Connection marked for deletion [" + adsap2Key.getAddress() + "]"));
                    return false;
                }
            }
            return true;
        }

        public void activateObject(Object object, Object object2) {
        }

        public void passivateObject(Object object, Object object2) {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }
    }
}

