/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class Adsap2Key {
    private static final String TRACE_CONTEXT = "Adsap2Key";
    private String m_szServerAddress = null;
    private PrivateKey m_privateKey = null;
    private X509Certificate[] m_x509certChain = null;
    private X509Certificate[] m_x509cTrusted = null;

    public Adsap2Key(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        this.m_szServerAddress = string;
        this.m_privateKey = privateKey;
        this.m_x509certChain = x509CertificateArray;
        this.m_x509cTrusted = x509CertificateArray2;
    }

    public Adsap2Key(String string, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        this(string, privateKey, new X509Certificate[]{x509Certificate}, new X509Certificate[]{x509Certificate2});
    }

    public String getAddress() {
        return this.m_szServerAddress;
    }

    public PrivateKey getPrivateKey() {
        return this.m_privateKey;
    }

    public X509Certificate[] getClientCertificateChain() {
        return this.m_x509certChain;
    }

    public X509Certificate[] getTrustedCertificateChain() {
        return this.m_x509cTrusted;
    }

    public int hashCode() {
        return this.m_szServerAddress.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Adsap2Key)) {
            return false;
        }
        Adsap2Key adsap2Key = (Adsap2Key)object;
        return this.checkEquals(this.m_szServerAddress, adsap2Key.m_szServerAddress) && this.checkEquals(this.m_privateKey, adsap2Key.m_privateKey) && this.checkEquals(this.m_x509certChain, adsap2Key.m_x509certChain) && this.checkEquals(this.m_x509cTrusted, adsap2Key.m_x509cTrusted);
    }

    private boolean checkEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }
}

