/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2AuthorizeReply;
import com.avocent.protocols.adsap2.Adsap2AuthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2ClearCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeReply;
import com.avocent.protocols.adsap2.Adsap2PreauthorizeRequest;
import com.avocent.protocols.adsap2.Adsap2SetCertificatesRequest;
import com.avocent.protocols.adsap2.Adsap2StatusReply;
import com.avocent.protocols.adsap2.InterfaceAdsap2;
import com.avocent.protocols.adsap2.MessageField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class Adsap2Message
implements InterfaceAdsap2 {
    private static final String TRACE_CONTEXT = "Adsap2Message";
    private int m_nCommandId = 0;
    private Vector m_vFields = null;

    protected Adsap2Message(int n, Vector vector) {
        this.m_nCommandId = n;
        this.m_vFields = vector;
        if (this.m_vFields == null) {
            this.m_vFields = new Vector();
        }
    }

    public int getCommandId() {
        return this.m_nCommandId;
    }

    public int getRecordLength() {
        int n = 0;
        Enumeration enumeration = this.m_vFields.elements();
        while (enumeration.hasMoreElements()) {
            MessageField messageField = (MessageField)enumeration.nextElement();
            n = n + messageField.getFieldData().length + 1 + 2;
        }
        if (n != 0) {
            ++n;
        }
        return n;
    }

    public boolean isFieldAvailable(int n) {
        Enumeration enumeration = this.m_vFields.elements();
        while (enumeration.hasMoreElements()) {
            MessageField messageField = (MessageField)enumeration.nextElement();
            if (messageField.getFieldId() != n) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfFields() {
        return this.m_vFields.size();
    }

    private MessageField getField(int n) {
        Enumeration enumeration = this.m_vFields.elements();
        while (enumeration.hasMoreElements()) {
            MessageField messageField = (MessageField)enumeration.nextElement();
            if (messageField.getFieldId() != n) continue;
            return messageField;
        }
        return null;
    }

    public int getFieldDataShort(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Short s = messageField.getShort();
        if (s == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (Short)");
            throw new ExceptionRequestFailed();
        }
        return s.intValue();
    }

    public int getFieldDataByte(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Byte by = messageField.getByte();
        if (by == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (Byte)");
            throw new ExceptionRequestFailed();
        }
        return by.intValue();
    }

    public String getFieldDataUTF(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        String string = messageField.getUTF();
        if (string == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (UTF)");
            throw new ExceptionRequestFailed();
        }
        return string;
    }

    public X509Certificate getFieldDataX509Cert(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        X509Certificate x509Certificate = messageField.getX509Cert();
        if (x509Certificate == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (X.509)");
            throw new ExceptionRequestFailed();
        }
        return x509Certificate;
    }

    public PublicKey getFieldDataPublicKey(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        PublicKey publicKey = messageField.getRSAPublicKey();
        if (publicKey == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (X.509 Key)");
            throw new ExceptionRequestFailed();
        }
        return publicKey;
    }

    public PrivateKey getFieldDataPrivateKey(int n) throws ExceptionRequestFailed {
        MessageField messageField = this.getField(n);
        if (messageField == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to get field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        PrivateKey privateKey = messageField.getPrivateKey();
        if (privateKey == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid value for field (PKCS8 PrivateKey)");
            throw new ExceptionRequestFailed();
        }
        return privateKey;
    }

    public boolean isReplyValid(Adsap2Message adsap2Message) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isReplyValid()");
        return false;
    }

    public boolean isValid() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isValid()");
        return true;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeBytes("ADSAP2");
            dataOutputStream.writeByte(this.getCommandId());
            dataOutputStream.writeInt(this.getRecordLength());
            Enumeration enumeration = this.m_vFields.elements();
            while (enumeration.hasMoreElements()) {
                MessageField messageField = (MessageField)enumeration.nextElement();
                dataOutputStream.writeByte(messageField.getFieldId());
                dataOutputStream.writeShort(messageField.getFieldData().length);
                dataOutputStream.write(messageField.getFieldData());
            }
            if (this.m_vFields.size() > 0) {
                dataOutputStream.writeByte(255);
            }
            dataOutputStream.writeByte(13);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to convert message to byte array", (Throwable)iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static Adsap2Message createMessage(int n, Vector vector) throws ExceptionNotSupported {
        switch (n) {
            case 1: {
                return new Adsap2SetCertificatesRequest(vector);
            }
            case 129: {
                return new Adsap2StatusReply(n, vector);
            }
            case 2: {
                return new Adsap2ClearCertificatesRequest(vector);
            }
            case 130: {
                return new Adsap2StatusReply(n, vector);
            }
            case 3: {
                return new Adsap2PreauthorizeRequest(vector);
            }
            case 131: {
                return new Adsap2PreauthorizeReply(vector);
            }
            case 4: {
                return new Adsap2AuthorizeRequest(vector);
            }
            case 132: {
                return new Adsap2AuthorizeReply(vector);
            }
        }
        Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported Command Id [" + n + "]"));
        throw new ExceptionNotSupported();
    }

    public static Adsap2Message readMessage(DataInputStream dataInputStream) throws ExceptionRequestFailed, IOException {
        int n = 0;
        Vector<MessageField> vector = new Vector<MessageField>();
        Adsap2Message adsap2Message = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting to read a message...");
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for SOH");
            byte by = dataInputStream.readByte();
            if (by != 1) {
                Trace.logError((String)TRACE_CONTEXT, (String)("No SOH, received [" + by + "]"));
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Signature");
            byte[] byArray = new byte[6];
            dataInputStream.readFully(byArray, 0, 6);
            String string = new String(byArray);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Received Signature=" + string));
            if (!string.equalsIgnoreCase("ADSAP2")) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Signature Invalid");
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Command ID");
            n = dataInputStream.readUnsignedByte();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Request ID=" + n));
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Record Length");
            int n2 = dataInputStream.readInt();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Record Length=" + n2));
            if (n2 > 8192) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Record Data too big");
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Record Data");
            byte[] byArray2 = new byte[n2];
            dataInputStream.readFully(byArray2, 0, n2);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Received Record Data");
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Terminator");
            byte by2 = dataInputStream.readByte();
            if (by2 != 13) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Message Terminator=" + by2));
                throw new ExceptionRequestFailed();
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Received Message Terminator");
            if (n2 > 0) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Breaking up the Record Data into Fields");
                DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray2));
                while (dataInputStream2.available() > 1) {
                    int n3 = dataInputStream2.readUnsignedByte();
                    int n4 = dataInputStream2.readUnsignedShort();
                    byte[] byArray3 = new byte[n4];
                    dataInputStream2.readFully(byArray3, 0, n4);
                    vector.add(new MessageField(n3, byArray3));
                }
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"No fields in Record Data, valid for some messages");
            }
            adsap2Message = Adsap2Message.createMessage(n, vector);
        }
        catch (ExceptionNotSupported exceptionNotSupported) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unsupported Message Received", (Throwable)exceptionNotSupported);
            throw new ExceptionRequestFailed();
        }
        return adsap2Message;
    }
}

