/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2StatusReply;
import com.avocent.protocols.adsap2.MessageField;
import java.util.Vector;

public class Adsap2PreauthorizeReply
extends Adsap2StatusReply {
    private static final String TRACE_CONTEXT = "Adsap2PreauthorizeReply";

    protected Adsap2PreauthorizeReply(Vector vector) {
        super(131, vector);
    }

    public String getUsername() throws ExceptionRequestFailed {
        return this.getFieldDataUTF(2);
    }

    public int getPreemptionLevel() throws ExceptionRequestFailed {
        return this.getFieldDataByte(3);
    }

    public int getSessionState() throws ExceptionRequestFailed {
        return this.getFieldDataByte(4);
    }

    public boolean isValid() {
        boolean bl = true;
        int n = 0;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isValid()");
        try {
            n = this.getStatus();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to get value for Status Field");
            return false;
        }
        if ((n == 0 || n == 256) && this.getNumberOfFields() > 1) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Too many fields for status of ERROR or NOERROR");
            return false;
        }
        if (!(n != 257 || this.isFieldAvailable(3) && this.isFieldAvailable(4))) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing Preemption Level or Session State");
            return false;
        }
        if (n == 258 && !this.isFieldAvailable(3)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing Preemption Level");
            return false;
        }
        if (n == 261 && !this.isFieldAvailable(2)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing Username");
            return false;
        }
        return true;
    }

    private static boolean isValidExclusiveSessionState(int n) {
        int n2 = 3;
        if ((n & ~n2) == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Valid session state [" + n + "]"));
            return true;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Invalid session state [" + n + "]"));
        return false;
    }

    public static Adsap2PreauthorizeReply createPreauthorizeReply(int n) throws ExceptionRequestFailed {
        if (n != 0 && n != 256) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Incorrect usage of status for PreauthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        return new Adsap2PreauthorizeReply(vector);
    }

    public static Adsap2PreauthorizeReply createPreauthorizeReply(int n, String string) throws ExceptionRequestFailed {
        if (n != 261) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Incorrect usage of status for PreauthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        vector.add(MessageField.createMessageFieldUTF(2, string));
        return new Adsap2PreauthorizeReply(vector);
    }

    public static Adsap2PreauthorizeReply createPreauthorizeReply(int n, int n2, int n3) throws ExceptionRequestFailed {
        if (n != 257) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Incorrect usage of status for PreauthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        if (!Adsap2PreauthorizeReply.isValidExclusiveSessionState(n3)) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Session State for PreauthorizeReply[" + n3 + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        vector.add(MessageField.createMessageFieldByte(3, n2));
        vector.add(MessageField.createMessageFieldByte(4, n3));
        return new Adsap2PreauthorizeReply(vector);
    }

    public static Adsap2PreauthorizeReply createPreauthorizeReply(int n, int n2) throws ExceptionRequestFailed {
        if (n != 258) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Incorrect usage of status for PreauthorizeReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        vector.add(MessageField.createMessageFieldByte(3, n2));
        return new Adsap2PreauthorizeReply(vector);
    }
}

