/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.MessageField;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class Adsap2PreauthorizeRequest
extends Adsap2Message {
    private static final String TRACE_CONTEXT = "Adsap2PreauthorizeRequest";

    protected Adsap2PreauthorizeRequest(Vector vector) {
        super(3, vector);
    }

    public X509Certificate getSessionCertificate() throws ExceptionRequestFailed {
        return this.getFieldDataX509Cert(1);
    }

    public boolean isValid() {
        boolean bl = true;
        if (!this.isFieldAvailable(1)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing Session Certificate");
            return false;
        }
        return true;
    }

    public boolean isReplyValid(Adsap2Message adsap2Message) {
        boolean bl = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isReplyValid()");
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid parameter for isReplyValid()");
            return false;
        }
        if (adsap2Message.getCommandId() != 131) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Reply[" + adsap2Message.getCommandId() + "]"));
            return false;
        }
        return adsap2Message.isValid();
    }

    public static Adsap2PreauthorizeRequest createPreauthorizeRequest(X509Certificate x509Certificate) throws ExceptionRequestFailed {
        if (x509Certificate == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Required field passed as null.");
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldX509Cert(1, x509Certificate));
        return new Adsap2PreauthorizeRequest(vector);
    }
}

