/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.adsap2.Adsap2Session;
import com.avocent.protocols.adsap2.InterfaceAdsap2;
import com.avocent.protocols.adsap2.InterfaceAdsap2RequestHandler;
import com.avocent.protocols.socket.SSLHelper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Adsap2Server
implements InterfaceAdsap2,
Runnable {
    private static final String TRACE_CONTEXT = "Adsap2Server";
    InterfaceAdsap2RequestHandler m_RequestHandler = null;
    private PrivateKey m_PrivateKey = null;
    private X509Certificate[] m_x509certChain = null;
    private int m_nPort = 3871;
    private String[] m_aszCiphers = InterfaceAdsap2.ADSAP2_CIPHERS;
    private long m_lInactivityTimeout = Long.parseLong(System.getProperty("Adsap2Server.InactivityTimeout", "60000"));
    private Thread m_tAcceptConnections = null;
    protected final ExecutionMonitor m_AcceptMonitor = new ExecutionMonitor();
    private ServerSocket m_ServerSocket = null;
    private MonitorConnections m_MonitorConnections = null;
    private Vector m_vConnections = new Vector();

    public Adsap2Server(PrivateKey privateKey, X509Certificate[] x509CertificateArray, InterfaceAdsap2RequestHandler interfaceAdsap2RequestHandler) {
        this.m_PrivateKey = privateKey;
        this.m_x509certChain = x509CertificateArray;
        this.m_RequestHandler = interfaceAdsap2RequestHandler;
    }

    public void setPort(int n) throws ExceptionRequestFailed {
        if (this.isServiceActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set port. Service already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_nPort = n;
    }

    public void setCiphers(String[] stringArray) throws ExceptionRequestFailed {
        if (this.isServiceActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set ciphers. Service already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_aszCiphers = stringArray;
    }

    public void setInactivityTimeout(long l) throws ExceptionRequestFailed {
        if (this.isServiceActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set inactivity timeout. Service already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_lInactivityTimeout = l;
    }

    public void setRequestHandler(InterfaceAdsap2RequestHandler interfaceAdsap2RequestHandler) throws ExceptionRequestFailed {
        if (this.isServiceActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set request handler. Service already in progress");
            throw new ExceptionRequestFailed();
        }
        this.m_RequestHandler = interfaceAdsap2RequestHandler;
    }

    public synchronized boolean isServiceActive() {
        return this.m_tAcceptConnections != null || this.m_ServerSocket != null;
    }

    public synchronized void stopService() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Stopping the ADSAP2 Server Service.");
        Thread thread = this.m_tAcceptConnections;
        this.m_tAcceptConnections = null;
        if (thread != null) {
            thread.interrupt();
        }
        this.closeServerSocket();
        if (thread != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Service to Stop.");
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"join() interrupted, lets continue", (Throwable)interruptedException);
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ADSAP2 Service Stopped.");
    }

    public synchronized void startService() throws ExceptionRequestFailed {
        if (this.isServiceActive()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Service already in progress, cannot start another.");
            throw new ExceptionRequestFailed();
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Starting ADSAP2 Service.");
        this.m_tAcceptConnections = new Thread((Runnable)this, "ADSAP2 Server");
        this.m_tAcceptConnections.start();
        this.m_AcceptMonitor.waitUntilStartupComplete();
    }

    private void closeServerSocket() {
        ServerSocket serverSocket = this.m_ServerSocket;
        if (serverSocket == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Socket already closed or being closed.");
            return;
        }
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Closing Server Socket.");
            serverSocket.close();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to close server socket", (Throwable)iOException);
        }
    }

    public void removeConnection(Adsap2Connection adsap2Connection) {
        this.m_vConnections.remove(adsap2Connection);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Connection Removed. Current number of connections: " + this.m_vConnections.size()));
        if (this.m_vConnections.size() <= 0 && this.m_MonitorConnections != null) {
            this.m_MonitorConnections.suspendThread();
        }
    }

    public void addConnection(Adsap2Connection adsap2Connection) {
        this.m_vConnections.add(adsap2Connection);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Connection Added. Current number of connections: " + this.m_vConnections.size()));
        if (this.m_MonitorConnections != null) {
            this.m_MonitorConnections.resumeThread();
        }
    }

    private void processInactiveConnections() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.m_vConnections.elements();
        while (enumeration.hasMoreElements()) {
            Adsap2Connection adsap2Connection = (Adsap2Connection)enumeration.nextElement();
            if (l - adsap2Connection.getLastActivityTime() <= this.m_lInactivityTimeout) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Dropping connection due to inacitivity.");
            adsap2Connection.stopConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block24: {
            block22: {
                block23: {
                    try {
                        try {
                            if (this.m_RequestHandler == null) {
                                Trace.logError((String)"Adsap2Server", (String)"No request handler specified.");
                                var4_1 = null;
                                this.m_tAcceptConnections = null;
                                this.closeServerSocket();
                                this.m_ServerSocket = null;
                                if (this.m_MonitorConnections == null) break block22;
                                break block23;
                            }
                            this.m_MonitorConnections = new MonitorConnections(this.m_lInactivityTimeout);
                            this.m_MonitorConnections.start();
                            this.m_MonitorConnections.suspendThread();
                            this.m_ServerSocket = new ServerSocket(this.m_nPort);
                            this.m_AcceptMonitor.startupComplete();
                            while (this.m_tAcceptConnections == Thread.currentThread()) {
                                Trace.logInfo((String)"Adsap2Server", (String)"Waiting to accept a connection...");
                                var1_9 = this.m_ServerSocket.accept();
                                var2_11 = new Adsap2Connection(var1_9);
                            }
                            break block24;
                        }
                        catch (IOException var1_10) {
                            Trace.logError((String)"Adsap2Server", (String)"Unable to create socket or accept connection, connection closed.", (Throwable)var1_10);
                            var4_3 = null;
                            this.m_tAcceptConnections = null;
                            this.closeServerSocket();
                            this.m_ServerSocket = null;
                            if (this.m_MonitorConnections != null) {
                                this.m_MonitorConnections.stopThread();
                            }
                            this.m_MonitorConnections = null;
                            while (this.m_vConnections.size() > 0) {
                                try {
                                    var5_7 = (Adsap2Connection)this.m_vConnections.remove(0);
                                    var5_7.stopConnection();
                                }
                                catch (ArrayIndexOutOfBoundsException var5_7) {
                                    Trace.logInfo((String)"Adsap2Server", (String)"Looks like connection went away on us...");
                                }
                            }
                            this.m_vConnections.clear();
                            if (this.m_RequestHandler != null) {
                                this.m_RequestHandler.serverStopped();
                            }
                            this.m_AcceptMonitor.executionComplete();
                            return;
                        }
                    }
                    catch (Throwable var3_12) {
                        var4_4 = null;
                        this.m_tAcceptConnections = null;
                        this.closeServerSocket();
                        this.m_ServerSocket = null;
                        if (this.m_MonitorConnections != null) {
                            this.m_MonitorConnections.stopThread();
                        }
                        this.m_MonitorConnections = null;
                        while (this.m_vConnections.size() > 0) {
                            ** try [egrp 2[TRYBLOCK] [6 : 180->201)] { 
lbl57:
                            // 1 sources

                            var5_8 = (Adsap2Connection)this.m_vConnections.remove(0);
                            var5_8.stopConnection();
lbl60:
                            // 1 sources

                            catch (ArrayIndexOutOfBoundsException var5_8) {
                                Trace.logInfo((String)"Adsap2Server", (String)"Looks like connection went away on us...");
                            }
                        }
                        this.m_vConnections.clear();
                        if (this.m_RequestHandler != null) {
                            this.m_RequestHandler.serverStopped();
                        }
                        this.m_AcceptMonitor.executionComplete();
                        throw var3_12;
                    }
                }
                this.m_MonitorConnections.stopThread();
            }
            this.m_MonitorConnections = null;
            while (this.m_vConnections.size() > 0) {
                ** try [egrp 2[TRYBLOCK] [6 : 180->201)] { 
lbl74:
                // 1 sources

                var5_5 = (Adsap2Connection)this.m_vConnections.remove(0);
                var5_5.stopConnection();
lbl77:
                // 1 sources

                catch (ArrayIndexOutOfBoundsException var5_5) {
                    Trace.logInfo((String)"Adsap2Server", (String)"Looks like connection went away on us...");
                }
            }
            this.m_vConnections.clear();
            if (this.m_RequestHandler != null) {
                this.m_RequestHandler.serverStopped();
            }
            this.m_AcceptMonitor.executionComplete();
            return;
        }
        var4_2 = null;
        this.m_tAcceptConnections = null;
        this.closeServerSocket();
        this.m_ServerSocket = null;
        if (this.m_MonitorConnections != null) {
            this.m_MonitorConnections.stopThread();
        }
        this.m_MonitorConnections = null;
        while (this.m_vConnections.size() > 0) {
            ** try [egrp 2[TRYBLOCK] [6 : 180->201)] { 
lbl95:
            // 1 sources

            var5_6 = (Adsap2Connection)this.m_vConnections.remove(0);
            var5_6.stopConnection();
lbl98:
            // 1 sources

            catch (ArrayIndexOutOfBoundsException var5_6) {
                Trace.logInfo((String)"Adsap2Server", (String)"Looks like connection went away on us...");
            }
        }
        this.m_vConnections.clear();
        if (this.m_RequestHandler != null) {
            this.m_RequestHandler.serverStopped();
        }
        this.m_AcceptMonitor.executionComplete();
    }

    private class ExecutionMonitor {
        private boolean m_bStartupComplete = false;
        private boolean m_bExecutionComplete = false;

        public synchronized void waitUntilStartupComplete() {
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Checking if Start-up Completed.");
            while (!this.m_bStartupComplete) {
                try {
                    Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Waiting for Start-up to complete.");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Wait on Start-up Interrupted...");
                }
            }
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Done waiting for Start-up to complete.");
        }

        public synchronized void waitUntilExcecutionComplete() {
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Checking if Execution Completed.");
            while (!this.m_bExecutionComplete) {
                try {
                    Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Waiting for execution to complete.");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Wait on execution Interrupted...");
                }
            }
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Done waiting for execution to complete.");
        }

        public synchronized void startupComplete() {
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Marking Start-up completed");
            this.m_bStartupComplete = true;
            this.notifyAll();
        }

        public synchronized void executionComplete() {
            Trace.logInfo((String)Adsap2Server.TRACE_CONTEXT, (String)"Marking Execution Complete");
            if (!this.m_bStartupComplete) {
                Trace.logError((String)Adsap2Server.TRACE_CONTEXT, (String)"Execution marked complete prior to start-up");
                this.m_bStartupComplete = true;
            }
            this.m_bExecutionComplete = true;
            this.notifyAll();
        }
    }

    private class Adsap2Connection
    implements Runnable {
        private static final String TRACE_CONTEXT = "Adsap2Connection";
        private SSLSocket m_sslsClient = null;
        private Socket m_sClientTcp = null;
        private Thread m_tRequestHandler = null;
        private long m_lLastActivity = System.currentTimeMillis();

        public Adsap2Connection(Socket socket) {
            this.m_sClientTcp = socket;
            Adsap2Server.this.addConnection(this);
            this.startConnection();
        }

        public synchronized long getLastActivityTime() {
            return this.m_lLastActivity;
        }

        private synchronized void updateLastActivityTime() {
            this.m_lLastActivity = System.currentTimeMillis();
        }

        private void startConnection() {
            if (this.m_tRequestHandler != null) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Connection already started.");
                return;
            }
            this.m_tRequestHandler = new Thread((Runnable)this, "Adsap2Connection [" + this.m_sClientTcp.getInetAddress().getHostAddress() + ":" + this.m_sClientTcp.getPort() + "]");
            this.m_tRequestHandler.start();
        }

        public void stopConnection() {
            if (this.m_tRequestHandler == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Connection already stopped.");
                return;
            }
            Thread thread = this.m_tRequestHandler;
            this.m_tRequestHandler = null;
            if (thread != null) {
                thread.interrupt();
            }
            if (this.m_sslsClient != null) {
                try {
                    this.m_sslsClient.close();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Problem closing SSL/TCP socket while stopping connection", (Throwable)iOException);
                }
            } else if (this.m_sClientTcp != null) {
                try {
                    this.m_sClientTcp.close();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Problem closing TCP socket while stopping connection", (Throwable)iOException);
                }
            }
            this.m_sslsClient = null;
            this.m_sClientTcp = null;
            Adsap2Server.this.removeConnection(this);
        }

        public void run() {
            Adsap2Session adsap2Session = null;
            if (this.m_tRequestHandler == Thread.currentThread()) {
                String string = this.m_sClientTcp.getInetAddress().getHostAddress();
                X509Certificate[] x509CertificateArray = Adsap2Server.this.m_RequestHandler.getCertificates(string);
                try {
                    SSLSocketFactory sSLSocketFactory = SSLHelper.getSSLSocketFactory(Adsap2Server.this.m_PrivateKey, Adsap2Server.this.m_x509certChain, x509CertificateArray);
                    this.m_sslsClient = (SSLSocket)sSLSocketFactory.createSocket(this.m_sClientTcp, string, this.m_sClientTcp.getPort(), true);
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create SSL Client Socket", (Throwable)iOException);
                    this.stopConnection();
                    return;
                }
                this.m_sClientTcp = null;
                this.m_sslsClient.setEnabledCipherSuites(Adsap2Server.this.m_aszCiphers);
                this.m_sslsClient.setEnableSessionCreation(true);
                this.m_sslsClient.setNeedClientAuth(true);
                this.m_sslsClient.setUseClientMode(false);
                try {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"Creating Session to use for handling requests");
                    adsap2Session = new Adsap2Session(this.m_sslsClient);
                    adsap2Session.startSession();
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create a session.", (Throwable)exception);
                    this.stopConnection();
                    return;
                }
            }
            this.updateLastActivityTime();
            while (this.m_tRequestHandler == Thread.currentThread()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Waiting for Next Request to Process...");
                try {
                    adsap2Session.processRequest(Adsap2Server.this.m_RequestHandler);
                    this.updateLastActivityTime();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Failure encountered while processing a request", (Throwable)exceptionRequestFailed);
                    this.stopConnection();
                    return;
                }
                catch (ExceptionNotSupported exceptionNotSupported) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Unsupported Request received.", (Throwable)exceptionNotSupported);
                    this.stopConnection();
                    return;
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Unable to process the request.", (Throwable)iOException);
                    this.stopConnection();
                    return;
                }
            }
        }
    }

    private class MonitorConnections
    extends ThreadContinuous {
        private static final String TRACE_CONTEXT = "MonitorConnections";
        private boolean m_bThreadSuspended = false;

        MonitorConnections(long l) {
            super(l);
        }

        protected void performTask() {
            if (!this.m_bThreadSuspended) {
                Adsap2Server.this.processInactiveConnections();
            }
        }

        public void suspendThread() {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Thread suspended.");
            this.m_bThreadSuspended = true;
        }

        public void resumeThread() {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Thread resumed.");
            this.m_bThreadSuspended = false;
        }
    }
}

