/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.InterfaceAdsap2RequestHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;

public class Adsap2Session {
    private static final String TRACE_CONTEXT = "Adsap2Session";
    private SSLSocket m_sslSocket = null;
    private OutputStream m_OutputStream = null;
    private DataInputStream m_DataInputStream = null;
    private boolean m_bRequestInProgress = false;

    public Adsap2Session(SSLSocket sSLSocket) {
        this.m_sslSocket = sSLSocket;
    }

    public synchronized boolean isSessionStarted() {
        return this.m_OutputStream != null && this.m_DataInputStream != null;
    }

    public synchronized void startSession() throws ExceptionRequestFailed, IOException {
        if (this.isSessionStarted()) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Session already started, cannot start again.");
            throw new ExceptionRequestFailed();
        }
        this.m_OutputStream = this.m_sslSocket.getOutputStream();
        this.m_DataInputStream = new DataInputStream(this.m_sslSocket.getInputStream());
    }

    public synchronized boolean isRequestInProgress() {
        return this.m_bRequestInProgress;
    }

    private synchronized boolean setProgressIndicator(boolean bl) {
        if (bl) {
            if (this.isRequestInProgress()) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to set the progress indicator. Request already in progress");
                return false;
            }
            this.m_bRequestInProgress = true;
        } else {
            this.m_bRequestInProgress = false;
        }
        return true;
    }

    private void writeMessage(Adsap2Message adsap2Message) throws ExceptionRequestFailed, IOException {
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid message passed, null value");
            throw new ExceptionRequestFailed();
        }
        byte[] byArray = adsap2Message.toByteArray();
        if (byArray == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid byte arrray for message");
            throw new ExceptionRequestFailed();
        }
        this.m_OutputStream.write(byArray);
        this.m_OutputStream.flush();
    }

    private Adsap2Message readMessage() throws ExceptionRequestFailed, IOException {
        return Adsap2Message.readMessage(this.m_DataInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Adsap2Message performRequest(Adsap2Message adsap2Message) throws ExceptionRequestFailed, IOException {
        Adsap2Message adsap2Message2 = null;
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid request passed, null value");
            throw new ExceptionRequestFailed();
        }
        if (!this.setProgressIndicator(true)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to handle another request. Request already in progress");
            throw new ExceptionRequestFailed();
        }
        try {
            if (!adsap2Message.isValid()) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Invalid request, cannot be sent.");
                throw new ExceptionRequestFailed();
            }
            this.writeMessage(adsap2Message);
            adsap2Message2 = this.readMessage();
            if (!adsap2Message.isReplyValid(adsap2Message2)) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Invalid reply returned for request. Request Id[" + adsap2Message.getCommandId() + "] " + "Response Id[" + adsap2Message2.getCommandId() + "]"));
                throw new ExceptionRequestFailed();
            }
        }
        finally {
            this.setProgressIndicator(false);
        }
        return adsap2Message2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(InterfaceAdsap2RequestHandler interfaceAdsap2RequestHandler) throws ExceptionRequestFailed, ExceptionNotSupported, IOException {
        if (interfaceAdsap2RequestHandler == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid request handler passed, null value");
            throw new ExceptionRequestFailed();
        }
        if (!this.setProgressIndicator(true)) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to handle another request. Request already in progress");
            throw new ExceptionRequestFailed();
        }
        try {
            Adsap2Message adsap2Message = this.readMessage();
            String string = this.m_sslSocket.getInetAddress().getHostAddress();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Received request, now handle it...");
            Adsap2Message adsap2Message2 = interfaceAdsap2RequestHandler.handleRequest(string, adsap2Message);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Request Processed, sending reply...");
            this.writeMessage(adsap2Message2);
        }
        finally {
            this.setProgressIndicator(false);
        }
    }
}

