/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.security.PKIHelper;
import com.avocent.protocols.adsap2.InterfaceAdsap2;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class Adsap2SessionCertificate
implements InterfaceAdsap2 {
    private static final String TRACE_CONTEXT = "Adsap2SessionCertificate";
    private String m_szUsername = null;
    private String m_szPassword = null;
    private String m_szPreemption = null;
    private String m_szMode = null;
    private String m_szExpiration = null;
    private String m_szRole = null;
    private String[] m_aszAddressLevels = null;

    public Adsap2SessionCertificate() {
    }

    public Adsap2SessionCertificate(X509Certificate x509Certificate) {
        this.setUsername(PKIHelper.getCertificateSubjectCommonName((X509Certificate)x509Certificate));
        try {
            String string;
            this.setPassword(PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.1"));
            this.setPreemption(PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.2"));
            this.setMode(PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.3"));
            this.setExpiration(PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.4"));
            this.setRole(PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)"1.3.6.1.4.1.10418.6.1.5"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < 128 && (string = PKIHelper.getCertificateExtensionUTFValue((X509Certificate)x509Certificate, (String)("1.3.6.1.4.1.10418.6.1." + (128 + i)))) != null; ++i) {
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                this.setAddressLevels(arrayList.toArray(new String[arrayList.size()]));
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"IO error reading certificate");
        }
    }

    public Adsap2SessionCertificate(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) {
        this.setUsername(string);
        this.setPassword(string2);
        this.setPreemption(string3);
        this.setMode(string4);
        this.setExpiration(string5);
        this.setRole(string6);
        this.setAddressLevels(stringArray);
    }

    public String getUsername() {
        return this.m_szUsername;
    }

    public void setUsername(String string) {
        this.m_szUsername = string;
    }

    public String getPassword() {
        return this.m_szPassword;
    }

    public void setPassword(String string) {
        this.m_szPassword = string;
    }

    public String getPreemption() {
        return this.m_szPreemption;
    }

    public void setPreemption(String string) {
        this.m_szPreemption = string;
    }

    public String getMode() {
        return this.m_szMode;
    }

    public boolean isShareMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("SHARE") || this.m_szMode.equalsIgnoreCase("SHARE_FORCE") || this.m_szMode.equalsIgnoreCase("SHARE_PASSIVE") || this.m_szMode.equalsIgnoreCase("SHARE_PASSIVE_FORCE");
    }

    public boolean isPreemptMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("PREEMPT") || this.m_szMode.equalsIgnoreCase("PREEMPT_EXCLUSIVE");
    }

    public boolean isNormalMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("NORMAL");
    }

    public boolean isScanMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("SCAN");
    }

    public boolean isStealthMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("STEALTH");
    }

    public boolean isExclusiveMode() {
        if (this.m_szMode == null) {
            return false;
        }
        return this.m_szMode.equalsIgnoreCase("EXCLUSIVE");
    }

    public void setMode(String string) {
        this.m_szMode = string;
    }

    public String getExpiration() {
        return this.m_szExpiration;
    }

    public void setExpiration(String string) {
        this.m_szExpiration = string;
    }

    public String getRole() {
        return this.m_szRole;
    }

    public void setRole(String string) {
        this.m_szRole = string;
    }

    public String[] getAddressLevels() {
        return this.m_aszAddressLevels;
    }

    public void setAddressLevels(String[] stringArray) {
        this.m_aszAddressLevels = stringArray;
    }
}

