/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.MessageField;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class Adsap2SetCertificatesRequest
extends Adsap2Message {
    private static final String TRACE_CONTEXT = "Adsap2SetCertificatesRequest";

    protected Adsap2SetCertificatesRequest(Vector vector) {
        super(1, vector);
    }

    public X509Certificate getDSViewSystemCertificate() throws ExceptionRequestFailed {
        return this.getFieldDataX509Cert(1);
    }

    public X509Certificate getApplianceCertificate() throws ExceptionRequestFailed {
        return this.getFieldDataX509Cert(2);
    }

    public PrivateKey getAppliancePrivateKey() throws ExceptionRequestFailed {
        return this.getFieldDataPrivateKey(3);
    }

    public boolean isValid() {
        boolean bl = true;
        if (!(this.isFieldAvailable(1) && this.isFieldAvailable(2) && this.isFieldAvailable(3))) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Missing DSView System Cert, MA Cert, or MA Private Key");
            return false;
        }
        return true;
    }

    public boolean isReplyValid(Adsap2Message adsap2Message) {
        boolean bl = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"isReplyValid()");
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid parameter for isReplyValid()");
            return false;
        }
        if (adsap2Message.getCommandId() != 129) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Reply[" + adsap2Message.getCommandId() + "]"));
            return false;
        }
        return adsap2Message.isValid();
    }

    public static Adsap2SetCertificatesRequest createSetCertificatesRequest(X509Certificate x509Certificate, X509Certificate x509Certificate2, PrivateKey privateKey) throws ExceptionRequestFailed {
        if (x509Certificate == null || x509Certificate2 == null || privateKey == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Required field passed as null.");
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldX509Cert(1, x509Certificate));
        vector.add(MessageField.createMessageFieldX509Cert(2, x509Certificate2));
        vector.add(MessageField.createMessageFieldPrivateKey(3, privateKey));
        return new Adsap2SetCertificatesRequest(vector);
    }
}

