/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.adsap2.Adsap2Message;
import com.avocent.protocols.adsap2.MessageField;
import java.util.Vector;

public class Adsap2StatusReply
extends Adsap2Message {
    private static final String TRACE_CONTEXT = "Adsap2StatusReply";

    protected Adsap2StatusReply(int n, Vector vector) {
        super(n, vector);
    }

    public int getStatus() throws ExceptionRequestFailed {
        int n = -1;
        switch (this.getCommandId()) {
            case 129: {
                n = 1;
                break;
            }
            case 130: {
                n = 1;
                break;
            }
            case 131: {
                n = 1;
                break;
            }
            case 132: {
                n = 1;
                break;
            }
            default: {
                n = -1;
                Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported Reply Message [" + this.getCommandId() + "]"));
                throw new ExceptionRequestFailed();
            }
        }
        return this.getFieldDataShort(n);
    }

    public boolean isReplyValid(Adsap2Message adsap2Message) {
        if (adsap2Message == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Invalid parameters for isReplyValid()");
            return false;
        }
        Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Reply[" + adsap2Message.getCommandId() + "]"));
        return false;
    }

    public static Adsap2StatusReply createSetCertificatesReply(int n) throws ExceptionRequestFailed {
        if (n != 0 && n != 256 && n != 260) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported status for SetCertificatesReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        return new Adsap2StatusReply(129, vector);
    }

    public static Adsap2StatusReply createClearCertificatesReply(int n) throws ExceptionRequestFailed {
        if (n != 0 && n != 256 && n != 260) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unsupported status for ClearCertificatesReply[" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        Vector<MessageField> vector = new Vector<MessageField>();
        vector.add(MessageField.createMessageFieldShort(1, n));
        return new Adsap2StatusReply(130, vector);
    }
}

