/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.adsap2;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.security.RSAEncodedPublicKeySpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class MessageField {
    private static final String TRACE_CONTEXT = "MessageField";
    private int m_nFieldId;
    private byte[] m_abyFieldData;

    public MessageField(int n, byte[] byArray) {
        this.m_nFieldId = n;
        this.m_abyFieldData = byArray;
    }

    public int getFieldId() {
        return this.m_nFieldId;
    }

    public byte[] getFieldData() {
        return this.m_abyFieldData;
    }

    public Short getShort() {
        Short s = null;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.m_abyFieldData));
        try {
            s = new Short(dataInputStream.readShort());
        }
        catch (IOException iOException) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Short not available, data length=[" + this.m_abyFieldData.length + "]"));
            return null;
        }
        return s;
    }

    public Byte getByte() {
        if (this.m_abyFieldData.length < 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Byte not available, data length=[" + this.m_abyFieldData.length + "]"));
            return null;
        }
        return new Byte(this.m_abyFieldData[0]);
    }

    public String getUTF() {
        String string = null;
        try {
            string = new String(this.m_abyFieldData, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Unsupported encoding");
            return null;
        }
        return string;
    }

    public X509Certificate getX509Cert() {
        X509Certificate x509Certificate = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.m_abyFieldData));
        }
        catch (CertificateException certificateException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create X.509 certificate", (Throwable)certificateException);
            return null;
        }
        return x509Certificate;
    }

    public PublicKey getX509PublicKey() {
        PublicKey publicKey = null;
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.m_abyFieldData);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create public key", (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create public key", (Throwable)invalidKeySpecException);
            return null;
        }
        return publicKey;
    }

    public PublicKey getRSAPublicKey() {
        PublicKey publicKey = null;
        try {
            RSAEncodedPublicKeySpec rSAEncodedPublicKeySpec = new RSAEncodedPublicKeySpec(this.m_abyFieldData);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(rSAEncodedPublicKeySpec.getKeySpec());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create public key", (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create public key", (Throwable)invalidKeySpecException);
            return null;
        }
        return publicKey;
    }

    public PrivateKey getPrivateKey() {
        PrivateKey privateKey = null;
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.m_abyFieldData);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create private key", (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to create private key", (Throwable)invalidKeySpecException);
            return null;
        }
        return privateKey;
    }

    public static MessageField createMessageFieldUTF(int n, String string) throws ExceptionRequestFailed {
        byte[] byArray = null;
        if (string == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Invalid data passed (null) for field [" + n + "]"));
            throw new ExceptionRequestFailed();
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to create field [" + n + "]"), (Throwable)unsupportedEncodingException);
            throw new ExceptionRequestFailed();
        }
        return new MessageField(n, byArray);
    }

    public static MessageField createMessageFieldShort(int n, int n2) throws ExceptionRequestFailed {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeShort(n2);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to create field [" + n + "]"), (Throwable)iOException);
            throw new ExceptionRequestFailed();
        }
        return new MessageField(n, byteArrayOutputStream.toByteArray());
    }

    public static MessageField createMessageFieldByte(int n, int n2) throws ExceptionRequestFailed {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(n2);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to create field [" + n + "]"), (Throwable)iOException);
            throw new ExceptionRequestFailed();
        }
        return new MessageField(n, byteArrayOutputStream.toByteArray());
    }

    public static MessageField createMessageFieldX509Cert(int n, X509Certificate x509Certificate) throws ExceptionRequestFailed {
        MessageField messageField = null;
        try {
            messageField = new MessageField(n, x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Unable to create field [" + n + "]"), (Throwable)certificateEncodingException);
            throw new ExceptionRequestFailed();
        }
        return messageField;
    }

    public static MessageField createMessageFieldPrivateKey(int n, PrivateKey privateKey) throws ExceptionRequestFailed {
        if (!MessageField.isStringPKCS8(privateKey.getFormat())) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Private Key does not support PKCS#8 encoding.");
            throw new ExceptionRequestFailed();
        }
        return new MessageField(n, privateKey.getEncoded());
    }

    public static MessageField createMessageFieldPublicKey(int n, PublicKey publicKey) throws ExceptionRequestFailed {
        if (!MessageField.isStringX509(publicKey.getFormat())) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Public Key does not support X.509 format.");
            throw new ExceptionRequestFailed();
        }
        return new MessageField(n, publicKey.getEncoded());
    }

    private static boolean isStringX509(String string) {
        return string != null && (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("X509"));
    }

    private static boolean isStringPKCS8(String string) {
        return string != null && (string.equalsIgnoreCase("PKCS#8") || string.equalsIgnoreCase("PKCS8"));
    }
}

