/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.aidp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.protocols.aidp.AidpDiscoverInfo;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class AidpSession {
    InetAddress m_iaAppliance;
    private static int m_nSequence = 0;

    public AidpSession(long l, long l2) throws ExceptionInvalidArgument {
        long l3 = l & l2;
        long l4 = l3 | (l2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
        String string = IpAddress.getString((long)l4);
        try {
            this.m_iaAppliance = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ExceptionInvalidArgument("The address given is not valid");
        }
    }

    public AidpSession(InetAddress inetAddress) {
        this.m_iaAppliance = inetAddress;
    }

    public AidpDiscoverInfo[] discover() throws IOException {
        Object[] objectArray;
        Trace.logInfo((String)"AIDP", (String)"Creating the UDP socket for AIDP messages");
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.setSoTimeout(4000);
        Trace.logInfo((String)"AIDP", (String)"UDP socket successfully created");
        Vector<AidpDiscoverInfo> vector = new Vector<AidpDiscoverInfo>();
        Trace.logInfo((String)"AIDP:Discover:Tx", (String)"Creating DISCOVER packet");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = AidpSession.getNextSequence();
        dataOutputStream.writeByte(1);
        dataOutputStream.writeBytes("AIDP");
        dataOutputStream.writeShort(n);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeByte(255);
        dataOutputStream.writeByte(13);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.m_iaAppliance, 3211);
        Trace.logInfo((String)"AIDP:Discover:Tx", (String)"Sending AIDP DISCOVER message");
        datagramSocket.send(datagramPacket);
        Trace.logInfo((String)"AIDP:Discover:Tx", (String)"Sent AIDP DISCOVER message");
        while (true) {
            DatagramPacket datagramPacket2;
            objectArray = new byte[8192];
            try {
                Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Receive Datagram (wait 4000 sec)");
                datagramPacket2 = new DatagramPacket((byte[])objectArray, 8192, this.m_iaAppliance, 3211);
                datagramSocket.receive(datagramPacket2);
            }
            catch (InterruptedIOException interruptedIOException) {
                Trace.logInfo((String)"AIDP:Discover:Rx", (String)"No data received within timeout");
                break;
            }
            catch (IOException iOException) {
                Trace.logError((String)"AIDP:Discover:Rx", (String)("IOException=" + iOException.getMessage()));
                throw iOException;
            }
            Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Received a datagram packet");
            try {
                int n2;
                byte[] byArray2 = datagramPacket2.getData();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                byte by = dataInputStream.readByte();
                if (by != 1) {
                    Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Packet is not AIDP (No SOH)");
                    continue;
                }
                byte[] byArray3 = new byte[4];
                dataInputStream.readFully(byArray3, 0, 4);
                String string = new String(byArray3);
                if (!string.equalsIgnoreCase("AIDP")) {
                    Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Packet is not AIDP (Bad Signature)");
                    continue;
                }
                int n3 = dataInputStream.readUnsignedShort();
                if (n3 != n) {
                    Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Packet is not AIDP (Bad Sequence)");
                    continue;
                }
                int n4 = dataInputStream.readUnsignedByte();
                if (n4 != 129) {
                    Trace.logInfo((String)"AIDP:Discover:Rx", (String)"Packet is not AIDP (Bad Command ID)");
                    continue;
                }
                int n5 = dataInputStream.readInt();
                int n6 = 0;
                MacAddress macAddress = null;
                IpAddress ipAddress = null;
                IpAddress ipAddress2 = null;
                IpAddress ipAddress3 = null;
                while ((n2 = dataInputStream.readUnsignedByte()) != 255) {
                    byte[] byArray4;
                    int n7;
                    if (n2 == 1) {
                        n7 = dataInputStream.readUnsignedShort();
                        n6 = dataInputStream.readUnsignedShort();
                        continue;
                    }
                    if (n2 == 2) {
                        n7 = dataInputStream.readUnsignedShort();
                        if (n7 != 6) {
                            throw new ExceptionRequestFailed("Bad MAC Address Length");
                        }
                        byArray4 = new byte[6];
                        dataInputStream.readFully(byArray4);
                        macAddress = new MacAddress(byArray4);
                        continue;
                    }
                    if (n2 == 3) {
                        n7 = dataInputStream.readUnsignedShort();
                        if (n7 != 4) {
                            throw new ExceptionRequestFailed("Bad IP Address Length");
                        }
                        byArray4 = new byte[4];
                        dataInputStream.readFully(byArray4);
                        ipAddress = new IpAddress(byArray4);
                        continue;
                    }
                    if (n2 == 4) {
                        n7 = dataInputStream.readUnsignedShort();
                        if (n7 != 4) {
                            throw new ExceptionRequestFailed("Bad Subnet Address Length");
                        }
                        byArray4 = new byte[4];
                        dataInputStream.readFully(byArray4);
                        ipAddress2 = new IpAddress(byArray4);
                        continue;
                    }
                    if (n2 != 5) continue;
                    n7 = dataInputStream.readUnsignedShort();
                    if (n7 != 4) {
                        throw new ExceptionRequestFailed("Bad Gateway Length");
                    }
                    byArray4 = new byte[4];
                    dataInputStream.readFully(byArray4);
                    ipAddress3 = new IpAddress(byArray4);
                }
                AidpDiscoverInfo aidpDiscoverInfo = new AidpDiscoverInfo(n6, macAddress, ipAddress, ipAddress2, ipAddress3);
                vector.addElement(aidpDiscoverInfo);
            }
            catch (Exception exception) {
                Trace.logInfo((String)"AIDP:Discover:Rx", (String)("Error processing receive packet :" + exception.getMessage()));
            }
        }
        objectArray = new AidpDiscoverInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            AidpDiscoverInfo aidpDiscoverInfo = (AidpDiscoverInfo)vector.elementAt(i);
            objectArray[i] = (byte)aidpDiscoverInfo;
        }
        datagramSocket.close();
        return objectArray;
    }

    public int testIpConfiguration(AidpDiscoverInfo aidpDiscoverInfo) {
        try {
            int n;
            Trace.logInfo((String)"AIDP:Test-IP", (String)"Creating TEST-IP record data");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            byte[] byArray = aidpDiscoverInfo.getMacAddress().getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(2);
            byte[] byArray2 = aidpDiscoverInfo.getIpAddress().getBytes();
            dataOutputStream.writeShort(byArray2.length);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeByte(3);
            byte[] byArray3 = aidpDiscoverInfo.getSubnetMask().getBytes();
            dataOutputStream.writeShort(byArray3.length);
            dataOutputStream.write(byArray3);
            dataOutputStream.writeByte(4);
            byte[] byArray4 = aidpDiscoverInfo.getGateway().getBytes();
            dataOutputStream.writeShort(byArray4.length);
            dataOutputStream.write(byArray4);
            dataOutputStream.writeByte(255);
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            Trace.logInfo((String)"AIDP:Test-IP", (String)"Sending AIDP TEST-IP request");
            byte[] byArray6 = this.request(2, byArray5);
            Trace.logInfo((String)"AIDP:Test-IP", (String)"Received Reply");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray6);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n2 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                if (n != 1) continue;
                int n3 = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.readUnsignedShort();
                break;
            }
            Trace.logInfo((String)"AIDP:Test-IP", (String)("Returned Status=" + n2));
            return n2;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"AIDP:Test-IP", (String)"Returned Status=REQUEST_TIMEOUT");
            return 4096;
        }
        catch (IOException iOException) {
            Trace.logInfo((String)"AIDP:Test-IP", (String)"Returned Status=IO_ERROR");
            return 4098;
        }
    }

    public int setIpConfiguration(AidpDiscoverInfo aidpDiscoverInfo) {
        try {
            int n;
            Trace.logInfo((String)"AIDP:Set-IP", (String)"Creating SET-IP record data");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            byte[] byArray = aidpDiscoverInfo.getMacAddress().getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(2);
            byte[] byArray2 = aidpDiscoverInfo.getIpAddress().getBytes();
            dataOutputStream.writeShort(byArray2.length);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeByte(3);
            byte[] byArray3 = aidpDiscoverInfo.getSubnetMask().getBytes();
            dataOutputStream.writeShort(byArray3.length);
            dataOutputStream.write(byArray3);
            dataOutputStream.writeByte(4);
            byte[] byArray4 = aidpDiscoverInfo.getGateway().getBytes();
            dataOutputStream.writeShort(byArray4.length);
            dataOutputStream.write(byArray4);
            dataOutputStream.writeByte(255);
            byte[] byArray5 = byteArrayOutputStream.toByteArray();
            Trace.logInfo((String)"AIDP:Set-IP", (String)"Sending AIDP SET-IP request");
            byte[] byArray6 = this.request(3, byArray5);
            Trace.logInfo((String)"AIDP:Set-IP", (String)"Received Reply");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray6);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n2 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                if (n != 1) continue;
                int n3 = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.readUnsignedShort();
                break;
            }
            Trace.logInfo((String)"AIDP:Set-IP", (String)("Returned Status=" + n2));
            return n2;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"AIDP:Set-IP", (String)"Returned Status=REQUEST_TIMEOUT");
            return 4096;
        }
        catch (IOException iOException) {
            Trace.logInfo((String)"AIDP:Set-IP", (String)"Returned Status=IO_ERROR");
            return 4098;
        }
    }

    public boolean snmpGet(VarBind varBind) {
        return this.snmpRequest(varBind, 160);
    }

    public boolean snmpGetNext(VarBind varBind) {
        return this.snmpRequest(varBind, 161);
    }

    public boolean snmpGet(VarBind[] varBindArray) {
        return this.snmpRequest(varBindArray, 160);
    }

    public boolean snmpGetNext(VarBind[] varBindArray) {
        return this.snmpRequest(varBindArray, 161);
    }

    private boolean snmpRequest(VarBind varBind, int n) {
        try {
            VarBindList varBindList = new VarBindList();
            varBindList.addVarBind(varBind);
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", n, 0, 0);
            int n2 = this.snmpRequest(snmpRequest);
            if (n2 == 0 && snmpRequest.getErrorStatus() == 0) {
                VarBindList varBindList2 = snmpRequest.getVarBindList();
                if (varBindList2.size() == 1) {
                    VarBind varBind2 = varBindList2.varbindAt(0);
                    varBind.copyFrom(varBind2);
                    return true;
                }
                Trace.logError((String)"AIDP:snmpGet", (String)"INVALID NUMBER OF BINDINGS");
                return false;
            }
            Trace.logError((String)"AIDP:snmpGet", (String)("AIDP Status=" + n2 + "SNMP Status=" + snmpRequest.getErrorStatusMessage()));
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)"AIDP:snmpGet", (String)"Error getting Value", (Throwable)exception);
            return false;
        }
    }

    private boolean snmpRequest(VarBind[] varBindArray, int n) {
        try {
            VarBindList varBindList = new VarBindList();
            for (int i = 0; i < varBindArray.length; ++i) {
                varBindList.addVarBind(varBindArray[i]);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", n, 0, 0);
            int n2 = this.snmpRequest(snmpRequest);
            if (n2 == 0 && snmpRequest.getErrorStatus() == 0) {
                VarBindList varBindList2 = snmpRequest.getVarBindList();
                if (varBindList.size() == varBindList2.size()) {
                    for (int i = 0; i < varBindList.size(); ++i) {
                        varBindArray[i].copyFrom(varBindList2.varbindAt(i));
                    }
                    return true;
                }
                Trace.logError((String)"AIDP:snmpGet", (String)"INVALID NUMBER OF BINDINGS");
                return false;
            }
            Trace.logError((String)"AIDP:snmpGet", (String)("AIDP Status=" + n2 + "SNMP Status=" + snmpRequest.getErrorStatusMessage()));
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)"AIDP:snmpGet", (String)"Error getting Value", (Throwable)exception);
            return false;
        }
    }

    public int snmpRequest(SnmpRequest snmpRequest) {
        try {
            int n;
            int n2;
            byte[] byArray;
            Trace.logInfo((String)"AIDP:SNMP", (String)"Creating SET-IP record data");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            VarBindList varBindList = snmpRequest.getVarBindList();
            for (int i = 0; i < varBindList.size(); ++i) {
                VarBind varBind = varBindList.varbindAt(i);
                byArray = ThreadAsmpSession.encodeAsmpAidpVarBindField(varBind);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeShort(byArray.length);
                dataOutputStream.write(byArray);
            }
            dataOutputStream.writeByte(255);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (snmpRequest.getRequestType() == 160) {
                n2 = 16;
            } else if (snmpRequest.getRequestType() == 161) {
                n2 = 17;
            } else {
                Trace.logError((String)"AIDP:SNMP", (String)("Invalid SNMP Request Type=" + snmpRequest.getRequestId()));
                snmpRequest.setErrorStatus(5);
                return 5;
            }
            Trace.logInfo((String)"AIDP:SNMP", (String)"Sending AIDP SNMP request");
            byArray = this.request(n2, byArray2);
            Trace.logInfo((String)"AIDP:SNMP", (String)"Received Reply");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 4097;
            VarBindList varBindList2 = new VarBindList();
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    snmpRequest.setErrorStatus(n3);
                    continue;
                }
                if (n == 2) {
                    dataInputStream.readUnsignedShort();
                    n4 = dataInputStream.readUnsignedShort();
                    snmpRequest.setErrorIndex(n4);
                    continue;
                }
                if (n != 3) continue;
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
                try {
                    VarBind varBind = ThreadAsmpSession.decodeAsmpAidpVarBindField(byArray3);
                    varBindList2.addVarBind(varBind);
                    snmpRequest.setNewVarBindList(varBindList2);
                }
                catch (Exception exception) {
                    snmpRequest.setErrorStatus(5);
                    return 5;
                }
            }
            Trace.logInfo((String)"AIDP:SNMP", (String)("AIDP SNMP request completed. Status=" + n3));
            if (n3 != 0) {
                if (n3 <= 5) {
                    snmpRequest.setErrorStatus(n3);
                } else {
                    snmpRequest.setErrorStatus(5);
                }
            }
            return n3;
        }
        catch (IOException iOException) {
            Trace.logInfo((String)"AIDP:SNMP", (String)"Returned Status=IO_ERROR");
            snmpRequest.setErrorStatus(5);
            return 4098;
        }
        catch (ExceptionInvalidIndex exceptionInvalidIndex) {
            Trace.logError((String)"AIDP:SNMP", (String)"Returned Status=BAD_REPLY");
            snmpRequest.setErrorStatus(5);
            return 4097;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"AIDP:SNMP", (String)"Returned Status=REQUEST_TIMEOUT");
            snmpRequest.setErrorStatus(5);
            return 4096;
        }
    }

    private static synchronized int getNextSequence() {
        if (m_nSequence == 65535) {
            m_nSequence = 0;
        }
        return ++m_nSequence;
    }

    private byte[] request(int n, byte[] byArray) throws IOException, ExceptionNoValue {
        Trace.logInfo((String)"AIDP", (String)"Creating the UDP socket for AIDP messages");
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.setSoTimeout(4000);
        Trace.logInfo((String)"AIDP", (String)"UDP socket successfully created");
        Trace.logInfo((String)"AIDP", (String)("Creating AIDP packet for command " + n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = AidpSession.getNextSequence();
        dataOutputStream.writeByte(1);
        dataOutputStream.writeBytes("AIDP");
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeByte(n);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeByte(13);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        AsnOctetString asnOctetString = new AsnOctetString(byArray);
        Trace.logInfo((String)"AIDP:Tx", (String)("RecordData=" + asnOctetString.getStringValue()));
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, this.m_iaAppliance, 3211);
        byte[] byArray3 = new byte[8192];
        int n3 = 0;
        while (n3 < 3) {
            int n4;
            DatagramPacket datagramPacket2;
            try {
                if (n3 > 0) {
                    Trace.logInfo((String)"AIDP", (String)("Retry " + n3 + " Receive UDP reply"));
                } else {
                    Trace.logInfo((String)"AIDP", (String)"Receive the UDP reply");
                }
                ++n3;
                Trace.logInfo((String)"AIDP", (String)("Sending AIDP message for command " + n));
                datagramSocket.send(datagramPacket);
                Trace.logInfo((String)"AIDP", (String)("Sent AIDP message for command " + n));
                Trace.logInfo((String)"AIDP", (String)"Wait 4000 seconds");
                datagramPacket2 = new DatagramPacket(byArray3, 8192, this.m_iaAppliance, 3211);
                datagramSocket.receive(datagramPacket2);
                Trace.logInfo((String)"AIDP", (String)"Received a datagram packet");
            }
            catch (InterruptedIOException interruptedIOException) {
                Trace.logInfo((String)"AIDP", (String)"No data received within timeout");
                continue;
            }
            catch (IOException iOException) {
                Trace.logError((String)"AIDP", (String)("IOException=" + iOException.getMessage()));
                continue;
            }
            byte[] byArray4 = datagramPacket2.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte by = dataInputStream.readByte();
            if (by != 1) {
                Trace.logError((String)"AIDP", (String)"Packet is not AIDP (No SOH)");
                continue;
            }
            byte[] byArray5 = new byte[4];
            dataInputStream.readFully(byArray5, 0, 4);
            String string = new String(byArray5);
            if (!string.equalsIgnoreCase("AIDP")) {
                Trace.logError((String)"AIDP", (String)"Packet is not AIDP (Bad Signature)");
                continue;
            }
            int n5 = dataInputStream.readUnsignedShort();
            if (n5 != n2) {
                Trace.logInfo((String)"AIDP", (String)"Packet is not AIDP (Bad Sequence)");
                continue;
            }
            int n6 = dataInputStream.readUnsignedByte();
            if (n6 != (n4 = n | 0x80)) {
                Trace.logError((String)"AIDP", (String)("AIDP RX Command ID is invalid ID=" + n6));
                continue;
            }
            int n7 = dataInputStream.readInt();
            if (n7 > 8192) {
                Trace.logError((String)"AIDP", (String)"AIDP packet is TOO BIG");
                continue;
            }
            byte[] byArray6 = new byte[n7];
            dataInputStream.readFully(byArray6);
            AsnOctetString asnOctetString2 = new AsnOctetString(byArray6);
            Trace.logInfo((String)"AIDP:Rx", (String)("RecordData=" + asnOctetString2.getStringValue()));
            datagramSocket.close();
            return byArray6;
        }
        datagramSocket.close();
        Trace.logInfo((String)"AIDP", (String)"AIDP packet is TOO BIG");
        throw new ExceptionNoValue();
    }
}

