/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.app;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.app.ProxyHelper;
import com.avocent.protocols.app.ProxyPacket;
import com.avocent.protocols.app.SocketAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class ProxyClient
implements Runnable {
    public static final int INITIAL_BUFFER_SIZE = 2048;
    public static final int MAX_BUFFER_SIZE = 262144;
    public static final long SELECT_TIMEOUT = 60000L;
    private ProxyPacket m_ppCurrent = new ProxyPacket();
    private ProxyPacket m_ppLast = null;
    private SocketAttachment m_saToServer;
    private SocketAttachment m_saToClient;
    private Thread m_thread;
    private ServerSocketChannel m_ssc;
    private SocketChannel m_sc;
    private int m_nLastStatus = 0;
    private boolean m_bSvrSocket = false;
    private boolean m_bTunnelOpen = false;
    private Selector m_selector = null;
    private Object m_oAPPWriteLock = new Object();
    private Object m_selectionLock = new Object();
    private int m_nTimeout;

    public ProxyClient(String string, int n, int n2) throws IOException {
        this.m_nTimeout = n2;
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        socketChannel.configureBlocking(true);
        if (n2 != 0) {
            socketChannel.socket().setSoTimeout(n2);
        }
        socketChannel.connect(new InetSocketAddress(string, n));
        if (!socketChannel.finishConnect()) {
            throw new IOException("Could Not Connect to Proxy Server");
        }
        this.m_selector = Selector.open();
        this.m_saToServer = new SocketAttachment(socketChannel, this.m_selector, this.m_selectionLock, (ByteBuffer)ByteBuffer.allocateDirect(2048).flip(), (ByteBuffer)ByteBuffer.allocateDirect(2048).flip());
        this.m_thread = new Thread((Runnable)this, "Avocent Proxy Client [" + string + ":" + n + "]");
        this.m_thread.start();
    }

    public int getLastStatusCode() {
        return this.m_nLastStatus;
    }

    public int openServerSocket(long l) throws IOException {
        this.m_bSvrSocket = true;
        this.openTunnel(l);
        if (this.m_ssc == null) {
            return -1;
        }
        return this.m_ssc.socket().getLocalPort();
    }

    public Socket openSocket(long l) throws IOException {
        this.m_bSvrSocket = false;
        this.openTunnel(l);
        if (this.m_sc == null) {
            return null;
        }
        return new NioSocketWrapper(this.m_sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openTunnel(long l) throws IOException {
        Object object = this.m_oAPPWriteLock;
        synchronized (object) {
            if (this.m_bTunnelOpen) {
                Trace.logError((String)"ProxyClient:openTunnel", (String)"Tunnel Already Opened");
                throw new IOException("Tunnel Already Opened");
            }
            ProxyPacket proxyPacket = new ProxyPacket(1);
            proxyPacket.addField(1, new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l});
            ProxyClient proxyClient = this;
            synchronized (proxyClient) {
                ProxyPacket proxyPacket2 = this.m_ppLast;
                this.m_saToServer.write(proxyPacket.toByteArray());
                while (this.m_thread != null && (this.m_ppLast == proxyPacket2 || this.m_ppLast.getCmd() != 129)) {
                    try {
                        this.wait(this.m_nTimeout >= 0 ? (long)this.m_nTimeout : 0L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.m_ppLast == proxyPacket2) {
                    Trace.logError((String)"ProxyClient:openTunnel", (String)("Thread " + this.m_thread + " stopped"));
                    throw new IOException("ProxyClient Stopped");
                }
                byte[] byArray = this.m_ppLast.getField(1);
                this.m_nLastStatus = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Trace.logInfo((String)"ProxyClient:stop", (String)"Stop called");
        Thread thread = this.m_thread;
        this.m_thread = null;
        ProxyClient proxyClient = this;
        synchronized (proxyClient) {
            this.notifyAll();
        }
        if (thread != null) {
            thread.interrupt();
        }
        if (this.m_selector != null) {
            this.m_selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = 1;
        while (this.m_thread == Thread.currentThread()) {
            var2_4 = this.m_selectionLock;
            ** synchronized (var2_4)
lbl7:
            // 1 sources

            var2_3 = System.currentTimeMillis();
            var4_5 = this.m_selector.select(60000L);
            var5_6 = System.currentTimeMillis();
            var7_7 = this.m_selector.selectedKeys().iterator();
            while (var7_7.hasNext()) {
                var8_8 = var7_7.next();
                var7_7.remove();
                var9_9 = var8_8.attachment();
                var10_10 = var8_8.channel();
                if (var10_10 instanceof ServerSocketChannel) {
                    var11_11 = ((ServerSocketChannel)var10_10).accept();
                    if (var11_11 == null) continue;
                    var11_11.socket().setTcpNoDelay(true);
                    var11_11.socket().setKeepAlive(true);
                    this.m_saToClient = new SocketAttachment(var11_11, this.m_selector, this.m_selectionLock, this.m_saToServer.getOutBuffer(), this.m_saToServer.getInBuffer());
                    var8_8.cancel();
                    this.m_ssc.close();
                    continue;
                }
                if (!this.m_bTunnelOpen) {
                    this.readPacket();
                    continue;
                }
                if (var9_9 == this.m_saToServer) {
                    ProxyHelper.handle(this.m_saToServer, this.m_saToClient);
                    continue;
                }
                if (var9_9 != this.m_saToClient) continue;
                ProxyHelper.handle(this.m_saToClient, this.m_saToServer);
            }
            if (var4_5 == 0 && var1_1 == 0 && var2_3 + 10L > var5_6) {
                Trace.logInfo((String)"ProxyClient:run", (String)"Selector Failed! Must Create New Selector!");
                var7_7 = Selector.open();
                var8_8 = this.m_selector.keys().iterator();
                while (var8_8.hasNext()) {
                    var9_9 = (SelectionKey)var8_8.next();
                    var10_10 = var9_9.attachment();
                    if (var10_10 instanceof SocketAttachment) {
                        ((SocketAttachment)var10_10).setSelector((Selector)var7_7);
                        continue;
                    }
                    var9_9.channel().register((Selector)var7_7, var9_9.interestOps(), var9_9.attachment());
                }
                this.m_selector.close();
                this.m_selector = var7_7;
                var4_5 = 1;
            }
            var1_1 = var4_5;
        }
        var13_12 = null;
        Trace.logInfo((String)"ProxyClient:run", (String)"Closing client");
        try {
            this.m_saToServer.close();
        }
        catch (Exception var14_15) {
            // empty catch block
        }
        try {
            this.m_saToClient.close();
        }
        catch (Exception var14_15) {
            // empty catch block
        }
        try {
            this.m_selector.close();
        }
        catch (Exception var14_15) {
            // empty catch block
        }
        this.m_thread = null;
        var14_15 = this;
        synchronized (var14_15) {
            this.notifyAll();
        }
        {
            catch (IOException var1_2) {
                Trace.logError((String)"ProxyClient:run", (String)"IOException", (Throwable)var1_2);
                var13_13 = null;
                Trace.logInfo((String)"ProxyClient:run", (String)"Closing client");
                try {
                    this.m_saToServer.close();
                }
                catch (Exception var14_16) {
                    // empty catch block
                }
                try {
                    this.m_saToClient.close();
                }
                catch (Exception var14_16) {
                    // empty catch block
                }
                try {
                    this.m_selector.close();
                }
                catch (Exception var14_16) {
                    // empty catch block
                }
                this.m_thread = null;
                var14_16 = this;
                synchronized (var14_16) {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable var12_21) {
            var13_14 = null;
            Trace.logInfo((String)"ProxyClient:run", (String)"Closing client");
            try {
                this.m_saToServer.close();
            }
            catch (Exception var14_17) {
                // empty catch block
            }
            try {
                this.m_saToClient.close();
            }
            catch (Exception var14_17) {
                // empty catch block
            }
            try {
                this.m_selector.close();
            }
            catch (Exception var14_17) {
                // empty catch block
            }
            this.m_thread = null;
            var14_17 = this;
            synchronized (var14_17) {
                this.notifyAll();
            }
            throw var12_21;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPacket() throws IOException {
        this.m_saToServer.handleWrites();
        this.m_ppCurrent.read(this.m_saToServer.m_sc);
        if (this.m_ppCurrent.isComplete()) {
            if (this.m_ppCurrent.isValid()) {
                ProxyClient proxyClient = this;
                synchronized (proxyClient) {
                    this.m_ppLast = this.m_ppCurrent;
                    this.notifyAll();
                    if (this.m_ppLast.getCmd() == 129 && this.m_ppLast.getField(1)[0] == 0 && this.m_ppLast.getField(1)[1] == 0) {
                        this.m_bTunnelOpen = true;
                        if (this.m_bSvrSocket) {
                            this.m_ssc = ServerSocketChannel.open();
                            this.m_ssc.configureBlocking(false);
                            this.m_ssc.register(this.m_selector, 16, null);
                            this.m_ssc.socket().bind(new InetSocketAddress("127.0.0.1", 0));
                        } else {
                            this.m_sc = this.m_saToServer.m_sc;
                            this.m_saToServer.m_sc = null;
                            this.m_saToServer.close();
                            this.m_sc.socket().setTcpNoDelay(false);
                            this.m_sc.configureBlocking(true);
                            this.stop();
                        }
                    }
                }
            } else {
                Trace.logError((String)"ProxyClient:readPacket", (String)"Invalid Response, Stop");
                this.stop();
            }
        }
    }

    private static class NioSocketWrapper
    extends Socket {
        private Socket m_socket;
        private ByteChannel m_channel;

        private NioSocketWrapper(SocketChannel socketChannel) {
            this.m_socket = socketChannel.socket();
            this.m_channel = NioSocketWrapper.wrapChannel(socketChannel);
        }

        public InputStream getInputStream() throws IOException {
            return Channels.newInputStream(this.m_channel);
        }

        public OutputStream getOutputStream() throws IOException {
            return Channels.newOutputStream(this.m_channel);
        }

        private static ByteChannel wrapChannel(final ByteChannel byteChannel) {
            return new ByteChannel(){

                public int write(ByteBuffer byteBuffer) throws IOException {
                    return byteChannel.write(byteBuffer);
                }

                public int read(ByteBuffer byteBuffer) throws IOException {
                    return byteChannel.read(byteBuffer);
                }

                public boolean isOpen() {
                    return byteChannel.isOpen();
                }

                public void close() throws IOException {
                    byteChannel.close();
                }
            };
        }

        public int getLocalPort() {
            return this.m_socket.getLocalPort();
        }

        public int getPort() {
            return this.m_socket.getPort();
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.m_socket.getReceiveBufferSize();
        }

        public int getSendBufferSize() throws SocketException {
            return this.m_socket.getSendBufferSize();
        }

        public int getSoLinger() throws SocketException {
            return this.m_socket.getSoLinger();
        }

        public int getSoTimeout() throws SocketException {
            return this.m_socket.getSoTimeout();
        }

        public int getTrafficClass() throws SocketException {
            return this.m_socket.getTrafficClass();
        }

        public void close() throws IOException {
            this.m_socket.close();
        }

        public void shutdownInput() throws IOException {
            this.m_socket.shutdownInput();
        }

        public void shutdownOutput() throws IOException {
            this.m_socket.shutdownOutput();
        }

        public boolean getKeepAlive() throws SocketException {
            return this.m_socket.getKeepAlive();
        }

        public boolean getOOBInline() throws SocketException {
            return this.m_socket.getOOBInline();
        }

        public boolean getReuseAddress() throws SocketException {
            return this.m_socket.getReuseAddress();
        }

        public boolean getTcpNoDelay() throws SocketException {
            return this.m_socket.getTcpNoDelay();
        }

        public boolean isBound() {
            return this.m_socket.isBound();
        }

        public boolean isClosed() {
            return this.m_socket.isClosed();
        }

        public boolean isConnected() {
            return this.m_socket.isConnected();
        }

        public boolean isInputShutdown() {
            return this.m_socket.isInputShutdown();
        }

        public boolean isOutputShutdown() {
            return this.m_socket.isOutputShutdown();
        }

        public void sendUrgentData(int n) throws IOException {
            this.m_socket.sendUrgentData(n);
        }

        public void setReceiveBufferSize(int n) throws SocketException {
            this.m_socket.setReceiveBufferSize(n);
        }

        public void setSendBufferSize(int n) throws SocketException {
            this.m_socket.setSendBufferSize(n);
        }

        public void setSoTimeout(int n) throws SocketException {
            this.m_socket.setSoTimeout(n);
        }

        public void setTrafficClass(int n) throws SocketException {
            this.m_socket.setTrafficClass(n);
        }

        public void setKeepAlive(boolean bl) throws SocketException {
            this.m_socket.setKeepAlive(bl);
        }

        public void setOOBInline(boolean bl) throws SocketException {
            this.m_socket.setOOBInline(bl);
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            this.m_socket.setReuseAddress(bl);
        }

        public void setTcpNoDelay(boolean bl) throws SocketException {
            this.m_socket.setTcpNoDelay(bl);
        }

        public void setSoLinger(boolean bl, int n) throws SocketException {
            this.m_socket.setSoLinger(bl, n);
        }

        public String toString() {
            return this.m_socket.toString();
        }

        public InetAddress getInetAddress() {
            return this.m_socket.getInetAddress();
        }

        public InetAddress getLocalAddress() {
            return this.m_socket.getLocalAddress();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.m_socket.getLocalSocketAddress();
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.m_socket.getRemoteSocketAddress();
        }

        public void bind(SocketAddress socketAddress) throws IOException {
            this.m_socket.bind(socketAddress);
        }

        public void connect(SocketAddress socketAddress) throws IOException {
            this.m_socket.connect(socketAddress);
        }

        public void connect(SocketAddress socketAddress, int n) throws IOException {
            this.m_socket.connect(socketAddress, n);
        }

        public SocketChannel getChannel() {
            return this.m_socket.getChannel();
        }
    }
}

