/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.app;

import com.avocent.protocols.app.SocketAttachment;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ProxyHelper {
    public static final int MAX_BUFFER_SIZE = 262144;

    static boolean isEmpty(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        return byteBuffer.position() == n && byteBuffer.limit() == n;
    }

    static boolean isFull(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        return byteBuffer.position() == 0 && byteBuffer.limit() == n;
    }

    static void resizeInBuffer(SocketAttachment socketAttachment, SocketAttachment socketAttachment2) {
        ByteBuffer byteBuffer = socketAttachment.getInBuffer();
        int n = byteBuffer.capacity();
        if (n < 262144) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n * 2);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            socketAttachment.setInBuffer(byteBuffer2);
            if (socketAttachment2 != null) {
                socketAttachment2.setOutBuffer(byteBuffer2);
                socketAttachment2.writeAlert();
            }
            socketAttachment.readAlert();
        }
    }

    static void resizeOutBuffer(SocketAttachment socketAttachment, SocketAttachment socketAttachment2) {
        ByteBuffer byteBuffer = socketAttachment.getOutBuffer();
        int n = byteBuffer.capacity();
        if (n < 262144) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n * 2);
            byteBuffer2.flip();
            socketAttachment.setOutBuffer(byteBuffer2);
            if (socketAttachment2 != null) {
                socketAttachment2.setInBuffer(byteBuffer2);
                socketAttachment2.readAlert();
            }
            socketAttachment.writeAlert();
        }
    }

    static void handle(SocketAttachment socketAttachment, SocketAttachment socketAttachment2) throws IOException {
        boolean bl = ProxyHelper.isEmpty(socketAttachment.getInBuffer());
        boolean bl2 = ProxyHelper.isFull(socketAttachment.getOutBuffer());
        socketAttachment.handle();
        if (bl && ProxyHelper.isFull(socketAttachment.getInBuffer())) {
            ProxyHelper.resizeInBuffer(socketAttachment, socketAttachment2);
        }
        if (bl2 && ProxyHelper.isEmpty(socketAttachment.getOutBuffer())) {
            ProxyHelper.resizeOutBuffer(socketAttachment, socketAttachment2);
        }
        if (socketAttachment2 != null) {
            socketAttachment2.readAlert();
            socketAttachment2.writeAlert();
        }
    }
}

