/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.app;

import com.avocent.lib.debug.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProxyPacket {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_BAD_HEADER = 1;
    public static final int ERROR_BODY_TOO_LONG = 2;
    public static final int ERROR_FIELD_TOO_LONG = 3;
    public static final int ERROR_FIELD_NOT_TERMINATED = 4;
    public static final int ERROR_BAD_TRAILER = 5;
    public static final int ERROR_EOS = 6;
    private static final int STATE_HEADER = 0;
    private static final int STATE_BODY = 1;
    private static final int STATE_COMPLETE = 2;
    private int m_nError = 0;
    private int m_nCmd;
    private HashMap m_hmFields = new HashMap();
    private Map m_hmFieldAccessor = this.m_hmFields;
    private int m_nReadState = 2;
    private byte[] m_baReadBuffer;
    private int m_nReadBufferOff = 0;

    public ProxyPacket() {
        this.m_nReadState = 0;
        this.m_baReadBuffer = new byte[10];
        this.m_nReadBufferOff = 0;
        this.m_hmFieldAccessor = Collections.unmodifiableMap(this.m_hmFields);
    }

    public ProxyPacket(int n) {
        this.m_nCmd = n;
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.m_hmFields.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            byte[] byArray = (byte[])this.m_hmFields.get(k);
            String string2 = "";
            for (int i = 0; i < byArray.length; ++i) {
                String string3 = Integer.toHexString(byArray[i] & 0xFF);
                string2 = string3.length() == 1 ? string2 + "0" + string3 : string2 + string3;
            }
            string = k + ": " + string2 + ", ";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 2);
        }
        return "ProxyPacket [ Cmd: " + this.m_nCmd + " Error: " + this.m_nError + " Fields: < " + string + " > ]";
    }

    public boolean isValid() {
        return this.m_nError == 0;
    }

    public int getErrorCode() {
        return this.m_nError;
    }

    public int getCmd() {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException("Cannot retrieve Cmd ID from an incomplete packet!");
        }
        return this.m_nCmd;
    }

    public void addField(int n, byte[] byArray) {
        this.m_hmFieldAccessor.put(new Integer(n), byArray);
    }

    public void removeField(int n) {
        this.m_hmFieldAccessor.remove(new Integer(n));
    }

    public boolean containsField(int n) {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException("Cannot retrieve items from an incomplete packet!");
        }
        return this.m_hmFieldAccessor.containsKey(new Integer(n));
    }

    public byte[] getField(int n) {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException("Cannot retrieve items from an incomplete packet!");
        }
        return (byte[])this.m_hmFieldAccessor.get(new Integer(n));
    }

    public Iterator getFieldIds() {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException("Cannot retrieve items from an incomplete packet!");
        }
        return this.m_hmFieldAccessor.keySet().iterator();
    }

    public boolean isComplete() {
        return this.m_nReadState == 2;
    }

    public void read(SocketChannel socketChannel) throws IOException {
        if (this.isComplete()) {
            Trace.logError((String)"ProxyPacket:read", (String)"Cannot read into a completed packet!");
            throw new UnsupportedOperationException("Cannot read into a complete packet!");
        }
        while (this.m_nReadState != 2) {
            int n = this.m_baReadBuffer.length - this.m_nReadBufferOff;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            int n2 = socketChannel.read(byteBuffer);
            if (n2 <= 0) {
                if (n2 != -1) break;
                Trace.logError((String)"ProxyPacket:read", (String)"End of Stream detected");
                this.m_nError = 6;
                this.m_nReadState = 2;
                break;
            }
            byteBuffer.flip();
            n = byteBuffer.remaining();
            byteBuffer.get(this.m_baReadBuffer, this.m_nReadBufferOff, n);
            this.m_nReadBufferOff += n;
            if (this.m_nReadBufferOff != this.m_baReadBuffer.length) continue;
            switch (this.m_nReadState) {
                case 0: {
                    this.processHeader();
                    break;
                }
                case 1: {
                    this.processBody();
                }
            }
        }
    }

    private void processHeader() {
        int n;
        if (this.m_baReadBuffer[0] != 1) {
            this.m_nError = 1;
            this.m_nReadState = 2;
            return;
        }
        byte[] byArray = "AvPP".getBytes();
        for (n = 1; n < byArray.length; ++n) {
            if (byArray[n - 1] == this.m_baReadBuffer[n]) continue;
            this.m_nError = 1;
            this.m_nReadState = 2;
            return;
        }
        this.m_nCmd = this.m_baReadBuffer[5] & 0xFF;
        n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | this.m_baReadBuffer[6 + i] & 0xFF;
        }
        if (n > 65535) {
            this.m_nError = 2;
            this.m_nReadState = 2;
            return;
        }
        this.m_baReadBuffer = new byte[n + 1];
        this.m_nReadBufferOff = 0;
        this.m_nReadState = 1;
    }

    private void processBody() {
        int n;
        int n2 = this.m_baReadBuffer.length - 1;
        if (this.m_baReadBuffer[n2] != 13) {
            this.m_nError = 5;
            this.m_nReadState = 2;
            return;
        }
        for (int i = 0; i < n2; i += n) {
            int n3 = this.m_baReadBuffer[i++] & 0xFF;
            n = this.m_baReadBuffer[i++] & 0xFF;
            if (i + (n = n << 8 | this.m_baReadBuffer[i++] & 0xFF) + 1 > n2) {
                this.m_nError = 3;
                this.m_nReadState = 2;
                return;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.m_baReadBuffer, i, byArray, 0, n);
            this.m_hmFields.put(new Integer(n3), byArray);
            if (this.m_baReadBuffer[i++] == -1) continue;
            this.m_nError = 4;
            this.m_nReadState = 2;
            return;
        }
        this.m_nReadState = 2;
        this.m_baReadBuffer = null;
    }

    public byte[] toByteArray() {
        if (this.m_nReadState != 2) {
            throw new UnsupportedOperationException("Cannot convert an incomplete packet to a byte array!");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Object object = this.getFieldIds();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                byte[] byArray = this.getField(n);
                dataOutputStream.writeByte(n);
                dataOutputStream.writeShort(byArray.length);
                dataOutputStream.write(byArray);
                dataOutputStream.writeByte(255);
            }
            dataOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeBytes("AvPP");
            dataOutputStream.writeByte(this.m_nCmd);
            dataOutputStream.writeInt(((Object)object).length);
            dataOutputStream.write((byte[])object);
            dataOutputStream.writeByte(13);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

