/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.app;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.app.ProxyHelper;
import com.avocent.protocols.app.ProxyPacket;
import com.avocent.protocols.app.SocketAttachment;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ProxyServer
implements Runnable {
    public static final long SESSION_TIMEOUT = 3600000L;
    public static final long OPEN_TUNNEL_TIMEOUT = Long.parseLong(System.getProperty("APP_OPEN_TUNNEL_TIMEOUT", Long.toString(5000L)));
    public static final long SELECT_TIMEOUT = 10000L;
    public static final int INITIAL_BUFFER_SIZE = 2048;
    public static final int MAX_BUFFER_SIZE = 262144;
    private SecureRandom m_sr;
    private int m_nPort;
    private Thread m_thread;
    private HashMap m_hmSessions = new HashMap();
    private HashMap m_hmActiveConnections = new HashMap();
    private HashSet m_pendingTunnels = new HashSet();
    private Selector selector = null;
    private Object m_selectionLock = new Object();

    public ProxyServer(int n) {
        this.m_nPort = n;
        this.m_thread = new Thread((Runnable)this, "Avocent Proxy");
        this.m_thread.start();
    }

    public boolean isRunning() {
        return this.m_thread != null;
    }

    public void stop() {
        Thread thread = this.m_thread;
        this.m_thread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    public Iterator getActiveConnections() {
        return this.m_hmActiveConnections.values().iterator();
    }

    public Iterator getSessions() {
        return this.m_hmSessions.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block35: {
            Trace.logInfo((String)"ProxyServer:run", (String)"Proxy Service starting");
            var1_1 = null;
            Trace.logInfo((String)"ProxyServer:run", (String)"Binding Socket");
            this.selector = Selector.open();
            var1_1 = ServerSocketChannel.open();
            var1_1.configureBlocking(false);
            var1_1.register(this.selector, 16, null);
            var1_1.socket().bind(new InetSocketAddress(this.m_nPort));
            Trace.logInfo((String)"ProxyServer:run", (String)"Listening ");
            var2_2 = 1;
            while (this.m_thread == Thread.currentThread()) {
                var3_5 = this.m_selectionLock;
                ** synchronized (var3_5)
lbl18:
                // 1 sources

                var3_4 = System.currentTimeMillis();
                var5_6 = this.selector.select(10000L);
                var6_7 = System.currentTimeMillis();
                var8_9 = this.selector.selectedKeys().iterator();
                while (var8_9.hasNext()) {
                    var9_10 = var8_9.next();
                    var8_9.remove();
                    var10_11 = null;
                    try {
                        var11_12 = var9_10.channel();
                        var10_11 = var9_10.attachment();
                        if (var11_12 == var1_1) {
                            Trace.logInfo((String)"ProxyServer:run", (String)"Waiting for connection");
                            var12_14 = ((ServerSocketChannel)var11_12).accept();
                            if (var12_14 == null) continue;
                            Trace.logInfo((String)"ProxyServer:run", (String)"Client connected");
                            var12_14.socket().setTcpNoDelay(true);
                            var12_14.socket().setKeepAlive(true);
                            new ServerSocketAttachment((SocketChannel)var12_14);
                            continue;
                        }
                        if (var10_11 != null) {
                            ((ServerSocketAttachment)var10_11).handle();
                            continue;
                        }
                        try {
                            var9_10.cancel();
                        }
                        catch (Exception var12_15) {}
                    }
                    catch (Exception var11_13) {
                        if (var10_11 != null && var10_11 instanceof ServerSocketAttachment) {
                            ((ServerSocketAttachment)var10_11).close();
                            continue;
                        }
                        this.m_thread = null;
                        break;
                    }
                }
                if (var5_6 == 0 && var2_2 == 0 && var3_4 + 10L > var6_7) {
                    Trace.logInfo((String)"ProxyServer:run", (String)"Selector Failed! Must Create New Selector!");
                    var8_9 = Selector.open();
                    var9_10 = this.selector.keys().iterator();
                    while (var9_10.hasNext()) {
                        var10_11 = (SelectionKey)var9_10.next();
                        var11_12 = var10_11.attachment();
                        if (var11_12 instanceof SocketAttachment) {
                            ((SocketAttachment)var11_12).setSelector((Selector)var8_9);
                            continue;
                        }
                        var10_11.channel().register((Selector)var8_9, var10_11.interestOps(), var10_11.attachment());
                    }
                    this.selector.close();
                    this.selector = var8_9;
                    var5_6 = 1;
                }
                var2_2 = var5_6;
                var8_8 = System.currentTimeMillis();
                var10_11 = this.m_pendingTunnels.iterator();
                while (var10_11.hasNext()) {
                    var11_12 = (ServerSocketAttachment)var10_11.next();
                    if (!var11_12.checkForTimeOut(var8_8)) continue;
                    var10_11.remove();
                }
                var10_11 = this.m_hmSessions;
                synchronized (var10_11) {
                    var11_12 = this.m_hmSessions.values().iterator();
                    while (var11_12.hasNext()) {
                        var12_14 = (Session)var11_12.next();
                        if (!var12_14.isExpired()) continue;
                        var11_12.remove();
                    }
                }
            }
            var15_17 = null;
            Trace.logInfo((String)"ProxyServer:run", (String)"Proxy Service stopping");
            this.stop();
            try {
                var1_1.close();
            }
            catch (Exception var16_20) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception var16_20) {
                // empty catch block
            }
            var16_20 = this.m_hmActiveConnections.keySet().iterator();
            while (var16_20.hasNext()) {
                var17_23 = (ServerSocketAttachment)var16_20.next();
                var17_23.close();
            }
            {
                break block35;
                catch (IOException var2_3) {
                    Trace.logInfo((String)"ProxyServer:run", (String)"IOException Proxy Service stopping");
                    var15_18 = null;
                    Trace.logInfo((String)"ProxyServer:run", (String)"Proxy Service stopping");
                    this.stop();
                    try {
                        var1_1.close();
                    }
                    catch (Exception var16_21) {
                        // empty catch block
                    }
                    try {
                        this.selector.close();
                    }
                    catch (Exception var16_21) {
                        // empty catch block
                    }
                    var16_21 = this.m_hmActiveConnections.keySet().iterator();
                    while (var16_21.hasNext()) {
                        var17_24 = (ServerSocketAttachment)var16_21.next();
                        var17_24.close();
                    }
                }
            }
            catch (Throwable var14_26) {
                var15_19 = null;
                Trace.logInfo((String)"ProxyServer:run", (String)"Proxy Service stopping");
                this.stop();
                try {
                    var1_1.close();
                }
                catch (Exception var16_22) {
                    // empty catch block
                }
                try {
                    this.selector.close();
                }
                catch (Exception var16_22) {
                    // empty catch block
                }
                var16_22 = this.m_hmActiveConnections.keySet().iterator();
                while (var16_22.hasNext()) {
                    var17_25 = (ServerSocketAttachment)var16_22.next();
                    var17_25.close();
                }
                throw var14_26;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(String string, int n) {
        HashMap hashMap = this.m_hmSessions;
        synchronized (hashMap) {
            if (this.m_sr == null) {
                try {
                    this.m_sr = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    Trace.logError((String)"ProxyServer:createSession", (String)"NoSuchAlgorithmException", (Throwable)noSuchAlgorithmException);
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
            Long l = new Long(this.m_sr.nextLong());
            while (this.m_hmSessions.containsKey(l)) {
                l = new Long(this.m_sr.nextLong());
            }
            this.m_hmSessions.put(l, new Session(l, string, n));
            return l;
        }
    }

    private class ServerSocketAttachment
    extends SocketAttachment {
        private long m_lLastCmd = System.currentTimeMillis();
        private ServerSocketAttachment m_saDestination;
        private ProxyPacket m_pPacket;
        private boolean m_bConnected = true;

        public ServerSocketAttachment(SocketChannel socketChannel) throws IOException {
            super(socketChannel, ProxyServer.this.selector, ProxyServer.this.m_selectionLock, (ByteBuffer)ByteBuffer.allocateDirect(2048).flip(), (ByteBuffer)ByteBuffer.allocateDirect(2048).flip());
            ProxyServer.this.m_pendingTunnels.add(this);
            this.m_pPacket = new ProxyPacket();
            this.handle();
        }

        public ServerSocketAttachment(SocketChannel socketChannel, ServerSocketAttachment serverSocketAttachment) throws IOException {
            super(socketChannel, ProxyServer.this.selector, ProxyServer.this.m_selectionLock, serverSocketAttachment.getOutBuffer(), serverSocketAttachment.getInBuffer());
            this.m_bConnected = false;
            this.m_saDestination = serverSocketAttachment;
            serverSocketAttachment.m_saDestination = this;
        }

        public boolean checkForTimeOut(long l) {
            if (this.m_saDestination == null && l - OPEN_TUNNEL_TIMEOUT > this.m_lLastCmd) {
                Trace.logError((String)"ProxyServer$ServerSocketAttachment:checkForTimeOut", (String)("Connection timed out " + this.toString()));
                this.close();
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.m_saDestination == null) {
                return this.m_sc.socket().getRemoteSocketAddress() + "<->[Unconnected]";
            }
            return this.m_sc.socket().getRemoteSocketAddress() + "<->" + this.m_saDestination.m_sc.socket().getRemoteSocketAddress();
        }

        private void connect() {
            ProxyPacket proxyPacket = new ProxyPacket(129);
            try {
                if (!this.m_sc.finishConnect()) {
                    throw new IOException();
                }
                this.m_sk.interestOps(this.m_sk.interestOps() & 0xFFFFFFF7);
                proxyPacket.addField(1, new byte[]{0, 0});
                this.m_saDestination.write(proxyPacket.toByteArray());
                ProxyServer.this.m_hmActiveConnections.put(this, this.toString());
                this.m_bConnected = true;
            }
            catch (IOException iOException) {
                proxyPacket.addField(1, new byte[]{1, 0});
                try {
                    this.m_saDestination.write(proxyPacket.toByteArray());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_saDestination.m_pPacket = new ProxyPacket();
                this.m_saDestination.m_saDestination = null;
                this.close();
            }
        }

        public void close() {
            try {
                ProxyServer.this.m_hmActiveConnections.remove(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.close();
            ServerSocketAttachment serverSocketAttachment = this.m_saDestination;
            this.m_saDestination = null;
            if (serverSocketAttachment != null) {
                serverSocketAttachment.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() throws IOException {
            block17: {
                if (!this.m_bConnected && (this.m_sk.interestOps() | 8) != 0) {
                    this.connect();
                }
                try {
                    if (this.m_pPacket != null) {
                        this.handleWrites();
                        this.m_pPacket.read(this.m_sc);
                        if (!this.m_pPacket.isComplete()) break block17;
                        this.m_lLastCmd = System.currentTimeMillis();
                        if (this.m_pPacket.isValid()) {
                            if (this.m_pPacket.getCmd() == 1) {
                                byte[] byArray = this.m_pPacket.getField(1);
                                Long l = new Long(new BigInteger(byArray).longValue());
                                Session session = null;
                                Object object = ProxyServer.this.m_hmSessions;
                                synchronized (object) {
                                    session = (Session)ProxyServer.this.m_hmSessions.remove(l);
                                    if (session != null && session.isExpired()) {
                                        session = null;
                                    }
                                }
                                if (session == null) {
                                    object = new ProxyPacket(129);
                                    ((ProxyPacket)object).addField(1, new byte[]{1, 1});
                                    this.write(((ProxyPacket)object).toByteArray());
                                    this.m_pPacket = new ProxyPacket();
                                } else {
                                    ServerSocketAttachment serverSocketAttachment;
                                    ProxyServer.this.m_pendingTunnels.remove(this);
                                    this.m_pPacket = null;
                                    object = SocketChannel.open();
                                    ((SocketChannel)object).socket().setTcpNoDelay(true);
                                    ((SocketChannel)object).socket().setKeepAlive(true);
                                    this.m_saDestination = serverSocketAttachment = new ServerSocketAttachment((SocketChannel)object, this);
                                    serverSocketAttachment.m_sk.interestOps(serverSocketAttachment.m_sk.interestOps() | 8);
                                    try {
                                        ((SocketChannel)object).connect(new InetSocketAddress(session.m_szHost, session.m_nPort));
                                    }
                                    catch (Exception exception) {
                                        Trace.logError((String)"ProxyServer:handle", (String)"Tunnel PacketError", (Throwable)exception);
                                        serverSocketAttachment.close();
                                        ProxyPacket proxyPacket = new ProxyPacket(129);
                                        proxyPacket.addField(1, new byte[]{1, 0});
                                        this.write(proxyPacket.toByteArray());
                                        this.m_pPacket = new ProxyPacket();
                                        this.m_saDestination = null;
                                    }
                                }
                                break block17;
                            }
                            Trace.logError((String)"ProxyServer:handle", (String)"UknownCommand");
                            this.close();
                            break block17;
                        }
                        Trace.logError((String)"ProxyServer:handle", (String)"Bad Packet, close");
                        this.close();
                        break block17;
                    }
                    boolean bl = ProxyHelper.isEmpty(this.getInBuffer());
                    boolean bl2 = ProxyHelper.isFull(this.getOutBuffer());
                    super.handle();
                    if (bl && ProxyHelper.isFull(this.getInBuffer())) {
                        ProxyHelper.resizeInBuffer(this, this.m_saDestination);
                    }
                    if (bl2 && ProxyHelper.isEmpty(this.getOutBuffer())) {
                        ProxyHelper.resizeOutBuffer(this, this.m_saDestination);
                    }
                    if (this.m_saDestination != null) {
                        this.m_saDestination.writeAlert();
                        this.m_saDestination.readAlert();
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"ProxyServer:handle", (String)"Failure. Close Tunnel", (Throwable)exception);
                    this.close();
                }
            }
        }
    }

    public class Session {
        private String m_szHost;
        private int m_nPort;
        private long m_lId;
        private long m_lExpirationTime = System.currentTimeMillis() + 3600000L;

        private Session(long l, String string, int n) {
            this.m_lId = l;
            this.m_szHost = string;
            this.m_nPort = n;
        }

        public long getId() {
            return this.m_lId;
        }

        public int getPort() {
            return this.m_nPort;
        }

        public String getHost() {
            return this.m_szHost;
        }

        public boolean isExpired() {
            return this.m_lExpirationTime < System.currentTimeMillis();
        }
    }
}

