/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.app;

import com.avocent.lib.debug.Trace;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;

public class SocketAttachment {
    private static final int XFER_THRESHOLD = 1024;
    private LinkedList m_llBuffs = new LinkedList();
    private ByteBuffer m_bbIn;
    private ByteBuffer m_bbOut;
    private ByteBuffer m_bbCur;
    SocketChannel m_sc;
    SelectionKey m_sk;
    private Object m_selectionLock;

    public SocketAttachment(SocketChannel socketChannel, Selector selector, Object object, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        socketChannel.configureBlocking(false);
        this.m_sc = socketChannel;
        this.m_bbIn = byteBuffer;
        this.m_bbCur = this.m_bbOut = byteBuffer2;
        this.m_selectionLock = object;
        this.setSelector(selector);
    }

    void setSelector(Selector selector) throws IOException {
        Trace.logInfo((String)"SocketAttachment:setSelector", (String)("Selector Set: " + this.m_sc + " " + selector + " " + this.m_sk));
        if (this.m_sk != null) {
            try {
                this.m_sk.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_sk = this.m_sc.register(selector, 0, this);
        Trace.logInfo((String)"SocketAttachment:setSelector", (String)("Selector Registered: " + this.m_sc + " " + this.m_sk));
        this.readAlert();
        this.writeAlert();
    }

    public void close() {
        try {
            this.m_sk.attach(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_bbIn = null;
        this.m_bbOut = null;
        this.m_bbCur = null;
        try {
            this.m_sk.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) {
        Object object = this.m_llBuffs;
        synchronized (object) {
            this.m_llBuffs.addLast(ByteBuffer.wrap(byArray));
            if (this.m_llBuffs.size() == 1 && this.m_bbCur == this.m_bbOut) {
                this.m_bbCur = (ByteBuffer)this.m_llBuffs.removeFirst();
            }
        }
        object = this.m_selectionLock;
        synchronized (object) {
            this.m_sk.selector().wakeup();
            try {
                this.writeAlert();
            }
            catch (CancelledKeyException cancelledKeyException) {
                Trace.logError((String)"SocketAttachment:write", (String)"CancelledKeyException", (Throwable)cancelledKeyException);
            }
        }
    }

    final void writeAlert() {
        if (this.m_bbCur.hasRemaining()) {
            this.m_sk.interestOps(this.m_sk.interestOps() | 4);
        } else {
            this.m_sk.interestOps(this.m_sk.interestOps() & 0xFFFFFFFB);
        }
    }

    final void readAlert() {
        if (this.m_bbIn.limit() != this.m_bbIn.capacity() || this.m_bbIn.position() != 0) {
            this.m_sk.interestOps(this.m_sk.interestOps() | 1);
        } else {
            this.m_sk.interestOps(this.m_sk.interestOps() & 0xFFFFFFFE);
        }
    }

    ByteBuffer getInBuffer() {
        return this.m_bbIn;
    }

    ByteBuffer getOutBuffer() {
        return this.m_bbOut;
    }

    void setInBuffer(ByteBuffer byteBuffer) {
        this.m_bbIn = byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutBuffer(ByteBuffer byteBuffer) {
        LinkedList linkedList = this.m_llBuffs;
        synchronized (linkedList) {
            ByteBuffer byteBuffer2 = this.m_bbOut;
            this.m_bbOut = byteBuffer;
            if (byteBuffer2 == this.m_bbCur) {
                this.m_bbCur = this.m_bbOut;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWrites() throws IOException {
        int n = this.m_sk.readyOps();
        if ((n & 4) != 0) {
            int n2 = this.m_sc.write(this.m_bbCur);
            while (n2 > 1024) {
                n2 = this.m_sc.write(this.m_bbCur);
            }
            if (!this.m_bbCur.hasRemaining() && this.m_bbCur != this.m_bbOut) {
                LinkedList linkedList = this.m_llBuffs;
                synchronized (linkedList) {
                    this.m_bbCur = this.m_llBuffs.size() == 0 ? this.m_bbOut : (ByteBuffer)this.m_llBuffs.removeFirst();
                }
            }
            this.writeAlert();
        }
    }

    void handleReads() throws IOException {
        int n = this.m_sk.readyOps();
        if ((n & 1) != 0) {
            this.m_bbIn.compact();
            int n2 = this.m_sc.read(this.m_bbIn);
            if (n2 == -1) {
                Trace.logError((String)"SocketAttachment:handleReads", (String)"End Of Stream ");
                throw new IOException("End-of-stream");
            }
            while (n2 > 1024) {
                n2 = this.m_sc.read(this.m_bbIn);
            }
            this.m_bbIn.flip();
            this.readAlert();
        }
    }

    void handle() throws IOException {
        this.handleWrites();
        this.handleReads();
    }
}

