/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class AnonymousAsmpConnectionPool
extends GenericKeyedObjectPool {
    private static final String TRACE_CONTEXT = "AnonymousAsmpConnectionPool";
    private static final int MAX_ACTIVE = Integer.parseInt(System.getProperty("AnonymousAsmpConnectionPool.MAX_ACTIVE", Integer.toString(4)));
    private static final int MAX_IDLE = Integer.parseInt(System.getProperty("AnonymousAsmpConnectionPool.MAX_IDLE", Integer.toString(1)));
    private static final int MAX_TOTAL = Integer.parseInt(System.getProperty("AnonymousAsmpConnectionPool.MAX_TOTAL", Integer.toString(-1)));
    private static final long MAX_WAIT = Long.parseLong(System.getProperty("AnonymousAsmpConnectionPool.MAX_WAIT", Long.toString(100L)));
    private static final long EVICTION_CHECK_TIME = Long.parseLong(System.getProperty("AnonymousAsmpConnectionPool.EVICTION_CHECK_TIME", Long.toString(10000L)));
    private static final long EVICTABLE_IDLE_TIME = Long.parseLong(System.getProperty("AnonymousAsmpConnectionPool.EVICTABLE_IDLE_TIME", Long.toString(600000L)));
    private static final int TCP_CONNECTION_RETRY_COUNT = Integer.parseInt(System.getProperty("AnonymousAsmpConnectionPool.TCP_CONNECTION_RETRY_COUNT", Integer.toString(0)));
    private static final int TCP_CONNECTION_RETRY_DELAY = Integer.parseInt(System.getProperty("AnonymousAsmpConnectionPool.TCP_CONNECTION_RETRY_DELAY", Integer.toString(500)));
    private static AnonymousAsmpConnectionFactory m_asmpConnectionFactory = null;
    private static AnonymousAsmpConnectionPool m_aacpInstance = new AnonymousAsmpConnectionPool();

    private AnonymousAsmpConnectionPool() {
        m_asmpConnectionFactory = new AnonymousAsmpConnectionFactory();
        this.setFactory(m_asmpConnectionFactory);
        this.setMaxActive(MAX_ACTIVE);
        this.setMaxIdle(MAX_IDLE);
        this.setMaxTotal(MAX_TOTAL);
        this.setMaxWait(MAX_WAIT);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(true);
        this.setTestWhileIdle(true);
        this.setTimeBetweenEvictionRunsMillis(EVICTION_CHECK_TIME);
        this.setMinEvictableIdleTimeMillis(EVICTABLE_IDLE_TIME);
        this.setWhenExhaustedAction((byte)1);
    }

    public static AnonymousAsmpConnectionPool getInstance() {
        return m_aacpInstance;
    }

    public Object borrowObject(Object object) throws UnknownHostException, IOException, Exception {
        return super.borrowObject(object);
    }

    public static void addObserver(Observer observer) {
        m_asmpConnectionFactory.addObserver(observer);
    }

    public static void deleteObserver(Observer observer) {
        m_asmpConnectionFactory.deleteObserver(observer);
    }

    private static class AnonymousAsmpConnectionFactory
    extends Observable
    implements KeyedPoolableObjectFactory {
        private AnonymousAsmpConnectionFactory() {
        }

        public Object makeObject(Object object) throws UnknownHostException, IOException {
            ThreadAsmpSession threadAsmpSession = null;
            Trace.logInfo((String)AnonymousAsmpConnectionPool.TRACE_CONTEXT, (String)("Creating ASMP Connection for [" + (String)object + "]"));
            InetAddress inetAddress = InetAddress.getByName((String)object);
            threadAsmpSession = new ThreadAsmpSession(inetAddress, false, 30000, TCP_CONNECTION_RETRY_COUNT, TCP_CONNECTION_RETRY_DELAY);
            try {
                if (!threadAsmpSession.startSession()) {
                    throw new IOException("User cancelled connection request.");
                }
            }
            catch (IOException iOException) {
                AnonymousAsmpConnectionFactory.terminateAsmpSession(threadAsmpSession);
                throw iOException;
            }
            return threadAsmpSession;
        }

        public void destroyObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            Trace.logInfo((String)AnonymousAsmpConnectionPool.TRACE_CONTEXT, (String)("Destroying ASMP Connection [" + (String)object + "]"));
            AnonymousAsmpConnectionFactory.terminateAsmpSession(threadAsmpSession);
        }

        public boolean validateObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            if (threadAsmpSession == null || object == null) {
                Trace.logInfo((String)AnonymousAsmpConnectionPool.TRACE_CONTEXT, (String)"Null data passed to validate, drop from pool");
                return false;
            }
            if (threadAsmpSession.getSessionStatus() != 2) {
                Trace.logInfo((String)AnonymousAsmpConnectionPool.TRACE_CONTEXT, (String)("Anonymous ASMP Connection Invalid [" + threadAsmpSession.getTargetAddress().getHostAddress() + "]"));
                this.notifyObservers((Object)threadAsmpSession);
                return false;
            }
            return true;
        }

        public void activateObject(Object object, Object object2) {
        }

        public void passivateObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            threadAsmpSession.setUsername(null);
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void terminateAsmpSession(ThreadAsmpSession threadAsmpSession) {
            if (threadAsmpSession != null) {
                try {
                    threadAsmpSession.logout();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logInfo((String)AnonymousAsmpConnectionPool.TRACE_CONTEXT, (String)"Failed to logout of Anonymous ASMP Connection");
                }
                finally {
                    threadAsmpSession.stopThread();
                }
            }
        }
    }
}

