/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.asmp.AsmpKey;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class AsmpConnectionPool
extends GenericKeyedObjectPool {
    private static final String TRACE_CONTEXT = "AsmpConnectionPool";
    private static final int MAX_ACTIVE = Integer.parseInt(System.getProperty("AsmpConnectionPool.MAX_ACTIVE", Integer.toString(4)));
    private static final int MAX_IDLE = Integer.parseInt(System.getProperty("AsmpConnectionPool.MAX_IDLE", Integer.toString(1)));
    private static final int MAX_TOTAL = Integer.parseInt(System.getProperty("AsmpConnectionPool.MAX_TOTAL", Integer.toString(-1)));
    private static final long MAX_WAIT = Long.parseLong(System.getProperty("AsmpConnectionPool.MAX_WAIT", Long.toString(100L)));
    private static final long EVICTION_CHECK_TIME = Long.parseLong(System.getProperty("AsmpConnectionPool.EVICTION_CHECK_TIME", Long.toString(10000L)));
    private static final long EVICTABLE_IDLE_TIME = Long.parseLong(System.getProperty("AsmpConnectionPool.EVICTABLE_IDLE_TIME", Long.toString(600000L)));
    private static final int TCP_CONNECTION_RETRY_COUNT = Integer.parseInt(System.getProperty("AsmpConnectionPool.TCP_CONNECTION_RETRY_COUNT", Integer.toString(0)));
    private static final int TCP_CONNECTION_RETRY_DELAY = Integer.parseInt(System.getProperty("AsmpConnectionPool.TCP_CONNECTION_RETRY_DELAY", Integer.toString(500)));
    private static AsmpConnectionFactory m_asmpConnectionFactory = null;
    private static HashMap m_hmConnections = new HashMap();
    private static HashMap m_hmPendingConnectionsToDelete = new HashMap();
    private static AsmpConnectionPool m_asmpPoolInstance = new AsmpConnectionPool();

    private AsmpConnectionPool() {
        m_asmpConnectionFactory = new AsmpConnectionFactory();
        this.setFactory(m_asmpConnectionFactory);
        this.setMaxActive(MAX_ACTIVE);
        this.setMaxIdle(MAX_IDLE);
        this.setMaxTotal(MAX_TOTAL);
        this.setMaxWait(MAX_WAIT);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(true);
        this.setTestWhileIdle(true);
        this.setTimeBetweenEvictionRunsMillis(EVICTION_CHECK_TIME);
        this.setMinEvictableIdleTimeMillis(EVICTABLE_IDLE_TIME);
        this.setWhenExhaustedAction((byte)1);
    }

    public static AsmpConnectionPool getInstance() {
        return m_asmpPoolInstance;
    }

    public Object borrowObject(Object object) throws UnknownHostException, IOException, Exception {
        return super.borrowObject(object);
    }

    public static void addObserver(Observer observer) {
        m_asmpConnectionFactory.addObserver(observer);
    }

    public static void deleteObserver(Observer observer) {
        m_asmpConnectionFactory.deleteObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearByAddress(String string) {
        HashMap hashMap = m_hmConnections;
        synchronized (hashMap) {
            Iterator iterator = m_hmConnections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)entry.getKey());
                AsmpKey asmpKey = (AsmpKey)entry.getValue();
                if (!asmpKey.getAddress().equals(string)) continue;
                m_hmPendingConnectionsToDelete.put(threadAsmpSession, asmpKey);
            }
        }
    }

    private static class AsmpConnectionFactory
    extends Observable
    implements KeyedPoolableObjectFactory {
        private AsmpConnectionFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject(Object object) throws UnknownHostException, IOException {
            AsmpKey asmpKey;
            ThreadAsmpSession threadAsmpSession;
            block10: {
                threadAsmpSession = null;
                asmpKey = (AsmpKey)object;
                if (asmpKey == null) {
                    throw new IOException("No Key Passed");
                }
                Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)("Creating ASMP Connection for [" + asmpKey.getAddress() + "]"));
                InetAddress inetAddress = InetAddress.getByName(asmpKey.getAddress());
                threadAsmpSession = asmpKey.isCertificateBased() ? new ThreadAsmpSession(inetAddress, true, true, 5000, 5000, 30000, asmpKey.getPrivateKey(), asmpKey.getClientCertificate(), asmpKey.getTrustedCertificate(), TCP_CONNECTION_RETRY_COUNT, TCP_CONNECTION_RETRY_DELAY, false) : new ThreadAsmpSession(inetAddress, true, 30000, TCP_CONNECTION_RETRY_COUNT, TCP_CONNECTION_RETRY_DELAY);
                try {
                    if (!threadAsmpSession.startSession()) {
                        throw new IOException("User cancelled connection request.");
                    }
                    if (asmpKey.isCertificateBased()) break block10;
                    int n = 0;
                    try {
                        n = threadAsmpSession.login(asmpKey.getUsername(), asmpKey.getPassword());
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)"Unable to login.");
                        throw new IOException("Unable to login");
                    }
                    Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)("Login status=" + n));
                    if (n != 0) {
                        throw new IOException("Unable to authenticate [" + n + "]");
                    }
                }
                catch (IOException iOException) {
                    AsmpConnectionFactory.terminateAsmpSession(threadAsmpSession);
                    throw iOException;
                }
            }
            Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)"ASMP Connection Established Successfully");
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                m_hmConnections.put(threadAsmpSession, asmpKey);
            }
            return threadAsmpSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            AsmpKey asmpKey = (AsmpKey)object;
            Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)("Destroying ASMP Connection [" + asmpKey.getAddress() + "]"));
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                m_hmConnections.remove((Object)threadAsmpSession);
                m_hmPendingConnectionsToDelete.remove((Object)threadAsmpSession);
            }
            AsmpConnectionFactory.terminateAsmpSession(threadAsmpSession);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            if (threadAsmpSession == null || object == null) {
                Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)"Null data passed to validate, drop from pool");
                return false;
            }
            if (threadAsmpSession.getSessionStatus() != 2) {
                Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)("ASMP Connection Invalid [" + threadAsmpSession.getTargetAddress().getHostAddress() + "]"));
                this.notifyObservers((Object)threadAsmpSession);
                return false;
            }
            HashMap hashMap = m_hmConnections;
            synchronized (hashMap) {
                if (m_hmPendingConnectionsToDelete.get((Object)threadAsmpSession) != null) {
                    Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)("ASMP Connection marked for deletion [" + threadAsmpSession.getTargetAddress().getHostAddress() + "]"));
                    return false;
                }
            }
            return true;
        }

        public void activateObject(Object object, Object object2) {
        }

        public void passivateObject(Object object, Object object2) {
            ThreadAsmpSession threadAsmpSession = (ThreadAsmpSession)((Object)object2);
            threadAsmpSession.setUsername(null);
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void terminateAsmpSession(ThreadAsmpSession threadAsmpSession) {
            if (threadAsmpSession != null) {
                try {
                    threadAsmpSession.logout();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logInfo((String)AsmpConnectionPool.TRACE_CONTEXT, (String)"Failed to logout of ASMP Connection");
                }
                finally {
                    threadAsmpSession.stopThread();
                }
            }
        }
    }
}

