/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class AsmpKey {
    private static final String TRACE_CONTEXT = "AsmpKey";
    private String m_szServerAddress = null;
    private boolean m_bCertificateBased = false;
    private PrivateKey m_privateKey = null;
    private X509Certificate m_x509cClient = null;
    private X509Certificate m_x509cTrusted = null;
    private String m_szUsername = null;
    private String m_szPassword = null;

    public AsmpKey(String string, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        this.m_szServerAddress = string;
        this.m_privateKey = privateKey;
        this.m_x509cClient = x509Certificate;
        this.m_x509cTrusted = x509Certificate2;
        this.m_bCertificateBased = true;
    }

    public AsmpKey(String string, String string2, String string3) {
        this.m_szServerAddress = string;
        this.m_szUsername = string2;
        this.m_szPassword = string3;
        this.m_bCertificateBased = false;
    }

    public String getAddress() {
        return this.m_szServerAddress;
    }

    public boolean isCertificateBased() {
        return this.m_bCertificateBased;
    }

    public PrivateKey getPrivateKey() {
        return this.m_privateKey;
    }

    public X509Certificate getClientCertificate() {
        return this.m_x509cClient;
    }

    public X509Certificate getTrustedCertificate() {
        return this.m_x509cTrusted;
    }

    public String getUsername() {
        return this.m_szUsername;
    }

    public String getPassword() {
        return this.m_szPassword;
    }

    public int hashCode() {
        return this.m_szServerAddress.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AsmpKey)) {
            return false;
        }
        AsmpKey asmpKey = (AsmpKey)object;
        return this.checkEquals(this.m_szServerAddress, asmpKey.m_szServerAddress) && this.m_bCertificateBased == asmpKey.m_bCertificateBased && this.checkEquals(this.m_privateKey, asmpKey.m_privateKey) && this.checkEquals(this.m_x509cClient, asmpKey.m_x509cClient) && this.checkEquals(this.m_x509cTrusted, asmpKey.m_x509cTrusted) && this.checkEquals(this.m_szUsername, asmpKey.m_szUsername) && this.checkEquals(this.m_szPassword, asmpKey.m_szPassword);
    }

    private boolean checkEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

