/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.protocols.asmp.AsmpSnmpResponse;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;

public class AsmpSnmpHelper {
    private AsmpSnmpHelper() {
    }

    public static AsmpSnmpResponse get(VarBindList varBindList, ThreadAsmpSession threadAsmpSession) {
        return AsmpSnmpHelper.sendRequest(varBindList, threadAsmpSession, 160);
    }

    public static AsmpSnmpResponse get(VarBind varBind, ThreadAsmpSession threadAsmpSession) {
        VarBindList varBindList = new VarBindList();
        varBindList.addVarBind(varBind);
        AsmpSnmpResponse asmpSnmpResponse = AsmpSnmpHelper.get(varBindList, threadAsmpSession);
        return asmpSnmpResponse;
    }

    public static AsmpSnmpResponse getNext(VarBindList varBindList, ThreadAsmpSession threadAsmpSession) {
        return AsmpSnmpHelper.sendRequest(varBindList, threadAsmpSession, 161);
    }

    public static AsmpSnmpResponse getNext(VarBind varBind, ThreadAsmpSession threadAsmpSession) {
        VarBindList varBindList = new VarBindList();
        varBindList.addVarBind(varBind);
        AsmpSnmpResponse asmpSnmpResponse = AsmpSnmpHelper.getNext(varBindList, threadAsmpSession);
        return asmpSnmpResponse;
    }

    public static AsmpSnmpResponse set(VarBindList varBindList, ThreadAsmpSession threadAsmpSession) {
        return AsmpSnmpHelper.sendRequest(varBindList, threadAsmpSession, 163);
    }

    public static AsmpSnmpResponse set(VarBind varBind, ThreadAsmpSession threadAsmpSession) {
        VarBindList varBindList = new VarBindList();
        varBindList.addVarBind(varBind);
        AsmpSnmpResponse asmpSnmpResponse = AsmpSnmpHelper.sendRequest(varBindList, threadAsmpSession, 163);
        return asmpSnmpResponse;
    }

    private static AsmpSnmpResponse sendRequest(VarBindList varBindList, ThreadAsmpSession threadAsmpSession, int n) {
        AsmpSnmpResponse asmpSnmpResponse = null;
        SnmpRequest snmpRequest = null;
        try {
            snmpRequest = new SnmpRequest(varBindList, null, null, n, 0, 0);
            int n2 = threadAsmpSession.snmpRequest(snmpRequest);
            VarBindList varBindList2 = null;
            if (snmpRequest.isResponseAvailable()) {
                varBindList2 = snmpRequest.getVarBindList();
            }
            asmpSnmpResponse = new AsmpSnmpResponse(varBindList2, n2, snmpRequest.getErrorIndex());
            return asmpSnmpResponse;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"AsmpSnmpHelper.sendRequest", (String)"Failure occurred on the session", (Throwable)exceptionRequestFailed);
            asmpSnmpResponse = new AsmpSnmpResponse(null, 4096, snmpRequest.getErrorIndex());
            return asmpSnmpResponse;
        }
    }
}

