/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.asmp.AsmpRequest;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.AsnOctetString;
import java.io.DataInputStream;
import java.util.ResourceBundle;

public class ThreadAsmpRx
extends ThreadContinuous {
    public static final long MSGLOOP_SLEEP_TIME = 5L;
    private static final long MSGLOOP_MAX_ITERATIONS = 100L;
    private static final long QUEUE_WAIT_TIME = 1000L;
    private static final int STATE_WAITING_SOH = 0;
    private static final int STATE_WAITING_SIGNATURE = 1;
    private static final int STATE_WAITING_SEQUENCE = 2;
    private static final int STATE_WAITING_COMMAND_ID = 3;
    private static final int STATE_WAITING_RECORD_LENGTH = 4;
    private static final int STATE_WAITING_DATA = 5;
    private static final int STATE_WAITING_TERMINATOR = 6;
    private int m_nState = 0;
    private BlockingQueue m_queueRx = new BlockingQueue();
    private DataInputStream m_disAppliance = null;
    private boolean m_bConnected = false;
    private ThreadAsmpSession m_asmpsession = null;
    static ResourceBundle res = ResourceBundle.getBundle("com.avocent.protocols.asmp.Res");

    ThreadAsmpRx(ThreadAsmpSession threadAsmpSession, DataInputStream dataInputStream) {
        super(5L);
        Trace.logInfo((String)"ASMP:Rx", (String)"ASMP Rx Thread Started");
        this.setName("ASMP Rx Thread");
        this.m_disAppliance = dataInputStream;
        this.m_asmpsession = threadAsmpSession;
        this.m_bConnected = true;
    }

    AsmpRequest remove() throws ExceptionNoValue {
        try {
            return (AsmpRequest)this.m_queueRx.remove(1000L);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"ASMP:Rx", (String)exceptionInvalidArgument.getMessage(), (Throwable)exceptionInvalidArgument);
            throw new ExceptionNoValue();
        }
    }

    protected void performTask() {
        block6: {
            try {
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for SOH");
                byte by = this.m_disAppliance.readByte();
                if (by != 1) {
                    return;
                }
                Trace.logInfo((String)"ASMP:Rx", (String)"Received SOH");
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Signature");
                byte[] byArray = new byte[4];
                this.m_disAppliance.readFully(byArray, 0, 4);
                String string = new String(byArray);
                Trace.logInfo((String)"ASMP:Rx", (String)("Received Signature=" + string));
                if (!string.equalsIgnoreCase("ASMP")) {
                    Trace.logError((String)"ASMP:Rx", (String)"ASMP SIGNATURE INVALID");
                    return;
                }
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Sequence Number");
                int n = this.m_disAppliance.readUnsignedShort();
                Trace.logInfo((String)"ASMP:Rx", (String)("Sequence Number=" + n));
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Request ID");
                int n2 = this.m_disAppliance.readUnsignedByte();
                Trace.logInfo((String)"ASMP:Rx", (String)("Request ID=" + n2));
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Record Length");
                int n3 = this.m_disAppliance.readInt();
                Trace.logInfo((String)"ASMP:Rx", (String)("Record Length=" + n3));
                if (n3 > 8192) {
                    Trace.logError((String)"ASMP:Rx", (String)"ASMP LENGTH TOO BIG");
                    return;
                }
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Record Data");
                byte[] byArray2 = new byte[n3];
                this.m_disAppliance.readFully(byArray2, 0, n3);
                Trace.logInfo((String)"ASMP:Rx", (String)"Received Record Data");
                Trace.logInfo((String)"ASMP:Rx", (String)"Waiting for Terminator");
                byte by2 = this.m_disAppliance.readByte();
                if (by2 != 13) {
                    Trace.logError((String)"ASMP:Rx", (String)("INVALID TERMINATOR=" + by2));
                    return;
                }
                Trace.logInfo((String)"ASMP:Rx", (String)"Received Terminator");
                AsmpRequest asmpRequest = new AsmpRequest(byArray2, n2, n);
                AsnOctetString asnOctetString = new AsnOctetString(byArray2);
                Trace.logInfo((String)"ASMP:Rx", (String)("RecordData=" + asnOctetString.getStringValue()));
                this.m_queueRx.add((Object)asmpRequest);
            }
            catch (Exception exception) {
                Trace.logInfo((String)"ASMP:Rx", (String)("Connection lost. Reason=" + exception.getMessage()));
                this.m_asmpsession.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
                if (this.m_asmpsession.isSslConnection() && this.m_asmpsession.isBackwardCompatible() && !this.m_asmpsession.isSessionSetupComplete()) break block6;
                this.m_disAppliance = null;
                this.m_bConnected = false;
                this.stopThread();
            }
        }
    }

    protected void cleanup() {
        try {
            Trace.logInfo((String)"ASMP:Rx", (String)"ASMP Rx Thread Cleanup");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.m_bConnected;
    }
}

