/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Assert;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.lib.util.ObserverHint;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.asmp.AsmpFileData;
import com.avocent.protocols.asmp.AsmpFileInfo;
import com.avocent.protocols.asmp.AsmpRequest;
import com.avocent.protocols.asmp.ThreadAsmpRx;
import com.avocent.protocols.asmp.ThreadAsmpTx;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.GetResponse;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import com.avocent.protocols.socket.SSLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.net.ssl.SSLException;

public class ThreadAsmpSession
extends ThreadContinuous {
    private static final String TRACE_CONTEXT = "ThreadAsmpSession";
    public static final int DEFAULT_TCP_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_SESSION_SETUP_TIMEOUT = 5000;
    public static final int DEFAULT_SSL_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_TCP_CONNECTION_RETRIES = 0;
    public static final int DEFAULT_TCP_CONNECTION_RETRY_DELAY = 500;
    public static final String LOGIN_TIMEOUT = "LOGIN_TIMEOUT";
    public static final String LOGOUT_TIMEOUT = "LOGOUT_TIMEOUT";
    public static final String SNMP_TIMEOUT = "SNMP_TIMEOUT";
    public static final String VERSION_TIMEOUT = "VERSION_TIMEOUT";
    public static final String OPEN_WRITE_TIMEOUT = "OPEN_WRITE_TIMEOUT";
    public static final String WRITE_TIMEOUT = "WRITE_TIMEOUT";
    public static final String CLOSE_WRITE_TIMEOUT = "CLOSE_WRITE_TIMEOUT";
    public static final String OPEN_READ_TIMEOUT = "OPEN_READ_TIMEOUT";
    public static final String READ_TIMEOUT = "READ_TIMEOUT";
    public static final String CLOSE_READ_TIMEOUT = "CLOSE_READ_TIMEOUT";
    public static final String KEEP_ALIVE = "KEEP_ALIVE";
    InetAddress m_iaAppliance;
    private Socket m_socketApplianceTcp = null;
    private Socket m_socketAppliance = null;
    private int m_nTcpConnectionTimeout;
    private int m_nTcpConnectionRetries;
    private int m_nTcpConnectionRetryDelay;
    private int m_nSessionSetupTimeout;
    private String m_szAddress;
    private int m_nSslConnectionTimeout;
    private String m_szClientCertificateFile;
    private String m_szClientFilePassphrase;
    private String m_szCertAuthCertificateFile;
    private PrivateKey m_pkClientPrivateKey = null;
    private X509Certificate m_x509ClientCertificate = null;
    private X509Certificate m_x509ServerCertificate = null;
    private byte[] m_abyClientCertificate = null;
    private String m_szClientPassphrase = null;
    private ThreadAsmpTx m_threadTx;
    private ThreadAsmpRx m_threadRx;
    private ThreadKeepAlive m_threadKeepAlive;
    private static final int SHUTDOWN_WAIT_TIMEOUT = 8000;
    private BlockingQueue m_queueRequests = new BlockingQueue();
    private int m_nSequence = 0;
    private boolean m_bAnonymousConnection = false;
    private boolean m_bNotifiedConnectionLost = false;
    private boolean m_bLogoutInProgress = false;
    private boolean m_bSessionSetupComplete = false;
    private boolean m_bBackwardCompatible = false;
    private boolean m_bSslConnection = false;
    private AsmpSessionObservable m_observable = new AsmpSessionObservable();
    static ResourceBundle res = ResourceBundle.getBundle("com.avocent.protocols.asmp.Res");
    private boolean m_bSessionSetupCanceled = false;
    private boolean m_bVerifyServerIpAddress = false;
    private String m_szUsername = null;
    private String m_szAsmpVersion = null;
    private int m_nAsmpMajorVersion = -1;
    private int m_nAsmpMinorVersion = -1;
    public static final int SESSION_NOT_ESTABLISHED = 0;
    public static final int SESSION_CREATION_INPROGRESS = 1;
    public static final int SESSION_OPERATIONAL = 2;
    public static final int SESSION_FAILED = 3;
    public static final int SESSION_CANCELED = 4;
    public static final int SESSION_CONNECTION_LOST = 5;
    public static final int SESSION_CLOSED = 6;
    private int m_nSessionStatus = 0;
    private Properties m_properties = new Properties();
    private Map m_SessionMap = new HashMap();

    public ThreadAsmpSession(InetAddress inetAddress) {
        this(inetAddress, false, 30000);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, int n) {
        this(inetAddress, bl, true, 5000, 5000, n, (String)null, (String)null, (String)null, 0, 500, false);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, int n, int n2, int n3) {
        this(inetAddress, bl, true, 5000, 5000, n, (String)null, (String)null, (String)null, n2, n3, false);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3) {
        this(inetAddress, bl, bl2, n, n2, n3, (String)null, (String)null, (String)null, 0, 500, false);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3, String string, String string2, String string3) {
        this(inetAddress, bl, bl2, n, n2, n3, string, string2, string3, 0, 500, false);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3, String string, String string2, String string3, int n4, int n5) {
        this(inetAddress, bl, bl2, n, n2, n3, string, string2, string3, 0, 500, false);
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3, String string, String string2, String string3, int n4, int n5, boolean bl3) {
        super(5L);
        Trace.logInfo((String)"ASMP:Main", (String)("Arguments given: iaAppliance=" + inetAddress + ", bSslSocket=" + bl + ", bBackwardCompatible=" + bl2 + ", nTcpConnectionTimeout=" + n + ", nSessionSetupTimeout=" + n2 + ", nSslConnectionTimeout=" + n3 + ", szClientCertificateFile=" + string + ", szClientFilePassphrase=" + string2 + ", szCertAuthCertificateFile=" + string3 + ", nTcpConnectionRetries=" + n4 + ", nTcpConnectionRetryDelay=" + n5 + " and bVerifyServerIpAddress=" + bl3));
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        if (string2 != null && string2.trim().length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.trim().length() == 0) {
            string3 = null;
        }
        this.m_iaAppliance = inetAddress;
        this.m_bSessionSetupComplete = false;
        this.m_bSslConnection = bl;
        this.m_bBackwardCompatible = bl2;
        this.m_nTcpConnectionTimeout = n;
        this.m_nTcpConnectionRetries = n4;
        this.m_nTcpConnectionRetryDelay = n5;
        this.m_nSessionSetupTimeout = n2;
        this.m_szAddress = inetAddress.getHostAddress();
        this.m_nSslConnectionTimeout = n3;
        this.m_szClientCertificateFile = string;
        this.m_szClientFilePassphrase = string2;
        this.m_szCertAuthCertificateFile = string3;
        this.m_bVerifyServerIpAddress = bl3;
        this.setName("ASMP Main Thread");
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2, int n4, int n5, boolean bl3) {
        super(5L);
        Trace.logInfo((String)"ASMP:Main", (String)("Arguments given: iaAppliance=" + inetAddress + ", bSslSocket=" + bl + ", bBackwardCompatible=" + bl2 + ", nTcpConnectionTimeout=" + n + ", nSessionSetupTimeout=" + n2 + ", nSslConnectionTimeout=" + n3 + ", pkClientPrivateKey=" + privateKey + ", x509ClientCertificate=" + x509Certificate + ", x509ServerCertificate=" + x509Certificate2 + ", nTcpConnectionRetries=" + n4 + ", nTcpConnectionRetryDelay=" + n5 + " and bVerifyServerIpAddress=" + bl3));
        this.m_iaAppliance = inetAddress;
        this.m_bSessionSetupComplete = false;
        this.m_bSslConnection = bl;
        this.m_bBackwardCompatible = bl2;
        this.m_nTcpConnectionTimeout = n;
        this.m_nTcpConnectionRetries = n4;
        this.m_nTcpConnectionRetryDelay = n5;
        this.m_nSessionSetupTimeout = n2;
        this.m_szAddress = inetAddress.getHostAddress();
        this.m_nSslConnectionTimeout = n3;
        this.m_pkClientPrivateKey = privateKey;
        this.m_x509ClientCertificate = x509Certificate;
        this.m_x509ServerCertificate = x509Certificate2;
        this.m_bVerifyServerIpAddress = bl3;
        this.setName("ASMP Main Thread");
    }

    public ThreadAsmpSession(InetAddress inetAddress, boolean bl, boolean bl2, int n, int n2, int n3, String string, byte[] byArray, X509Certificate x509Certificate, int n4, int n5, boolean bl3) {
        super(5L);
        Trace.logInfo((String)"ASMP:Main", (String)("Arguments given: iaAppliance=" + inetAddress + ", bSslSocket=" + bl + ", bBackwardCompatible=" + bl2 + ", nTcpConnectionTimeout=" + n + ", nSessionSetupTimeout=" + n2 + ", nSslConnectionTimeout=" + n3 + ", szClientPassphrase=" + string + ", abyClientCertificate=" + byArray + ", x509ServerCertificate=" + x509Certificate + ", nTcpConnectionRetries=" + n4 + ", nTcpConnectionRetryDelay=" + n5 + " and bVerifyServerIpAddress=" + bl3));
        this.m_iaAppliance = inetAddress;
        this.m_bSessionSetupComplete = false;
        this.m_bSslConnection = bl;
        this.m_bBackwardCompatible = bl2;
        this.m_nTcpConnectionTimeout = n;
        this.m_nTcpConnectionRetries = n4;
        this.m_nTcpConnectionRetryDelay = n5;
        this.m_nSessionSetupTimeout = n2;
        this.m_szAddress = inetAddress.getHostAddress();
        this.m_nSslConnectionTimeout = n3;
        this.m_szClientPassphrase = string;
        this.m_abyClientCertificate = byArray;
        this.m_x509ServerCertificate = x509Certificate;
        this.m_bVerifyServerIpAddress = bl3;
        this.setName("ASMP Main Thread");
    }

    public boolean startSession() throws IOException {
        int n;
        DataInputStream dataInputStream;
        InputStream inputStream;
        OutputStream outputStream;
        this.setSessionStatus(1);
        try {
            Trace.logInfo((String)"ASMP:Main", (String)("Opening TCP socket connection to appliance at Address=" + this.m_szAddress + " Port=" + 3211 + "connect timeout=" + this.m_nTcpConnectionTimeout));
            this.m_socketApplianceTcp = this.connect(new InetSocketAddress(this.m_iaAppliance, 3211), this.m_nTcpConnectionTimeout, this.m_nTcpConnectionRetries, this.m_nTcpConnectionRetryDelay);
            Trace.logInfo((String)"ASMP:Main", (String)"TCP Connection Established.");
            outputStream = this.m_socketApplianceTcp.getOutputStream();
            inputStream = this.m_socketApplianceTcp.getInputStream();
            dataInputStream = new DataInputStream(inputStream);
            Trace.logInfo((String)"ASMP:Main", (String)"Creating and starting ASMP-TCP Tx Thread");
            this.m_threadTx = new ThreadAsmpTx(outputStream);
            this.m_threadTx.start();
            Trace.logInfo((String)"ASMP:Main", (String)"Creating and starting ASMP-TCP Rx Thread");
            this.m_threadRx = new ThreadAsmpRx(this, dataInputStream);
            this.m_threadRx.start();
            this.m_threadRx.setSleepTime(200L);
            this.start();
            n = this.m_bSslConnection ? 1 : 2;
            int n2 = this.sendSessionSetup(this.m_socketApplianceTcp, n, this.m_nSessionSetupTimeout);
            this.m_bSessionSetupComplete = true;
            if (this.m_bSslConnection) {
                try {
                    Trace.logInfo((String)"ASMP:Main", (String)"Stopping ASMP Receive Thread");
                    this.m_threadRx.stopThreadAndWait(8000L);
                    Trace.logInfo((String)"ASMP:Main", (String)"Stopping ASMP Transmit Thread");
                    this.m_threadTx.stopThreadAndWait(8000L);
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    Trace.logError((String)"ASMP:Main", (String)"Exception attempting to stop Tx & Rx Threads.");
                }
            } else {
                this.m_threadRx.setSleepTime(5L);
            }
            if (n2 != 0) {
                Trace.logError((String)"ASMP:Main", (String)("Session Setup Request failed with error= " + n2));
                if (this.m_bSslConnection && this.m_bBackwardCompatible) {
                    Trace.logInfo((String)"ASMP:Main", (String)"Session Setup Request failed, but Backward Compatibility flag is set, so continuing on.");
                } else {
                    this.setSessionStatus(3);
                    throw new IOException();
                }
            }
            if (!this.m_bSslConnection) {
                this.determineApplianceAsmpVersion();
                int n3 = this.login("", "");
                if (n3 != 0) {
                    Trace.logInfo((String)"ASMP:Main", (String)("TCP Session Login Request failed with error= " + n3));
                    this.setSessionStatus(3);
                    throw new IOException();
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Trace.logError((String)"ASMP:Main", (String)"TCP Connection Establishment Timed-out... ", (Throwable)socketTimeoutException);
            this.setSessionStatus(3);
            throw new IOException();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"ASMP:Main", (String)"Session Setup failed...");
            this.setSessionStatus(3);
            throw new IOException();
        }
        catch (IOException iOException) {
            if (this.m_bSessionSetupCanceled) {
                this.setSessionStatus(4);
                return false;
            }
            this.setSessionStatus(3);
            throw new IOException();
        }
        if (this.m_bSessionSetupCanceled) {
            this.setSessionStatus(4);
            return false;
        }
        if (this.m_bSslConnection) {
            try {
                Trace.logInfo((String)"ASMP:Main", (String)"Opening SSL socket connection to appliance");
                this.m_socketAppliance = this.m_szClientPassphrase != null || this.m_abyClientCertificate != null ? SSLHelper.createSSLSocket(this.m_socketApplianceTcp, this.m_szAddress, 3211, this.m_nSslConnectionTimeout, this.m_szClientPassphrase, this.m_abyClientCertificate, this.m_x509ServerCertificate, this.m_bVerifyServerIpAddress) : (this.m_pkClientPrivateKey != null || this.m_x509ServerCertificate != null || this.m_x509ClientCertificate != null ? SSLHelper.createSSLSocket(this.m_socketApplianceTcp, this.m_szAddress, 3211, this.m_nSslConnectionTimeout, this.m_pkClientPrivateKey, this.m_x509ClientCertificate, this.m_x509ServerCertificate, this.m_bVerifyServerIpAddress) : SSLHelper.createSSLSocket(this.m_socketApplianceTcp, this.m_szAddress, 3211, this.m_nSslConnectionTimeout, this.m_szClientCertificateFile, this.m_szClientFilePassphrase, this.m_szCertAuthCertificateFile, this.m_bVerifyServerIpAddress));
                outputStream = this.m_socketAppliance.getOutputStream();
                inputStream = this.m_socketAppliance.getInputStream();
                dataInputStream = new DataInputStream(inputStream);
                Trace.logInfo((String)"ASMP:Main", (String)"Creating and starting ASMP-SSL Tx Thread");
                this.m_threadTx = new ThreadAsmpTx(outputStream);
                this.m_threadTx.start();
                Trace.logInfo((String)"ASMP:Main", (String)"Creating and starting ASMP-SSL Rx Thread");
                this.m_threadRx = new ThreadAsmpRx(this, dataInputStream);
                this.m_threadRx.start();
                this.determineApplianceAsmpVersion();
                if ((this.m_szClientCertificateFile != null || this.m_x509ClientCertificate != null || this.m_abyClientCertificate != null) && (n = this.login("", "")) != 0) {
                    Trace.logInfo((String)"ASMP:Main", (String)("TCP Session Login Request failed with error= " + n));
                    this.setSessionStatus(3);
                    throw new IOException();
                }
            }
            catch (SSLException sSLException) {
                Trace.logError((String)"ASMP:Main", (String)"SSL socket connection failed", (Throwable)sSLException);
                this.setSessionStatus(3);
                throw new IOException();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"ASMP:Main", (String)"SSL socket connection failed", (Throwable)exceptionRequestFailed);
                this.setSessionStatus(3);
                throw new IOException();
            }
            Trace.logInfo((String)"ASMP:Main", (String)"Connected SSL to appliance");
        } else {
            this.m_socketAppliance = this.m_socketApplianceTcp;
        }
        Trace.logInfo((String)"ASMP:Main", (String)"Creating and starting ASMP Keep Alive Thread");
        this.m_threadKeepAlive = new ThreadKeepAlive();
        this.m_threadKeepAlive.setName("ASMP Keep Alive Thread");
        this.m_threadKeepAlive.start();
        this.setSessionStatus(2);
        return this.m_bSessionSetupComplete;
    }

    private void determineApplianceAsmpVersion() throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.versionRequest(stringBuffer);
        if (n == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"ASMP Version Returned");
            this.m_szAsmpVersion = stringBuffer.toString();
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("ASMP Version Failed, defaulting to 2.0 [" + n + "]"));
            this.m_szAsmpVersion = "2.0";
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ASMP Version=" + this.m_szAsmpVersion));
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_szAsmpVersion, ".");
        try {
            if (stringTokenizer.hasMoreElements()) {
                this.m_nAsmpMajorVersion = Integer.parseInt(stringTokenizer.nextToken());
                this.m_nAsmpMinorVersion = 0;
            } else {
                this.m_nAsmpMajorVersion = -1;
                this.m_nAsmpMinorVersion = -1;
            }
            if (stringTokenizer.hasMoreElements()) {
                this.m_nAsmpMinorVersion = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Unable to parse version", (Throwable)numberFormatException);
            this.m_nAsmpMajorVersion = -1;
            this.m_nAsmpMinorVersion = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSessionSetup() {
        ThreadAsmpSession threadAsmpSession = this;
        synchronized (threadAsmpSession) {
            this.m_bSessionSetupCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSetupBeenCanceled() {
        ThreadAsmpSession threadAsmpSession = this;
        synchronized (threadAsmpSession) {
            return this.m_bSessionSetupCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSessionStatus(int n) {
        ThreadAsmpSession threadAsmpSession = this;
        synchronized (threadAsmpSession) {
            int n2 = this.getSessionStatus();
            if (!(n != 3 && n != 4 && n != 5 && n != 6 || n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6)) {
                return;
            }
            this.m_nSessionStatus = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionStatus() {
        ThreadAsmpSession threadAsmpSession = this;
        synchronized (threadAsmpSession) {
            return this.m_nSessionStatus;
        }
    }

    protected Socket connect(SocketAddress socketAddress, int n, int n2, int n3) throws IOException {
        Socket socket = null;
        Trace.logInfo((String)"ASMP:connect", (String)"Establishing a socket connection");
        for (int i = 0; i <= n2 && !this.hasSetupBeenCanceled(); ++i) {
            socket = new Socket();
            Trace.logInfo((String)"ASMP:connect", (String)"Socket created.");
            try {
                socket.connect(socketAddress, n);
                Trace.logInfo((String)"ASMP:connect", (String)"Socket Created and Connection Established.");
                return socket;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                    Trace.logError((String)"ASMP:connect", (String)"Interrupt received", (Throwable)interruptedException);
                    throw new IOException();
                }
                Trace.logError((String)"ASMP:connect", (String)"Unable to establish connection, try again?", (Throwable)iOException);
                if (i > n2 || this.hasSetupBeenCanceled()) {
                    throw new IOException();
                }
                try {
                    Thread.sleep(n3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Trace.logError((String)"ASMP:connect", (String)"Interrupt received", (Throwable)interruptedException);
                    throw new IOException();
                }
            }
        }
        throw new IOException();
    }

    protected int sendSessionSetup(Socket socket, int n, int n2) throws ExceptionRequestFailed {
        try {
            int n3;
            Trace.logInfo((String)"ASMP:sendSessionSetup", (String)("ASMP Session Setup Connection Type=" + n));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(n);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 48, this.getNextSequence());
            Trace.logInfo((String)"ASMP:sendSessionSetup", (String)"ASMP SESSION SETUP request sent");
            int n4 = this.request(asmpRequest, n2);
            if (n4 != 0) {
                return n4;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logInfo((String)"ASMP:sendSessionSetup", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n5 = 4097;
            while ((n3 = dataInputStream.readUnsignedByte()) != 255) {
                int n6;
                if (n3 == 1) {
                    n6 = dataInputStream.readUnsignedShort();
                    n5 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n6 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n6];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:sendSessionSetup", (String)("ASMP SESSION SETUP request completed. Status=" + n5));
            return n5;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public void start() {
        if (!this.isAlive()) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performTask() {
        try {
            Assert.isNotEventDispatchThread();
            AsmpRequest asmpRequest = this.m_threadRx.remove();
            Trace.logInfo((String)"ASMP:main", (String)"Received Reply");
            if (asmpRequest.getCommandID() == 255) {
                this.notifyObserversBroadcast(asmpRequest);
                return;
            }
            BlockingQueue blockingQueue = this.m_queueRequests;
            synchronized (blockingQueue) {
                Trace.logInfo((String)"ASMP:main", (String)"Searching Queue for match");
                int n = this.m_queueRequests.size();
                Trace.logInfo((String)"ASMP:main", (String)("Outstanding Request are " + n));
                for (int i = 0; i < n; ++i) {
                    AsmpRequest asmpRequest2 = (AsmpRequest)this.m_queueRequests.elementAt(i);
                    Trace.logInfo((String)"ASMP:main", (String)("Does this Sequence (" + asmpRequest2.getSequence() + ")" + "Match Rx (" + asmpRequest.getSequence() + ")"));
                    if (asmpRequest2.getSequence() != asmpRequest.getSequence()) continue;
                    Trace.logInfo((String)"ASMP:main", (String)"Reply matches");
                    AsmpRequest asmpRequest3 = asmpRequest2;
                    synchronized (asmpRequest3) {
                        Trace.logInfo((String)"ASMP:main", (String)"Updating data");
                        asmpRequest2.setResponse(asmpRequest);
                        Trace.logInfo((String)"ASMP:main", (String)"Notify requestor");
                        asmpRequest2.notify();
                        return;
                    }
                }
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            // empty catch block
        }
    }

    protected void cleanup() {
        this.setSessionStatus(6);
        try {
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP Thread Cleanup");
            Trace.logInfo((String)"ASMP:Main", (String)"Stopping Keep Alive Thread");
            this.m_threadKeepAlive.stopThreadAndWait(8000L);
            Trace.logInfo((String)"ASMP:Main", (String)"Stopping ASMP Transmit Thread");
            this.m_threadTx.stopThreadAndWait(8000L);
            if (this.m_socketAppliance != null) {
                Trace.logInfo((String)"ASMP:Main", (String)"Closing ASMP TCP connection");
                this.m_socketAppliance.close();
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP TCP connection closed");
            } else {
                Trace.logInfo((String)"ASMP:Main", (String)"No ASMP TCP connection to close");
            }
            this.m_socketAppliance = null;
            Trace.logInfo((String)"ASMP:Main", (String)"Stopping ASMP Receive Thread");
            this.m_threadRx.stopThreadAndWait(8000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized int getNextSequence() {
        if (this.m_nSequence == 65535) {
            this.m_nSequence = 0;
        }
        return ++this.m_nSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int request(AsmpRequest asmpRequest, int n) throws ExceptionRequestFailed {
        int n2;
        block17: {
            int n3;
            block16: {
                Assert.isNotEventDispatchThread();
                if (asmpRequest == null) {
                    return 256;
                }
                if (n <= 0) {
                    return 256;
                }
                if (this.m_threadTx == null) {
                    throw new ExceptionRequestFailed();
                }
                try {
                    try {
                        AsmpRequest asmpRequest2 = asmpRequest;
                        synchronized (asmpRequest2) {
                            this.m_queueRequests.add((Object)asmpRequest);
                            Trace.logInfo((String)"ASMP:main", (String)("Adding Request to Outstanding Queue Size=" + this.m_queueRequests.size()));
                            this.m_threadTx.request(asmpRequest);
                            asmpRequest.wait(n);
                            if (asmpRequest.getState() == 2) {
                                n3 = 0;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                                Object var7_8 = null;
                                break block16;
                            }
                            n2 = 4096;
                        }
                        break block17;
                    }
                    catch (InterruptedException interruptedException) {
                        this.setSessionStatus(3);
                        throw new ExceptionRequestFailed();
                    }
                    catch (IOException iOException) {
                        this.setSessionStatus(3);
                        throw new ExceptionRequestFailed();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    Trace.logInfo((String)"Asmp:main", (String)"Finally");
                    BlockingQueue blockingQueue = this.m_queueRequests;
                    synchronized (blockingQueue) {
                        this.m_queueRequests.removeElement((Object)asmpRequest);
                        throw throwable;
                    }
                }
            }
            Trace.logInfo((String)"Asmp:main", (String)"Finally");
            BlockingQueue blockingQueue = this.m_queueRequests;
            synchronized (blockingQueue) {
                this.m_queueRequests.removeElement((Object)asmpRequest);
                return n3;
            }
        }
        Object var7_9 = null;
        Trace.logInfo((String)"Asmp:main", (String)"Finally");
        BlockingQueue blockingQueue = this.m_queueRequests;
        synchronized (blockingQueue) {
            this.m_queueRequests.removeElement((Object)asmpRequest);
            return n2;
        }
    }

    public int login(String string, String string2) throws ExceptionRequestFailed {
        Assert.isNotEventDispatchThread();
        Object var3_3 = null;
        try {
            int n;
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP login Username = " + string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray = string.getBytes("UTF-8");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            byte[] byArray2 = string2.getBytes("UTF-8");
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(byArray2.length);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeByte(255);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray3, 1, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP login request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(LOGIN_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray4 = asmpRequest.getData();
            if (byArray4 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray5 = new byte[n4];
                dataInputStream.readFully(byArray5);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP login request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public int logout() throws ExceptionRequestFailed {
        Assert.isNotEventDispatchThread();
        this.m_bLogoutInProgress = true;
        Object var1_1 = null;
        try {
            int n;
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP Logout");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 2, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP LOGOUT request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(LOGOUT_TIMEOUT, "5000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP LOGOUT request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public int snmpRequest(SnmpRequest snmpRequest) throws ExceptionRequestFailed {
        try {
            int n;
            Object object;
            int n2;
            Assert.isNotEventDispatchThread();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            VarBindList varBindList = snmpRequest.getVarBindList();
            if (Trace.isTraceEnabled()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("snmpRequest() Request RequestType[" + snmpRequest.getRequestType() + "] "));
                for (n2 = 0; n2 < varBindList.size(); ++n2) {
                    try {
                        object = varBindList.varbindAt(n2);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("varbind[" + n2 + "] [" + ((VarBind)object).getName() + "]=[" + ((VarBind)object).getStringValue() + "]"));
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("Unable to view varbind[" + n2 + "]"));
                    }
                }
            }
            for (n2 = 0; n2 < varBindList.size(); ++n2) {
                object = varBindList.varbindAt(n2);
                byte[] byArray = ThreadAsmpSession.encodeAsmpAidpVarBindField((VarBind)object);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeShort(byArray.length);
                dataOutputStream.write(byArray);
            }
            if (snmpRequest.getRequestType() == 163 && this.getMajorVersion() >= 3) {
                String string = snmpRequest.getUsername();
                if (string == null || string.length() <= 0) {
                    string = this.getUsername();
                }
                if (string == null) {
                    string = "";
                }
                object = string.getBytes();
                dataOutputStream.writeByte(2);
                dataOutputStream.writeShort(((Object)object).length);
                dataOutputStream.write((byte[])object);
            }
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (snmpRequest.getRequestType() == 160) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP SNMP GET Request");
                object = new AsmpRequest(byArray, 16, this.getNextSequence());
            } else if (snmpRequest.getRequestType() == 161) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP SNMP GETNEXT Request");
                object = new AsmpRequest(byArray, 17, this.getNextSequence());
            } else if (snmpRequest.getRequestType() == 163) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP SNMP SET Request");
                object = new AsmpRequest(byArray, 18, this.getNextSequence());
            } else {
                Trace.logError((String)"ASMP:Main", (String)"Invalid SNMP Request Type");
                snmpRequest.setErrorStatus(5);
                return 256;
            }
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP SNMP request sent");
            int n3 = this.request((AsmpRequest)object, this.getIntProperty(SNMP_TIMEOUT, "8000"));
            if (n3 != 0) {
                return n3;
            }
            byte[] byArray2 = ((AsmpRequest)object).getData();
            if (byArray2 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            boolean bl = false;
            int n4 = 0;
            int n5 = 4097;
            VarBindList varBindList2 = new VarBindList();
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                byte[] byArray3;
                int n6;
                if (n == 1) {
                    dataInputStream.readUnsignedShort();
                    n5 = dataInputStream.readUnsignedShort();
                    continue;
                }
                if (n == 2) {
                    dataInputStream.readUnsignedShort();
                    n4 = dataInputStream.readUnsignedShort();
                    continue;
                }
                if (n == 3) {
                    n6 = dataInputStream.readUnsignedShort();
                    byArray3 = new byte[n6];
                    dataInputStream.readFully(byArray3);
                    try {
                        VarBind varBind = ThreadAsmpSession.decodeAsmpAidpVarBindField(byArray3);
                        varBindList2.addVarBind(varBind);
                        continue;
                    }
                    catch (Exception exception) {
                        snmpRequest.setErrorStatus(5);
                        return 5;
                    }
                }
                n6 = dataInputStream.readUnsignedShort();
                byArray3 = new byte[n6];
                dataInputStream.readFully(byArray3);
            }
            if (Trace.isTraceEnabled()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("snmpRequest() Response ErrorStatus[" + n5 + "] " + "ErrorIndex[" + n4 + "]"));
                for (n = 0; n < varBindList2.size(); ++n) {
                    try {
                        VarBind varBind = varBindList2.varbindAt(n);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("varbind[" + n + "] [" + varBind.getName() + "]=[" + varBind.getStringValue() + "]"));
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("Unable to view varbind[" + n + "]"));
                    }
                }
            }
            GetResponse getResponse = new GetResponse(varBindList2, snmpRequest.getRequestId(), n5, n4);
            snmpRequest.setResponse(getResponse);
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP SNMP request completed. Status=" + n5));
            if (n5 != 0) {
                if (n5 < 256) {
                    snmpRequest.setErrorStatus(n5);
                } else {
                    snmpRequest.setErrorStatus(5);
                }
            }
            return n5;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
        catch (ExceptionInvalidIndex exceptionInvalidIndex) {
            Trace.logError((String)"ASMP:Main", (String)"Invalid SNMP Request Type", (Throwable)exceptionInvalidIndex);
            snmpRequest.setErrorStatus(5);
            return 4096;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"ASMP:Main", (String)"Invalid SNMP Request Type", (Throwable)exceptionNoValue);
            snmpRequest.setErrorStatus(5);
            return 4096;
        }
    }

    public int versionRequest(StringBuffer stringBuffer) throws ExceptionRequestFailed {
        if (stringBuffer == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Null version passed");
            throw new ExceptionRequestFailed();
        }
        try {
            int n;
            Assert.isNotEventDispatchThread();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray = "3.0".getBytes();
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(255);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"ASMP Version Request");
            AsmpRequest asmpRequest = new AsmpRequest(byArray2, 49, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP version request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(VERSION_TIMEOUT, "8000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray3 = asmpRequest.getData();
            if (byArray3 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            String string = null;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                byte[] byArray4;
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                if (n == 2) {
                    n4 = dataInputStream.readUnsignedShort();
                    byArray4 = new byte[n4];
                    dataInputStream.readFully(byArray4);
                    string = new String(byArray4);
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byArray4 = new byte[n4];
                dataInputStream.readFully(byArray4);
            }
            if (n3 == 0) {
                if (string == null) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"ASMP Reply message missing version info.");
                    n3 = 4097;
                } else {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("ASMP version returned [" + string + "]"));
                    stringBuffer.replace(0, stringBuffer.length(), string);
                }
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)("ASMP version request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public static VarBind decodeAsmpAidpVarBindField(byte[] byArray) throws ExceptionRequestFailed {
        try {
            int n;
            int n2;
            VarBind varBind = new VarBind();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = dataInputStream.readUnsignedByte();
            if (n3 != 6) {
                Trace.logError((String)"ASMP:Main", (String)"Exception decoding VarBind : OID Type is incorrect");
                throw new ExceptionRequestFailed();
            }
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = n4 / 4;
            int[] nArray = new int[n5];
            String string = "";
            for (n2 = 0; n2 < n5; ++n2) {
                n = dataInputStream.readInt();
                if (string.length() > 0) {
                    string = string + ".";
                }
                string = string + n;
            }
            varBind.setName(string);
            n2 = dataInputStream.readUnsignedByte();
            n = dataInputStream.readUnsignedShort();
            switch (n2) {
                default: {
                    varBind.setNullValue();
                    break;
                }
                case 2: {
                    int n6 = dataInputStream.readInt();
                    varBind.setIntegerValue(n6);
                    break;
                }
                case 65: {
                    long l = dataInputStream.readInt();
                    varBind.setUnsignedValue(l, 65);
                    break;
                }
                case 66: {
                    long l = dataInputStream.readInt();
                    varBind.setUnsignedValue(l, 66);
                    break;
                }
                case 67: {
                    long l = dataInputStream.readInt();
                    varBind.setUnsignedValue(l, 67);
                    break;
                }
                case 64: {
                    if (n != 4) {
                        Trace.logError((String)"ASMP:Main", (String)"Exception decoding VarBind : Invalid IP Address binding");
                        throw new ExceptionRequestFailed();
                    }
                    byte[] byArray2 = new byte[n];
                    dataInputStream.readFully(byArray2);
                    IpAddress ipAddress = new IpAddress(byArray2);
                    varBind.setIpAddressValue(ipAddress);
                    break;
                }
                case 4: {
                    byte[] byArray3 = new byte[n];
                    dataInputStream.readFully(byArray3);
                    varBind.setOctetStringValue(byArray3);
                    break;
                }
                case 6: {
                    int n7 = n / 4;
                    int[] nArray2 = new int[n7];
                    for (int i = 0; i < n7; ++i) {
                        nArray2[i] = dataInputStream.readInt();
                    }
                    varBind.setOidValue(nArray2);
                }
            }
            return varBind;
        }
        catch (Exception exception) {
            Trace.logError((String)"ASMP:Main", (String)("Exception decoding VarBind : " + exception), (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static byte[] encodeAsmpAidpVarBindField(VarBind varBind) throws ExceptionNoValue {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            AsnObjectIdentifier asnObjectIdentifier = varBind.getOidName();
            int[] nArray = asnObjectIdentifier.getOidValue();
            dataOutputStream.writeByte(6);
            dataOutputStream.writeShort(nArray.length * 4);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            switch (varBind.getSyntax()) {
                default: {
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(0);
                    break;
                }
                case 2: {
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(4);
                    dataOutputStream.writeInt(varBind.getIntegerValue());
                    break;
                }
                case 65: 
                case 66: 
                case 67: {
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(8);
                    dataOutputStream.writeInt((int)varBind.getUnsignedValue());
                    break;
                }
                case 64: {
                    IpAddress ipAddress = varBind.getIpAddressValue();
                    byte[] byArray = ipAddress.getBytes();
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(byArray.length);
                    dataOutputStream.write(byArray);
                    break;
                }
                case 4: {
                    byte[] byArray = varBind.getOctetStringValue();
                    if (byArray == null) {
                        dataOutputStream.writeByte((byte)varBind.getSyntax());
                        dataOutputStream.writeShort(0);
                        break;
                    }
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(byArray.length);
                    dataOutputStream.write(byArray);
                    break;
                }
                case 6: {
                    int[] nArray2 = varBind.getOidValue();
                    dataOutputStream.writeByte((byte)varBind.getSyntax());
                    dataOutputStream.writeShort(4 * nArray2.length);
                    for (int i = 0; i < nArray2.length; ++i) {
                        dataOutputStream.writeInt(nArray2[i]);
                    }
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"ASMP:Main", (String)("Exception encoding VarBind : " + exception));
            throw new ExceptionNoValue();
        }
    }

    public int openWrite(AsmpFileInfo asmpFileInfo) throws ExceptionRequestFailed {
        Object var2_2 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            String string = asmpFileInfo.getFilename();
            long l = asmpFileInfo.getFileSize();
            int n2 = asmpFileInfo.getFileType();
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Open Write Filename=" + string));
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Open Write Size=" + l));
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Open Write Type=" + n2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(string.length());
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeInt((int)l);
            dataOutputStream.writeByte(3);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(n2);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 32, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP OPEN WRITE request sent");
            int n3 = this.request(asmpRequest, this.getIntProperty(OPEN_WRITE_TIMEOUT, "30000"));
            if (n3 != 0) {
                return n3;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n4 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n5;
                if (n == 1) {
                    n5 = dataInputStream.readUnsignedShort();
                    n4 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n5 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n5];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP OPEN WRITE request completed. Status=" + n4));
            return n4;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public int write(AsmpFileData asmpFileData) throws ExceptionRequestFailed {
        Object var2_2 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Write Block=" + asmpFileData.getBlockNumber()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort((short)asmpFileData.getBlockNumber());
            byte[] byArray = asmpFileData.getData();
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(255);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray2, 33, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP WRITE FILE request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(WRITE_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray3 = asmpRequest.getData();
            if (byArray3 == null) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray4 = new byte[n4];
                dataInputStream.readFully(byArray4);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP WRITE FILE request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public int closeWrite() throws ExceptionRequestFailed {
        Object var1_1 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP Close Write");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 34, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP CLOSE FILE WRITE request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(CLOSE_WRITE_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logInfo((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP CLOSE FILE WRITE request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            Trace.logError((String)"ASMP:Main", (String)"IOException", (Throwable)iOException);
            throw new ExceptionRequestFailed();
        }
    }

    public int openRead(AsmpFileInfo asmpFileInfo) throws ExceptionRequestFailed {
        Object var2_2 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            String string = asmpFileInfo.getFilename();
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Open Read Filename=" + string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(string.length());
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 35, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP OPEN FILE READ request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(OPEN_READ_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                if (n == 2) {
                    dataInputStream.readUnsignedShort();
                    long l = dataInputStream.readInt();
                    asmpFileInfo.setFileSize(l);
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP OPEN FILE READ request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            Trace.logError((String)"ASMP:Main", (String)"IOException during openRead", (Throwable)iOException);
            throw new ExceptionRequestFailed();
        }
    }

    public int read(AsmpFileData asmpFileData) throws ExceptionRequestFailed {
        Object var2_2 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP Read Block Number=" + asmpFileData.getBlockNumber()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(asmpFileData.getBlockNumber());
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 36, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP READ FILE request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(READ_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                byte[] byArray3;
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                if (n == 2) {
                    dataInputStream.readUnsignedShort();
                    n4 = dataInputStream.readUnsignedShort();
                    asmpFileData.setBlockNumber(n4);
                    continue;
                }
                if (n == 3) {
                    n4 = dataInputStream.readUnsignedShort();
                    byArray3 = new byte[n4];
                    dataInputStream.readFully(byArray3);
                    asmpFileData.setData(byArray3);
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP READ FILE request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public int closeRead() throws ExceptionRequestFailed {
        Object var1_1 = null;
        try {
            int n;
            Assert.isNotEventDispatchThread();
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP Close Read");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(255);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            AsmpRequest asmpRequest = new AsmpRequest(byArray, 37, this.getNextSequence());
            Trace.logInfo((String)"ASMP:Main", (String)"ASMP CLOSE FILE READ request sent");
            int n2 = this.request(asmpRequest, this.getIntProperty(CLOSE_READ_TIMEOUT, "30000"));
            if (n2 != 0) {
                return n2;
            }
            byte[] byArray2 = asmpRequest.getData();
            if (byArray2 == null) {
                Trace.logError((String)"ASMP:Main", (String)"ASMP Reply message was empty.");
                return 4097;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = 4097;
            while ((n = dataInputStream.readUnsignedByte()) != 255) {
                int n4;
                if (n == 1) {
                    n4 = dataInputStream.readUnsignedShort();
                    n3 = dataInputStream.readUnsignedShort();
                    continue;
                }
                n4 = dataInputStream.readUnsignedShort();
                byte[] byArray3 = new byte[n4];
                dataInputStream.readFully(byArray3);
            }
            Trace.logInfo((String)"ASMP:Main", (String)("ASMP CLOSE FILE READ request completed. Status=" + n3));
            return n3;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed();
        }
    }

    public void addObserver(Observer observer) {
        Trace.logInfo((String)"ASMP:BCAST", (String)"addObserver");
        this.m_observable.addObserver(observer);
        Trace.logInfo((String)"ASMP:BCAST", (String)("New Observer added. Total Count = " + this.m_observable.countObservers()));
    }

    public void removeObserver(Observer observer) {
        Trace.logInfo((String)"ASMP:BCAST", (String)"removeObserver");
        this.m_observable.deleteObserver(observer);
        Trace.logInfo((String)"ASMP:BCAST", (String)("Observer removed. Total Count = " + this.m_observable.countObservers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversBroadcast(AsmpRequest asmpRequest) {
        AsmpSessionObservable asmpSessionObservable = this.m_observable;
        synchronized (asmpSessionObservable) {
            try {
                int n;
                Assert.isNotEventDispatchThread();
                Trace.logInfo((String)"ASMP:BCAST", (String)"notifyObserversBroadcast");
                byte[] byArray = asmpRequest.getData();
                if (byArray == null) {
                    Trace.logError((String)"ASMP:BCAST", (String)"ASMP broadcast message was empty.");
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                Trace.logInfo((String)"ASMP:BCAST", (String)"Parsing Broadcast Record Data");
                int n2 = 0;
                String string = "";
                int n3 = 0;
                while ((n = dataInputStream.readUnsignedByte()) != 255) {
                    byte[] byArray2;
                    int n4;
                    if (n == 1) {
                        Trace.logInfo((String)"ASMP:BCAST", (String)"Field=TYPE");
                        n4 = dataInputStream.readUnsignedShort();
                        n2 = dataInputStream.readUnsignedShort();
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Length=" + n4));
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Type=" + n2));
                        continue;
                    }
                    if (n == 2) {
                        Trace.logInfo((String)"ASMP:BCAST", (String)"Field=MESSAGE");
                        n4 = dataInputStream.readUnsignedShort();
                        byArray2 = new byte[n4];
                        dataInputStream.readFully(byArray2);
                        string = new String(byArray2, "UTF-8");
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Length=" + n4));
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Message=" + string));
                        continue;
                    }
                    if (n == 3) {
                        Trace.logInfo((String)"ASMP:BCAST", (String)"Field=MSGCODE");
                        n4 = dataInputStream.readUnsignedShort();
                        n3 = dataInputStream.readUnsignedShort();
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Length=" + n4));
                        Trace.logInfo((String)"ASMP:BCAST", (String)("Code=" + n3));
                        continue;
                    }
                    Trace.logInfo((String)"ASMP:BCAST", (String)("Unknown Field. ID=" + n));
                    n4 = dataInputStream.readUnsignedShort();
                    byArray2 = new byte[n4];
                    dataInputStream.readFully(byArray2);
                }
                if (n2 == 1 && n3 > 0) {
                    Trace.logInfo((String)"ASMP:BCAST", (String)"Valid Broadcast Message. Notify Observers Msg Code");
                    ObserverHint observerHint = new ObserverHint(1, (Object)new Integer(n3));
                    this.m_observable.notifyObservers(observerHint);
                    Trace.logInfo((String)"ASMP:BCAST", (String)(this.m_observable.countObservers() + " Observer(s) notified"));
                    this.m_bNotifiedConnectionLost = true;
                    return;
                }
                if (n2 == 1 && string.length() > 0) {
                    Trace.logInfo((String)"ASMP:BCAST", (String)"Valid Broadcast Message. Notify Observers Msg String");
                    ObserverHint observerHint = new ObserverHint(1, (Object)string);
                    this.m_observable.notifyObservers(observerHint);
                    Trace.logInfo((String)"ASMP:BCAST", (String)(this.m_observable.countObservers() + " Observer(s) notified"));
                    this.m_bNotifiedConnectionLost = true;
                    return;
                }
                Trace.logError((String)"ASMP:BCAST", (String)"Invalid BCast Message (No message)");
            }
            catch (Exception exception) {
                Trace.logError((String)"ASMP:BCAST", (String)"Improperly formatted Broadcast message", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObserverConnectionLost(String string) {
        AsmpSessionObservable asmpSessionObservable = this.m_observable;
        synchronized (asmpSessionObservable) {
            if (this.m_bSslConnection && this.m_bBackwardCompatible && !this.m_bSessionSetupComplete) {
                Trace.logInfo((String)"ASMP:DISC", (String)"Connection lost and backward compatibility mode is ON.  Notifying all outstanding requests, so they don't continue to wait...");
                try {
                    this.abortRequests();
                    Trace.logInfo((String)"ASMP:DISC", (String)"Opening new socket for SSL connection...");
                    this.m_socketApplianceTcp = new Socket();
                    this.m_socketApplianceTcp.connect(new InetSocketAddress(this.m_iaAppliance, 3211), this.m_nTcpConnectionTimeout);
                    Trace.logInfo((String)"ASMP:DISC", (String)"TCP Socket created again.");
                    this.m_threadRx.stopThread();
                    this.m_threadTx.stopThread();
                }
                catch (IOException iOException) {
                    Trace.logError((String)"ASMP:DISC", (String)"TCP Connection Establishment failed. ", (Throwable)iOException);
                    this.setSessionStatus(5);
                    this.stopThread();
                }
            } else {
                this.abortRequests();
                if (this.m_bLogoutInProgress) {
                    Trace.logInfo((String)"ASMP:DISC", (String)"Connection Lost. Logout in progress.");
                    this.setSessionStatus(6);
                    this.stopThread();
                } else {
                    Trace.logInfo((String)"ASMP:DISC", (String)"Connection Lost. Notify Observers");
                    if (this.m_bNotifiedConnectionLost) {
                        Trace.logInfo((String)"ASMP:DISC", (String)"Already Notified.");
                    } else {
                        this.m_bNotifiedConnectionLost = true;
                        ObserverHint observerHint = new ObserverHint(2, (Object)string);
                        this.m_observable.notifyObservers(observerHint);
                        Trace.logInfo((String)"ASMP:DISC", (String)(this.m_observable.countObservers() + " Observer(s) notified"));
                    }
                    this.setSessionStatus(5);
                    this.stopThread();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortRequests() {
        BlockingQueue blockingQueue = this.m_queueRequests;
        synchronized (blockingQueue) {
            int n = this.m_queueRequests.size();
            Trace.logInfo((String)"ASMP:abortRequests", (String)("Number of outstanding requests=" + n));
            for (int i = 0; i < n; ++i) {
                AsmpRequest asmpRequest;
                AsmpRequest asmpRequest2 = asmpRequest = (AsmpRequest)this.m_queueRequests.elementAt(i);
                synchronized (asmpRequest2) {
                    Trace.logInfo((String)"ASMP:abortRequests", (String)("Notify requestor for command ID=" + asmpRequest.getCommandID() + " (note: requestor may report TIMEOUT as a result)."));
                    asmpRequest.notify();
                    continue;
                }
            }
        }
    }

    public InetAddress getLocalIpAddress() {
        InetAddress inetAddress = null;
        if (this.m_socketAppliance != null) {
            inetAddress = this.m_socketAppliance.getLocalAddress();
            Trace.logInfo((String)"ASMP:Main", (String)("Local host/IP address is " + inetAddress.getHostName() + "/" + inetAddress.getHostAddress()));
        }
        return inetAddress;
    }

    public InetAddress getTargetAddress() {
        return this.m_iaAppliance;
    }

    public String getUsername() {
        return this.m_szUsername;
    }

    public void setUsername(String string) {
        this.m_szUsername = string;
    }

    public String getVersion() {
        return this.m_szAsmpVersion;
    }

    public int getMajorVersion() {
        return this.m_nAsmpMajorVersion;
    }

    public int getMinorVersion() {
        return this.m_nAsmpMinorVersion;
    }

    public boolean isSessionSetupComplete() {
        return this.m_bSessionSetupComplete;
    }

    public boolean isBackwardCompatible() {
        return this.m_bBackwardCompatible;
    }

    public boolean isSslConnection() {
        return this.m_bSslConnection;
    }

    public void setProperty(String string, String string2) {
        this.m_properties.setProperty(string, string2);
    }

    public int getIntProperty(String string, String string2) {
        Integer n = new Integer(this.m_properties.getProperty(string, string2).trim());
        return n;
    }

    public Map getSessionMap() {
        return this.m_SessionMap;
    }

    class ThreadKeepAlive
    extends ThreadContinuous {
        private static final int KEEP_ALIVE_INTERVAL = 60;
        private static final int KEEP_ALIVE_TIMEOUT = 120;

        ThreadKeepAlive() {
            super(60000L);
        }

        protected void performTask() {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(60);
                dataOutputStream.writeByte(2);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(120);
                dataOutputStream.writeByte(255);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                AsmpRequest asmpRequest = new AsmpRequest(byArray, 38, ThreadAsmpSession.this.getNextSequence());
                Trace.logInfo((String)"ASMP:KeepAlive", (String)"ASMP KeepAlive request sent");
                int n2 = ThreadAsmpSession.this.request(asmpRequest, ThreadAsmpSession.this.getIntProperty(ThreadAsmpSession.KEEP_ALIVE, "30000"));
                if (n2 != 0) {
                    Trace.logError((String)"ASMP:KeepAlive", (String)"Keep Alive Poll Failed");
                    ThreadAsmpSession.this.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
                    return;
                }
                byte[] byArray2 = asmpRequest.getData();
                if (byArray2 == null) {
                    Trace.logError((String)"ASMP:KeepAlive", (String)"Keep Alive Poll Failed. NULL Data");
                    ThreadAsmpSession.this.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n3 = 4097;
                while ((n = dataInputStream.readUnsignedByte()) != 255) {
                    int n4;
                    if (n == 1) {
                        n4 = dataInputStream.readUnsignedShort();
                        n3 = dataInputStream.readUnsignedShort();
                        continue;
                    }
                    n4 = dataInputStream.readUnsignedShort();
                    byte[] byArray3 = new byte[n4];
                    dataInputStream.readFully(byArray3);
                }
                Trace.logInfo((String)"ASMP:KeepAlive", (String)("ASMP Keep ALive completed. Status=" + n3));
                if (n3 == 0) {
                    Trace.logInfo((String)"ASMP:KeepAlive", (String)"Keep Alive successful");
                } else if (n3 == 256) {
                    Trace.logInfo((String)"ASMP:KeepAlive", (String)"NOTE: OLD APPLIANCE, DOES NOT SUPPORT KEEP ALIVE");
                } else {
                    Trace.logError((String)"ASMP:KeepAlive", (String)"Keep Alive Poll Failed");
                    ThreadAsmpSession.this.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
                }
            }
            catch (IOException iOException) {
                Trace.logError((String)"ASMP:KeepAlive", (String)"Keep Alive request failed. IOException");
                ThreadAsmpSession.this.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"ASMP:KeepAlive", (String)("Keep Alive request failed. " + exceptionRequestFailed.getMessage()));
                ThreadAsmpSession.this.notifyObserverConnectionLost(res.getString("IDS_Connection_Lost"));
            }
        }
    }

    class AsmpSessionObservable
    extends Observable {
        AsmpSessionObservable() {
        }

        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers();
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }
    }
}

