/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.asmp.AsmpRequest;
import com.avocent.protocols.snmp.AsnOctetString;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThreadAsmpTx
extends ThreadContinuous {
    private static final long MSGLOOP_SLEEP_TIME = 5L;
    private static final long QUEUE_WAIT_TIME = 1000L;
    private BlockingQueue m_queueTx = new BlockingQueue();
    private boolean m_bConnected = true;
    private OutputStream m_osAppliance = null;

    ThreadAsmpTx(OutputStream outputStream) {
        super(5L);
        Trace.logInfo((String)"ASMP:Tx", (String)"ASMP Tx Thread Started");
        this.setName("ASMP Tx Thread");
        this.m_osAppliance = outputStream;
    }

    void request(AsmpRequest asmpRequest) throws IOException {
        if (!this.m_bConnected) {
            throw new IOException();
        }
        this.m_queueTx.add((Object)asmpRequest);
    }

    protected void performTask() {
        try {
            try {
                AsmpRequest asmpRequest = (AsmpRequest)this.m_queueTx.remove(1000L);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeBytes("ASMP");
                dataOutputStream.writeShort(asmpRequest.getSequence());
                dataOutputStream.writeByte(asmpRequest.getCommandID());
                byte[] byArray = asmpRequest.getData();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                dataOutputStream.writeByte(13);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                AsnOctetString asnOctetString = new AsnOctetString(byArray);
                Trace.logInfo((String)"ASMP:Tx", (String)("RecordData=" + asnOctetString.getStringValue()));
                this.m_osAppliance.write(byArray2);
                this.m_osAppliance.flush();
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Trace.logError((String)"ASMP:Tx", (String)exceptionInvalidArgument.getMessage());
            }
            catch (ExceptionNoValue exceptionNoValue) {}
        }
        catch (IOException iOException) {
            Trace.logError((String)"ASMP:Tx", (String)("Caught IOException" + iOException.getMessage()));
            this.m_osAppliance = null;
            this.m_bConnected = false;
        }
    }

    protected void cleanup() {
        try {
            Trace.logInfo((String)"ASMP:Tx", (String)"ASMP Tx Thread Cleanup");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

