/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asxr;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.net.IpAddress;
import com.avocent.protocols.asxr.AsxrConstants;
import com.avocent.protocols.asxr.AsxrCredentialFactory;
import com.avocent.protocols.asxr.AsxrCredentials;
import com.avocent.protocols.asxr.AsxrId;
import com.avocent.protocols.asxr.AsxrSender;
import com.avocent.protocols.socket.SSLHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.rpc.Stub;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.BasicClientConfig;

public class AsxrHelper
implements AsxrConstants {
    private static AsxrCredentialFactory m_credFactory;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$xml$rpc$Service;

    private AsxrHelper() {
    }

    public static Stub locateService(Object object, String string, Class clazz) throws RemoteException {
        try {
            AsxrCredentials asxrCredentials = m_credFactory.getCredentials(object);
            URL uRL = new URL("https", asxrCredentials.getHost(), 3502, "/asxr/" + string);
            BasicClientConfig basicClientConfig = new BasicClientConfig();
            basicClientConfig.deployTransport("http", (Handler)new SimpleTargetedChain((Handler)new AsxrSender(asxrCredentials)));
            Service service = new Service((EngineConfiguration)basicClientConfig);
            Constructor constructor = clazz.getConstructor(class$java$net$URL == null ? (class$java$net$URL = AsxrHelper.class$("java.net.URL")) : class$java$net$URL, class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = AsxrHelper.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service);
            return (Stub)constructor.newInstance(uRL, service);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.logError((String)"AsxrHelper.locateService", (String)"Could Not Build Service URL", (Throwable)malformedURLException);
            throw new IllegalArgumentException("Invalid host or service name");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Trace.logError((String)"AsxrHelper.locateService", (String)"Could Not Find Required Stub Constructor", (Throwable)noSuchMethodException);
            throw new IllegalArgumentException("Could Not Find Required Axis Stub Constructor");
        }
        catch (InstantiationException instantiationException) {
            Trace.logError((String)"AsxrHelper.locateService", (String)"Could Not Execute Required Stub Constructor", (Throwable)instantiationException);
            throw new IllegalArgumentException("Could Not Execute Required Axis Stub Constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.logError((String)"AsxrHelper.locateService", (String)"Axis Cosntruct is not publically accessible", (Throwable)illegalAccessException);
            throw new IllegalArgumentException("Axis Constructor is not publically accessible!");
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.logError((String)"AsxrHelper.locateService", (String)"Axis Stub threw an exception", (Throwable)invocationTargetException);
            throw new RemoteException("Error Instantiating Axis Stub", invocationTargetException.getTargetException());
        }
    }

    public static synchronized AsxrCredentialFactory getCredentialFactory() {
        return m_credFactory;
    }

    public static synchronized void setCredentialFactory(AsxrCredentialFactory asxrCredentialFactory) {
        m_credFactory = asxrCredentialFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsxrId getId(Object object) throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        AsxrCredentialFactory asxrCredentialFactory = AsxrHelper.getCredentialFactory();
        AsxrCredentials asxrCredentials = null;
        if (asxrCredentialFactory != null) {
            asxrCredentials = asxrCredentialFactory.getCredentials(object);
        }
        if (asxrCredentials == null) {
            asxrCredentials = m_credFactory.getDefaultCredentials(object.toString());
        }
        String string3 = asxrCredentials.getHost();
        SSLSocketFactory sSLSocketFactory = SSLHelper.getSSLSocketFactory(asxrCredentials.getClientKey(), asxrCredentials.getClientCertificateChain());
        Socket socket = null;
        try {
            try {
                socket = sSLSocketFactory.createSocket(InetAddress.getByAddress(string3, IpAddress.getBytes((String)string3)), 3502);
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                socket = sSLSocketFactory.createSocket(string3, 3502);
            }
            socket.setSoTimeout(AsxrConstants.ID_TIMEOUT);
            Certificate[] certificateArray = ((SSLSocket)socket).getSession().getPeerCertificates();
            bl = !Arrays.asList(asxrCredentials.getTrustedCertificates()).contains(certificateArray[0]);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("GET /asxr/ HTTP/1.0\r\n\r\n".getBytes("utf-8"));
            InputStream inputStream = socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            while (string4 != null && string4.length() > 0) {
                String[] stringArray = string4.split(":", 2);
                if (stringArray.length == 2) {
                    String string5 = stringArray[0].trim();
                    if (string5.equalsIgnoreCase("Avocent-Appliance-Name")) {
                        string2 = stringArray[1].trim();
                    } else if (string5.equalsIgnoreCase("Avocent-Appliance-Id")) {
                        string = stringArray[1].trim();
                    }
                }
                string4 = bufferedReader.readLine();
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        if (string2 == null || string == null) {
            return null;
        }
        return new AsxrId(string2, string, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

