/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asxr;

import com.avocent.protocols.asxr.AsxrConstants;
import com.avocent.protocols.asxr.AsxrCredentials;
import com.avocent.protocols.asxr.AsxrSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

class AsxrSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)(class$com$avocent$protocols$asxr$AsxrSender == null ? (class$com$avocent$protocols$asxr$AsxrSender = AsxrSender.class$("com.avocent.protocols.asxr.AsxrSender")) : class$com$avocent$protocols$asxr$AsxrSender).getName());
    private AsxrCredentials m_cred;
    static /* synthetic */ Class class$com$avocent$protocols$asxr$AsxrSender;

    AsxrSender(AsxrCredentials asxrCredentials) {
        this.m_cred = asxrCredentials;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"HTTPSender::invoke"));
        }
        BooleanHolder booleanHolder = new BooleanHolder(false);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            String string;
            Socket socket = null;
            try {
                URL uRL = new URL(messageContext.getStrProp("transport.url"));
                string = uRL.getHost();
                int n2 = uRL.getPort();
                socket = AsxrSocketFactory.createSocket(this.m_cred);
                if (messageContext.getTimeout() != 0) {
                    socket.setSoTimeout(messageContext.getTimeout());
                } else {
                    socket.setSoTimeout(AsxrConstants.REQUEST_TIMEOUT);
                }
                InputStream inputStream = this.writeToSocket(socket, messageContext, uRL, stringBuffer, string, n2, booleanHolder);
                Hashtable hashtable = new Hashtable();
                inputStream = this.readHeadersFromSocket(socket, messageContext, inputStream, hashtable);
                this.readFromSocket(socket, messageContext, inputStream, hashtable);
            }
            catch (Exception exception) {
                if (++n < 3 && (exception instanceof SocketException && socket != null || exception instanceof AxisFault && (string = (AxisFault)exception).getFaultCode().getLocalPart().equals("HTTP") && string.getFaultString().startsWith("(408)"))) continue;
                AsxrSocketFactory.precreateSocket(this.m_cred);
                log.debug((Object)exception);
                throw AxisFault.makeFault((Exception)exception);
            }
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"HTTPDispatchHandler::invoke"));
        }
        AsxrSocketFactory.precreateSocket(this.m_cred);
    }

    private InputStream writeToSocket(Socket socket, MessageContext messageContext, URL uRL, StringBuffer stringBuffer, String string, int n, BooleanHolder booleanHolder) throws IOException {
        Object object;
        Object object2;
        Map.Entry entry;
        Object object3;
        Hashtable hashtable;
        CharSequence charSequence;
        String string2;
        CharSequence charSequence2 = null;
        String string3 = null;
        String string4 = null;
        charSequence2 = messageContext.getUsername();
        string3 = messageContext.getPassword();
        String string5 = string2 = messageContext.useSOAPAction() ? messageContext.getSOAPActionURI() : "";
        if (string2 == null) {
            string2 = "";
        }
        if (charSequence2 == null && uRL.getUserInfo() != null) {
            charSequence = uRL.getUserInfo();
            int n2 = ((String)charSequence).indexOf(58);
            if (n2 >= 0 && n2 + 1 < ((String)charSequence).length()) {
                charSequence2 = ((String)charSequence).substring(0, n2);
                string3 = ((String)charSequence).substring(n2 + 1);
            } else {
                charSequence2 = charSequence;
            }
        }
        if (charSequence2 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append((String)charSequence2).append(":").append(string3 == null ? "" : string3);
            stringBuffer.append("Authorization").append(": Basic ").append(Base64.encode((byte[])((StringBuffer)charSequence).toString().getBytes())).append("\r\n");
        }
        if (messageContext.getMaintainSession()) {
            charSequence = messageContext.getStrProp("Cookie");
            String string6 = messageContext.getStrProp("Cookie2");
            if (charSequence != null) {
                stringBuffer.append("Cookie").append(": ").append((String)charSequence).append("\r\n");
            }
            if (string6 != null) {
                stringBuffer.append("Cookie2").append(": ").append(string6).append("\r\n");
            }
        }
        charSequence = new StringBuffer();
        String string7 = null;
        boolean bl = true;
        if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            string7 = messageContext.getStrProp("soap12.webmethod");
        }
        if (string7 == null) {
            string7 = "POST";
        } else {
            bl = string7.equals("POST");
        }
        ((StringBuffer)charSequence).append(string7).append(" ");
        if (booleanHolder.value) {
            ((StringBuffer)charSequence).append(uRL.toExternalForm());
        } else {
            ((StringBuffer)charSequence).append(uRL.getFile() == null || uRL.getFile().equals("") ? "/" : uRL.getFile());
        }
        Message message = messageContext.getRequestMessage();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string8 = null;
        String string9 = messageContext.getStrProp("axis.transport.version");
        if (null == string9) {
            string9 = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((string9 = string9.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            bl2 = false;
        }
        if ((hashtable = (Hashtable)messageContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == stringBuffer) {
                stringBuffer = new StringBuffer(1024);
            }
            object3 = hashtable.entrySet().iterator();
            while (object3.hasNext()) {
                entry = object3.next();
                object2 = entry.getKey();
                if (null == object2) continue;
                String string10 = object2.toString().trim();
                if (string10.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (bl2 || null == (object = entry.getValue().toString()) || !((String)object).trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    bl3 = true;
                    continue;
                }
                if (string10.equalsIgnoreCase("Host") || string10.equalsIgnoreCase("Content-Type") || string10.equalsIgnoreCase("SOAPAction") || string10.equalsIgnoreCase("Content-Length") || string10.equalsIgnoreCase("Cookie") || string10.equalsIgnoreCase("Cookie2") || string10.equalsIgnoreCase("Authorization") || string10.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (string10.equalsIgnoreCase("Connection")) {
                    if (bl2 || !((String)(object = entry.getValue().toString())).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    string8 = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!bl2 && string10.equalsIgnoreCase("Expect") && null != (object = entry.getValue().toString()) && ((String)object).trim().equalsIgnoreCase("100-continue")) {
                    bl4 = true;
                }
                stringBuffer.append(string10).append(": ").append(entry.getValue()).append("\r\n");
            }
        }
        if (!bl2) {
            string8 = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        ((StringBuffer)charSequence).append(" ");
        ((StringBuffer)charSequence).append(bl2 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        if (bl) {
            ((StringBuffer)charSequence).append("Content-Type").append(": ").append(message.getContentType(messageContext.getSOAPConstants())).append("\r\n");
        }
        ((StringBuffer)charSequence).append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append(Messages.getMessage((String)"axisUserAgent")).append("\r\n").append("Host").append(": ").append(string).append(n == -1 ? "" : ":" + n).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": \"").append(string2).append("\"\r\n");
        if (bl) {
            if (!bl3) {
                ((StringBuffer)charSequence).append("Content-Length").append(": ").append(message.getContentLength()).append("\r\n");
            } else {
                ((StringBuffer)charSequence).append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
            }
        }
        if (null != string8) {
            ((StringBuffer)charSequence).append("Connection");
            ((StringBuffer)charSequence).append(": ");
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append("\r\n");
        }
        if (null != stringBuffer) {
            ((StringBuffer)charSequence).append(stringBuffer.toString());
        }
        ((StringBuffer)charSequence).append("\r\n");
        object3 = socket.getOutputStream();
        if (!bl) {
            ((OutputStream)object3).write(((StringBuffer)charSequence).toString().getBytes("iso-8859-1"));
            ((OutputStream)object3).flush();
            return null;
        }
        entry = null;
        if (bl3) {
            ((OutputStream)object3).write(((StringBuffer)charSequence).toString().getBytes("iso-8859-1"));
        }
        if (bl4) {
            ((OutputStream)object3).flush();
            object2 = new Hashtable();
            entry = this.readHeadersFromSocket(socket, messageContext, null, (Hashtable)object2);
            int n3 = -1;
            object = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != object) {
                n3 = (Integer)object;
            }
            if (100 == n3) {
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                String string11 = (String)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault axisFault = new AxisFault("HTTP", "(" + n3 + ")" + string11, null, null);
                axisFault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + n3), (String)""));
                throw axisFault;
            }
        }
        if (bl3) {
            object2 = new ChunkedOutputStream((OutputStream)object3);
            object3 = new BufferedOutputStream((OutputStream)object2, 8192);
            try {
                message.writeTo((OutputStream)object3);
            }
            catch (SOAPException sOAPException) {
                log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)sOAPException);
            }
            ((OutputStream)object3).flush();
            object2.eos();
        } else {
            object3 = new BufferedOutputStream((OutputStream)object3, 8192);
            try {
                ((OutputStream)object3).write(((StringBuffer)charSequence).toString().getBytes("iso-8859-1"));
                message.writeTo((OutputStream)object3);
            }
            catch (SOAPException sOAPException) {
                log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)sOAPException);
            }
            ((OutputStream)object3).flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            log.debug((Object)(charSequence + string4));
        }
        return entry;
    }

    private InputStream readHeadersFromSocket(Socket socket, MessageContext messageContext, InputStream inputStream, Hashtable hashtable) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (null == inputStream) {
            inputStream = new BufferedInputStream(socket.getInputStream());
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
        while (true) {
            String string;
            String string2;
            if (!bl) {
                n = (byte)inputStream.read();
            }
            if (n == -1) break;
            bl = false;
            if (n != 13 && n != 10) {
                if (n == 58 && n3 == -1) {
                    n3 = n2;
                }
                ++n2;
                byteArrayOutputStream.write(n);
                continue;
            }
            if (n == 13) continue;
            if (n2 == 0) break;
            n = (byte)inputStream.read();
            bl = true;
            if (n == 32 || n == 9) continue;
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            if (n3 != -1) {
                string2 = new String(byArray, 0, n3, "iso-8859-1");
                string = new String(byArray, n3 + 1, n2 - 1 - n3, "iso-8859-1");
                n3 = -1;
            } else {
                string2 = new String(byArray, 0, n2, "iso-8859-1");
                string = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(string2 + string));
            }
            if (messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int n5 = string2.indexOf(32) + 1;
                String string3 = string2.substring(n5).trim();
                int n6 = string3.indexOf(32);
                if (n6 != -1) {
                    string3 = string3.substring(0, n6);
                }
                n4 = Integer.parseInt(string3);
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, (Object)new Integer(n4));
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, (Object)string2.substring(n5 + n6 + 1));
            } else {
                hashtable.put(string2.toLowerCase(), string);
            }
            n2 = 0;
        }
        return inputStream;
    }

    private InputStream readFromSocket(Socket socket, MessageContext messageContext, InputStream inputStream, Hashtable hashtable) throws IOException {
        String string;
        Message message = null;
        Integer n = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        String string2 = string = null == (string = (String)hashtable.get("Content-Type".toLowerCase())) ? null : string.trim();
        if (!(n2 > 199 && n2 < 300 || messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || string != null && !string.startsWith("text/html") && n2 > 499 && n2 < 600)) {
            byte by;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
            while (-1 != (by = (byte)inputStream.read())) {
                byteArrayOutputStream.write(by);
            }
            String string3 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            AxisFault axisFault = new AxisFault("HTTP", "(" + n2 + ")" + string3, null, null);
            axisFault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + n2), (String)byteArrayOutputStream.toString()));
            throw axisFault;
        }
        String string4 = (String)hashtable.get("Content-Location".toLowerCase());
        string4 = null == string4 ? null : string4.trim();
        String string5 = (String)hashtable.get("Content-Length".toLowerCase());
        string5 = null == string5 ? null : string5.trim();
        String string6 = (String)hashtable.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
        if (null != string6 && string6.trim().equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
            inputStream = new ChunkedInputStream(inputStream);
        }
        message = new Message((Object)new SocketInputStream(inputStream, socket), false, string, string4);
        message.setMessageType("response");
        messageContext.setResponseMessage(message);
        if (log.isDebugEnabled()) {
            if (null == string5) {
                log.debug((Object)("\n" + Messages.getMessage((String)"no00", (String)"Content-Length")));
            }
            log.debug((Object)("\n" + Messages.getMessage((String)"xmlRecd00")));
            log.debug((Object)"-----------------------------------------------");
            log.debug((Object)message.getSOAPEnvelope().toString());
        }
        if (messageContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", hashtable, messageContext);
            this.handleCookie("Cookie2", "Set-Cookie2", hashtable, messageContext);
        }
        return inputStream;
    }

    public void handleCookie(String string, String string2, Hashtable hashtable, MessageContext messageContext) {
        if (hashtable.containsKey(string2.toLowerCase())) {
            String string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            messageContext.setProperty(string, (Object)string3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

