/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.asxr;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.BlockingQueue;
import com.avocent.protocols.asxr.AsxrCredentials;
import com.avocent.protocols.socket.SSLHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLSocket;

class AsxrSocketFactory
implements Runnable {
    private static final int MAX_PRECONNECTIONS = Integer.getInteger("AsxrSocketFactory.MAX_PRECONNECTIONS", 10);
    private static final boolean DEBUG = Boolean.getBoolean("AsxrSocketFactory.DEBUG");
    private LinkedHashMap m_socketCache = new LinkedHashMap(){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > MAX_PRECONNECTIONS;
        }
    };
    private static AsxrSocketFactory m_instance = new AsxrSocketFactory();
    private BlockingQueue m_queue = new BlockingQueue();

    private AsxrSocketFactory() {
        Thread thread = new Thread((Runnable)this, "AsxrSocketFactory:Preconnection");
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    AsxrCredentials asxrCredentials;
                    if ((asxrCredentials = (AsxrCredentials)this.m_queue.remove()) == null) {
                        continue;
                    }
                    LinkedHashMap linkedHashMap = this.m_socketCache;
                    // MONITORENTER : linkedHashMap
                    Socket socket = (Socket)this.m_socketCache.remove(asxrCredentials);
                    if (socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected()) {
                        this.m_socketCache.put(asxrCredentials, socket);
                        // MONITOREXIT : linkedHashMap
                        continue;
                    }
                    // MONITOREXIT : linkedHashMap
                    if (DEBUG) {
                        socket = new Socket(asxrCredentials.getHost(), 80);
                    } else {
                        try {
                            socket = SSLHelper.getSSLSocketFactory(asxrCredentials.getClientKey(), asxrCredentials.getClientCertificateChain(), asxrCredentials.getTrustedCertificates()).createSocket(InetAddress.getByAddress(asxrCredentials.getHost(), IpAddress.getBytes((String)asxrCredentials.getHost())), 3502);
                        }
                        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                            socket = SSLHelper.getSSLSocketFactory(asxrCredentials.getClientKey(), asxrCredentials.getClientCertificateChain(), asxrCredentials.getTrustedCertificates()).createSocket(asxrCredentials.getHost(), 3502);
                        }
                        ((SSLSocket)socket).startHandshake();
                    }
                    linkedHashMap = this.m_socketCache;
                    // MONITORENTER : linkedHashMap
                    this.m_socketCache.put(asxrCredentials, socket);
                    // MONITOREXIT : linkedHashMap
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    static Socket createSocket(AsxrCredentials asxrCredentials) throws IOException {
        Socket socket = null;
        if (DEBUG) {
            socket = new Socket(asxrCredentials.getHost(), 80);
        } else {
            try {
                socket = SSLHelper.getSSLSocketFactory(asxrCredentials.getClientKey(), asxrCredentials.getClientCertificateChain(), asxrCredentials.getTrustedCertificates()).createSocket(InetAddress.getByAddress(asxrCredentials.getHost(), IpAddress.getBytes((String)asxrCredentials.getHost())), 3502);
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                socket = SSLHelper.getSSLSocketFactory(asxrCredentials.getClientKey(), asxrCredentials.getClientCertificateChain(), asxrCredentials.getTrustedCertificates()).createSocket(asxrCredentials.getHost(), 3502);
            }
        }
        return socket;
    }

    static void precreateSocket(AsxrCredentials asxrCredentials) {
    }
}

