/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.protocols.snmp.AsnMibConversionHelper;
import com.avocent.protocols.snmp.AsnNull;
import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ExceptionInvalidIndex;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import com.avocent.protocols.snmp.MibMap;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.SnmpOperationException;
import com.avocent.protocols.snmp.SnmpResponse;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMibAccess {
    protected abstract SnmpResponse get(VarBindList var1);

    protected abstract SnmpResponse getNext(VarBindList var1);

    protected abstract SnmpResponse set(VarBindList var1);

    public void set(String string, Object object) throws SnmpOperationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        this.set(hashMap);
    }

    public void set(Map map) throws SnmpOperationException {
        VarBindList varBindList = new VarBindList();
        try {
            this.fillVarBindListForSet(null, MibNode.getRoot(), map, varBindList);
        }
        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
            throw new SnmpOperationException("SET", exceptionUnknownMibName);
        }
        LinkedList<VarBindList> linkedList = new LinkedList<VarBindList>();
        linkedList.add(varBindList);
        while (linkedList.size() > 0) {
            varBindList = (VarBindList)linkedList.removeFirst();
            SnmpResponse snmpResponse = this.set(varBindList);
            if (!snmpResponse.hasError()) continue;
            if (snmpResponse.getErrorStatus() == 1 && varBindList.size() > 1) {
                try {
                    VarBindList varBindList2 = new VarBindList();
                    int n = varBindList.size() / 2;
                    while (varBindList.size() > n) {
                        varBindList2.addVarBind(varBindList.varbindAt(n));
                        varBindList.removeVarBindAt(n);
                        linkedList.addFirst(varBindList2);
                        linkedList.addFirst(varBindList);
                    }
                    continue;
                }
                catch (ExceptionInvalidIndex exceptionInvalidIndex) {
                    throw new SnmpOperationException("SET", snmpResponse, exceptionInvalidIndex);
                }
            }
            throw new SnmpOperationException("SET", snmpResponse);
        }
    }

    private void fillVarBindListForSet(AsnObjectIdentifier asnObjectIdentifier, MibNode mibNode, Map map, VarBindList varBindList) throws ExceptionUnknownMibName {
        boolean bl = mibNode != null;
        int[] nArray = asnObjectIdentifier == null ? new int[]{} : asnObjectIdentifier.getOidValue();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            NodeInfo nodeInfo = mibNode != null ? new NodeInfo(mibNode, string) : new NodeInfo(asnObjectIdentifier, string);
            Object v = entry.getValue();
            if (v instanceof Map) {
                this.fillVarBindListForSet(nodeInfo.getOid(), nodeInfo.getMibNode(), (Map)v, varBindList);
                continue;
            }
            AsnObject asnObject = AsnMibConversionHelper.convertFromJavaToAsn(v, nodeInfo.getMibNode());
            varBindList.addVarBind(new VarBind(nodeInfo.getOid(), asnObject));
        }
    }

    public Object get(String string) throws SnmpOperationException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        MibMap mibMap = this.get(hashSet);
        return mibMap.get(string);
    }

    public MibMap get(Set set) throws SnmpOperationException {
        Object object;
        Object object2;
        Object object3;
        MibNode mibNode = MibNode.getRoot();
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
        ArrayList<NodeInfo> arrayList2 = new ArrayList<NodeInfo>();
        try {
            object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = new NodeInfo(mibNode, (String)object2);
                if (((NodeInfo)object).isIndexed()) {
                    arrayList2.add((NodeInfo)object);
                    continue;
                }
                arrayList.add((NodeInfo)object);
            }
        }
        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
            throw new SnmpOperationException("GET", exceptionUnknownMibName);
        }
        object3 = new MibMap();
        this.doGet((Map)object3, arrayList, 0, arrayList.size());
        Collections.sort(arrayList2);
        object2 = this.buildVarBindListForGet(arrayList2, 0, arrayList2.size());
        try {
            object = ((VarBindList)object2).varbinds();
            while (object.hasMoreElements()) {
                VarBind varBind = (VarBind)object.nextElement();
                varBind.setName(varBind.getOidName().getStringValue() + ".0");
            }
        }
        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
            throw new SnmpOperationException("GETNEXT", exceptionUnknownMibName);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new SnmpOperationException("GETNEXT", exceptionInvalidArgument);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            throw new SnmpOperationException("GETNEXT", exceptionNoValue);
        }
        this.doGetNext((Map)object3, (VarBindList)object2, arrayList2, arrayList2.size());
        return object3;
    }

    private VarBindList buildVarBindListForGet(List list, int n, int n2) {
        VarBindList varBindList = new VarBindList();
        AsnNull asnNull = new AsnNull();
        for (int i = 0; i < n2; ++i) {
            NodeInfo nodeInfo = (NodeInfo)list.get(n + i);
            VarBind varBind = new VarBind(nodeInfo.getOid(), asnNull);
            varBindList.addVarBind(varBind);
        }
        return varBindList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGet(Map map, List list, int n, int n2) throws SnmpOperationException {
        if (n2 == 0) {
            return;
        }
        VarBindList varBindList = this.buildVarBindListForGet(list, n, n2);
        SnmpResponse snmpResponse = this.get(varBindList);
        if (snmpResponse.hasError()) {
            if (snmpResponse.getErrorStatus() != 1 || varBindList.size() <= 1) throw new SnmpOperationException("GET", snmpResponse);
            int n3 = n2 / 2;
            this.doGet(map, list, n, n3);
            this.doGet(map, list, n + n3, n2 - n3);
            return;
        } else {
            VarBindList varBindList2 = snmpResponse.getVarBindList();
            Enumeration enumeration = varBindList2.varbinds();
            while (enumeration.hasMoreElements()) {
                VarBind varBind = (VarBind)enumeration.nextElement();
                NodeInfo nodeInfo = (NodeInfo)list.get(n++);
                Object object = AsnMibConversionHelper.convertFromAsnToJava(varBind.getAsnObject(), nodeInfo.getMibNode());
                map.put(nodeInfo.getName(), object);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doGetNext(Map var1_1, VarBindList var2_2, List var3_3, int var4_4) throws SnmpOperationException {
        var5_5 = null;
lbl2:
        // 3 sources

        try {
            while (var4_4 > 0) {
                block7: {
                    block8: {
                        var5_5 = this.getNext(var2_2);
                        if (!var5_5.hasError()) break block7;
                        if (var5_5.getErrorStatus() == 1 && var2_2.size() > 1) {
                            var6_6 = var4_4 / 2;
                            this.doGetNext(var1_1, var2_2, var3_3, var6_6);
                            this.doGetNext(var1_1, var2_2, var3_3, var4_4 - var6_6);
                            return;
                        }
                        if (var5_5.getErrorStatus() != 2) break block8;
                        var6_7 = var5_5.getErrorIndex() - 1;
                        while (var6_7 < var4_4) {
                            var3_3.remove(var6_7);
                            var2_2.removeVarBindAt(var6_7);
                            --var4_4;
                        }
                        ** GOTO lbl2
                    }
                    throw new SnmpOperationException("GETNEXT", var5_5);
                }
                var4_4 = this.saveGetNext(var1_1, var5_5.getVarBindList(), var3_3, var4_4);
                var2_2 = new VarBindList();
                var6_8 = var5_5.getVarBindList();
                for (var7_11 = 0; var7_11 < var4_4; ++var7_11) {
                    var2_2.addVarBind(new VarBind(var6_8.varbindAt(var7_11).getOidName(), new AsnNull()));
                }
                ** GOTO lbl2
            }
        }
        catch (ExceptionInvalidIndex var6_9) {
            throw new SnmpOperationException("GETNEXT", var5_5, var6_9);
        }
        catch (ExceptionNoValue var6_10) {
            throw new SnmpOperationException("GETNEXT", var5_5, var6_10);
        }
    }

    private int saveGetNext(Map map, VarBindList varBindList, List list, int n) throws ExceptionInvalidIndex, ExceptionNoValue {
        if (n == 0) {
            return 0;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n2 = 0;
        Object object = varBindList.varbinds();
        while (object.hasMoreElements() && n2 < n) {
            NodeInfo nodeInfo;
            String string;
            VarBind varBind = (VarBind)object.nextElement();
            if ((string = (nodeInfo = (NodeInfo)list.get(n2++)).getIndex(varBind.getOidName())) == null) {
                linkedList.addFirst(new Integer(n2 - 1));
                continue;
            }
            String string2 = nodeInfo.getName().replaceAll("\\[\\]", "");
            if (string.charAt(0) != '[') {
                string2 = string2 + '.';
            }
            Object object2 = AsnMibConversionHelper.convertFromAsnToJava(varBind.getAsnObject(), this.getMibNode(nodeInfo.getMibNode(), string));
            map.put(string2 + string, object2);
        }
        while (linkedList.size() > 0) {
            object = (Integer)linkedList.removeFirst();
            varBindList.removeVarBindAt((Integer)object);
            list.remove((Integer)object);
            --n;
        }
        return n;
    }

    private MibNode getMibNode(MibNode mibNode, String string) {
        int n = string.indexOf(91);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string == null || string.length() == 0) {
            return mibNode;
        }
        return mibNode.findChild(string);
    }

    private static class NodeInfo
    implements Comparable {
        private String m_szName;
        private boolean m_bIndexed;
        private MibNode m_mibNode;
        private AsnObjectIdentifier m_oid;

        private NodeInfo(MibNode mibNode, String string) throws ExceptionUnknownMibName {
            this.init(mibNode, mibNode.getOid(), string);
        }

        private NodeInfo(AsnObjectIdentifier asnObjectIdentifier, String string) throws ExceptionUnknownMibName {
            this.init(null, asnObjectIdentifier, string);
        }

        public int compareTo(Object object) {
            int[] nArray = this.m_oid.getOidValue();
            int[] nArray2 = ((NodeInfo)object).getOid().getOidValue();
            for (int i = 0; i < nArray.length && i < nArray2.length; ++i) {
                int n = nArray[i] - nArray2[i];
                if (n == 0) continue;
                return n;
            }
            return nArray.length - nArray2.length;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        private void init(MibNode mibNode, AsnObjectIdentifier asnObjectIdentifier, String string) throws ExceptionUnknownMibName {
            this.m_szName = string;
            string = string.trim();
            this.m_bIndexed = string.endsWith("[]");
            String string2 = string;
            if (mibNode != null) {
                int n = string.indexOf(91);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                this.m_mibNode = mibNode.findDescendent(string);
            }
            if (this.m_szName.indexOf(91) == -1) {
                string2 = string2 + ".0";
            }
            String[] stringArray = string2.split("[\\[\\]\\.]+");
            int[] nArray = null;
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                MibNode mibNode2 = null;
                if (mibNode != null) {
                    mibNode2 = mibNode.findDescendent(stringArray[i]);
                }
                if (mibNode2 == null) {
                    if (nArray == null) {
                        int[] nArray2 = mibNode.getOid().getOidValue();
                        if (nArray2 == null) {
                            nArray2 = new int[]{};
                        }
                        nArray = new int[nArray2.length + stringArray.length - i];
                        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                        n = nArray2.length;
                    }
                    try {
                        nArray[n++] = Integer.parseInt(stringArray[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string3 = "";
                        if (mibNode != null) {
                            if (mibNode != MibNode.getRoot()) {
                                string3 = mibNode.getFullName() + ".";
                            }
                        } else if (asnObjectIdentifier != null) {
                            string3 = asnObjectIdentifier.getStringValue() + ".";
                        }
                        throw new ExceptionUnknownMibName(string3 + string);
                    }
                }
                mibNode = mibNode2;
            }
            if (mibNode != null) {
                this.m_oid = mibNode.getOid();
            } else {
                if (n != nArray.length) {
                    int[] nArray3 = new int[n];
                    System.arraycopy(nArray, 0, nArray3, 0, n);
                    nArray = nArray3;
                }
                this.m_oid = new AsnObjectIdentifier(nArray);
            }
        }

        private String getIndex(AsnObjectIdentifier asnObjectIdentifier) {
            int[] nArray = this.m_oid.getOidValue();
            int[] nArray2 = asnObjectIdentifier.getOidValue();
            if (nArray2.length < nArray.length) {
                return null;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return null;
            }
            if (nArray.length == nArray2.length) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            MibNode mibNode = this.getMibNode();
            boolean bl = false;
            if (mibNode == null) {
                bl = true;
                stringBuffer.append('[');
            }
            for (int i = nArray.length; i < nArray2.length; ++i) {
                int n = nArray2[i];
                MibNode mibNode2 = null;
                if (mibNode != null && (mibNode2 = mibNode.getChild(n)) == null) {
                    bl = true;
                    if (i != nArray.length) {
                        stringBuffer.setLength(stringBuffer.length() - 1);
                    }
                    stringBuffer.append('[');
                }
                if (mibNode2 != null) {
                    stringBuffer.append(mibNode2.getName());
                } else {
                    stringBuffer.append("" + n);
                }
                if (i < nArray2.length - 1) {
                    stringBuffer.append('.');
                }
                mibNode = mibNode2;
            }
            if (bl) {
                stringBuffer.append(']');
            }
            return stringBuffer.toString();
        }

        private AsnObjectIdentifier getOid() {
            return this.m_oid;
        }

        private boolean isIndexed() {
            return this.m_bIndexed;
        }

        private MibNode getMibNode() {
            return this.m_mibNode;
        }

        private String getName() {
            return this.m_szName;
        }
    }
}

