/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.ExceptionAsnBadValue;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class AsnInteger32
extends AsnObject {
    private long m_lIntegerValue = 0L;

    public AsnInteger32() {
        super(2);
        this.setIntegerValue(0);
    }

    public AsnInteger32(int n) {
        super(2);
        this.setIntegerValue(n);
    }

    public AsnInteger32(String string) throws ExceptionAsnBadValue {
        super(2);
        this.setStringValue(string);
    }

    public int getIntegerValue() {
        return (int)this.m_lIntegerValue;
    }

    public void setIntegerValue(int n) {
        this.m_lIntegerValue = n;
    }

    public String getStringValue() {
        return Long.toString(this.m_lIntegerValue);
    }

    public void setStringValue(String string) throws ExceptionAsnBadValue {
        try {
            int n = Integer.parseInt(string);
            this.setIntegerValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionAsnBadValue();
        }
    }

    public void encodeValue(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        BigInteger bigInteger = BigInteger.valueOf(this.m_lIntegerValue);
        byte[] byArray = bigInteger.toByteArray();
        try {
            dataOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int getSizeOfValueField() {
        BigInteger bigInteger = BigInteger.valueOf(this.m_lIntegerValue);
        byte[] byArray = bigInteger.toByteArray();
        return byArray.length;
    }

    public void decodeValue(DataInputStream dataInputStream, int n) throws ExceptionSnmpInvalidMessage {
        try {
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            BigInteger bigInteger = new BigInteger(byArray);
            this.setIntegerValue(bigInteger.intValue());
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }
}

