/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.net.IpAddress;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.ExceptionAsnBadValue;

public class AsnIpAddress
extends AsnOctetString {
    public AsnIpAddress() {
        super(64);
    }

    public AsnIpAddress(byte[] byArray) {
        super(64);
        this.setIpAddressValue(byArray);
    }

    public AsnIpAddress(String string) throws ExceptionAsnBadValue {
        super(64);
        this.setStringValue(string);
    }

    public void setIpAddressValue(byte[] byArray) {
        super.setOctetStringValue(byArray);
    }

    public byte[] getIpAddressValue() {
        byte[] byArray = super.getOctetStringValue();
        return byArray;
    }

    public String getStringValue() {
        byte[] byArray = super.getOctetStringValue();
        if (byArray == null) {
            return "";
        }
        if (byArray.length != 4) {
            return "";
        }
        String string = "";
        string = string + (byArray[0] & 0xFF);
        string = string + ".";
        string = string + (byArray[1] & 0xFF);
        string = string + ".";
        string = string + (byArray[2] & 0xFF);
        string = string + ".";
        string = string + (byArray[3] & 0xFF);
        return string;
    }

    public void setStringValue(String string) throws ExceptionAsnBadValue {
        try {
            byte[] byArray = IpAddress.getBytes((String)string);
            this.setIpAddressValue(byArray);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new ExceptionAsnBadValue();
        }
    }
}

