/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.net.IpAddress;
import com.avocent.protocols.snmp.AsnInteger32;
import com.avocent.protocols.snmp.AsnIpAddress;
import com.avocent.protocols.snmp.AsnNull;
import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.AsnUnsigned32;
import com.avocent.protocols.snmp.MibNode;
import com.avocent.protocols.snmp.TypeConversion;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;

public class AsnMibConversionHelper {
    private AsnMibConversionHelper() {
    }

    public static AsnObject convertFromJavaToAsn(Object object, MibNode mibNode) {
        Object object2;
        if (mibNode != null && object instanceof String && (object2 = mibNode.getSymbols()).containsKey(object)) {
            object = object2.get(object);
        }
        if (object == null) {
            return new AsnNull();
        }
        if (object instanceof AsnObject) {
            return (AsnObject)object;
        }
        if (mibNode == null) {
            return AsnMibConversionHelper.convertToUnknown(object);
        }
        object2 = null;
        int n = mibNode.getType();
        switch (n) {
            case 6: {
                object2 = AsnMibConversionHelper.convertToString(object, "us-ascii");
                break;
            }
            case 7: {
                object2 = AsnMibConversionHelper.convertToString(object, "utf-8");
                break;
            }
            case 3: {
                object2 = AsnMibConversionHelper.convertToByteArray(object);
                break;
            }
            case 8: {
                object2 = AsnMibConversionHelper.convertToIpAddress(object);
                break;
            }
            case 9: {
                object2 = AsnMibConversionHelper.convertToMacAddress(object);
                break;
            }
            case 1: {
                object2 = AsnMibConversionHelper.convertToInteger(object);
                break;
            }
        }
        if (object2 != null) {
            return object2;
        }
        return AsnMibConversionHelper.convertToUnknown(object);
    }

    public static Object convertFromAsnToJava(AsnObject asnObject, MibNode mibNode) {
        Object object = null;
        if (asnObject instanceof AsnNull) {
            return null;
        }
        if (asnObject instanceof AsnInteger32) {
            object = new Integer(((AsnInteger32)asnObject).getIntegerValue());
        } else if (asnObject instanceof AsnUnsigned32) {
            object = new Long(((AsnUnsigned32)asnObject).getUnsignedValue());
        } else if (asnObject instanceof AsnObjectIdentifier) {
            object = ((AsnObjectIdentifier)asnObject).getStringValue();
        } else if (asnObject instanceof AsnOctetString) {
            object = ((AsnOctetString)asnObject).getOctetStringValue();
        } else if (asnObject instanceof AsnIpAddress) {
            try {
                object = new IpAddress(((AsnIpAddress)asnObject).getIpAddressValue());
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {}
        } else {
            object = asnObject.toString();
        }
        Integer n = object;
        if (mibNode != null) {
            try {
                int n2 = mibNode.getType();
                switch (n2) {
                    case 6: {
                        if (object instanceof byte[]) {
                            object = new String((byte[])object, "us-ascii");
                            break;
                        }
                        object = TypeConversion.asString(object);
                        break;
                    }
                    case 7: {
                        object = TypeConversion.asString(object);
                        break;
                    }
                    case 3: {
                        object = TypeConversion.asByteArray(object);
                        break;
                    }
                    case 2: {
                        if (object instanceof Number) break;
                        object = new Double(object.toString());
                        break;
                    }
                    case 1: {
                        object = TypeConversion.asNumber(object);
                        break;
                    }
                    case 8: {
                        object = TypeConversion.asIpAddress(object);
                        break;
                    }
                    case 9: {
                        object = TypeConversion.asMacAddress(object);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (object == null) {
                object = n;
            }
            if (mibNode.getSymbols().size() > 0) {
                object = TypeConversion.asString(object);
                Iterator iterator = mibNode.getSymbols().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!object.equals(entry.getValue())) continue;
                    object = entry.getKey();
                    break;
                }
            }
        }
        return object;
    }

    private static AsnOctetString convertToString(Object object, String string) {
        if (object instanceof byte[]) {
            return new AsnOctetString((byte[])object);
        }
        try {
            return new AsnOctetString(TypeConversion.asString(object).getBytes(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.logError((String)"AsnMibConversionHelper:convertToString", (String)("Unsupported Encoding? " + string), (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    private static AsnOctetString convertToByteArray(Object object) {
        byte[] byArray = TypeConversion.asByteArray(object);
        if (byArray != null) {
            return new AsnOctetString(byArray);
        }
        return null;
    }

    private static AsnObject convertToInteger(Object object) {
        long l = TypeConversion.asLong(object);
        if (l < Integer.MAX_VALUE) {
            return new AsnInteger32((int)l);
        }
        return new AsnUnsigned32(65, l);
    }

    private static AsnIpAddress convertToIpAddress(Object object) {
        IpAddress ipAddress = TypeConversion.asIpAddress(object);
        if (ipAddress == null) {
            if (TypeConversion.asString(object, "").equals("")) {
                return new AsnIpAddress(new byte[]{0, 0, 0, 0});
            }
            throw new IllegalArgumentException(object + " could not be converted to an IpAddress");
        }
        return new AsnIpAddress(ipAddress.getBytes());
    }

    private static AsnOctetString convertToMacAddress(Object object) {
        byte[] byArray = TypeConversion.asByteArray(object);
        if (byArray != null) {
            return new AsnOctetString((byte[])object);
        }
        return null;
    }

    private static AsnObject convertToUnknown(Object object) {
        if (object instanceof byte[]) {
            return new AsnOctetString((byte[])object);
        }
        if (object instanceof char[]) {
            try {
                return new AsnOctetString(new String((char[])object).getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.logError((String)"AsnMibConversionHelper:convertToUnknown", (String)"UTF-8 Unsupported?", (Throwable)unsupportedEncodingException);
                return null;
            }
        }
        if (object instanceof IpAddress) {
            return new AsnIpAddress(((IpAddress)object).getBytes());
        }
        if (object instanceof InetAddress) {
            return new AsnIpAddress(((InetAddress)object).getAddress());
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l < Integer.MAX_VALUE) {
                return new AsnInteger32((int)l);
            }
            return new AsnUnsigned32(65, l);
        }
        return new AsnOctetString(TypeConversion.asString(object));
    }
}

