/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class AsnObject {
    protected int m_nSyntax = 0;
    public static final int ASN_INTEGER32 = 2;
    public static final int ASN_BITS = 3;
    public static final int ASN_OCTETSTRING = 4;
    public static final int ASN_NULL = 5;
    public static final int ASN_OBJECTIDENTIFIER = 6;
    public static final int ASN_SEQUENCE = 48;
    public static final int SNMP_PDU_GET = 160;
    public static final int SNMP_PDU_GETNEXT = 161;
    public static final int SNMP_PDU_RESPONSE = 162;
    public static final int SNMP_PDU_SET = 163;
    public static final int SNMP_PDU_V1TRAP = 164;
    public static final int ASN_IPADDRESS = 64;
    public static final int ASN_COUNTER32 = 65;
    public static final int ASN_GAUGE32 = 66;
    public static final int ASN_UNSIGNED32 = 66;
    public static final int ASN_TIMETICKS = 67;
    public static final int ASN_OPAQUE = 68;

    AsnObject(int n) {
        this.m_nSyntax = n;
    }

    public int getSyntax() {
        return this.m_nSyntax;
    }

    public void encodeTag(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        try {
            dataOutputStream.writeByte((byte)this.m_nSyntax);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int getSizeOfTagField() {
        return 1;
    }

    public static int decodeTag(DataInputStream dataInputStream) throws ExceptionSnmpInvalidMessage {
        try {
            int n = dataInputStream.readUnsignedByte();
            return n;
        }
        catch (EOFException eOFException) {
            return -1;
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public static void encodeLength(DataOutputStream dataOutputStream, long l) throws ExceptionSnmpInvalidMessage {
        try {
            if ((l &= Long.MAX_VALUE) < 128L) {
                dataOutputStream.writeByte((byte)l);
                return;
            }
            int n = AsnObject.getSizeOfLengthField(l) - 1;
            dataOutputStream.writeByte((byte)(0x80 | (byte)n));
            byte[] byArray = new byte[n];
            while (n-- > 0) {
                byArray[n] = (byte)(l & 0xFFL);
                l >>= 8;
            }
            dataOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public static int getSizeOfLengthField(long l) {
        if ((l &= Long.MAX_VALUE) < 128L) {
            return 1;
        }
        int n = 0;
        do {
            ++n;
        } while ((l >>= 8) > 0L);
        return n + 1;
    }

    public static int decodeLength(DataInputStream dataInputStream) throws ExceptionSnmpInvalidMessage {
        try {
            byte by = dataInputStream.readByte();
            if ((by & 0x80) == 0) {
                return by & 0x7F;
            }
            int n = by & 0x7F;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 <<= 8;
                n2 |= dataInputStream.readUnsignedByte();
            }
            if (n2 < 0 || n2 > 8192) {
                Trace.logError((String)"SNMP:AsnObject", (String)("BAD SNMP LENGTH = " + Integer.toString(n2)));
                throw new ExceptionSnmpInvalidMessage();
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public abstract void encodeValue(DataOutputStream var1) throws ExceptionSnmpInvalidMessage;

    public abstract int getSizeOfValueField();

    public abstract void decodeValue(DataInputStream var1, int var2) throws ExceptionSnmpInvalidMessage;
}

