/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AsnObjectIdentifier
extends AsnObject {
    private int[] m_anOidValue = null;

    public AsnObjectIdentifier() {
        super(6);
    }

    public AsnObjectIdentifier(int[] nArray) {
        super(6);
        this.setOidValue(nArray);
    }

    public void setOidValue(int[] nArray) {
        this.m_anOidValue = nArray;
    }

    public int[] getOidValue() {
        return this.m_anOidValue;
    }

    public String getStringValue() {
        if (this.m_anOidValue == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_anOidValue.length; ++i) {
            stringBuffer.append(this.m_anOidValue[i]);
            stringBuffer.append(".");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void encodeValue(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        if (this.m_anOidValue == null) {
            throw new ExceptionSnmpInvalidMessage();
        }
        if (this.m_anOidValue.length < 2) {
            throw new ExceptionSnmpInvalidMessage();
        }
        try {
            for (int i = 0; i < this.m_anOidValue.length; ++i) {
                int n;
                if (i == 0) {
                    n = this.m_anOidValue[0] * 40 + this.m_anOidValue[1];
                    ++i;
                } else {
                    n = this.m_anOidValue[i];
                }
                int n2 = n;
                int n3 = 1;
                while ((n2 >>= 7) != 0) {
                    ++n3;
                }
                byte[] byArray = new byte[n3];
                byArray[n3 - 1] = (byte)(n & 0x7F);
                while ((n >>= 7) != 0 && n3-- > 0) {
                    byArray[n3 - 1] = (byte)(n & 0x7F);
                    int n4 = n3 - 1;
                    byArray[n4] = (byte)(byArray[n4] | 0x80);
                }
                dataOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int getSizeOfValueField() {
        int n = 0;
        if (this.m_anOidValue == null) {
            return 0;
        }
        if (this.m_anOidValue.length < 2) {
            return 0;
        }
        for (int i = 0; i < this.m_anOidValue.length; ++i) {
            int n2;
            if (i == 0) {
                n2 = this.m_anOidValue[0] * 40 + this.m_anOidValue[1];
                ++i;
            } else {
                n2 = this.m_anOidValue[i];
            }
            ++n;
            while ((n2 >>= 7) != 0) {
                ++n;
            }
        }
        return n;
    }

    public void decodeValue(DataInputStream dataInputStream, int n) throws ExceptionSnmpInvalidMessage {
        if (n < 1) {
            throw new ExceptionSnmpInvalidMessage();
        }
        try {
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            boolean bl = false;
            int[] nArray = new int[2];
            nArray[1] = byArray[0] % 40;
            nArray[0] = (byArray[0] - nArray[1]) / 40;
            int n2 = 0;
            for (int i = 1; i < byArray.length; ++i) {
                if (((char)byArray[i] & 0x80) != 0) {
                    n2 <<= 7;
                    n2 |= byArray[i] & 0x7F;
                    continue;
                }
                n2 <<= 7;
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray.length] = n2 |= byArray[i] & 0x7F;
                nArray = nArray2;
                n2 = 0;
            }
            this.setOidValue(nArray);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }
}

