/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import com.avocent.protocols.snmp.ExceptionVarBindIncompatibleSyntax;
import com.avocent.protocols.snmp.ExceptionVarBindInvalidFormat;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AsnOctetString
extends AsnObject {
    public static final int MACADDRESS_FORMAT = 1;
    public static final int GENERAL_DISPLAY_FORMAT = 2;
    public static final int RAW_DISPLAY_FORMAT = 3;
    protected byte[] m_byOctetStringValue = null;

    public AsnOctetString() {
        super(4);
    }

    public AsnOctetString(int n) {
        super(n);
    }

    public AsnOctetString(byte[] byArray) {
        super(4);
        this.setOctetStringValue(byArray);
    }

    public AsnOctetString(String string) {
        super(4);
        this.setDisplayStringValue(string);
    }

    public void setOctetStringValue(byte[] byArray) {
        this.m_byOctetStringValue = (byte[])(byArray == null ? null : byArray);
    }

    public byte[] getOctetStringValue() {
        return this.m_byOctetStringValue;
    }

    public void setDisplayStringValue(String string) {
        if (string == null) {
            this.m_byOctetStringValue = null;
        } else if (string.length() == 0) {
            this.m_byOctetStringValue = null;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            while (string.length() > 0) {
                int n = string.indexOf("<0x");
                if (n != -1) {
                    try {
                        dataOutputStream.writeBytes(string.substring(0, n));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (string.length() >= n + 5) {
                        String string2 = string.substring(n, n + 6);
                        string = string.substring(n + 6);
                        if (string2.charAt(5) == '>') {
                            String string3 = string2.substring(1, 5);
                            try {
                                Integer n2 = Integer.decode(string3);
                                try {
                                    dataOutputStream.writeByte((byte)n2.intValue());
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        try {
                            dataOutputStream.writeBytes(string2);
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                try {
                    dataOutputStream.writeBytes(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string = "";
            }
            this.m_byOctetStringValue = byteArrayOutputStream.toByteArray();
        }
    }

    public String getStringValue() {
        int n;
        int n2;
        if (this.m_byOctetStringValue == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (n2 = 0; n2 < this.m_byOctetStringValue.length; ++n2) {
            n = this.m_byOctetStringValue[n2];
            if ((n &= 0xFF) >= 32 && n < 127) continue;
            bl = true;
        }
        if (bl) {
            for (n2 = 0; n2 < this.m_byOctetStringValue.length; ++n2) {
                n = this.m_byOctetStringValue[n2];
                String string = Integer.toHexString(n &= 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuffer.append("<0x");
                stringBuffer.append(string.toUpperCase());
                stringBuffer.append(">");
            }
            return stringBuffer.toString();
        }
        return new String(this.m_byOctetStringValue);
    }

    public String getRawStringValue() {
        if (this.m_byOctetStringValue == null) {
            return "";
        }
        return new String(this.m_byOctetStringValue);
    }

    public String getStringValue(int n) throws ExceptionVarBindIncompatibleSyntax, ExceptionVarBindInvalidFormat {
        if (this.getSyntax() == 4) {
            if (n == 1) {
                return this.macAddressToString();
            }
            if (n == 2) {
                return this.getStringValue();
            }
            if (n == 3) {
                return this.getRawStringValue();
            }
            throw new ExceptionVarBindInvalidFormat(n);
        }
        throw new ExceptionVarBindIncompatibleSyntax(this.m_nSyntax);
    }

    private String macAddressToString() {
        if (this.m_byOctetStringValue != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_byOctetStringValue.length; ++i) {
                int n = this.m_byOctetStringValue[i];
                String string = Integer.toHexString(n &= 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuffer.append(string.toUpperCase());
                stringBuffer.append("-");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }
        return null;
    }

    public void encodeValue(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        try {
            if (this.m_byOctetStringValue == null) {
                return;
            }
            dataOutputStream.write(this.m_byOctetStringValue);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int getSizeOfValueField() {
        if (this.m_byOctetStringValue == null) {
            return 0;
        }
        return this.m_byOctetStringValue.length;
    }

    public void decodeValue(DataInputStream dataInputStream, int n) throws ExceptionSnmpInvalidMessage {
        try {
            this.m_byOctetStringValue = new byte[n];
            dataInputStream.readFully(this.m_byOctetStringValue);
        }
        catch (IOException iOException) {
            this.m_byOctetStringValue = null;
        }
    }
}

