/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.snmp.AsnCounter32;
import com.avocent.protocols.snmp.AsnGauge32;
import com.avocent.protocols.snmp.AsnInteger32;
import com.avocent.protocols.snmp.AsnIpAddress;
import com.avocent.protocols.snmp.AsnNull;
import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.AsnOctetString;
import com.avocent.protocols.snmp.AsnTimeTicks;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;

class AsnSequence
extends AsnObject {
    private Vector m_vSequence = new Vector();

    AsnSequence() {
        super(48);
    }

    AsnSequence(int n) {
        super(n);
    }

    public void add(AsnObject asnObject) throws ExceptionSnmpInvalidMessage {
        try {
            this.m_vSequence.addElement(asnObject);
        }
        catch (Exception exception) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int size() {
        return this.m_vSequence.size();
    }

    public final synchronized AsnObject asnobjectAt(int n, int n2) throws NoSuchElementException, ExceptionSnmpInvalidMessage {
        AsnObject asnObject = (AsnObject)this.m_vSequence.elementAt(n);
        if (n2 != 0 && asnObject.getSyntax() != n2) {
            throw new ExceptionSnmpInvalidMessage();
        }
        return asnObject;
    }

    public void encodeValue(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        for (int i = 0; i < this.m_vSequence.size(); ++i) {
            AsnObject asnObject = (AsnObject)this.m_vSequence.elementAt(i);
            asnObject.encodeTag(dataOutputStream);
            AsnObject.encodeLength(dataOutputStream, asnObject.getSizeOfValueField());
            asnObject.encodeValue(dataOutputStream);
        }
    }

    public int getSizeOfValueField() {
        int n = 0;
        for (int i = 0; i < this.m_vSequence.size(); ++i) {
            AsnObject asnObject = (AsnObject)this.m_vSequence.elementAt(i);
            int n2 = asnObject.getSizeOfValueField();
            int n3 = asnObject.getSizeOfTagField() + AsnObject.getSizeOfLengthField(n2) + n2;
            n += n3;
        }
        return n;
    }

    public void decodeValue(DataInputStream dataInputStream, int n) throws ExceptionSnmpInvalidMessage {
        try {
            int n2;
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
            while ((n2 = AsnObject.decodeTag(dataInputStream2)) != -1) {
                int n3 = AsnObject.decodeLength(dataInputStream2);
                AsnObject asnObject = null;
                switch (n2) {
                    case 2: {
                        asnObject = new AsnInteger32();
                        break;
                    }
                    case 4: {
                        asnObject = new AsnOctetString();
                        break;
                    }
                    case 5: {
                        asnObject = new AsnNull();
                        break;
                    }
                    case 6: {
                        asnObject = new AsnObjectIdentifier();
                        break;
                    }
                    case 48: 
                    case 162: {
                        asnObject = new AsnSequence(n2);
                        break;
                    }
                    case 65: {
                        asnObject = new AsnCounter32();
                        break;
                    }
                    case 66: {
                        asnObject = new AsnGauge32();
                        break;
                    }
                    case 67: {
                        asnObject = new AsnTimeTicks();
                        break;
                    }
                    case 64: {
                        asnObject = new AsnIpAddress();
                        break;
                    }
                    default: {
                        Trace.logError((String)"SNMP:AsnSequence", (String)("UNKNOWN OR UNSUPPORTED SNMP TAG=" + Integer.toHexString(n2)));
                        throw new ExceptionSnmpInvalidMessage();
                    }
                }
                this.add(asnObject);
                asnObject.decodeValue(dataInputStream2, n3);
            }
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
        catch (ExceptionSnmpInvalidMessage exceptionSnmpInvalidMessage) {
            throw exceptionSnmpInvalidMessage;
        }
    }
}

