/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.protocols.snmp.AsnObject;
import com.avocent.protocols.snmp.ExceptionAsnBadValue;
import com.avocent.protocols.snmp.ExceptionSnmpInvalidMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class AsnUnsigned32
extends AsnObject {
    protected long m_lIntegerValue = 0L;

    public AsnUnsigned32(int n, long l) {
        super(n);
        this.setUnsignedValue(l);
    }

    public AsnUnsigned32(int n, String string) throws ExceptionAsnBadValue {
        super(n);
        this.setStringValue(string);
    }

    public long getUnsignedValue() {
        return this.m_lIntegerValue;
    }

    public void setUnsignedValue(long l) {
        this.m_lIntegerValue = l;
        this.m_lIntegerValue &= 0xFFFFFFFFL;
    }

    public String getStringValue() {
        return Long.toString(this.m_lIntegerValue);
    }

    public void setStringValue(String string) throws ExceptionAsnBadValue {
        try {
            long l = Long.parseLong(string);
            this.setUnsignedValue(l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionAsnBadValue();
        }
    }

    public void encodeValue(DataOutputStream dataOutputStream) throws ExceptionSnmpInvalidMessage {
        BigInteger bigInteger = BigInteger.valueOf(this.m_lIntegerValue);
        byte[] byArray = bigInteger.toByteArray();
        try {
            dataOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }

    public int getSizeOfValueField() {
        BigInteger bigInteger = BigInteger.valueOf(this.m_lIntegerValue);
        byte[] byArray = bigInteger.toByteArray();
        return byArray.length;
    }

    public void decodeValue(DataInputStream dataInputStream, int n) throws ExceptionSnmpInvalidMessage {
        try {
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            BigInteger bigInteger = new BigInteger(byArray);
            this.setUnsignedValue(bigInteger.longValue());
        }
        catch (IOException iOException) {
            throw new ExceptionSnmpInvalidMessage();
        }
    }
}

