/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import com.avocent.lib.debug.Trace;
import com.avocent.protocols.snmp.AsnObjectIdentifier;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import com.avocent.protocols.snmp.MibNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Mib {
    private static final String PADDING = "          ";
    public static final String MANAGEMENT_PREFIX = "iso.org.dod.internet.mgmt.";
    public static final String ENTERPRISE_PREFIX = "iso.org.dod.internet.private.enterprises.";

    public static AsnObjectIdentifier NameToOid(String string) throws ExceptionUnknownMibName {
        if (!Character.isDigit(string.charAt(0))) {
            if (string.startsWith("mib-2.")) {
                string = MANAGEMENT_PREFIX + string;
            } else if (!string.startsWith("iso")) {
                string = ENTERPRISE_PREFIX + string;
            }
        }
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        MibNode mibNode = MibNode.getRoot();
        for (int i = 0; i < stringArray.length; ++i) {
            MibNode mibNode2 = mibNode.getChild(stringArray[i]);
            if (mibNode2 == null) {
                while (i < stringArray.length) {
                    try {
                        nArray[i] = Integer.parseInt(stringArray[i]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionUnknownMibName(string);
                    }
                }
                return new AsnObjectIdentifier(nArray);
            }
            nArray[i] = mibNode2.getId();
            mibNode = mibNode2;
        }
        return new AsnObjectIdentifier(nArray);
    }

    public static String OidToName(AsnObjectIdentifier asnObjectIdentifier) {
        int[] nArray = asnObjectIdentifier.getOidValue();
        MibNode mibNode = MibNode.getRoot();
        for (int i = 0; i < nArray.length; ++i) {
            MibNode mibNode2 = mibNode.getChild(nArray[i]);
            if (mibNode2 == null) {
                String string = "";
                for (int j = i; j < nArray.length; ++j) {
                    string = string + "." + nArray[j];
                }
                return mibNode.getFullName() + string;
            }
            mibNode = mibNode2;
        }
        return mibNode.getFullName();
    }

    public static String OidToRelativeName(AsnObjectIdentifier asnObjectIdentifier) {
        String string = Mib.OidToName(asnObjectIdentifier);
        if (string.startsWith(MANAGEMENT_PREFIX)) {
            return string.substring(MANAGEMENT_PREFIX.length());
        }
        if (string.startsWith(ENTERPRISE_PREFIX)) {
            return string.substring(ENTERPRISE_PREFIX.length());
        }
        return string;
    }

    public static int OidCompare(AsnObjectIdentifier asnObjectIdentifier, AsnObjectIdentifier asnObjectIdentifier2) {
        int[] nArray = null;
        int[] nArray2 = null;
        if (asnObjectIdentifier != null) {
            nArray = asnObjectIdentifier.getOidValue();
        }
        if (asnObjectIdentifier2 != null) {
            nArray2 = asnObjectIdentifier2.getOidValue();
        }
        if (nArray == null || nArray2 == null) {
            if (nArray == nArray2) {
                return -1;
            }
            return 0;
        }
        int n = nArray.length < nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return i;
        }
        return nArray.length == nArray2.length ? -1 : n;
    }

    public static String padString(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        while (string.length() < n) {
            string = PADDING + string;
        }
        return string.substring(string.length() - n);
    }

    public static void register(String string) throws ClassNotFoundException, ClassCastException {
        Trace.logInfo((String)"SNMP:MIB", (String)("Registering class " + string));
        Class.forName(string);
    }

    public static Map getAllMibs() {
        HashMap hashMap = new HashMap();
        Mib.recurseAllMibs(hashMap, MibNode.getRoot());
        return hashMap;
    }

    private static void recurseAllMibs(HashMap hashMap, MibNode mibNode) {
        hashMap.putAll(mibNode.getMibs());
        Iterator iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            Mib.recurseAllMibs(hashMap, (MibNode)iterator.next());
        }
    }

    public static void dumpLoadedMibs(boolean bl) {
        MibNode mibNode = MibNode.getRoot();
        HashMap hashMap = new HashMap();
        Trace.logInfo((String)"LoadedMibs", (String)("Total Tree Size=" + mibNode.getSize()));
        Mib.findMibs(hashMap, mibNode);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Trace.logInfo((String)"LoadedMibs", (String)("Mib Name=[" + entry.getKey() + "] " + "Tree Size=" + entry.getValue()));
        }
        if (bl) {
            Trace.logInfo((String)"LoadedMibs", (String)"Detailed DUMP Started *********");
            Mib.dumpNode(MibNode.getRoot());
            Trace.logInfo((String)"LoadedMibs", (String)"Detailed DUMP Ended *********");
        }
    }

    private static void dumpNode(MibNode mibNode) {
        if (mibNode.getId() != Integer.MIN_VALUE) {
            Trace.logInfo((String)"LoadedMibs", (String)("Mib=" + mibNode.getMibs() + " " + "Symbolic Name=[" + mibNode.getFullName() + "] " + "Node Id=[" + mibNode.getOid().getStringValue() + "] " + "Parent Node Id=[" + mibNode.getParent().getOid().getStringValue() + "] "));
        }
        Iterator iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            Mib.dumpNode((MibNode)iterator.next());
        }
    }

    private static void findMibs(Map map, MibNode mibNode) {
        Iterator iterator = mibNode.getMibs().entrySet().iterator();
        while (iterator.hasNext()) {
            Integer n;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string2.length() > 0) {
                string = string + "[" + string2 + "]";
            }
            n = (n = (Integer)map.get(string)) == null ? new Integer(1) : new Integer(n + 1);
            map.put(string, n);
        }
        iterator = mibNode.getChildren().iterator();
        while (iterator.hasNext()) {
            Mib.findMibs(map, (MibNode)((Object)iterator.next()));
        }
    }
}

