/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.protocols.snmp;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MibMap
extends LinkedHashMap {
    public Object get(Object object) {
        String string = (String)object;
        if (!this.isSubMapName(string)) {
            return super.get(this.convertToStandardName(string, 0));
        }
        String[] stringArray = string.split("[\\[\\]\\.]+");
        MibMap mibMap = new MibMap();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = this.getSubMapMemberName((String)entry.getKey(), stringArray);
            if (string2 == null) continue;
            mibMap.put(string2, entry.getValue());
        }
        return mibMap;
    }

    public Object remove(Object object) {
        String string = (String)object;
        if (!this.isSubMapName(string)) {
            return super.remove(this.convertToStandardName(string, 0));
        }
        String[] stringArray = string.split("[\\[\\]\\.]+");
        MibMap mibMap = new MibMap();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = this.getSubMapMemberName((String)entry.getKey(), stringArray);
            if (string2 == null) continue;
            mibMap.put(string2, entry.getValue());
            iterator.remove();
        }
        return mibMap;
    }

    public Object put(Object object, Object object2) {
        String string = (String)object;
        if (!this.isSubMapName(string)) {
            return super.put(this.convertToStandardName(string, 0), object2);
        }
        String[] stringArray = string.split("[\\[\\]\\.]+");
        MibMap mibMap = new MibMap();
        Iterator iterator = ((Map)object2).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = this.convertToStandardName(string + (String)entry.getKey(), 0);
            mibMap.put(string2, this.put(string2, entry.getValue()));
        }
        return mibMap;
    }

    private String getSubMapMemberName(String string, String[] stringArray) {
        String[] stringArray2 = string.split("[\\[\\]\\.]+");
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray2.length && n < stringArray.length) {
            if (stringArray2[n2].length() == 0) {
                ++n2;
                continue;
            }
            if (stringArray[n].length() == 0) {
                ++n;
                continue;
            }
            if (stringArray2[n2].equals(stringArray[n])) {
                ++n2;
                ++n;
                continue;
            }
            return null;
        }
        if (n2 == stringArray2.length || n != stringArray.length) {
            return null;
        }
        return this.convertToStandardName(string, n2);
    }

    private boolean isSubMapName(String string) {
        return string.endsWith("[]");
    }

    private String convertToStandardName(String string, int n) {
        int n2;
        String[] stringArray = string.split("[\\[\\]\\.]+");
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = stringArray.length; n2 > n && stringArray[n2 - 1].matches("^[0-9]+$"); --n2) {
        }
        for (int i = n; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            if (n2 == i) {
                stringBuffer.append('[');
            } else if (i > n && stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(stringArray[i]);
        }
        if (n2 < stringArray.length) {
            stringBuffer.append(']');
        } else if (n2 == stringArray.length) {
            stringBuffer.append("[0]");
        }
        return stringBuffer.toString();
    }
}

